// third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_STATIC_BITMAP_IMAGE_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_STATIC_BITMAP_IMAGE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-blink-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom-blink.h"
#include "gpu/ipc/common/exported_shared_image.mojom-blink.h"
#include "gpu/ipc/common/sync_token.mojom-blink.h"
#include "skia/public/mojom/image_info.mojom-blink.h"
#include "mojo/public/mojom/base/values.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/messaging/accelerated_image_info.h"
#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class ImageReleaseCallbackProxy;

template <typename ImplRefTraits>
class ImageReleaseCallbackStub;

class ImageReleaseCallbackRequestValidator;


class CORE_EXPORT ImageReleaseCallback
    : public ImageReleaseCallbackInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ImageReleaseCallback";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ImageReleaseCallbackInterfaceBase;
  using Proxy_ = ImageReleaseCallbackProxy;

  template <typename ImplRefTraits>
  using Stub_ = ImageReleaseCallbackStub<ImplRefTraits>;

  using RequestValidator_ = ImageReleaseCallbackRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kReleaseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Release_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ImageReleaseCallback() = default;

  virtual void Release(const ::gpu::SyncToken& token) = 0;
};



class CORE_EXPORT ImageReleaseCallbackProxy
    : public ImageReleaseCallback {
 public:
  using InterfaceType = ImageReleaseCallback;

  explicit ImageReleaseCallbackProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Release(const ::gpu::SyncToken& token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CORE_EXPORT ImageReleaseCallbackStubDispatch {
 public:
  static bool Accept(ImageReleaseCallback* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ImageReleaseCallback* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ImageReleaseCallback>>
class ImageReleaseCallbackStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ImageReleaseCallbackStub() = default;
  ~ImageReleaseCallbackStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImageReleaseCallbackStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ImageReleaseCallbackStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT ImageReleaseCallbackRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class CORE_EXPORT SerializedStaticBitmapImage {
 public:
  using DataView = SerializedStaticBitmapImageDataView;
  using Data_ = internal::SerializedStaticBitmapImage_Data;
  using Tag = Data_::SerializedStaticBitmapImage_Tag;

  template <typename... Args>
  static SerializedStaticBitmapImagePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |bitmap|.
  static SerializedStaticBitmapImagePtr NewBitmap(
      const ::SkBitmap& value);
  // Construct an instance holding |accelerated_image|.
  static SerializedStaticBitmapImagePtr NewAcceleratedImage(
      ::blink::AcceleratedImageInfo value);

  template <typename U>
  static SerializedStaticBitmapImagePtr From(const U& u) {
    return mojo::TypeConverter<SerializedStaticBitmapImagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerializedStaticBitmapImage>::Convert(*this);
  }
  ~SerializedStaticBitmapImage();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  SerializedStaticBitmapImage(const SerializedStaticBitmapImage& other) = delete;
  SerializedStaticBitmapImage& operator=(const SerializedStaticBitmapImage& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = SerializedStaticBitmapImagePtr>
  SerializedStaticBitmapImagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, SerializedStaticBitmapImage>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, SerializedStaticBitmapImage>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_bitmap() const { return tag_ == Tag::kBitmap; }
  const ::SkBitmap& get_bitmap() const {
    CHECK(tag_ == Tag::kBitmap);
    return data_.bitmap;
  }
  ::SkBitmap& get_bitmap() {
    CHECK(tag_ == Tag::kBitmap);
    return data_.bitmap;
  }
  void set_bitmap(const ::SkBitmap& bitmap);

  bool is_accelerated_image() const { return tag_ == Tag::kAcceleratedImage; }
  const ::blink::AcceleratedImageInfo& get_accelerated_image() const {
    CHECK(tag_ == Tag::kAcceleratedImage);
    return data_.accelerated_image;
  }
  ::blink::AcceleratedImageInfo& get_accelerated_image() {
    CHECK(tag_ == Tag::kAcceleratedImage);
    return data_.accelerated_image;
  }
  void set_accelerated_image(::blink::AcceleratedImageInfo accelerated_image);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerializedStaticBitmapImage::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<SerializedStaticBitmapImage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
        const ::SkBitmap& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAcceleratedImage)>,
        ::blink::AcceleratedImageInfo value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::SkBitmap bitmap;
    ::blink::AcceleratedImageInfo accelerated_image;
  };

  SerializedStaticBitmapImage(
      std::in_place_index_t<static_cast<size_t>(Tag::kBitmap)>,
      const ::SkBitmap& value);
  SerializedStaticBitmapImage(
      std::in_place_index_t<static_cast<size_t>(Tag::kAcceleratedImage)>,
      ::blink::AcceleratedImageInfo value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class CORE_EXPORT AcceleratedStaticBitmapImage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AcceleratedStaticBitmapImage, T>::value>;
  using DataView = AcceleratedStaticBitmapImageDataView;
  using Data_ = internal::AcceleratedStaticBitmapImage_Data;

  template <typename... Args>
  static AcceleratedStaticBitmapImagePtr New(Args&&... args) {
    return AcceleratedStaticBitmapImagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AcceleratedStaticBitmapImagePtr From(const U& u) {
    return mojo::TypeConverter<AcceleratedStaticBitmapImagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AcceleratedStaticBitmapImage>::Convert(*this);
  }


  AcceleratedStaticBitmapImage();

  AcceleratedStaticBitmapImage(
      ::gpu::ExportedSharedImage shared_image,
      const ::gpu::SyncToken& sync_token,
      ::SkAlphaType alpha_type,
      ::mojo::PendingRemote<ImageReleaseCallback> release_callback);

AcceleratedStaticBitmapImage(const AcceleratedStaticBitmapImage&) = delete;
AcceleratedStaticBitmapImage& operator=(const AcceleratedStaticBitmapImage&) = delete;

  ~AcceleratedStaticBitmapImage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AcceleratedStaticBitmapImagePtr>
  AcceleratedStaticBitmapImagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AcceleratedStaticBitmapImage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AcceleratedStaticBitmapImage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AcceleratedStaticBitmapImage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AcceleratedStaticBitmapImage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AcceleratedStaticBitmapImage_UnserializedMessageContext<
            UserType, AcceleratedStaticBitmapImage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AcceleratedStaticBitmapImage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AcceleratedStaticBitmapImage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AcceleratedStaticBitmapImage_UnserializedMessageContext<
            UserType, AcceleratedStaticBitmapImage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AcceleratedStaticBitmapImage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gpu::ExportedSharedImage shared_image;
  
  ::gpu::SyncToken sync_token;
  
  ::SkAlphaType alpha_type;
  
  ::mojo::PendingRemote<ImageReleaseCallback> release_callback;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AcceleratedStaticBitmapImage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AcceleratedStaticBitmapImage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AcceleratedStaticBitmapImage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AcceleratedStaticBitmapImage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
SerializedStaticBitmapImagePtr SerializedStaticBitmapImage::Clone() const {
  switch (tag_) {
    case Tag::kBitmap:
      return NewBitmap(
          mojo::Clone(data_.bitmap));
    case Tag::kAcceleratedImage:
      return NewAcceleratedImage(
          mojo::Clone(data_.accelerated_image));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, SerializedStaticBitmapImage>::value>::type*>
bool SerializedStaticBitmapImage::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kBitmap:
      return mojo::Equals(data_.bitmap, other.data_.bitmap);
    case Tag::kAcceleratedImage:
      return mojo::Equals(data_.accelerated_image, other.data_.accelerated_image);
  }

  return false;
}
template <typename StructPtrType>
AcceleratedStaticBitmapImagePtr AcceleratedStaticBitmapImage::Clone() const {
  return New(
      mojo::Clone(shared_image),
      mojo::Clone(sync_token),
      mojo::Clone(alpha_type),
      mojo::Clone(release_callback)
  );
}

template <typename T, AcceleratedStaticBitmapImage::EnableIfSame<T>*>
bool AcceleratedStaticBitmapImage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->shared_image, other_struct.shared_image))
    return false;
  if (!mojo::Equals(this->sync_token, other_struct.sync_token))
    return false;
  if (!mojo::Equals(this->alpha_type, other_struct.alpha_type))
    return false;
  if (!mojo::Equals(this->release_callback, other_struct.release_callback))
    return false;
  return true;
}

template <typename T, AcceleratedStaticBitmapImage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.shared_image < rhs.shared_image)
    return true;
  if (rhs.shared_image < lhs.shared_image)
    return false;
  if (lhs.sync_token < rhs.sync_token)
    return true;
  if (rhs.sync_token < lhs.sync_token)
    return false;
  if (lhs.alpha_type < rhs.alpha_type)
    return true;
  if (rhs.alpha_type < lhs.alpha_type)
    return false;
  if (lhs.release_callback < rhs.release_callback)
    return true;
  if (rhs.release_callback < lhs.release_callback)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::AcceleratedStaticBitmapImage::DataView,
                                         ::blink::mojom::blink::AcceleratedStaticBitmapImagePtr> {
  static bool IsNull(const ::blink::mojom::blink::AcceleratedStaticBitmapImagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AcceleratedStaticBitmapImagePtr* output) { output->reset(); }

  static  decltype(::blink::mojom::blink::AcceleratedStaticBitmapImage::shared_image)& shared_image(
       ::blink::mojom::blink::AcceleratedStaticBitmapImagePtr& input) {
    return input->shared_image;
  }

  static const decltype(::blink::mojom::blink::AcceleratedStaticBitmapImage::sync_token)& sync_token(
      const ::blink::mojom::blink::AcceleratedStaticBitmapImagePtr& input) {
    return input->sync_token;
  }

  static decltype(::blink::mojom::blink::AcceleratedStaticBitmapImage::alpha_type) alpha_type(
      const ::blink::mojom::blink::AcceleratedStaticBitmapImagePtr& input) {
    return input->alpha_type;
  }

  static  decltype(::blink::mojom::blink::AcceleratedStaticBitmapImage::release_callback)& release_callback(
       ::blink::mojom::blink::AcceleratedStaticBitmapImagePtr& input) {
    return input->release_callback;
  }

  static bool Read(::blink::mojom::blink::AcceleratedStaticBitmapImage::DataView input, ::blink::mojom::blink::AcceleratedStaticBitmapImagePtr* output);
};


template <>
struct CORE_EXPORT UnionTraits<::blink::mojom::blink::SerializedStaticBitmapImage::DataView,
                                        ::blink::mojom::blink::SerializedStaticBitmapImagePtr> {
  static bool IsNull(const ::blink::mojom::blink::SerializedStaticBitmapImagePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SerializedStaticBitmapImagePtr* output) { output->reset(); }

  static ::blink::mojom::blink::SerializedStaticBitmapImage::Tag GetTag(const ::blink::mojom::blink::SerializedStaticBitmapImagePtr& input) {
    return input->which();
  }

  static  ::SkBitmap& bitmap( ::blink::mojom::blink::SerializedStaticBitmapImagePtr& input) {
    return input->get_bitmap();
  }

  static  ::blink::AcceleratedImageInfo& accelerated_image( ::blink::mojom::blink::SerializedStaticBitmapImagePtr& input) {
    return input->get_accelerated_image();
  }

  static bool Read(::blink::mojom::blink::SerializedStaticBitmapImage::DataView input, ::blink::mojom::blink::SerializedStaticBitmapImagePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_STATIC_BITMAP_IMAGE_MOJOM_BLINK_H_