// third_party/blink/public/mojom/messaging/message_port_descriptor.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/messaging/message_port_descriptor.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }



  function MessagePortDescriptor(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MessagePortDescriptor.prototype.initDefaults_ = function() {
    this.pipeHandle = null;
    this.id = null;
    this.sequenceNumber = 0;
  };
  MessagePortDescriptor.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MessagePortDescriptor.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MessagePortDescriptor.pipeHandle
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MessagePortDescriptor.id
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MessagePortDescriptor.encodedSize = codec.kStructHeaderSize + 24;

  MessagePortDescriptor.decode = function(decoder) {
    var packed;
    var val = new MessagePortDescriptor();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.pipeHandle =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.id =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.sequenceNumber =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  MessagePortDescriptor.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MessagePortDescriptor.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Handle, val.pipeHandle);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.id);
    encoder.encodeStruct(codec.Uint64, val.sequenceNumber);
  };
  exports.MessagePortDescriptor = MessagePortDescriptor;
})();