// third_party/blink/public/mojom/mediastream/media_stream.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-params-data.h"
#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/mediastream/media_stream.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
SearchOnlyByDeviceId::SearchOnlyByDeviceId() {}

SearchOnlyByDeviceId::~SearchOnlyByDeviceId() = default;
size_t SearchOnlyByDeviceId::Hash(size_t seed) const {
  return seed;
}

void SearchOnlyByDeviceId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
}

bool SearchOnlyByDeviceId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SearchBySessionId::SearchBySessionId()
    : session_id_map() {}

SearchBySessionId::SearchBySessionId(
    const ::blink::HashMap<::blink::String, ::base::UnguessableToken>& session_id_map_in)
    : session_id_map(std::move(session_id_map_in)) {}

SearchBySessionId::~SearchBySessionId() = default;

void SearchBySessionId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_id_map"), this->session_id_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<::blink::String, ::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SearchBySessionId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaStreamDevice::MediaStreamDevice()
    : type(),
      id(),
      display_id(),
      video_facing(),
      group_id(),
      matched_output_device_id(),
      name(),
      input(),
      session_id(),
      display_media_info() {}

MediaStreamDevice::MediaStreamDevice(
    MediaStreamType type_in,
    const ::blink::String& id_in,
    int64_t display_id_in,
    ::media::VideoFacingMode video_facing_in,
    const ::blink::String& group_id_in,
    const ::blink::String& matched_output_device_id_in,
    const ::blink::String& name_in,
    const ::media::AudioParameters& input_in,
    const std::optional<::base::UnguessableToken>& session_id_in,
    ::media::mojom::blink::DisplayMediaInformationPtr display_media_info_in)
    : type(std::move(type_in)),
      id(std::move(id_in)),
      display_id(std::move(display_id_in)),
      video_facing(std::move(video_facing_in)),
      group_id(std::move(group_id_in)),
      matched_output_device_id(std::move(matched_output_device_id_in)),
      name(std::move(name_in)),
      input(std::move(input_in)),
      session_id(std::move(session_id_in)),
      display_media_info(std::move(display_media_info_in)) {}

MediaStreamDevice::~MediaStreamDevice() = default;

void MediaStreamDevice::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaStreamType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_id"), this->display_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_facing"), this->video_facing,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoFacingMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matched_output_device_id"), this->matched_output_device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input"), this->input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::AudioParameters&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_id"), this->session_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_media_info"), this->display_media_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::blink::DisplayMediaInformationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaStreamDevice::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrackControls::TrackControls()
    : stream_type(),
      device_ids() {}

TrackControls::TrackControls(
    MediaStreamType stream_type_in,
    ::blink::Vector<::blink::String> device_ids_in)
    : stream_type(std::move(stream_type_in)),
      device_ids(std::move(device_ids_in)) {}

TrackControls::~TrackControls() = default;

void TrackControls::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream_type"), this->stream_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type MediaStreamType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_ids"), this->device_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrackControls::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StreamControls::StreamControls()
    : audio(),
      video(),
      hotword_enabled(),
      disable_local_echo(),
      suppress_local_audio_playback(),
      restrict_own_audio(),
      exclude_system_audio(),
      window_audio_preference(),
      exclude_self_browser_surface(),
      request_pan_tilt_zoom_permission(),
      request_all_screens(),
      preferred_display_surface(),
      dynamic_surface_switching_requested(),
      exclude_monitor_type_surfaces() {}

StreamControls::StreamControls(
    const ::blink::TrackControls& audio_in,
    const ::blink::TrackControls& video_in,
    bool hotword_enabled_in,
    bool disable_local_echo_in,
    bool suppress_local_audio_playback_in,
    bool restrict_own_audio_in,
    bool exclude_system_audio_in,
    WindowAudioPreference window_audio_preference_in,
    bool exclude_self_browser_surface_in,
    bool request_pan_tilt_zoom_permission_in,
    bool request_all_screens_in,
    PreferredDisplaySurface preferred_display_surface_in,
    bool dynamic_surface_switching_requested_in,
    bool exclude_monitor_type_surfaces_in)
    : audio(std::move(audio_in)),
      video(std::move(video_in)),
      hotword_enabled(std::move(hotword_enabled_in)),
      disable_local_echo(std::move(disable_local_echo_in)),
      suppress_local_audio_playback(std::move(suppress_local_audio_playback_in)),
      restrict_own_audio(std::move(restrict_own_audio_in)),
      exclude_system_audio(std::move(exclude_system_audio_in)),
      window_audio_preference(std::move(window_audio_preference_in)),
      exclude_self_browser_surface(std::move(exclude_self_browser_surface_in)),
      request_pan_tilt_zoom_permission(std::move(request_pan_tilt_zoom_permission_in)),
      request_all_screens(std::move(request_all_screens_in)),
      preferred_display_surface(std::move(preferred_display_surface_in)),
      dynamic_surface_switching_requested(std::move(dynamic_surface_switching_requested_in)),
      exclude_monitor_type_surfaces(std::move(exclude_monitor_type_surfaces_in)) {}

StreamControls::~StreamControls() = default;

void StreamControls::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio"), this->audio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::TrackControls&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video"), this->video,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::TrackControls&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hotword_enabled"), this->hotword_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "disable_local_echo"), this->disable_local_echo,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suppress_local_audio_playback"), this->suppress_local_audio_playback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "restrict_own_audio"), this->restrict_own_audio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclude_system_audio"), this->exclude_system_audio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "window_audio_preference"), this->window_audio_preference,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WindowAudioPreference>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclude_self_browser_surface"), this->exclude_self_browser_surface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_pan_tilt_zoom_permission"), this->request_pan_tilt_zoom_permission,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_all_screens"), this->request_all_screens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preferred_display_surface"), this->preferred_display_surface,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PreferredDisplaySurface>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dynamic_surface_switching_requested"), this->dynamic_surface_switching_requested,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclude_monitor_type_surfaces"), this->exclude_monitor_type_surfaces,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StreamControls::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetOpenDeviceResponse::GetOpenDeviceResponse()
    : label(),
      device(),
      pan_tilt_zoom_allowed() {}

GetOpenDeviceResponse::GetOpenDeviceResponse(
    const ::blink::String& label_in,
    const ::blink::MediaStreamDevice& device_in,
    bool pan_tilt_zoom_allowed_in)
    : label(std::move(label_in)),
      device(std::move(device_in)),
      pan_tilt_zoom_allowed(std::move(pan_tilt_zoom_allowed_in)) {}

GetOpenDeviceResponse::~GetOpenDeviceResponse() = default;

void GetOpenDeviceResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device"), this->device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::MediaStreamDevice&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pan_tilt_zoom_allowed"), this->pan_tilt_zoom_allowed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetOpenDeviceResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CapturedWheelAction::CapturedWheelAction()
    : relative_x(),
      relative_y(),
      wheel_delta_x(),
      wheel_delta_y() {}

CapturedWheelAction::CapturedWheelAction(
    double relative_x_in,
    double relative_y_in,
    int32_t wheel_delta_x_in,
    int32_t wheel_delta_y_in)
    : relative_x(std::move(relative_x_in)),
      relative_y(std::move(relative_y_in)),
      wheel_delta_x(std::move(wheel_delta_x_in)),
      wheel_delta_y(std::move(wheel_delta_y_in)) {}

CapturedWheelAction::~CapturedWheelAction() = default;
size_t CapturedWheelAction::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->relative_x);
  seed = mojo::internal::WTFHash(seed, this->relative_y);
  seed = mojo::internal::WTFHash(seed, this->wheel_delta_x);
  seed = mojo::internal::WTFHash(seed, this->wheel_delta_y);
  return seed;
}

void CapturedWheelAction::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_x"), this->relative_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relative_y"), this->relative_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wheel_delta_x"), this->wheel_delta_x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wheel_delta_y"), this->wheel_delta_y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CapturedWheelAction::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StreamDevices::StreamDevices()
    : audio_device(),
      video_device() {}

StreamDevices::StreamDevices(
    const std::optional<::blink::MediaStreamDevice>& audio_device_in,
    const std::optional<::blink::MediaStreamDevice>& video_device_in)
    : audio_device(std::move(audio_device_in)),
      video_device(std::move(video_device_in)) {}

StreamDevices::~StreamDevices() = default;

void StreamDevices::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "audio_device"), this->audio_device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::MediaStreamDevice>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "video_device"), this->video_device,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::MediaStreamDevice>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StreamDevices::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StreamDevicesSet::StreamDevicesSet()
    : stream_devices() {}

StreamDevicesSet::StreamDevicesSet(
    ::blink::Vector<StreamDevicesPtr> stream_devices_in)
    : stream_devices(std::move(stream_devices_in)) {}

StreamDevicesSet::~StreamDevicesSet() = default;

void StreamDevicesSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream_devices"), this->stream_devices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<StreamDevicesPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StreamDevicesSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StreamSelectionInfoPtr
StreamSelectionInfo::NewSearchOnlyByDeviceId(
    SearchOnlyByDeviceIdPtr value) {
  return StreamSelectionInfoPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSearchOnlyByDeviceId)>,
      std::move(value));
}

StreamSelectionInfoPtr
StreamSelectionInfo::NewSearchBySessionId(
    SearchBySessionIdPtr value) {
  return StreamSelectionInfoPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSearchBySessionId)>,
      std::move(value));
}

StreamSelectionInfo::StreamSelectionInfo(
    std::in_place_index_t<static_cast<size_t>(Tag::kSearchOnlyByDeviceId)>,
    SearchOnlyByDeviceIdPtr value)
    : tag_(Tag::kSearchOnlyByDeviceId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSearchOnlyByDeviceId)>,
            std::move(value)) {}

StreamSelectionInfo::StreamSelectionInfo(
    std::in_place_index_t<static_cast<size_t>(Tag::kSearchBySessionId)>,
    SearchBySessionIdPtr value)
    : tag_(Tag::kSearchBySessionId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSearchBySessionId)>,
            std::move(value)) {}
StreamSelectionInfo::~StreamSelectionInfo() {
  DestroyActive();
}

void StreamSelectionInfo::set_search_only_by_device_id(SearchOnlyByDeviceIdPtr search_only_by_device_id) {
  if (tag_ == Tag::kSearchOnlyByDeviceId) {
    data_.search_only_by_device_id = std::move(search_only_by_device_id);
  } else {
    DestroyActive();
    tag_ = Tag::kSearchOnlyByDeviceId;
    new (&data_.search_only_by_device_id) SearchOnlyByDeviceIdPtr(
        std::move(search_only_by_device_id));
  }
}

void StreamSelectionInfo::set_search_by_session_id(SearchBySessionIdPtr search_by_session_id) {
  if (tag_ == Tag::kSearchBySessionId) {
    data_.search_by_session_id = std::move(search_by_session_id);
  } else {
    DestroyActive();
    tag_ = Tag::kSearchBySessionId;
    new (&data_.search_by_session_id) SearchBySessionIdPtr(
        std::move(search_by_session_id));
  }
}


StreamSelectionInfo::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSearchOnlyByDeviceId)>,
    SearchOnlyByDeviceIdPtr value)
    : search_only_by_device_id(std::move(value)) {}

StreamSelectionInfo::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSearchBySessionId)>,
    SearchBySessionIdPtr value)
    : search_by_session_id(std::move(value)) {}

void StreamSelectionInfo::DestroyActive() {
  switch (tag_) {

    case Tag::kSearchOnlyByDeviceId:
      std::destroy_at(&data_.search_only_by_device_id);
      break;
    case Tag::kSearchBySessionId:
      std::destroy_at(&data_.search_by_session_id);
      break;
  }
}

bool StreamSelectionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

MediaStreamDeviceObserver::IPCStableHashFunction MediaStreamDeviceObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaStreamDeviceObserver>(message.name())) {
    case messages::MediaStreamDeviceObserver::kOnDeviceStopped: {
      return &MediaStreamDeviceObserver::OnDeviceStopped_Sym::IPCStableHash;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceChanged: {
      return &MediaStreamDeviceObserver::OnDeviceChanged_Sym::IPCStableHash;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceRequestStateChange: {
      return &MediaStreamDeviceObserver::OnDeviceRequestStateChange_Sym::IPCStableHash;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceCaptureConfigurationChange: {
      return &MediaStreamDeviceObserver::OnDeviceCaptureConfigurationChange_Sym::IPCStableHash;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceCaptureHandleChange: {
      return &MediaStreamDeviceObserver::OnDeviceCaptureHandleChange_Sym::IPCStableHash;
    }
    case messages::MediaStreamDeviceObserver::kOnZoomLevelChange: {
      return &MediaStreamDeviceObserver::OnZoomLevelChange_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaStreamDeviceObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaStreamDeviceObserver>(message.name())) {
      case messages::MediaStreamDeviceObserver::kOnDeviceStopped:
            return "Receive blink::mojom::MediaStreamDeviceObserver::OnDeviceStopped";
      case messages::MediaStreamDeviceObserver::kOnDeviceChanged:
            return "Receive blink::mojom::MediaStreamDeviceObserver::OnDeviceChanged";
      case messages::MediaStreamDeviceObserver::kOnDeviceRequestStateChange:
            return "Receive blink::mojom::MediaStreamDeviceObserver::OnDeviceRequestStateChange";
      case messages::MediaStreamDeviceObserver::kOnDeviceCaptureConfigurationChange:
            return "Receive blink::mojom::MediaStreamDeviceObserver::OnDeviceCaptureConfigurationChange";
      case messages::MediaStreamDeviceObserver::kOnDeviceCaptureHandleChange:
            return "Receive blink::mojom::MediaStreamDeviceObserver::OnDeviceCaptureHandleChange";
      case messages::MediaStreamDeviceObserver::kOnZoomLevelChange:
            return "Receive blink::mojom::MediaStreamDeviceObserver::OnZoomLevelChange";
    }
  } else {
    switch (static_cast<messages::MediaStreamDeviceObserver>(message.name())) {
      case messages::MediaStreamDeviceObserver::kOnDeviceStopped:
            return "Receive reply blink::mojom::MediaStreamDeviceObserver::OnDeviceStopped";
      case messages::MediaStreamDeviceObserver::kOnDeviceChanged:
            return "Receive reply blink::mojom::MediaStreamDeviceObserver::OnDeviceChanged";
      case messages::MediaStreamDeviceObserver::kOnDeviceRequestStateChange:
            return "Receive reply blink::mojom::MediaStreamDeviceObserver::OnDeviceRequestStateChange";
      case messages::MediaStreamDeviceObserver::kOnDeviceCaptureConfigurationChange:
            return "Receive reply blink::mojom::MediaStreamDeviceObserver::OnDeviceCaptureConfigurationChange";
      case messages::MediaStreamDeviceObserver::kOnDeviceCaptureHandleChange:
            return "Receive reply blink::mojom::MediaStreamDeviceObserver::OnDeviceCaptureHandleChange";
      case messages::MediaStreamDeviceObserver::kOnZoomLevelChange:
            return "Receive reply blink::mojom::MediaStreamDeviceObserver::OnZoomLevelChange";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaStreamDeviceObserver::OnDeviceStopped_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0641451d;  // IPCStableHash for blink::mojom::MediaStreamDeviceObserver::OnDeviceStopped
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDeviceObserver::OnDeviceChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe954e6b2;  // IPCStableHash for blink::mojom::MediaStreamDeviceObserver::OnDeviceChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDeviceObserver::OnDeviceRequestStateChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7eeda43a;  // IPCStableHash for blink::mojom::MediaStreamDeviceObserver::OnDeviceRequestStateChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDeviceObserver::OnDeviceCaptureConfigurationChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x54ca16e6;  // IPCStableHash for blink::mojom::MediaStreamDeviceObserver::OnDeviceCaptureConfigurationChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDeviceObserver::OnDeviceCaptureHandleChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1874151e;  // IPCStableHash for blink::mojom::MediaStreamDeviceObserver::OnDeviceCaptureHandleChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDeviceObserver::OnZoomLevelChange_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb4f93d56;  // IPCStableHash for blink::mojom::MediaStreamDeviceObserver::OnZoomLevelChange
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaStreamDeviceObserverProxy::MediaStreamDeviceObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaStreamDeviceObserverProxy::OnDeviceStopped(
    const ::blink::String& in_label, const ::blink::MediaStreamDevice& in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDeviceObserver::OnDeviceStopped", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDeviceObserver::kOnDeviceStopped), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDeviceObserver_OnDeviceStopped_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in MediaStreamDeviceObserver.OnDeviceStopped request");
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
    in_device,
    device_fragment);

  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device in MediaStreamDeviceObserver.OnDeviceStopped request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDeviceObserver::Name_);
  message.set_method_name("OnDeviceStopped");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamDeviceObserverProxy::OnDeviceChanged(
    const ::blink::String& in_label, const ::blink::MediaStreamDevice& in_old_device, const ::blink::MediaStreamDevice& in_new_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDeviceObserver::OnDeviceChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_device"), in_old_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_device"), in_new_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDeviceObserver::kOnDeviceChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDeviceObserver_OnDeviceChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in MediaStreamDeviceObserver.OnDeviceChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->old_device)::BaseType> old_device_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
    in_old_device,
    old_device_fragment);

  params->old_device.Set(
      old_device_fragment.is_null() ? nullptr : old_device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->old_device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null old_device in MediaStreamDeviceObserver.OnDeviceChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_device)::BaseType> new_device_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
    in_new_device,
    new_device_fragment);

  params->new_device.Set(
      new_device_fragment.is_null() ? nullptr : new_device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->new_device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null new_device in MediaStreamDeviceObserver.OnDeviceChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDeviceObserver::Name_);
  message.set_method_name("OnDeviceChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamDeviceObserverProxy::OnDeviceRequestStateChange(
    const ::blink::String& in_label, const ::blink::MediaStreamDevice& in_device, MediaStreamStateChange in_new_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDeviceObserver::OnDeviceRequestStateChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_state"), in_new_state,
                        "<value of type MediaStreamStateChange>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDeviceObserver::kOnDeviceRequestStateChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in MediaStreamDeviceObserver.OnDeviceRequestStateChange request");
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
    in_device,
    device_fragment);

  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device in MediaStreamDeviceObserver.OnDeviceRequestStateChange request");

  
  mojo::internal::Serialize<::blink::mojom::MediaStreamStateChange>(
    in_new_state,
    &params->new_state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDeviceObserver::Name_);
  message.set_method_name("OnDeviceRequestStateChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamDeviceObserverProxy::OnDeviceCaptureConfigurationChange(
    const ::blink::String& in_label, const ::blink::MediaStreamDevice& in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDeviceObserver::OnDeviceCaptureConfigurationChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDeviceObserver::kOnDeviceCaptureConfigurationChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in MediaStreamDeviceObserver.OnDeviceCaptureConfigurationChange request");
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
    in_device,
    device_fragment);

  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device in MediaStreamDeviceObserver.OnDeviceCaptureConfigurationChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDeviceObserver::Name_);
  message.set_method_name("OnDeviceCaptureConfigurationChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamDeviceObserverProxy::OnDeviceCaptureHandleChange(
    const ::blink::String& in_label, const ::blink::MediaStreamDevice& in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDeviceObserver::OnDeviceCaptureHandleChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDeviceObserver::kOnDeviceCaptureHandleChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in MediaStreamDeviceObserver.OnDeviceCaptureHandleChange request");
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
    in_device,
    device_fragment);

  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device in MediaStreamDeviceObserver.OnDeviceCaptureHandleChange request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDeviceObserver::Name_);
  message.set_method_name("OnDeviceCaptureHandleChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamDeviceObserverProxy::OnZoomLevelChange(
    const ::blink::String& in_label, const ::blink::MediaStreamDevice& in_device, int32_t in_zoom_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDeviceObserver::OnZoomLevelChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zoom_level"), in_zoom_level,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDeviceObserver::kOnZoomLevelChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in MediaStreamDeviceObserver.OnZoomLevelChange request");
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
    in_device,
    device_fragment);

  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device in MediaStreamDeviceObserver.OnZoomLevelChange request");

  params->zoom_level = in_zoom_level;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDeviceObserver::Name_);
  message.set_method_name("OnZoomLevelChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaStreamDeviceObserverStubDispatch::Accept(
    MediaStreamDeviceObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaStreamDeviceObserver>(message->header()->name)) {
    case messages::MediaStreamDeviceObserver::kOnDeviceStopped: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDeviceObserver_OnDeviceStopped_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDeviceObserver_OnDeviceStopped_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDeviceObserver.0
      bool success = true;
      ::blink::String p_label{};
      ::blink::MediaStreamDevice p_device{};
      MediaStreamDeviceObserver_OnDeviceStopped_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (success && !input_data_view.ReadDevice(&p_device))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDeviceObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceStopped(        
        std::move(p_label), 
        std::move(p_device));
      return true;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceChanged: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDeviceObserver_OnDeviceChanged_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDeviceObserver_OnDeviceChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDeviceObserver.1
      bool success = true;
      ::blink::String p_label{};
      ::blink::MediaStreamDevice p_old_device{};
      ::blink::MediaStreamDevice p_new_device{};
      MediaStreamDeviceObserver_OnDeviceChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (success && !input_data_view.ReadOldDevice(&p_old_device))
        success = false;
      if (success && !input_data_view.ReadNewDevice(&p_new_device))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDeviceObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceChanged(        
        std::move(p_label), 
        std::move(p_old_device), 
        std::move(p_new_device));
      return true;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceRequestStateChange: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDeviceObserver.2
      bool success = true;
      ::blink::String p_label{};
      ::blink::MediaStreamDevice p_device{};
      MediaStreamStateChange p_new_state{};
      MediaStreamDeviceObserver_OnDeviceRequestStateChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (success && !input_data_view.ReadDevice(&p_device))
        success = false;
      if (success && !input_data_view.ReadNewState(&p_new_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDeviceObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceRequestStateChange(        
        std::move(p_label), 
        std::move(p_device), 
        std::move(p_new_state));
      return true;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceCaptureConfigurationChange: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDeviceObserver.3
      bool success = true;
      ::blink::String p_label{};
      ::blink::MediaStreamDevice p_device{};
      MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (success && !input_data_view.ReadDevice(&p_device))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDeviceObserver::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceCaptureConfigurationChange(        
        std::move(p_label), 
        std::move(p_device));
      return true;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceCaptureHandleChange: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDeviceObserver.4
      bool success = true;
      ::blink::String p_label{};
      ::blink::MediaStreamDevice p_device{};
      MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (success && !input_data_view.ReadDevice(&p_device))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDeviceObserver::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnDeviceCaptureHandleChange(        
        std::move(p_label), 
        std::move(p_device));
      return true;
    }
    case messages::MediaStreamDeviceObserver::kOnZoomLevelChange: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDeviceObserver.5
      bool success = true;
      ::blink::String p_label{};
      ::blink::MediaStreamDevice p_device{};
      int32_t p_zoom_level{};
      MediaStreamDeviceObserver_OnZoomLevelChange_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (success && !input_data_view.ReadDevice(&p_device))
        success = false;
      if (success)
        p_zoom_level = input_data_view.zoom_level();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDeviceObserver::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnZoomLevelChange(        
        std::move(p_label), 
        std::move(p_device), 
        std::move(p_zoom_level));
      return true;
    }
  }
  return false;
}

// static
bool MediaStreamDeviceObserverStubDispatch::AcceptWithResponder(
    MediaStreamDeviceObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaStreamDeviceObserver>(message->header()->name)) {
    case messages::MediaStreamDeviceObserver::kOnDeviceStopped: {
      break;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceChanged: {
      break;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceRequestStateChange: {
      break;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceCaptureConfigurationChange: {
      break;
    }
    case messages::MediaStreamDeviceObserver::kOnDeviceCaptureHandleChange: {
      break;
    }
    case messages::MediaStreamDeviceObserver::kOnZoomLevelChange: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaStreamDeviceObserverValidationInfo[] = {
    { &internal::MediaStreamDeviceObserver_OnDeviceStopped_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamDeviceObserver_OnDeviceChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamDeviceObserver_OnDeviceRequestStateChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamDeviceObserver_OnDeviceCaptureConfigurationChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamDeviceObserver_OnDeviceCaptureHandleChange_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamDeviceObserver_OnZoomLevelChange_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaStreamDeviceObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::MediaStreamDeviceObserver::Name_,
    kMediaStreamDeviceObserverValidationInfo);
}

// The declaration includes the definition on other builds.

MediaStreamDispatcherHost::IPCStableHashFunction MediaStreamDispatcherHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaStreamDispatcherHost>(message.name())) {
    case messages::MediaStreamDispatcherHost::kGenerateStreams: {
      return &MediaStreamDispatcherHost::GenerateStreams_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kFocusCapturedSurface: {
      return &MediaStreamDispatcherHost::FocusCapturedSurface_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kCancelRequest: {
      return &MediaStreamDispatcherHost::CancelRequest_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kStopStreamDevice: {
      return &MediaStreamDispatcherHost::StopStreamDevice_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kOpenDevice: {
      return &MediaStreamDispatcherHost::OpenDevice_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kCloseDevice: {
      return &MediaStreamDispatcherHost::CloseDevice_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kSetCapturingLinkSecured: {
      return &MediaStreamDispatcherHost::SetCapturingLinkSecured_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kApplySubCaptureTarget: {
      return &MediaStreamDispatcherHost::ApplySubCaptureTarget_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kSendWheel: {
      return &MediaStreamDispatcherHost::SendWheel_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kUpdateZoomLevel: {
      return &MediaStreamDispatcherHost::UpdateZoomLevel_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kRequestCapturedSurfaceControlPermission: {
      return &MediaStreamDispatcherHost::RequestCapturedSurfaceControlPermission_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kGetOpenDevice: {
      return &MediaStreamDispatcherHost::GetOpenDevice_Sym::IPCStableHash;
    }
    case messages::MediaStreamDispatcherHost::kKeepDeviceAliveForTransfer: {
      return &MediaStreamDispatcherHost::KeepDeviceAliveForTransfer_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaStreamDispatcherHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaStreamDispatcherHost>(message.name())) {
      case messages::MediaStreamDispatcherHost::kGenerateStreams:
            return "Receive blink::mojom::MediaStreamDispatcherHost::GenerateStreams";
      case messages::MediaStreamDispatcherHost::kFocusCapturedSurface:
            return "Receive blink::mojom::MediaStreamDispatcherHost::FocusCapturedSurface";
      case messages::MediaStreamDispatcherHost::kCancelRequest:
            return "Receive blink::mojom::MediaStreamDispatcherHost::CancelRequest";
      case messages::MediaStreamDispatcherHost::kStopStreamDevice:
            return "Receive blink::mojom::MediaStreamDispatcherHost::StopStreamDevice";
      case messages::MediaStreamDispatcherHost::kOpenDevice:
            return "Receive blink::mojom::MediaStreamDispatcherHost::OpenDevice";
      case messages::MediaStreamDispatcherHost::kCloseDevice:
            return "Receive blink::mojom::MediaStreamDispatcherHost::CloseDevice";
      case messages::MediaStreamDispatcherHost::kSetCapturingLinkSecured:
            return "Receive blink::mojom::MediaStreamDispatcherHost::SetCapturingLinkSecured";
      case messages::MediaStreamDispatcherHost::kApplySubCaptureTarget:
            return "Receive blink::mojom::MediaStreamDispatcherHost::ApplySubCaptureTarget";
      case messages::MediaStreamDispatcherHost::kSendWheel:
            return "Receive blink::mojom::MediaStreamDispatcherHost::SendWheel";
      case messages::MediaStreamDispatcherHost::kUpdateZoomLevel:
            return "Receive blink::mojom::MediaStreamDispatcherHost::UpdateZoomLevel";
      case messages::MediaStreamDispatcherHost::kRequestCapturedSurfaceControlPermission:
            return "Receive blink::mojom::MediaStreamDispatcherHost::RequestCapturedSurfaceControlPermission";
      case messages::MediaStreamDispatcherHost::kGetOpenDevice:
            return "Receive blink::mojom::MediaStreamDispatcherHost::GetOpenDevice";
      case messages::MediaStreamDispatcherHost::kKeepDeviceAliveForTransfer:
            return "Receive blink::mojom::MediaStreamDispatcherHost::KeepDeviceAliveForTransfer";
    }
  } else {
    switch (static_cast<messages::MediaStreamDispatcherHost>(message.name())) {
      case messages::MediaStreamDispatcherHost::kGenerateStreams:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::GenerateStreams";
      case messages::MediaStreamDispatcherHost::kFocusCapturedSurface:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::FocusCapturedSurface";
      case messages::MediaStreamDispatcherHost::kCancelRequest:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::CancelRequest";
      case messages::MediaStreamDispatcherHost::kStopStreamDevice:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::StopStreamDevice";
      case messages::MediaStreamDispatcherHost::kOpenDevice:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::OpenDevice";
      case messages::MediaStreamDispatcherHost::kCloseDevice:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::CloseDevice";
      case messages::MediaStreamDispatcherHost::kSetCapturingLinkSecured:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::SetCapturingLinkSecured";
      case messages::MediaStreamDispatcherHost::kApplySubCaptureTarget:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::ApplySubCaptureTarget";
      case messages::MediaStreamDispatcherHost::kSendWheel:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::SendWheel";
      case messages::MediaStreamDispatcherHost::kUpdateZoomLevel:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::UpdateZoomLevel";
      case messages::MediaStreamDispatcherHost::kRequestCapturedSurfaceControlPermission:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::RequestCapturedSurfaceControlPermission";
      case messages::MediaStreamDispatcherHost::kGetOpenDevice:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::GetOpenDevice";
      case messages::MediaStreamDispatcherHost::kKeepDeviceAliveForTransfer:
            return "Receive reply blink::mojom::MediaStreamDispatcherHost::KeepDeviceAliveForTransfer";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaStreamDispatcherHost::GenerateStreams_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x67c77c35;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::GenerateStreams
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::FocusCapturedSurface_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x88f549c0;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::FocusCapturedSurface
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::CancelRequest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x34b3116c;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::CancelRequest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::StopStreamDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa86d18e5;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::StopStreamDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::OpenDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4561a489;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::OpenDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::CloseDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd2e722b5;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::CloseDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::SetCapturingLinkSecured_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0785ce41;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::SetCapturingLinkSecured
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::ApplySubCaptureTarget_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2012b40a;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::ApplySubCaptureTarget
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::SendWheel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x43ab9e1b;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::SendWheel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::UpdateZoomLevel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6abd94f6;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::UpdateZoomLevel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::RequestCapturedSurfaceControlPermission_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeee5fed9;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::RequestCapturedSurfaceControlPermission
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::GetOpenDevice_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0554e2fe;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::GetOpenDevice
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamDispatcherHost::KeepDeviceAliveForTransfer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbfa63d47;  // IPCStableHash for blink::mojom::MediaStreamDispatcherHost::KeepDeviceAliveForTransfer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool MediaStreamDispatcherHost::GetOpenDevice(int32_t request_id, const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, MediaStreamRequestResult* out_result, GetOpenDeviceResponsePtr* out_response) {
  NOTREACHED();
}

class MediaStreamDispatcherHost_GenerateStreams_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaStreamDispatcherHost_GenerateStreams_ForwardToCallback(
      MediaStreamDispatcherHost::GenerateStreamsCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaStreamDispatcherHost_GenerateStreams_ForwardToCallback(const MediaStreamDispatcherHost_GenerateStreams_ForwardToCallback&) = delete;
  MediaStreamDispatcherHost_GenerateStreams_ForwardToCallback& operator=(const MediaStreamDispatcherHost_GenerateStreams_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaStreamDispatcherHost::GenerateStreamsCallback callback_;
};

class MediaStreamDispatcherHost_OpenDevice_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaStreamDispatcherHost_OpenDevice_ForwardToCallback(
      MediaStreamDispatcherHost::OpenDeviceCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaStreamDispatcherHost_OpenDevice_ForwardToCallback(const MediaStreamDispatcherHost_OpenDevice_ForwardToCallback&) = delete;
  MediaStreamDispatcherHost_OpenDevice_ForwardToCallback& operator=(const MediaStreamDispatcherHost_OpenDevice_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaStreamDispatcherHost::OpenDeviceCallback callback_;
};

class MediaStreamDispatcherHost_ApplySubCaptureTarget_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaStreamDispatcherHost_ApplySubCaptureTarget_ForwardToCallback(
      MediaStreamDispatcherHost::ApplySubCaptureTargetCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaStreamDispatcherHost_ApplySubCaptureTarget_ForwardToCallback(const MediaStreamDispatcherHost_ApplySubCaptureTarget_ForwardToCallback&) = delete;
  MediaStreamDispatcherHost_ApplySubCaptureTarget_ForwardToCallback& operator=(const MediaStreamDispatcherHost_ApplySubCaptureTarget_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaStreamDispatcherHost::ApplySubCaptureTargetCallback callback_;
};

class MediaStreamDispatcherHost_UpdateZoomLevel_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaStreamDispatcherHost_UpdateZoomLevel_ForwardToCallback(
      MediaStreamDispatcherHost::UpdateZoomLevelCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaStreamDispatcherHost_UpdateZoomLevel_ForwardToCallback(const MediaStreamDispatcherHost_UpdateZoomLevel_ForwardToCallback&) = delete;
  MediaStreamDispatcherHost_UpdateZoomLevel_ForwardToCallback& operator=(const MediaStreamDispatcherHost_UpdateZoomLevel_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaStreamDispatcherHost::UpdateZoomLevelCallback callback_;
};

class MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ForwardToCallback(
      MediaStreamDispatcherHost::RequestCapturedSurfaceControlPermissionCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ForwardToCallback(const MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ForwardToCallback&) = delete;
  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ForwardToCallback& operator=(const MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaStreamDispatcherHost::RequestCapturedSurfaceControlPermissionCallback callback_;
};
class MediaStreamDispatcherHost_GetOpenDevice_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  MediaStreamDispatcherHost_GetOpenDevice_HandleSyncResponse(
      bool* result, MediaStreamRequestResult* out_result, GetOpenDeviceResponsePtr* out_response)
      : result_(result), out_result_(out_result), out_response_(out_response) {
    DCHECK(!*result_);
  }

  MediaStreamDispatcherHost_GetOpenDevice_HandleSyncResponse(const MediaStreamDispatcherHost_GetOpenDevice_HandleSyncResponse&) = delete;
  MediaStreamDispatcherHost_GetOpenDevice_HandleSyncResponse& operator=(const MediaStreamDispatcherHost_GetOpenDevice_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  MediaStreamRequestResult* out_result_;
  GetOpenDeviceResponsePtr* out_response_;};

class MediaStreamDispatcherHost_GetOpenDevice_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaStreamDispatcherHost_GetOpenDevice_ForwardToCallback(
      MediaStreamDispatcherHost::GetOpenDeviceCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaStreamDispatcherHost_GetOpenDevice_ForwardToCallback(const MediaStreamDispatcherHost_GetOpenDevice_ForwardToCallback&) = delete;
  MediaStreamDispatcherHost_GetOpenDevice_ForwardToCallback& operator=(const MediaStreamDispatcherHost_GetOpenDevice_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaStreamDispatcherHost::GetOpenDeviceCallback callback_;
};

class MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ForwardToCallback(
      MediaStreamDispatcherHost::KeepDeviceAliveForTransferCallback callback
      ) : callback_(std::move(callback)) {
  }

  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ForwardToCallback(const MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ForwardToCallback&) = delete;
  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ForwardToCallback& operator=(const MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MediaStreamDispatcherHost::KeepDeviceAliveForTransferCallback callback_;
};

MediaStreamDispatcherHostProxy::MediaStreamDispatcherHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaStreamDispatcherHostProxy::GenerateStreams(
    int32_t in_request_id, const ::blink::StreamControls& in_controls, bool in_user_gesture, StreamSelectionInfoPtr in_audio_stream_selection_info, GenerateStreamsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::GenerateStreams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("controls"), in_controls,
                        "<value of type const ::blink::StreamControls&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_gesture"), in_user_gesture,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("audio_stream_selection_info"), in_audio_stream_selection_info,
                        "<value of type StreamSelectionInfoPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kGenerateStreams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_GenerateStreams_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->controls)::BaseType> controls_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StreamControlsDataView>(
    in_controls,
    controls_fragment);

  params->controls.Set(
      controls_fragment.is_null() ? nullptr : controls_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->controls.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null controls in MediaStreamDispatcherHost.GenerateStreams request");

  params->user_gesture = in_user_gesture;
  mojo::internal::MessageFragment<decltype(params->audio_stream_selection_info)>
      audio_stream_selection_info_fragment(params.message());
  audio_stream_selection_info_fragment.Claim(&params->audio_stream_selection_info);
  
  mojo::internal::Serialize<::blink::mojom::StreamSelectionInfoDataView>(
    in_audio_stream_selection_info,
    audio_stream_selection_info_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->audio_stream_selection_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null audio_stream_selection_info in MediaStreamDispatcherHost.GenerateStreams request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("GenerateStreams");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaStreamDispatcherHost_GenerateStreams_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaStreamDispatcherHostProxy::FocusCapturedSurface(
    const ::blink::String& in_label, bool in_focus) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::FocusCapturedSurface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("focus"), in_focus,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kFocusCapturedSurface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in MediaStreamDispatcherHost.FocusCapturedSurface request");

  params->focus = in_focus;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("FocusCapturedSurface");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamDispatcherHostProxy::CancelRequest(
    int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::CancelRequest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kCancelRequest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_CancelRequest_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("CancelRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamDispatcherHostProxy::StopStreamDevice(
    const ::blink::String& in_device_id, const std::optional<::base::UnguessableToken>& in_session_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::StopStreamDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kStopStreamDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_StopStreamDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in MediaStreamDispatcherHost.StopStreamDevice request");
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("StopStreamDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamDispatcherHostProxy::OpenDevice(
    int32_t in_request_id, const ::blink::String& in_device_id, MediaStreamType in_type, OpenDeviceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::OpenDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_id"), in_device_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type MediaStreamType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kOpenDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_OpenDevice_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->device_id)::BaseType> device_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_id,
    device_id_fragment);

  params->device_id.Set(
      device_id_fragment.is_null() ? nullptr : device_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_id in MediaStreamDispatcherHost.OpenDevice request");

  
  mojo::internal::Serialize<::blink::mojom::MediaStreamType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("OpenDevice");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaStreamDispatcherHost_OpenDevice_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaStreamDispatcherHostProxy::CloseDevice(
    const ::blink::String& in_label) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::CloseDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kCloseDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_CloseDevice_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in MediaStreamDispatcherHost.CloseDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("CloseDevice");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamDispatcherHostProxy::SetCapturingLinkSecured(
    const std::optional<::base::UnguessableToken>& in_session_id, MediaStreamType in_type, bool in_is_secure) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::SetCapturingLinkSecured", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type MediaStreamType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_secure"), in_is_secure,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kSetCapturingLinkSecured), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  mojo::internal::Serialize<::blink::mojom::MediaStreamType>(
    in_type,
    &params->type);

  params->is_secure = in_is_secure;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("SetCapturingLinkSecured");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamDispatcherHostProxy::ApplySubCaptureTarget(
    const ::base::UnguessableToken& in_session_id, ::media::mojom::blink::SubCaptureTargetType in_type, const ::base::Token& in_sub_capture_target, uint32_t in_sub_capture_target_version, ApplySubCaptureTargetCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::ApplySubCaptureTarget", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::media::mojom::blink::SubCaptureTargetType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sub_capture_target"), in_sub_capture_target,
                        "<value of type const ::base::Token&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sub_capture_target_version"), in_sub_capture_target_version,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kApplySubCaptureTarget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in MediaStreamDispatcherHost.ApplySubCaptureTarget request");

  
  mojo::internal::Serialize<::media::mojom::SubCaptureTargetType>(
    in_type,
    &params->type);
  mojo::internal::MessageFragment<
      typename decltype(params->sub_capture_target)::BaseType> sub_capture_target_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
    in_sub_capture_target,
    sub_capture_target_fragment);

  params->sub_capture_target.Set(
      sub_capture_target_fragment.is_null() ? nullptr : sub_capture_target_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sub_capture_target.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sub_capture_target in MediaStreamDispatcherHost.ApplySubCaptureTarget request");

  params->sub_capture_target_version = in_sub_capture_target_version;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("ApplySubCaptureTarget");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaStreamDispatcherHost_ApplySubCaptureTarget_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaStreamDispatcherHostProxy::SendWheel(
    const ::base::UnguessableToken& in_session_id, CapturedWheelActionPtr in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::SendWheel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type CapturedWheelActionPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kSendWheel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_SendWheel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in MediaStreamDispatcherHost.SendWheel request");
  mojo::internal::MessageFragment<
      typename decltype(params->action)::BaseType> action_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::CapturedWheelActionDataView>(
    in_action,
    action_fragment);

  params->action.Set(
      action_fragment.is_null() ? nullptr : action_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->action.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null action in MediaStreamDispatcherHost.SendWheel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("SendWheel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamDispatcherHostProxy::UpdateZoomLevel(
    const ::base::UnguessableToken& in_session_id, ZoomLevelAction in_action, UpdateZoomLevelCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::UpdateZoomLevel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type ZoomLevelAction>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kUpdateZoomLevel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in MediaStreamDispatcherHost.UpdateZoomLevel request");

  
  mojo::internal::Serialize<::blink::mojom::ZoomLevelAction>(
    in_action,
    &params->action);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("UpdateZoomLevel");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaStreamDispatcherHost_UpdateZoomLevel_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaStreamDispatcherHostProxy::RequestCapturedSurfaceControlPermission(
    const ::base::UnguessableToken& in_session_id, RequestCapturedSurfaceControlPermissionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::RequestCapturedSurfaceControlPermission", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kRequestCapturedSurfaceControlPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in MediaStreamDispatcherHost.RequestCapturedSurfaceControlPermission request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("RequestCapturedSurfaceControlPermission");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool MediaStreamDispatcherHostProxy::GetOpenDevice(
    int32_t param_request_id, const ::base::UnguessableToken& param_session_id, const ::base::UnguessableToken& param_transfer_id, MediaStreamRequestResult* out_param_result, GetOpenDeviceResponsePtr* out_param_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::MediaStreamDispatcherHost::GetOpenDevice (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), param_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), param_session_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transfer_id"), param_transfer_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#else
  TRACE_EVENT0("mojom", "MediaStreamDispatcherHost::GetOpenDevice");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kGetOpenDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_GetOpenDevice_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = param_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    param_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in MediaStreamDispatcherHost.GetOpenDevice request");
  mojo::internal::MessageFragment<
      typename decltype(params->transfer_id)::BaseType> transfer_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    param_transfer_id,
    transfer_id_fragment);

  params->transfer_id.Set(
      transfer_id_fragment.is_null() ? nullptr : transfer_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->transfer_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null transfer_id in MediaStreamDispatcherHost.GetOpenDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("GetOpenDevice");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaStreamDispatcherHost_GetOpenDevice_HandleSyncResponse(
          &result, out_param_result, out_param_response));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "MediaStreamDispatcherHost::GetOpenDevice", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), out_param_result,
                        "<value of type MediaStreamRequestResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), out_param_response,
                        "<value of type GetOpenDeviceResponsePtr>");
   });
#endif
  return result;
}

void MediaStreamDispatcherHostProxy::GetOpenDevice(
    int32_t in_request_id, const ::base::UnguessableToken& in_session_id, const ::base::UnguessableToken& in_transfer_id, GetOpenDeviceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::GetOpenDevice", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transfer_id"), in_transfer_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kGetOpenDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_GetOpenDevice_Params_Data> params(
          message);
  params.Allocate();

  params->request_id = in_request_id;
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in MediaStreamDispatcherHost.GetOpenDevice request");
  mojo::internal::MessageFragment<
      typename decltype(params->transfer_id)::BaseType> transfer_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_transfer_id,
    transfer_id_fragment);

  params->transfer_id.Set(
      transfer_id_fragment.is_null() ? nullptr : transfer_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->transfer_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null transfer_id in MediaStreamDispatcherHost.GetOpenDevice request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("GetOpenDevice");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaStreamDispatcherHost_GetOpenDevice_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void MediaStreamDispatcherHostProxy::KeepDeviceAliveForTransfer(
    const ::base::UnguessableToken& in_session_id, const ::base::UnguessableToken& in_transfer_id, KeepDeviceAliveForTransferCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamDispatcherHost::KeepDeviceAliveForTransfer", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_id"), in_session_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("transfer_id"), in_transfer_id,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kKeepDeviceAliveForTransfer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->session_id)::BaseType> session_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_session_id,
    session_id_fragment);

  params->session_id.Set(
      session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->session_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null session_id in MediaStreamDispatcherHost.KeepDeviceAliveForTransfer request");
  mojo::internal::MessageFragment<
      typename decltype(params->transfer_id)::BaseType> transfer_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_transfer_id,
    transfer_id_fragment);

  params->transfer_id.Set(
      transfer_id_fragment.is_null() ? nullptr : transfer_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->transfer_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null transfer_id in MediaStreamDispatcherHost.KeepDeviceAliveForTransfer request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("KeepDeviceAliveForTransfer");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MediaStreamDispatcherHost_GenerateStreams_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaStreamDispatcherHost::GenerateStreamsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaStreamDispatcherHost_GenerateStreams_ProxyToResponder> proxy(
        new MediaStreamDispatcherHost_GenerateStreams_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaStreamDispatcherHost_GenerateStreams_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaStreamDispatcherHost_GenerateStreams_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaStreamDispatcherHost_GenerateStreams_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaStreamDispatcherHost::GenerateStreamsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      MediaStreamRequestResult in_result, const ::blink::String& in_label, StreamDevicesSetPtr in_stream_devices, bool in_pan_tilt_zoom_allowed);
};

bool MediaStreamDispatcherHost_GenerateStreams_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaStreamDispatcherHost.0
  bool success = true;
  MediaStreamRequestResult p_result{};
  ::blink::String p_label{};
  StreamDevicesSetPtr p_stream_devices{};
  bool p_pan_tilt_zoom_allowed{};
  MediaStreamDispatcherHost_GenerateStreams_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadLabel(&p_label))
    success = false;
  if (success && !input_data_view.ReadStreamDevices(&p_stream_devices))
    success = false;
  if (success)
    p_pan_tilt_zoom_allowed = input_data_view.pan_tilt_zoom_allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaStreamDispatcherHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_label), 
std::move(p_stream_devices), 
std::move(p_pan_tilt_zoom_allowed));
  }
  return true;
}

void MediaStreamDispatcherHost_GenerateStreams_ProxyToResponder::Run(
    MediaStreamRequestResult in_result, const ::blink::String& in_label, StreamDevicesSetPtr in_stream_devices, bool in_pan_tilt_zoom_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaStreamDispatcherHost::GenerateStreams", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type MediaStreamRequestResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream_devices"), in_stream_devices,
                        "<value of type StreamDevicesSetPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pan_tilt_zoom_allowed"), in_pan_tilt_zoom_allowed,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kGenerateStreams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::MediaStreamRequestResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in ");
  mojo::internal::MessageFragment<
      typename decltype(params->stream_devices)::BaseType> stream_devices_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StreamDevicesSetDataView>(
    in_stream_devices,
    stream_devices_fragment);

  params->stream_devices.Set(
      stream_devices_fragment.is_null() ? nullptr : stream_devices_fragment.data());

  params->pan_tilt_zoom_allowed = in_pan_tilt_zoom_allowed;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("GenerateStreams");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaStreamDispatcherHost_OpenDevice_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaStreamDispatcherHost::OpenDeviceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaStreamDispatcherHost_OpenDevice_ProxyToResponder> proxy(
        new MediaStreamDispatcherHost_OpenDevice_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaStreamDispatcherHost_OpenDevice_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaStreamDispatcherHost_OpenDevice_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaStreamDispatcherHost_OpenDevice_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaStreamDispatcherHost::OpenDeviceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const ::blink::String& in_label, const ::blink::MediaStreamDevice& in_device);
};

bool MediaStreamDispatcherHost_OpenDevice_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaStreamDispatcherHost.4
  bool success = true;
  bool p_success{};
  ::blink::String p_label{};
  ::blink::MediaStreamDevice p_device{};
  MediaStreamDispatcherHost_OpenDevice_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadLabel(&p_label))
    success = false;
  if (success && !input_data_view.ReadDevice(&p_device))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaStreamDispatcherHost::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_label), 
std::move(p_device));
  }
  return true;
}

void MediaStreamDispatcherHost_OpenDevice_ProxyToResponder::Run(
    bool in_success, const ::blink::String& in_label, const ::blink::MediaStreamDevice& in_device) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaStreamDispatcherHost::OpenDevice", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("label"), in_label,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device"), in_device,
                        "<value of type const ::blink::MediaStreamDevice&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kOpenDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->label)::BaseType> label_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_label,
    label_fragment);

  params->label.Set(
      label_fragment.is_null() ? nullptr : label_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->label.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null label in ");
  mojo::internal::MessageFragment<
      typename decltype(params->device)::BaseType> device_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::MediaStreamDeviceDataView>(
    in_device,
    device_fragment);

  params->device.Set(
      device_fragment.is_null() ? nullptr : device_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("OpenDevice");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaStreamDispatcherHost_ApplySubCaptureTarget_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaStreamDispatcherHost::ApplySubCaptureTargetCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaStreamDispatcherHost_ApplySubCaptureTarget_ProxyToResponder> proxy(
        new MediaStreamDispatcherHost_ApplySubCaptureTarget_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaStreamDispatcherHost_ApplySubCaptureTarget_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaStreamDispatcherHost_ApplySubCaptureTarget_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaStreamDispatcherHost_ApplySubCaptureTarget_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaStreamDispatcherHost::ApplySubCaptureTargetCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::media::mojom::blink::ApplySubCaptureTargetResult in_result);
};

bool MediaStreamDispatcherHost_ApplySubCaptureTarget_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaStreamDispatcherHost.7
  bool success = true;
  ::media::mojom::blink::ApplySubCaptureTargetResult p_result{};
  MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaStreamDispatcherHost::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void MediaStreamDispatcherHost_ApplySubCaptureTarget_ProxyToResponder::Run(
    ::media::mojom::blink::ApplySubCaptureTargetResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaStreamDispatcherHost::ApplySubCaptureTarget", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::media::mojom::blink::ApplySubCaptureTargetResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kApplySubCaptureTarget), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::media::mojom::ApplySubCaptureTargetResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("ApplySubCaptureTarget");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaStreamDispatcherHost_UpdateZoomLevel_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaStreamDispatcherHost::UpdateZoomLevelCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaStreamDispatcherHost_UpdateZoomLevel_ProxyToResponder> proxy(
        new MediaStreamDispatcherHost_UpdateZoomLevel_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaStreamDispatcherHost_UpdateZoomLevel_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaStreamDispatcherHost_UpdateZoomLevel_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaStreamDispatcherHost_UpdateZoomLevel_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaStreamDispatcherHost::UpdateZoomLevelCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CapturedSurfaceControlResult in_result);
};

bool MediaStreamDispatcherHost_UpdateZoomLevel_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaStreamDispatcherHost.9
  bool success = true;
  CapturedSurfaceControlResult p_result{};
  MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaStreamDispatcherHost::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void MediaStreamDispatcherHost_UpdateZoomLevel_ProxyToResponder::Run(
    CapturedSurfaceControlResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaStreamDispatcherHost::UpdateZoomLevel", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CapturedSurfaceControlResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kUpdateZoomLevel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::CapturedSurfaceControlResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("UpdateZoomLevel");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaStreamDispatcherHost::RequestCapturedSurfaceControlPermissionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ProxyToResponder> proxy(
        new MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaStreamDispatcherHost::RequestCapturedSurfaceControlPermissionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CapturedSurfaceControlResult in_result);
};

bool MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaStreamDispatcherHost.10
  bool success = true;
  CapturedSurfaceControlResult p_result{};
  MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaStreamDispatcherHost::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ProxyToResponder::Run(
    CapturedSurfaceControlResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaStreamDispatcherHost::RequestCapturedSurfaceControlPermission", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CapturedSurfaceControlResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kRequestCapturedSurfaceControlPermission), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::CapturedSurfaceControlResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("RequestCapturedSurfaceControlPermission");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class MediaStreamDispatcherHost_GetOpenDevice_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaStreamDispatcherHost::GetOpenDeviceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaStreamDispatcherHost_GetOpenDevice_ProxyToResponder> proxy(
        new MediaStreamDispatcherHost_GetOpenDevice_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaStreamDispatcherHost_GetOpenDevice_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaStreamDispatcherHost_GetOpenDevice_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaStreamDispatcherHost_GetOpenDevice_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaStreamDispatcherHost::GetOpenDeviceCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      MediaStreamRequestResult in_result, GetOpenDeviceResponsePtr in_response);
};

bool MediaStreamDispatcherHost_GetOpenDevice_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaStreamDispatcherHost.11
  bool success = true;
  MediaStreamRequestResult p_result{};
  GetOpenDeviceResponsePtr p_response{};
  MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaStreamDispatcherHost::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_response));
  }
  return true;
}

void MediaStreamDispatcherHost_GetOpenDevice_ProxyToResponder::Run(
    MediaStreamRequestResult in_result, GetOpenDeviceResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaStreamDispatcherHost::GetOpenDevice", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type MediaStreamRequestResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type GetOpenDeviceResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kGetOpenDevice), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::MediaStreamRequestResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::GetOpenDeviceResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("GetOpenDevice");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool MediaStreamDispatcherHost_GetOpenDevice_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data* params =
      reinterpret_cast<internal::MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for MediaStreamDispatcherHost.11
  bool success = true;
  MediaStreamRequestResult p_result{};
  GetOpenDeviceResponsePtr p_response{};
  MediaStreamDispatcherHost_GetOpenDevice_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaStreamDispatcherHost::Name_, 11, true);
    return false;
  }
  *out_result_ = std::move(p_result);
  *out_response_ = std::move(p_response);
  *result_ = true;
  return true;
}
class MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MediaStreamDispatcherHost::KeepDeviceAliveForTransferCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ProxyToResponder> proxy(
        new MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MediaStreamDispatcherHost::KeepDeviceAliveForTransferCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_device_found);
};

bool MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MediaStreamDispatcherHost.12
  bool success = true;
  bool p_device_found{};
  MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_device_found = input_data_view.device_found();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MediaStreamDispatcherHost::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_device_found));
  }
  return true;
}

void MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ProxyToResponder::Run(
    bool in_device_found) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MediaStreamDispatcherHost::KeepDeviceAliveForTransfer", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_found"), in_device_found,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamDispatcherHost::kKeepDeviceAliveForTransfer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->device_found = in_device_found;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamDispatcherHost::Name_);
  message.set_method_name("KeepDeviceAliveForTransfer");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool MediaStreamDispatcherHostStubDispatch::Accept(
    MediaStreamDispatcherHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaStreamDispatcherHost>(message->header()->name)) {
    case messages::MediaStreamDispatcherHost::kGenerateStreams: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kFocusCapturedSurface: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.1
      bool success = true;
      ::blink::String p_label{};
      bool p_focus{};
      MediaStreamDispatcherHost_FocusCapturedSurface_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (success)
        p_focus = input_data_view.focus();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FocusCapturedSurface(        
        std::move(p_label), 
        std::move(p_focus));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kCancelRequest: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDispatcherHost_CancelRequest_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDispatcherHost_CancelRequest_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.2
      bool success = true;
      int32_t p_request_id{};
      MediaStreamDispatcherHost_CancelRequest_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelRequest(        
        std::move(p_request_id));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kStopStreamDevice: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDispatcherHost_StopStreamDevice_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDispatcherHost_StopStreamDevice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.3
      bool success = true;
      ::blink::String p_device_id{};
      std::optional<::base::UnguessableToken> p_session_id{};
      MediaStreamDispatcherHost_StopStreamDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StopStreamDevice(        
        std::move(p_device_id), 
        std::move(p_session_id));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kOpenDevice: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kCloseDevice: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDispatcherHost_CloseDevice_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDispatcherHost_CloseDevice_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.5
      bool success = true;
      ::blink::String p_label{};
      MediaStreamDispatcherHost_CloseDevice_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLabel(&p_label))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseDevice(        
        std::move(p_label));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kSetCapturingLinkSecured: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.6
      bool success = true;
      std::optional<::base::UnguessableToken> p_session_id{};
      MediaStreamType p_type{};
      bool p_is_secure{};
      MediaStreamDispatcherHost_SetCapturingLinkSecured_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success)
        p_is_secure = input_data_view.is_secure();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCapturingLinkSecured(        
        std::move(p_session_id), 
        std::move(p_type), 
        std::move(p_is_secure));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kApplySubCaptureTarget: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kSendWheel: {
      DCHECK(message->is_serialized());
      internal::MediaStreamDispatcherHost_SendWheel_Params_Data* params =
          reinterpret_cast<internal::MediaStreamDispatcherHost_SendWheel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.8
      bool success = true;
      ::base::UnguessableToken p_session_id{};
      CapturedWheelActionPtr p_action{};
      MediaStreamDispatcherHost_SendWheel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendWheel(        
        std::move(p_session_id), 
        std::move(p_action));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kUpdateZoomLevel: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kRequestCapturedSurfaceControlPermission: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kGetOpenDevice: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kKeepDeviceAliveForTransfer: {
      break;
    }
  }
  return false;
}

// static
bool MediaStreamDispatcherHostStubDispatch::AcceptWithResponder(
    MediaStreamDispatcherHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaStreamDispatcherHost>(message->header()->name)) {
    case messages::MediaStreamDispatcherHost::kGenerateStreams: {
      internal::MediaStreamDispatcherHost_GenerateStreams_Params_Data* params =
          reinterpret_cast<
              internal::MediaStreamDispatcherHost_GenerateStreams_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.0
      bool success = true;
      int32_t p_request_id{};
      ::blink::StreamControls p_controls{};
      bool p_user_gesture{};
      StreamSelectionInfoPtr p_audio_stream_selection_info{};
      MediaStreamDispatcherHost_GenerateStreams_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadControls(&p_controls))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (success && !input_data_view.ReadAudioStreamSelectionInfo(&p_audio_stream_selection_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 0, false);
        return false;
      }
      auto callback =
          MediaStreamDispatcherHost_GenerateStreams_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GenerateStreams(        
        std::move(p_request_id), 
        std::move(p_controls), 
        std::move(p_user_gesture), 
        std::move(p_audio_stream_selection_info), std::move(callback));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kFocusCapturedSurface: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kCancelRequest: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kStopStreamDevice: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kOpenDevice: {
      internal::MediaStreamDispatcherHost_OpenDevice_Params_Data* params =
          reinterpret_cast<
              internal::MediaStreamDispatcherHost_OpenDevice_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.4
      bool success = true;
      int32_t p_request_id{};
      ::blink::String p_device_id{};
      MediaStreamType p_type{};
      MediaStreamDispatcherHost_OpenDevice_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadDeviceId(&p_device_id))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 4, false);
        return false;
      }
      auto callback =
          MediaStreamDispatcherHost_OpenDevice_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenDevice(        
        std::move(p_request_id), 
        std::move(p_device_id), 
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kCloseDevice: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kSetCapturingLinkSecured: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kApplySubCaptureTarget: {
      internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data* params =
          reinterpret_cast<
              internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.7
      bool success = true;
      ::base::UnguessableToken p_session_id{};
      ::media::mojom::blink::SubCaptureTargetType p_type{};
      ::base::Token p_sub_capture_target{};
      uint32_t p_sub_capture_target_version{};
      MediaStreamDispatcherHost_ApplySubCaptureTarget_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadSubCaptureTarget(&p_sub_capture_target))
        success = false;
      if (success)
        p_sub_capture_target_version = input_data_view.sub_capture_target_version();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 7, false);
        return false;
      }
      auto callback =
          MediaStreamDispatcherHost_ApplySubCaptureTarget_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ApplySubCaptureTarget(        
        std::move(p_session_id), 
        std::move(p_type), 
        std::move(p_sub_capture_target), 
        std::move(p_sub_capture_target_version), std::move(callback));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kSendWheel: {
      break;
    }
    case messages::MediaStreamDispatcherHost::kUpdateZoomLevel: {
      internal::MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data* params =
          reinterpret_cast<
              internal::MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.9
      bool success = true;
      ::base::UnguessableToken p_session_id{};
      ZoomLevelAction p_action{};
      MediaStreamDispatcherHost_UpdateZoomLevel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadAction(&p_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 9, false);
        return false;
      }
      auto callback =
          MediaStreamDispatcherHost_UpdateZoomLevel_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateZoomLevel(        
        std::move(p_session_id), 
        std::move(p_action), std::move(callback));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kRequestCapturedSurfaceControlPermission: {
      internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data* params =
          reinterpret_cast<
              internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.10
      bool success = true;
      ::base::UnguessableToken p_session_id{};
      MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 10, false);
        return false;
      }
      auto callback =
          MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestCapturedSurfaceControlPermission(        
        std::move(p_session_id), std::move(callback));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kGetOpenDevice: {
      internal::MediaStreamDispatcherHost_GetOpenDevice_Params_Data* params =
          reinterpret_cast<
              internal::MediaStreamDispatcherHost_GetOpenDevice_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.11
      bool success = true;
      int32_t p_request_id{};
      ::base::UnguessableToken p_session_id{};
      ::base::UnguessableToken p_transfer_id{};
      MediaStreamDispatcherHost_GetOpenDevice_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadTransferId(&p_transfer_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 11, false);
        return false;
      }
      auto callback =
          MediaStreamDispatcherHost_GetOpenDevice_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetOpenDevice(        
        std::move(p_request_id), 
        std::move(p_session_id), 
        std::move(p_transfer_id), std::move(callback));
      return true;
    }
    case messages::MediaStreamDispatcherHost::kKeepDeviceAliveForTransfer: {
      internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data* params =
          reinterpret_cast<
              internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MediaStreamDispatcherHost.12
      bool success = true;
      ::base::UnguessableToken p_session_id{};
      ::base::UnguessableToken p_transfer_id{};
      MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSessionId(&p_session_id))
        success = false;
      if (success && !input_data_view.ReadTransferId(&p_transfer_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamDispatcherHost::Name_, 12, false);
        return false;
      }
      auto callback =
          MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->KeepDeviceAliveForTransfer(        
        std::move(p_session_id), 
        std::move(p_transfer_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaStreamDispatcherHostValidationInfo[] = {
    { &internal::MediaStreamDispatcherHost_GenerateStreams_Params_Data::Validate,
     &internal::MediaStreamDispatcherHost_GenerateStreams_ResponseParams_Data::Validate},
    { &internal::MediaStreamDispatcherHost_FocusCapturedSurface_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamDispatcherHost_CancelRequest_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamDispatcherHost_StopStreamDevice_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamDispatcherHost_OpenDevice_Params_Data::Validate,
     &internal::MediaStreamDispatcherHost_OpenDevice_ResponseParams_Data::Validate},
    { &internal::MediaStreamDispatcherHost_CloseDevice_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamDispatcherHost_SetCapturingLinkSecured_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_Params_Data::Validate,
     &internal::MediaStreamDispatcherHost_ApplySubCaptureTarget_ResponseParams_Data::Validate},
    { &internal::MediaStreamDispatcherHost_SendWheel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamDispatcherHost_UpdateZoomLevel_Params_Data::Validate,
     &internal::MediaStreamDispatcherHost_UpdateZoomLevel_ResponseParams_Data::Validate},
    { &internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_Params_Data::Validate,
     &internal::MediaStreamDispatcherHost_RequestCapturedSurfaceControlPermission_ResponseParams_Data::Validate},
    { &internal::MediaStreamDispatcherHost_GetOpenDevice_Params_Data::Validate,
     &internal::MediaStreamDispatcherHost_GetOpenDevice_ResponseParams_Data::Validate},
    { &internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_Params_Data::Validate,
     &internal::MediaStreamDispatcherHost_KeepDeviceAliveForTransfer_ResponseParams_Data::Validate},
};

bool MediaStreamDispatcherHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::MediaStreamDispatcherHost::Name_,
    kMediaStreamDispatcherHostValidationInfo);
}

bool MediaStreamDispatcherHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::MediaStreamDispatcherHost::Name_,
    kMediaStreamDispatcherHostValidationInfo);
}
// The declaration includes the definition on other builds.

MediaStreamTrackMetricsHost::IPCStableHashFunction MediaStreamTrackMetricsHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaStreamTrackMetricsHost>(message.name())) {
    case messages::MediaStreamTrackMetricsHost::kAddTrack: {
      return &MediaStreamTrackMetricsHost::AddTrack_Sym::IPCStableHash;
    }
    case messages::MediaStreamTrackMetricsHost::kRemoveTrack: {
      return &MediaStreamTrackMetricsHost::RemoveTrack_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaStreamTrackMetricsHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaStreamTrackMetricsHost>(message.name())) {
      case messages::MediaStreamTrackMetricsHost::kAddTrack:
            return "Receive blink::mojom::MediaStreamTrackMetricsHost::AddTrack";
      case messages::MediaStreamTrackMetricsHost::kRemoveTrack:
            return "Receive blink::mojom::MediaStreamTrackMetricsHost::RemoveTrack";
    }
  } else {
    switch (static_cast<messages::MediaStreamTrackMetricsHost>(message.name())) {
      case messages::MediaStreamTrackMetricsHost::kAddTrack:
            return "Receive reply blink::mojom::MediaStreamTrackMetricsHost::AddTrack";
      case messages::MediaStreamTrackMetricsHost::kRemoveTrack:
            return "Receive reply blink::mojom::MediaStreamTrackMetricsHost::RemoveTrack";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaStreamTrackMetricsHost::AddTrack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed09e4a4;  // IPCStableHash for blink::mojom::MediaStreamTrackMetricsHost::AddTrack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaStreamTrackMetricsHost::RemoveTrack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe2e640ce;  // IPCStableHash for blink::mojom::MediaStreamTrackMetricsHost::RemoveTrack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaStreamTrackMetricsHostProxy::MediaStreamTrackMetricsHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaStreamTrackMetricsHostProxy::AddTrack(
    uint64_t in_id, bool in_is_audio, bool in_is_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamTrackMetricsHost::AddTrack", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_audio"), in_is_audio,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_remote"), in_is_remote,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamTrackMetricsHost::kAddTrack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamTrackMetricsHost_AddTrack_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

  params->is_audio = in_is_audio;

  params->is_remote = in_is_remote;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamTrackMetricsHost::Name_);
  message.set_method_name("AddTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaStreamTrackMetricsHostProxy::RemoveTrack(
    uint64_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MediaStreamTrackMetricsHost::RemoveTrack", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaStreamTrackMetricsHost::kRemoveTrack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MediaStreamTrackMetricsHost_RemoveTrack_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaStreamTrackMetricsHost::Name_);
  message.set_method_name("RemoveTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaStreamTrackMetricsHostStubDispatch::Accept(
    MediaStreamTrackMetricsHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaStreamTrackMetricsHost>(message->header()->name)) {
    case messages::MediaStreamTrackMetricsHost::kAddTrack: {
      DCHECK(message->is_serialized());
      internal::MediaStreamTrackMetricsHost_AddTrack_Params_Data* params =
          reinterpret_cast<internal::MediaStreamTrackMetricsHost_AddTrack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamTrackMetricsHost.0
      bool success = true;
      uint64_t p_id{};
      bool p_is_audio{};
      bool p_is_remote{};
      MediaStreamTrackMetricsHost_AddTrack_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (success)
        p_is_audio = input_data_view.is_audio();
      if (success)
        p_is_remote = input_data_view.is_remote();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamTrackMetricsHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddTrack(        
        std::move(p_id), 
        std::move(p_is_audio), 
        std::move(p_is_remote));
      return true;
    }
    case messages::MediaStreamTrackMetricsHost::kRemoveTrack: {
      DCHECK(message->is_serialized());
      internal::MediaStreamTrackMetricsHost_RemoveTrack_Params_Data* params =
          reinterpret_cast<internal::MediaStreamTrackMetricsHost_RemoveTrack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaStreamTrackMetricsHost.1
      bool success = true;
      uint64_t p_id{};
      MediaStreamTrackMetricsHost_RemoveTrack_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaStreamTrackMetricsHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveTrack(        
        std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool MediaStreamTrackMetricsHostStubDispatch::AcceptWithResponder(
    MediaStreamTrackMetricsHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaStreamTrackMetricsHost>(message->header()->name)) {
    case messages::MediaStreamTrackMetricsHost::kAddTrack: {
      break;
    }
    case messages::MediaStreamTrackMetricsHost::kRemoveTrack: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaStreamTrackMetricsHostValidationInfo[] = {
    { &internal::MediaStreamTrackMetricsHost_AddTrack_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaStreamTrackMetricsHost_RemoveTrack_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaStreamTrackMetricsHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::MediaStreamTrackMetricsHost::Name_,
    kMediaStreamTrackMetricsHostValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SearchOnlyByDeviceId::DataView, ::blink::mojom::blink::SearchOnlyByDeviceIdPtr>::Read(
    ::blink::mojom::blink::SearchOnlyByDeviceId::DataView input,
    ::blink::mojom::blink::SearchOnlyByDeviceIdPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SearchOnlyByDeviceIdPtr result(::blink::mojom::blink::SearchOnlyByDeviceId::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SearchBySessionId::DataView, ::blink::mojom::blink::SearchBySessionIdPtr>::Read(
    ::blink::mojom::blink::SearchBySessionId::DataView input,
    ::blink::mojom::blink::SearchBySessionIdPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SearchBySessionIdPtr result(::blink::mojom::blink::SearchBySessionId::New());
  
      if (success && !input.ReadSessionIdMap(&result->session_id_map))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::MediaStreamDevice::DataView, ::blink::mojom::blink::MediaStreamDevicePtr>::Read(
    ::blink::mojom::blink::MediaStreamDevice::DataView input,
    ::blink::mojom::blink::MediaStreamDevicePtr* output) {
  bool success = true;
  ::blink::mojom::blink::MediaStreamDevicePtr result(::blink::mojom::blink::MediaStreamDevice::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success)
        result->display_id = input.display_id();
      if (success && !input.ReadVideoFacing(&result->video_facing))
        success = false;
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success && !input.ReadMatchedOutputDeviceId(&result->matched_output_device_id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadInput(&result->input))
        success = false;
      if (success && !input.ReadSessionId(&result->session_id))
        success = false;
      if (success && !input.ReadDisplayMediaInfo(&result->display_media_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TrackControls::DataView, ::blink::mojom::blink::TrackControlsPtr>::Read(
    ::blink::mojom::blink::TrackControls::DataView input,
    ::blink::mojom::blink::TrackControlsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TrackControlsPtr result(::blink::mojom::blink::TrackControls::New());
  
      if (success && !input.ReadStreamType(&result->stream_type))
        success = false;
      if (success && !input.ReadDeviceIds(&result->device_ids))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::StreamControls::DataView, ::blink::mojom::blink::StreamControlsPtr>::Read(
    ::blink::mojom::blink::StreamControls::DataView input,
    ::blink::mojom::blink::StreamControlsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::StreamControlsPtr result(::blink::mojom::blink::StreamControls::New());
  
      if (success && !input.ReadAudio(&result->audio))
        success = false;
      if (success && !input.ReadVideo(&result->video))
        success = false;
      if (success)
        result->hotword_enabled = input.hotword_enabled();
      if (success)
        result->disable_local_echo = input.disable_local_echo();
      if (success)
        result->suppress_local_audio_playback = input.suppress_local_audio_playback();
      if (success)
        result->restrict_own_audio = input.restrict_own_audio();
      if (success)
        result->exclude_system_audio = input.exclude_system_audio();
      if (success && !input.ReadWindowAudioPreference(&result->window_audio_preference))
        success = false;
      if (success)
        result->exclude_self_browser_surface = input.exclude_self_browser_surface();
      if (success)
        result->request_pan_tilt_zoom_permission = input.request_pan_tilt_zoom_permission();
      if (success)
        result->request_all_screens = input.request_all_screens();
      if (success && !input.ReadPreferredDisplaySurface(&result->preferred_display_surface))
        success = false;
      if (success)
        result->dynamic_surface_switching_requested = input.dynamic_surface_switching_requested();
      if (success)
        result->exclude_monitor_type_surfaces = input.exclude_monitor_type_surfaces();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::GetOpenDeviceResponse::DataView, ::blink::mojom::blink::GetOpenDeviceResponsePtr>::Read(
    ::blink::mojom::blink::GetOpenDeviceResponse::DataView input,
    ::blink::mojom::blink::GetOpenDeviceResponsePtr* output) {
  bool success = true;
  ::blink::mojom::blink::GetOpenDeviceResponsePtr result(::blink::mojom::blink::GetOpenDeviceResponse::New());
  
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadDevice(&result->device))
        success = false;
      if (success)
        result->pan_tilt_zoom_allowed = input.pan_tilt_zoom_allowed();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::CapturedWheelAction::DataView, ::blink::mojom::blink::CapturedWheelActionPtr>::Read(
    ::blink::mojom::blink::CapturedWheelAction::DataView input,
    ::blink::mojom::blink::CapturedWheelActionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CapturedWheelActionPtr result(::blink::mojom::blink::CapturedWheelAction::New());
  
      if (success)
        result->relative_x = input.relative_x();
      if (success)
        result->relative_y = input.relative_y();
      if (success)
        result->wheel_delta_x = input.wheel_delta_x();
      if (success)
        result->wheel_delta_y = input.wheel_delta_y();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::StreamDevices::DataView, ::blink::mojom::blink::StreamDevicesPtr>::Read(
    ::blink::mojom::blink::StreamDevices::DataView input,
    ::blink::mojom::blink::StreamDevicesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::StreamDevicesPtr result(::blink::mojom::blink::StreamDevices::New());
  
      if (success && !input.ReadAudioDevice(&result->audio_device))
        success = false;
      if (success && !input.ReadVideoDevice(&result->video_device))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::StreamDevicesSet::DataView, ::blink::mojom::blink::StreamDevicesSetPtr>::Read(
    ::blink::mojom::blink::StreamDevicesSet::DataView input,
    ::blink::mojom::blink::StreamDevicesSetPtr* output) {
  bool success = true;
  ::blink::mojom::blink::StreamDevicesSetPtr result(::blink::mojom::blink::StreamDevicesSet::New());
  
      if (success && !input.ReadStreamDevices(&result->stream_devices))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::StreamSelectionInfo::DataView, ::blink::mojom::blink::StreamSelectionInfoPtr>::Read(
    ::blink::mojom::blink::StreamSelectionInfo::DataView input,
    ::blink::mojom::blink::StreamSelectionInfoPtr* output) {
  using UnionType = ::blink::mojom::blink::StreamSelectionInfo;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSearchOnlyByDeviceId: {
      ::blink::mojom::blink::SearchOnlyByDeviceIdPtr result_search_only_by_device_id{};
      if (!input.ReadSearchOnlyByDeviceId(&result_search_only_by_device_id))
        return false;

      *output = UnionType::NewSearchOnlyByDeviceId(
          std::move(result_search_only_by_device_id));
      break;
    }
    case Tag::kSearchBySessionId: {
      ::blink::mojom::blink::SearchBySessionIdPtr result_search_by_session_id{};
      if (!input.ReadSearchBySessionId(&result_search_by_session_id))
        return false;

      *output = UnionType::NewSearchBySessionId(
          std::move(result_search_by_session_id));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void MediaStreamDeviceObserverInterceptorForTesting::OnDeviceStopped(const ::blink::String& label, const ::blink::MediaStreamDevice& device) {
  GetForwardingInterface()->OnDeviceStopped(
    std::move(label)
    , 
    std::move(device)
    );
}
void MediaStreamDeviceObserverInterceptorForTesting::OnDeviceChanged(const ::blink::String& label, const ::blink::MediaStreamDevice& old_device, const ::blink::MediaStreamDevice& new_device) {
  GetForwardingInterface()->OnDeviceChanged(
    std::move(label)
    , 
    std::move(old_device)
    , 
    std::move(new_device)
    );
}
void MediaStreamDeviceObserverInterceptorForTesting::OnDeviceRequestStateChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device, MediaStreamStateChange new_state) {
  GetForwardingInterface()->OnDeviceRequestStateChange(
    std::move(label)
    , 
    std::move(device)
    , 
    std::move(new_state)
    );
}
void MediaStreamDeviceObserverInterceptorForTesting::OnDeviceCaptureConfigurationChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device) {
  GetForwardingInterface()->OnDeviceCaptureConfigurationChange(
    std::move(label)
    , 
    std::move(device)
    );
}
void MediaStreamDeviceObserverInterceptorForTesting::OnDeviceCaptureHandleChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device) {
  GetForwardingInterface()->OnDeviceCaptureHandleChange(
    std::move(label)
    , 
    std::move(device)
    );
}
void MediaStreamDeviceObserverInterceptorForTesting::OnZoomLevelChange(const ::blink::String& label, const ::blink::MediaStreamDevice& device, int32_t zoom_level) {
  GetForwardingInterface()->OnZoomLevelChange(
    std::move(label)
    , 
    std::move(device)
    , 
    std::move(zoom_level)
    );
}
MediaStreamDeviceObserverAsyncWaiter::MediaStreamDeviceObserverAsyncWaiter(
    MediaStreamDeviceObserver* proxy) : proxy_(proxy) {}

MediaStreamDeviceObserverAsyncWaiter::~MediaStreamDeviceObserverAsyncWaiter() = default;





void MediaStreamDispatcherHostInterceptorForTesting::GenerateStreams(int32_t request_id, const ::blink::StreamControls& controls, bool user_gesture, StreamSelectionInfoPtr audio_stream_selection_info, GenerateStreamsCallback callback) {
  GetForwardingInterface()->GenerateStreams(
    std::move(request_id)
    , 
    std::move(controls)
    , 
    std::move(user_gesture)
    , 
    std::move(audio_stream_selection_info)
    , std::move(callback));
}
void MediaStreamDispatcherHostInterceptorForTesting::FocusCapturedSurface(const ::blink::String& label, bool focus) {
  GetForwardingInterface()->FocusCapturedSurface(
    std::move(label)
    , 
    std::move(focus)
    );
}
void MediaStreamDispatcherHostInterceptorForTesting::CancelRequest(int32_t request_id) {
  GetForwardingInterface()->CancelRequest(
    std::move(request_id)
    );
}
void MediaStreamDispatcherHostInterceptorForTesting::StopStreamDevice(const ::blink::String& device_id, const std::optional<::base::UnguessableToken>& session_id) {
  GetForwardingInterface()->StopStreamDevice(
    std::move(device_id)
    , 
    std::move(session_id)
    );
}
void MediaStreamDispatcherHostInterceptorForTesting::OpenDevice(int32_t request_id, const ::blink::String& device_id, MediaStreamType type, OpenDeviceCallback callback) {
  GetForwardingInterface()->OpenDevice(
    std::move(request_id)
    , 
    std::move(device_id)
    , 
    std::move(type)
    , std::move(callback));
}
void MediaStreamDispatcherHostInterceptorForTesting::CloseDevice(const ::blink::String& label) {
  GetForwardingInterface()->CloseDevice(
    std::move(label)
    );
}
void MediaStreamDispatcherHostInterceptorForTesting::SetCapturingLinkSecured(const std::optional<::base::UnguessableToken>& session_id, MediaStreamType type, bool is_secure) {
  GetForwardingInterface()->SetCapturingLinkSecured(
    std::move(session_id)
    , 
    std::move(type)
    , 
    std::move(is_secure)
    );
}
void MediaStreamDispatcherHostInterceptorForTesting::ApplySubCaptureTarget(const ::base::UnguessableToken& session_id, ::media::mojom::blink::SubCaptureTargetType type, const ::base::Token& sub_capture_target, uint32_t sub_capture_target_version, ApplySubCaptureTargetCallback callback) {
  GetForwardingInterface()->ApplySubCaptureTarget(
    std::move(session_id)
    , 
    std::move(type)
    , 
    std::move(sub_capture_target)
    , 
    std::move(sub_capture_target_version)
    , std::move(callback));
}
void MediaStreamDispatcherHostInterceptorForTesting::SendWheel(const ::base::UnguessableToken& session_id, CapturedWheelActionPtr action) {
  GetForwardingInterface()->SendWheel(
    std::move(session_id)
    , 
    std::move(action)
    );
}
void MediaStreamDispatcherHostInterceptorForTesting::UpdateZoomLevel(const ::base::UnguessableToken& session_id, ZoomLevelAction action, UpdateZoomLevelCallback callback) {
  GetForwardingInterface()->UpdateZoomLevel(
    std::move(session_id)
    , 
    std::move(action)
    , std::move(callback));
}
void MediaStreamDispatcherHostInterceptorForTesting::RequestCapturedSurfaceControlPermission(const ::base::UnguessableToken& session_id, RequestCapturedSurfaceControlPermissionCallback callback) {
  GetForwardingInterface()->RequestCapturedSurfaceControlPermission(
    std::move(session_id)
    , std::move(callback));
}
void MediaStreamDispatcherHostInterceptorForTesting::GetOpenDevice(int32_t request_id, const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, GetOpenDeviceCallback callback) {
  GetForwardingInterface()->GetOpenDevice(
    std::move(request_id)
    , 
    std::move(session_id)
    , 
    std::move(transfer_id)
    , std::move(callback));
}
void MediaStreamDispatcherHostInterceptorForTesting::KeepDeviceAliveForTransfer(const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, KeepDeviceAliveForTransferCallback callback) {
  GetForwardingInterface()->KeepDeviceAliveForTransfer(
    std::move(session_id)
    , 
    std::move(transfer_id)
    , std::move(callback));
}
MediaStreamDispatcherHostAsyncWaiter::MediaStreamDispatcherHostAsyncWaiter(
    MediaStreamDispatcherHost* proxy) : proxy_(proxy) {}

MediaStreamDispatcherHostAsyncWaiter::~MediaStreamDispatcherHostAsyncWaiter() = default;


void MediaStreamDispatcherHostAsyncWaiter::GenerateStreams(
    int32_t request_id, const ::blink::StreamControls& controls, bool user_gesture, StreamSelectionInfoPtr audio_stream_selection_info, MediaStreamRequestResult* out_result, ::blink::String* out_label, StreamDevicesSetPtr* out_stream_devices, bool* out_pan_tilt_zoom_allowed) {
  base::RunLoop loop;
  proxy_->GenerateStreams(
      std::move(request_id),
      std::move(controls),
      std::move(user_gesture),
      std::move(audio_stream_selection_info),
      base::BindOnce(
          [](base::RunLoop* loop,
             MediaStreamRequestResult* out_result
,
             ::blink::String* out_label
,
             StreamDevicesSetPtr* out_stream_devices
,
             bool* out_pan_tilt_zoom_allowed
,
             MediaStreamRequestResult result,
             const ::blink::String& label,
             StreamDevicesSetPtr stream_devices,
             bool pan_tilt_zoom_allowed) {*out_result = std::move(result);*out_label = std::move(label);*out_stream_devices = std::move(stream_devices);*out_pan_tilt_zoom_allowed = std::move(pan_tilt_zoom_allowed);
            loop->Quit();
          },
          &loop,
          out_result,
          out_label,
          out_stream_devices,
          out_pan_tilt_zoom_allowed));
  loop.Run();
}



void MediaStreamDispatcherHostAsyncWaiter::OpenDevice(
    int32_t request_id, const ::blink::String& device_id, MediaStreamType type, bool* out_success, ::blink::String* out_label, ::blink::MediaStreamDevice* out_device) {
  base::RunLoop loop;
  proxy_->OpenDevice(
      std::move(request_id),
      std::move(device_id),
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             ::blink::String* out_label
,
             ::blink::MediaStreamDevice* out_device
,
             bool success,
             const ::blink::String& label,
             const ::blink::MediaStreamDevice& device) {*out_success = std::move(success);*out_label = std::move(label);*out_device = std::move(device);
            loop->Quit();
          },
          &loop,
          out_success,
          out_label,
          out_device));
  loop.Run();
}



void MediaStreamDispatcherHostAsyncWaiter::ApplySubCaptureTarget(
    const ::base::UnguessableToken& session_id, ::media::mojom::blink::SubCaptureTargetType type, const ::base::Token& sub_capture_target, uint32_t sub_capture_target_version, ::media::mojom::blink::ApplySubCaptureTargetResult* out_result) {
  base::RunLoop loop;
  proxy_->ApplySubCaptureTarget(
      std::move(session_id),
      std::move(type),
      std::move(sub_capture_target),
      std::move(sub_capture_target_version),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::media::mojom::blink::ApplySubCaptureTargetResult* out_result
,
             ::media::mojom::blink::ApplySubCaptureTargetResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::media::mojom::blink::ApplySubCaptureTargetResult MediaStreamDispatcherHostAsyncWaiter::ApplySubCaptureTarget(
    const ::base::UnguessableToken& session_id, ::media::mojom::blink::SubCaptureTargetType type, const ::base::Token& sub_capture_target, uint32_t sub_capture_target_version) {
  ::media::mojom::blink::ApplySubCaptureTargetResult async_wait_result;
  ApplySubCaptureTarget(std::move(session_id),std::move(type),std::move(sub_capture_target),std::move(sub_capture_target_version),&async_wait_result);
  return async_wait_result;
}

void MediaStreamDispatcherHostAsyncWaiter::UpdateZoomLevel(
    const ::base::UnguessableToken& session_id, ZoomLevelAction action, CapturedSurfaceControlResult* out_result) {
  base::RunLoop loop;
  proxy_->UpdateZoomLevel(
      std::move(session_id),
      std::move(action),
      base::BindOnce(
          [](base::RunLoop* loop,
             CapturedSurfaceControlResult* out_result
,
             CapturedSurfaceControlResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CapturedSurfaceControlResult MediaStreamDispatcherHostAsyncWaiter::UpdateZoomLevel(
    const ::base::UnguessableToken& session_id, ZoomLevelAction action) {
  CapturedSurfaceControlResult async_wait_result;
  UpdateZoomLevel(std::move(session_id),std::move(action),&async_wait_result);
  return async_wait_result;
}

void MediaStreamDispatcherHostAsyncWaiter::RequestCapturedSurfaceControlPermission(
    const ::base::UnguessableToken& session_id, CapturedSurfaceControlResult* out_result) {
  base::RunLoop loop;
  proxy_->RequestCapturedSurfaceControlPermission(
      std::move(session_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             CapturedSurfaceControlResult* out_result
,
             CapturedSurfaceControlResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CapturedSurfaceControlResult MediaStreamDispatcherHostAsyncWaiter::RequestCapturedSurfaceControlPermission(
    const ::base::UnguessableToken& session_id) {
  CapturedSurfaceControlResult async_wait_result;
  RequestCapturedSurfaceControlPermission(std::move(session_id),&async_wait_result);
  return async_wait_result;
}

void MediaStreamDispatcherHostAsyncWaiter::GetOpenDevice(
    int32_t request_id, const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, MediaStreamRequestResult* out_result, GetOpenDeviceResponsePtr* out_response) {
  base::RunLoop loop;
  proxy_->GetOpenDevice(
      std::move(request_id),
      std::move(session_id),
      std::move(transfer_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             MediaStreamRequestResult* out_result
,
             GetOpenDeviceResponsePtr* out_response
,
             MediaStreamRequestResult result,
             GetOpenDeviceResponsePtr response) {*out_result = std::move(result);*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_result,
          out_response));
  loop.Run();
}



void MediaStreamDispatcherHostAsyncWaiter::KeepDeviceAliveForTransfer(
    const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id, bool* out_device_found) {
  base::RunLoop loop;
  proxy_->KeepDeviceAliveForTransfer(
      std::move(session_id),
      std::move(transfer_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_device_found
,
             bool device_found) {*out_device_found = std::move(device_found);
            loop->Quit();
          },
          &loop,
          out_device_found));
  loop.Run();
}

bool MediaStreamDispatcherHostAsyncWaiter::KeepDeviceAliveForTransfer(
    const ::base::UnguessableToken& session_id, const ::base::UnguessableToken& transfer_id) {
  bool async_wait_result;
  KeepDeviceAliveForTransfer(std::move(session_id),std::move(transfer_id),&async_wait_result);
  return async_wait_result;
}




void MediaStreamTrackMetricsHostInterceptorForTesting::AddTrack(uint64_t id, bool is_audio, bool is_remote) {
  GetForwardingInterface()->AddTrack(
    std::move(id)
    , 
    std::move(is_audio)
    , 
    std::move(is_remote)
    );
}
void MediaStreamTrackMetricsHostInterceptorForTesting::RemoveTrack(uint64_t id) {
  GetForwardingInterface()->RemoveTrack(
    std::move(id)
    );
}
MediaStreamTrackMetricsHostAsyncWaiter::MediaStreamTrackMetricsHostAsyncWaiter(
    MediaStreamTrackMetricsHost* proxy) : proxy_(proxy) {}

MediaStreamTrackMetricsHostAsyncWaiter::~MediaStreamTrackMetricsHostAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif