// third_party/blink/public/mojom/mediastream/media_devices.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT MediaDevicesDispatcherHostInterceptorForTesting : public MediaDevicesDispatcherHost {
  virtual MediaDevicesDispatcherHost* GetForwardingInterface() = 0;
  void EnumerateDevices(bool request_audio_input, bool request_video_input, bool request_audio_output, bool request_video_input_capabilities, bool request_audio_input_capabilities, EnumerateDevicesCallback callback) override;
  void GetVideoInputCapabilities(GetVideoInputCapabilitiesCallback callback) override;
  void GetAllVideoInputDeviceFormats(const std::string& device_id, GetAllVideoInputDeviceFormatsCallback callback) override;
  void GetAvailableVideoInputDeviceFormats(const std::string& device_id, GetAvailableVideoInputDeviceFormatsCallback callback) override;
  void GetAudioInputCapabilities(GetAudioInputCapabilitiesCallback callback) override;
  void AddMediaDevicesListener(bool subscribe_audio_input, bool subscribe_video_input, bool subscribe_audio_output, ::mojo::PendingRemote<MediaDevicesListener> listener) override;
  void SetCaptureHandleConfig(::blink::mojom::CaptureHandleConfigPtr config) override;
  void CloseFocusWindowOfOpportunity(const std::string& label) override;
  void ProduceSubCaptureTargetId(::media::mojom::SubCaptureTargetType type, ProduceSubCaptureTargetIdCallback callback) override;
  void SetPreferredSinkId(const std::string& sink_id, SetPreferredSinkIdCallback callback) override;
  void SelectAudioOutput(const std::string& device_id, SelectAudioOutputCallback callback) override;
};
class BLINK_COMMON_EXPORT MediaDevicesDispatcherHostAsyncWaiter {
 public:
  explicit MediaDevicesDispatcherHostAsyncWaiter(MediaDevicesDispatcherHost* proxy);

  MediaDevicesDispatcherHostAsyncWaiter(const MediaDevicesDispatcherHostAsyncWaiter&) = delete;
  MediaDevicesDispatcherHostAsyncWaiter& operator=(const MediaDevicesDispatcherHostAsyncWaiter&) = delete;

  ~MediaDevicesDispatcherHostAsyncWaiter();
  void EnumerateDevices(
      bool request_audio_input, bool request_video_input, bool request_audio_output, bool request_video_input_capabilities, bool request_audio_input_capabilities, std::vector<std::vector<::blink::WebMediaDeviceInfo>>* out_enumeration, std::vector<VideoInputDeviceCapabilitiesPtr>* out_video_input_device_capabilities, std::vector<AudioInputDeviceCapabilitiesPtr>* out_audio_input_device_capabilities);
  
  void GetVideoInputCapabilities(
      std::vector<VideoInputDeviceCapabilitiesPtr>* out_video_input_device_capabilities);
  std::vector<VideoInputDeviceCapabilitiesPtr> GetVideoInputCapabilities();
  void GetAllVideoInputDeviceFormats(
      const std::string& device_id, std::vector<::media::VideoCaptureFormat>* out_formats);
  std::vector<::media::VideoCaptureFormat> GetAllVideoInputDeviceFormats(const std::string& device_id);
  void GetAvailableVideoInputDeviceFormats(
      const std::string& device_id, std::vector<::media::VideoCaptureFormat>* out_formats);
  std::vector<::media::VideoCaptureFormat> GetAvailableVideoInputDeviceFormats(const std::string& device_id);
  void GetAudioInputCapabilities(
      std::vector<AudioInputDeviceCapabilitiesPtr>* out_audio_input_device_capabilities);
  std::vector<AudioInputDeviceCapabilitiesPtr> GetAudioInputCapabilities();
  void ProduceSubCaptureTargetId(
      ::media::mojom::SubCaptureTargetType type, std::string* out_id);
  std::string ProduceSubCaptureTargetId(::media::mojom::SubCaptureTargetType type);
  void SetPreferredSinkId(
      const std::string& sink_id, ::media::OutputDeviceStatus* out_status);
  ::media::OutputDeviceStatus SetPreferredSinkId(const std::string& sink_id);
  void SelectAudioOutput(
      const std::string& device_id, SelectAudioOutputResultPtr* out_result);
  SelectAudioOutputResultPtr SelectAudioOutput(const std::string& device_id);

 private:
  MediaDevicesDispatcherHost* const proxy_;
};


class BLINK_COMMON_EXPORT MediaDevicesListenerInterceptorForTesting : public MediaDevicesListener {
  virtual MediaDevicesListener* GetForwardingInterface() = 0;
  void OnDevicesChanged(MediaDeviceType type, const std::vector<::blink::WebMediaDeviceInfo>& device_infos) override;
};
class BLINK_COMMON_EXPORT MediaDevicesListenerAsyncWaiter {
 public:
  explicit MediaDevicesListenerAsyncWaiter(MediaDevicesListener* proxy);

  MediaDevicesListenerAsyncWaiter(const MediaDevicesListenerAsyncWaiter&) = delete;
  MediaDevicesListenerAsyncWaiter& operator=(const MediaDevicesListenerAsyncWaiter&) = delete;

  ~MediaDevicesListenerAsyncWaiter();

 private:
  MediaDevicesListener* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_TEST_UTILS_H_