// third_party/blink/public/mojom/mediastream/media_devices.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-shared-internal.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/audio_parameters.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/media/capture_handle_config.mojom-shared.h"


namespace blink::mojom {
class MediaDeviceInfoDataView;

class VideoInputDeviceCapabilitiesDataView;

class SelectAudioOutputResultDataView;

class AudioInputDeviceCapabilitiesDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::MediaDeviceInfoDataView> {
  using Data = ::blink::mojom::internal::MediaDeviceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::VideoInputDeviceCapabilitiesDataView> {
  using Data = ::blink::mojom::internal::VideoInputDeviceCapabilities_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SelectAudioOutputResultDataView> {
  using Data = ::blink::mojom::internal::SelectAudioOutputResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::AudioInputDeviceCapabilitiesDataView> {
  using Data = ::blink::mojom::internal::AudioInputDeviceCapabilities_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class MediaDeviceType : int32_t {
  
  kMediaAudioInput = 0,
  
  kMediaVideoInput = 1,
  
  kMediaAudioOutput = 2,
  
  kNumMediaDeviceTypes = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, MediaDeviceType value);
inline bool IsKnownEnumValue(MediaDeviceType value) {
  return internal::MediaDeviceType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FacingMode : int32_t {
  
  kNone = 0,
  
  kUser = 1,
  
  kEnvironment = 2,
  
  kLeft = 3,
  
  kRight = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, FacingMode value);
inline bool IsKnownEnumValue(FacingMode value) {
  return internal::FacingMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AudioOutputStatus : int32_t {
  
  kSuccess = 0,
  
  kNoPermission = 1,
  
  kNoDevices = 2,
  
  kUnknown = 3,
  
  kDeviceNotFound = 4,
  
  kErrorOtherRequestInProgress = 5,
  
  kNotSupported = 6,
  
  kNoUserActivation = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, AudioOutputStatus value);
inline bool IsKnownEnumValue(AudioOutputStatus value) {
  return internal::AudioOutputStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MediaDevicesDispatcherHostInterfaceBase {};

using MediaDevicesDispatcherHostPtrDataView =
    mojo::InterfacePtrDataView<MediaDevicesDispatcherHostInterfaceBase>;
using MediaDevicesDispatcherHostRequestDataView =
    mojo::InterfaceRequestDataView<MediaDevicesDispatcherHostInterfaceBase>;
using MediaDevicesDispatcherHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaDevicesDispatcherHostInterfaceBase>;
using MediaDevicesDispatcherHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaDevicesDispatcherHostInterfaceBase>;
class MediaDevicesListenerInterfaceBase {};

using MediaDevicesListenerPtrDataView =
    mojo::InterfacePtrDataView<MediaDevicesListenerInterfaceBase>;
using MediaDevicesListenerRequestDataView =
    mojo::InterfaceRequestDataView<MediaDevicesListenerInterfaceBase>;
using MediaDevicesListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaDevicesListenerInterfaceBase>;
using MediaDevicesListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaDevicesListenerInterfaceBase>;


class MediaDeviceInfoDataView {
 public:
  MediaDeviceInfoDataView() = default;

  MediaDeviceInfoDataView(
      internal::MediaDeviceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGroupIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetControlSupportDataView(
      ::media::mojom::VideoCaptureControlSupportDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadControlSupport(UserType* output) {
    
    auto* pointer = data_->control_support.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureControlSupportDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFacingMode(UserType* output) const {
    auto data_value = data_->facing_mode;
    return mojo::internal::Deserialize<::blink::mojom::FacingMode>(
        data_value, output);
  }
  FacingMode facing_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FacingMode>(data_->facing_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAvailability(UserType* output) const {
    if (!data_->availability_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::CameraAvailability>(
        data_->availability_$value, &output->emplace());
  }
  std::optional<::media::mojom::CameraAvailability> availability() const {
    if (!data_->availability_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CameraAvailability>(data_->availability_$value));
  }
 private:
  internal::MediaDeviceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoInputDeviceCapabilitiesDataView {
 public:
  VideoInputDeviceCapabilitiesDataView() = default;

  VideoInputDeviceCapabilitiesDataView(
      internal::VideoInputDeviceCapabilities_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGroupIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetControlSupportDataView(
      ::media::mojom::VideoCaptureControlSupportDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadControlSupport(UserType* output) {
    
    auto* pointer = data_->control_support.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoCaptureControlSupportDataView>(
        pointer, output, message_);
  }
  inline void GetFormatsDataView(
      mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFormats(UserType* output) {
    
    auto* pointer = data_->formats.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::VideoCaptureFormatDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFacingMode(UserType* output) const {
    auto data_value = data_->facing_mode;
    return mojo::internal::Deserialize<::blink::mojom::FacingMode>(
        data_value, output);
  }
  FacingMode facing_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::FacingMode>(data_->facing_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAvailability(UserType* output) const {
    if (!data_->availability_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::CameraAvailability>(
        data_->availability_$value, &output->emplace());
  }
  std::optional<::media::mojom::CameraAvailability> availability() const {
    if (!data_->availability_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::CameraAvailability>(data_->availability_$value));
  }
 private:
  internal::VideoInputDeviceCapabilities_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SelectAudioOutputResultDataView {
 public:
  SelectAudioOutputResultDataView() = default;

  SelectAudioOutputResultDataView(
      internal::SelectAudioOutputResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::blink::mojom::AudioOutputStatus>(
        data_value, output);
  }
  AudioOutputStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::AudioOutputStatus>(data_->status));
  }
  inline void GetDeviceInfoDataView(
      MediaDeviceInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceInfo(UserType* output) {
    
    auto* pointer = data_->device_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::MediaDeviceInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::SelectAudioOutputResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AudioInputDeviceCapabilitiesDataView {
 public:
  AudioInputDeviceCapabilitiesDataView() = default;

  AudioInputDeviceCapabilitiesDataView(
      internal::AudioInputDeviceCapabilities_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceId(UserType* output) {
    
    auto* pointer = data_->device_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetGroupIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParametersDataView(
      ::media::mojom::AudioParametersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParameters(UserType* output) {
    
    auto* pointer = data_->parameters.Get();
    return mojo::internal::Deserialize<::media::mojom::AudioParametersDataView>(
        pointer, output, message_);
  }
  bool is_valid() const {
    return data_->is_valid;
  }
  int32_t channels() const {
    return data_->channels;
  }
  int32_t sample_rate() const {
    return data_->sample_rate;
  }
  inline void GetLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatency(UserType* output) {
    
    auto* pointer = data_->latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioInputDeviceCapabilities_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_DATA_VIEW_H_