// third_party/blink/public/mojom/mediastream/media_devices.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_BLINK_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_BLINK_TEST_UTILS_H_

#include "third_party/blink/public/mojom/mediastream/media_devices.mojom-blink.h"
#include "third_party/blink/renderer/platform/platform_export.h"


namespace blink::mojom::blink {


class PLATFORM_EXPORT MediaDevicesDispatcherHostInterceptorForTesting : public MediaDevicesDispatcherHost {
  virtual MediaDevicesDispatcherHost* GetForwardingInterface() = 0;
  void EnumerateDevices(bool request_audio_input, bool request_video_input, bool request_audio_output, bool request_video_input_capabilities, bool request_audio_input_capabilities, EnumerateDevicesCallback callback) override;
  void GetVideoInputCapabilities(GetVideoInputCapabilitiesCallback callback) override;
  void GetAllVideoInputDeviceFormats(const ::blink::String& device_id, GetAllVideoInputDeviceFormatsCallback callback) override;
  void GetAvailableVideoInputDeviceFormats(const ::blink::String& device_id, GetAvailableVideoInputDeviceFormatsCallback callback) override;
  void GetAudioInputCapabilities(GetAudioInputCapabilitiesCallback callback) override;
  void AddMediaDevicesListener(bool subscribe_audio_input, bool subscribe_video_input, bool subscribe_audio_output, ::mojo::PendingRemote<MediaDevicesListener> listener) override;
  void SetCaptureHandleConfig(::blink::mojom::blink::CaptureHandleConfigPtr config) override;
  void CloseFocusWindowOfOpportunity(const ::blink::String& label) override;
  void ProduceSubCaptureTargetId(::media::mojom::blink::SubCaptureTargetType type, ProduceSubCaptureTargetIdCallback callback) override;
  void SetPreferredSinkId(const ::blink::String& sink_id, SetPreferredSinkIdCallback callback) override;
  void SelectAudioOutput(const ::blink::String& device_id, SelectAudioOutputCallback callback) override;
};
class PLATFORM_EXPORT MediaDevicesDispatcherHostAsyncWaiter {
 public:
  explicit MediaDevicesDispatcherHostAsyncWaiter(MediaDevicesDispatcherHost* proxy);

  MediaDevicesDispatcherHostAsyncWaiter(const MediaDevicesDispatcherHostAsyncWaiter&) = delete;
  MediaDevicesDispatcherHostAsyncWaiter& operator=(const MediaDevicesDispatcherHostAsyncWaiter&) = delete;

  ~MediaDevicesDispatcherHostAsyncWaiter();
  void EnumerateDevices(
      bool request_audio_input, bool request_video_input, bool request_audio_output, bool request_video_input_capabilities, bool request_audio_input_capabilities, ::blink::Vector<::blink::Vector<::blink::WebMediaDeviceInfo>>* out_enumeration, ::blink::Vector<VideoInputDeviceCapabilitiesPtr>* out_video_input_device_capabilities, ::blink::Vector<AudioInputDeviceCapabilitiesPtr>* out_audio_input_device_capabilities);
  
  void GetVideoInputCapabilities(
      ::blink::Vector<VideoInputDeviceCapabilitiesPtr>* out_video_input_device_capabilities);
  ::blink::Vector<VideoInputDeviceCapabilitiesPtr> GetVideoInputCapabilities();
  void GetAllVideoInputDeviceFormats(
      const ::blink::String& device_id, ::blink::Vector<::media::VideoCaptureFormat>* out_formats);
  ::blink::Vector<::media::VideoCaptureFormat> GetAllVideoInputDeviceFormats(const ::blink::String& device_id);
  void GetAvailableVideoInputDeviceFormats(
      const ::blink::String& device_id, ::blink::Vector<::media::VideoCaptureFormat>* out_formats);
  ::blink::Vector<::media::VideoCaptureFormat> GetAvailableVideoInputDeviceFormats(const ::blink::String& device_id);
  void GetAudioInputCapabilities(
      ::blink::Vector<AudioInputDeviceCapabilitiesPtr>* out_audio_input_device_capabilities);
  ::blink::Vector<AudioInputDeviceCapabilitiesPtr> GetAudioInputCapabilities();
  void ProduceSubCaptureTargetId(
      ::media::mojom::blink::SubCaptureTargetType type, ::blink::String* out_id);
  ::blink::String ProduceSubCaptureTargetId(::media::mojom::blink::SubCaptureTargetType type);
  void SetPreferredSinkId(
      const ::blink::String& sink_id, ::media::mojom::blink::OutputDeviceStatus* out_status);
  ::media::mojom::blink::OutputDeviceStatus SetPreferredSinkId(const ::blink::String& sink_id);
  void SelectAudioOutput(
      const ::blink::String& device_id, SelectAudioOutputResultPtr* out_result);
  SelectAudioOutputResultPtr SelectAudioOutput(const ::blink::String& device_id);

 private:
  MediaDevicesDispatcherHost* const proxy_;
};


class PLATFORM_EXPORT MediaDevicesListenerInterceptorForTesting : public MediaDevicesListener {
  virtual MediaDevicesListener* GetForwardingInterface() = 0;
  void OnDevicesChanged(MediaDeviceType type, const ::blink::Vector<::blink::WebMediaDeviceInfo>& device_infos) override;
};
class PLATFORM_EXPORT MediaDevicesListenerAsyncWaiter {
 public:
  explicit MediaDevicesListenerAsyncWaiter(MediaDevicesListener* proxy);

  MediaDevicesListenerAsyncWaiter(const MediaDevicesListenerAsyncWaiter&) = delete;
  MediaDevicesListenerAsyncWaiter& operator=(const MediaDevicesListenerAsyncWaiter&) = delete;

  ~MediaDevicesListenerAsyncWaiter();

 private:
  MediaDevicesListener* const proxy_;
};




}  // blink::mojom::blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASTREAM_MEDIA_DEVICES_MOJOM_BLINK_TEST_UTILS_H_