// third_party/blink/public/mojom/mediasession/media_session.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/media_session/public/mojom/media_session.mojom-shared.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::MediaSessionPlaybackState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::MediaSessionEnterPictureInPictureReason, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::MediaSessionSeekToDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MediaSessionSeekToDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MediaSessionSeekToDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::seek_time(input)) in_seek_time = Traits::seek_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->seek_time)::BaseType> seek_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_seek_time,
        seek_time_fragment);

      fragment->seek_time.Set(
          seek_time_fragment.is_null() ? nullptr : seek_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->seek_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null seek_time in MediaSessionSeekToDetails struct");

      fragment->fast_seek = Traits::fast_seek(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::MediaSessionEnterPictureInPictureDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MediaSessionEnterPictureInPictureDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MediaSessionEnterPictureInPictureDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::MediaSessionEnterPictureInPictureReason>(
        Traits::reason(input),
        &fragment->reason);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::SpecMediaMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SpecMediaMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SpecMediaMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in SpecMediaMetadata struct");

      decltype(Traits::artist(input)) in_artist = Traits::artist(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->artist)::BaseType> artist_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_artist,
        artist_fragment);

      fragment->artist.Set(
          artist_fragment.is_null() ? nullptr : artist_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->artist.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null artist in SpecMediaMetadata struct");

      decltype(Traits::album(input)) in_album = Traits::album(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->album)::BaseType> album_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_album,
        album_fragment);

      fragment->album.Set(
          album_fragment.is_null() ? nullptr : album_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->album.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null album in SpecMediaMetadata struct");

      decltype(Traits::artwork(input)) in_artwork = Traits::artwork(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->artwork)::BaseType>
          artwork_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& artwork_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>, send_validation>(
        in_artwork,
        artwork_fragment,
        &artwork_validate_params);

      fragment->artwork.Set(
          artwork_fragment.is_null() ? nullptr : artwork_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->artwork.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null artwork in SpecMediaMetadata struct");

      decltype(Traits::chapterInfo(input)) in_chapterInfo = Traits::chapterInfo(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->chapterInfo)::BaseType>
          chapterInfo_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& chapterInfo_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>, send_validation>(
        in_chapterInfo,
        chapterInfo_fragment,
        &chapterInfo_validate_params);

      fragment->chapterInfo.Set(
          chapterInfo_fragment.is_null() ? nullptr : chapterInfo_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->chapterInfo.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null chapterInfo in SpecMediaMetadata struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::MediaSessionActionDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::MediaSessionActionDetailsDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::MediaSessionActionDetails_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::MediaSessionActionDetailsDataView::Tag::kSeekTo: {
    decltype(Traits::seek_to(input))
    in_seek_to = Traits::seek_to(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_seek_to)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::MediaSessionSeekToDetailsDataView, send_validation>(
  in_seek_to,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null seek_to in MediaSessionActionDetails union");
    fragment->data.f_seek_to.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::MediaSessionActionDetailsDataView::Tag::kEnterPictureInPicture: {
    decltype(Traits::enter_picture_in_picture(input))
    in_enter_picture_in_picture = Traits::enter_picture_in_picture(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_enter_picture_in_picture)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::MediaSessionEnterPictureInPictureDetailsDataView, send_validation>(
  in_enter_picture_in_picture,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null enter_picture_in_picture in MediaSessionActionDetails union");
    fragment->data.f_enter_picture_in_picture.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_SEND_VALIDATION_H_