// third_party/blink/public/mojom/manifest/manifest_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/manifest/manifest_manager.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
RequestManifestError::RequestManifestError()
    : error(),
      details() {}

RequestManifestError::RequestManifestError(
    ::blink::mojom::blink::ManifestRequestResult error_in,
    ::blink::Vector<::blink::mojom::blink::ManifestErrorPtr> details_in)
    : error(std::move(error_in)),
      details(std::move(details_in)) {}

RequestManifestError::~RequestManifestError() = default;

void RequestManifestError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::ManifestRequestResult>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "details"), this->details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<::blink::mojom::blink::ManifestErrorPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RequestManifestError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr
ManifestManager_RequestManifestAndErrors_ResponseParam_Result::NewSuccess(
    ::blink::mojom::blink::ManifestPtr value) {
  return ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr
ManifestManager_RequestManifestAndErrors_ResponseParam_Result::NewFailure(
    RequestManifestErrorPtr value) {
  return ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
      std::move(value));
}

ManifestManager_RequestManifestAndErrors_ResponseParam_Result::ManifestManager_RequestManifestAndErrors_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::mojom::blink::ManifestPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

ManifestManager_RequestManifestAndErrors_ResponseParam_Result::ManifestManager_RequestManifestAndErrors_ResponseParam_Result(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    RequestManifestErrorPtr value)
    : tag_(Tag::kFailure),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFailure)>,
            std::move(value)) {}
ManifestManager_RequestManifestAndErrors_ResponseParam_Result::~ManifestManager_RequestManifestAndErrors_ResponseParam_Result() {
  DestroyActive();
}

void ManifestManager_RequestManifestAndErrors_ResponseParam_Result::set_success(::blink::mojom::blink::ManifestPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) ::blink::mojom::blink::ManifestPtr(
        std::move(success));
  }
}

void ManifestManager_RequestManifestAndErrors_ResponseParam_Result::set_failure(RequestManifestErrorPtr failure) {
  if (tag_ == Tag::kFailure) {
    data_.failure = std::move(failure);
  } else {
    DestroyActive();
    tag_ = Tag::kFailure;
    new (&data_.failure) RequestManifestErrorPtr(
        std::move(failure));
  }
}


ManifestManager_RequestManifestAndErrors_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    ::blink::mojom::blink::ManifestPtr value)
    : success(std::move(value)) {}

ManifestManager_RequestManifestAndErrors_ResponseParam_Result::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
    RequestManifestErrorPtr value)
    : failure(std::move(value)) {}

void ManifestManager_RequestManifestAndErrors_ResponseParam_Result::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kFailure:
      std::destroy_at(&data_.failure);
      break;
  }
}

bool ManifestManager_RequestManifestAndErrors_ResponseParam_Result::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

ManifestManager::IPCStableHashFunction ManifestManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ManifestManager>(message.name())) {
    case messages::ManifestManager::kRequestManifest: {
      return &ManifestManager::RequestManifest_Sym::IPCStableHash;
    }
    case messages::ManifestManager::kRequestManifestAndErrors: {
      return &ManifestManager::RequestManifestAndErrors_Sym::IPCStableHash;
    }
    case messages::ManifestManager::kRequestManifestDebugInfo: {
      return &ManifestManager::RequestManifestDebugInfo_Sym::IPCStableHash;
    }
    case messages::ManifestManager::kParseManifestFromString: {
      return &ManifestManager::ParseManifestFromString_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ManifestManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ManifestManager>(message.name())) {
      case messages::ManifestManager::kRequestManifest:
            return "Receive blink::mojom::ManifestManager::RequestManifest";
      case messages::ManifestManager::kRequestManifestAndErrors:
            return "Receive blink::mojom::ManifestManager::RequestManifestAndErrors";
      case messages::ManifestManager::kRequestManifestDebugInfo:
            return "Receive blink::mojom::ManifestManager::RequestManifestDebugInfo";
      case messages::ManifestManager::kParseManifestFromString:
            return "Receive blink::mojom::ManifestManager::ParseManifestFromString";
    }
  } else {
    switch (static_cast<messages::ManifestManager>(message.name())) {
      case messages::ManifestManager::kRequestManifest:
            return "Receive reply blink::mojom::ManifestManager::RequestManifest";
      case messages::ManifestManager::kRequestManifestAndErrors:
            return "Receive reply blink::mojom::ManifestManager::RequestManifestAndErrors";
      case messages::ManifestManager::kRequestManifestDebugInfo:
            return "Receive reply blink::mojom::ManifestManager::RequestManifestDebugInfo";
      case messages::ManifestManager::kParseManifestFromString:
            return "Receive reply blink::mojom::ManifestManager::ParseManifestFromString";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ManifestManager::RequestManifest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a5de105;  // IPCStableHash for blink::mojom::ManifestManager::RequestManifest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ManifestManager::RequestManifestAndErrors_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4a81dcb9;  // IPCStableHash for blink::mojom::ManifestManager::RequestManifestAndErrors
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ManifestManager::RequestManifestDebugInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e6e81b7;  // IPCStableHash for blink::mojom::ManifestManager::RequestManifestDebugInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ManifestManager::ParseManifestFromString_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c76ec89;  // IPCStableHash for blink::mojom::ManifestManager::ParseManifestFromString
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ManifestManager_RequestManifest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ManifestManager_RequestManifest_ForwardToCallback(
      ManifestManager::RequestManifestCallback callback
      ) : callback_(std::move(callback)) {
  }

  ManifestManager_RequestManifest_ForwardToCallback(const ManifestManager_RequestManifest_ForwardToCallback&) = delete;
  ManifestManager_RequestManifest_ForwardToCallback& operator=(const ManifestManager_RequestManifest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ManifestManager::RequestManifestCallback callback_;
};

class ManifestManager_RequestManifestAndErrors_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ManifestManager_RequestManifestAndErrors_ForwardToCallback(
      ManifestManager::RequestManifestAndErrorsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ManifestManager_RequestManifestAndErrors_ForwardToCallback(const ManifestManager_RequestManifestAndErrors_ForwardToCallback&) = delete;
  ManifestManager_RequestManifestAndErrors_ForwardToCallback& operator=(const ManifestManager_RequestManifestAndErrors_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ManifestManager::RequestManifestAndErrorsCallback callback_;
};

class ManifestManager_RequestManifestDebugInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ManifestManager_RequestManifestDebugInfo_ForwardToCallback(
      ManifestManager::RequestManifestDebugInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  ManifestManager_RequestManifestDebugInfo_ForwardToCallback(const ManifestManager_RequestManifestDebugInfo_ForwardToCallback&) = delete;
  ManifestManager_RequestManifestDebugInfo_ForwardToCallback& operator=(const ManifestManager_RequestManifestDebugInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ManifestManager::RequestManifestDebugInfoCallback callback_;
};

class ManifestManager_ParseManifestFromString_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ManifestManager_ParseManifestFromString_ForwardToCallback(
      ManifestManager::ParseManifestFromStringCallback callback
      ) : callback_(std::move(callback)) {
  }

  ManifestManager_ParseManifestFromString_ForwardToCallback(const ManifestManager_ParseManifestFromString_ForwardToCallback&) = delete;
  ManifestManager_ParseManifestFromString_ForwardToCallback& operator=(const ManifestManager_ParseManifestFromString_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ManifestManager::ParseManifestFromStringCallback callback_;
};

ManifestManagerProxy::ManifestManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ManifestManagerProxy::RequestManifest(
    RequestManifestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ManifestManager::RequestManifest");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManifestManager::kRequestManifest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_RequestManifest_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("RequestManifest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ManifestManager_RequestManifest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ManifestManagerProxy::RequestManifestAndErrors(
    RequestManifestAndErrorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ManifestManager::RequestManifestAndErrors");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManifestManager::kRequestManifestAndErrors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_RequestManifestAndErrors_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("RequestManifestAndErrors");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ManifestManager_RequestManifestAndErrors_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ManifestManagerProxy::RequestManifestDebugInfo(
    RequestManifestDebugInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ManifestManager::RequestManifestDebugInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManifestManager::kRequestManifestDebugInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_RequestManifestDebugInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("RequestManifestDebugInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ManifestManager_RequestManifestDebugInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ManifestManagerProxy::ParseManifestFromString(
    const ::blink::KURL& in_document_url, const ::blink::KURL& in_manifest_url, const ::blink::String& in_manifest_content, ParseManifestFromStringCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ManifestManager::ParseManifestFromString", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document_url"), in_document_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("manifest_url"), in_manifest_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("manifest_content"), in_manifest_content,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManifestManager::kParseManifestFromString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_ParseManifestFromString_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->document_url)::BaseType> document_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_document_url,
    document_url_fragment);

  params->document_url.Set(
      document_url_fragment.is_null() ? nullptr : document_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->document_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null document_url in ManifestManager.ParseManifestFromString request");
  mojo::internal::MessageFragment<
      typename decltype(params->manifest_url)::BaseType> manifest_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_manifest_url,
    manifest_url_fragment);

  params->manifest_url.Set(
      manifest_url_fragment.is_null() ? nullptr : manifest_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->manifest_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null manifest_url in ManifestManager.ParseManifestFromString request");
  mojo::internal::MessageFragment<
      typename decltype(params->manifest_content)::BaseType> manifest_content_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_manifest_content,
    manifest_content_fragment);

  params->manifest_content.Set(
      manifest_content_fragment.is_null() ? nullptr : manifest_content_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->manifest_content.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null manifest_content in ManifestManager.ParseManifestFromString request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("ParseManifestFromString");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ManifestManager_ParseManifestFromString_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ManifestManager_RequestManifest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ManifestManager::RequestManifestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ManifestManager_RequestManifest_ProxyToResponder> proxy(
        new ManifestManager_RequestManifest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ManifestManager_RequestManifest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ManifestManager_RequestManifest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ManifestManager_RequestManifest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ManifestManager::RequestManifestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ManifestRequestResult in_result, const ::blink::KURL& in_url, ::blink::mojom::blink::ManifestPtr in_manifest);
};

bool ManifestManager_RequestManifest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ManifestManager_RequestManifest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ManifestManager_RequestManifest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ManifestManager.0
  bool success = true;
  ::blink::mojom::blink::ManifestRequestResult p_result{};
  ::blink::KURL p_url{};
  ::blink::mojom::blink::ManifestPtr p_manifest{};
  ManifestManager_RequestManifest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success && !input_data_view.ReadManifest(&p_manifest))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ManifestManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_url), 
std::move(p_manifest));
  }
  return true;
}

void ManifestManager_RequestManifest_ProxyToResponder::Run(
    ::blink::mojom::blink::ManifestRequestResult in_result, const ::blink::KURL& in_url, ::blink::mojom::blink::ManifestPtr in_manifest) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ManifestManager::RequestManifest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::blink::ManifestRequestResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("manifest"), in_manifest,
                        "<value of type ::blink::mojom::blink::ManifestPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManifestManager::kRequestManifest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_RequestManifest_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::ManifestRequestResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ");
  mojo::internal::MessageFragment<
      typename decltype(params->manifest)::BaseType> manifest_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ManifestDataView>(
    in_manifest,
    manifest_fragment);

  params->manifest.Set(
      manifest_fragment.is_null() ? nullptr : manifest_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->manifest.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null manifest in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("RequestManifest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ManifestManager_RequestManifestAndErrors_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ManifestManager::RequestManifestAndErrorsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ManifestManager_RequestManifestAndErrors_ProxyToResponder> proxy(
        new ManifestManager_RequestManifestAndErrors_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Transform)
      .Then(base::BindOnce(&ManifestManager_RequestManifestAndErrors_ProxyToResponder::Run,
                          std::move(proxy)));
  }

  static ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr Transform(base::expected<
  ::blink::mojom::blink::ManifestPtr,
  RequestManifestErrorPtr> in) {
    return in.has_value() ? ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_Result::NewSuccess(std::move(in.value())) :
                            ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_Result::NewFailure(std::move(in.error()));
  }



  ~ManifestManager_RequestManifestAndErrors_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ManifestManager_RequestManifestAndErrors_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ManifestManager::RequestManifestAndErrorsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr in_result);
};

bool ManifestManager_RequestManifestAndErrors_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ManifestManager_RequestManifestAndErrors_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ManifestManager_RequestManifestAndErrors_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ManifestManager.1
  bool success = true;
  ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr p_result{};
  ManifestManager_RequestManifestAndErrors_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ManifestManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    if (p_result->is_success()) {
      std::move(callback_).Run(base::ok(std::move(p_result->get_success())));
    } else {
      std::move(callback_).Run(base::unexpected(std::move(p_result->get_failure())));
    }
  }
  return true;
}

void ManifestManager_RequestManifestAndErrors_ProxyToResponder::Run(
    ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ManifestManager::RequestManifestAndErrors", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManifestManager::kRequestManifestAndErrors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_RequestManifestAndErrors_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::ManifestManager_RequestManifestAndErrors_ResponseParam_ResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("RequestManifestAndErrors");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ManifestManager_RequestManifestDebugInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ManifestManager::RequestManifestDebugInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ManifestManager_RequestManifestDebugInfo_ProxyToResponder> proxy(
        new ManifestManager_RequestManifestDebugInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ManifestManager_RequestManifestDebugInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ManifestManager_RequestManifestDebugInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ManifestManager_RequestManifestDebugInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ManifestManager::RequestManifestDebugInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::KURL& in_url, ::blink::mojom::blink::ManifestPtr in_parsed_manifest, ::blink::mojom::blink::ManifestDebugInfoPtr in_debug_info);
};

bool ManifestManager_RequestManifestDebugInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ManifestManager_RequestManifestDebugInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ManifestManager_RequestManifestDebugInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ManifestManager.2
  bool success = true;
  ::blink::KURL p_url{};
  ::blink::mojom::blink::ManifestPtr p_parsed_manifest{};
  ::blink::mojom::blink::ManifestDebugInfoPtr p_debug_info{};
  ManifestManager_RequestManifestDebugInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (success && !input_data_view.ReadParsedManifest(&p_parsed_manifest))
    success = false;
  if (success && !input_data_view.ReadDebugInfo(&p_debug_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ManifestManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url), 
std::move(p_parsed_manifest), 
std::move(p_debug_info));
  }
  return true;
}

void ManifestManager_RequestManifestDebugInfo_ProxyToResponder::Run(
    const ::blink::KURL& in_url, ::blink::mojom::blink::ManifestPtr in_parsed_manifest, ::blink::mojom::blink::ManifestDebugInfoPtr in_debug_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ManifestManager::RequestManifestDebugInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parsed_manifest"), in_parsed_manifest,
                        "<value of type ::blink::mojom::blink::ManifestPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_info"), in_debug_info,
                        "<value of type ::blink::mojom::blink::ManifestDebugInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManifestManager::kRequestManifestDebugInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_RequestManifestDebugInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ");
  mojo::internal::MessageFragment<
      typename decltype(params->parsed_manifest)::BaseType> parsed_manifest_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ManifestDataView>(
    in_parsed_manifest,
    parsed_manifest_fragment);

  params->parsed_manifest.Set(
      parsed_manifest_fragment.is_null() ? nullptr : parsed_manifest_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->parsed_manifest.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null parsed_manifest in ");
  mojo::internal::MessageFragment<
      typename decltype(params->debug_info)::BaseType> debug_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ManifestDebugInfoDataView>(
    in_debug_info,
    debug_info_fragment);

  params->debug_info.Set(
      debug_info_fragment.is_null() ? nullptr : debug_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->debug_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null debug_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("RequestManifestDebugInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ManifestManager_ParseManifestFromString_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ManifestManager::ParseManifestFromStringCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ManifestManager_ParseManifestFromString_ProxyToResponder> proxy(
        new ManifestManager_ParseManifestFromString_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ManifestManager_ParseManifestFromString_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ManifestManager_ParseManifestFromString_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ManifestManager_ParseManifestFromString_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ManifestManager::ParseManifestFromStringCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::ManifestPtr in_parsed_manifest);
};

bool ManifestManager_ParseManifestFromString_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ManifestManager_ParseManifestFromString_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ManifestManager_ParseManifestFromString_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ManifestManager.3
  bool success = true;
  ::blink::mojom::blink::ManifestPtr p_parsed_manifest{};
  ManifestManager_ParseManifestFromString_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadParsedManifest(&p_parsed_manifest))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ManifestManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_parsed_manifest));
  }
  return true;
}

void ManifestManager_ParseManifestFromString_ProxyToResponder::Run(
    ::blink::mojom::blink::ManifestPtr in_parsed_manifest) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::ManifestManager::ParseManifestFromString", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parsed_manifest"), in_parsed_manifest,
                        "<value of type ::blink::mojom::blink::ManifestPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ManifestManager::kParseManifestFromString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ManifestManager_ParseManifestFromString_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parsed_manifest)::BaseType> parsed_manifest_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ManifestDataView>(
    in_parsed_manifest,
    parsed_manifest_fragment);

  params->parsed_manifest.Set(
      parsed_manifest_fragment.is_null() ? nullptr : parsed_manifest_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ManifestManager::Name_);
  message.set_method_name("ParseManifestFromString");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ManifestManagerStubDispatch::Accept(
    ManifestManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ManifestManager>(message->header()->name)) {
    case messages::ManifestManager::kRequestManifest: {
      break;
    }
    case messages::ManifestManager::kRequestManifestAndErrors: {
      break;
    }
    case messages::ManifestManager::kRequestManifestDebugInfo: {
      break;
    }
    case messages::ManifestManager::kParseManifestFromString: {
      break;
    }
  }
  return false;
}

// static
bool ManifestManagerStubDispatch::AcceptWithResponder(
    ManifestManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ManifestManager>(message->header()->name)) {
    case messages::ManifestManager::kRequestManifest: {
      internal::ManifestManager_RequestManifest_Params_Data* params =
          reinterpret_cast<
              internal::ManifestManager_RequestManifest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ManifestManager.0
      bool success = true;
      ManifestManager_RequestManifest_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManifestManager::Name_, 0, false);
        return false;
      }
      auto callback =
          ManifestManager_RequestManifest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestManifest(std::move(callback));
      return true;
    }
    case messages::ManifestManager::kRequestManifestAndErrors: {
      internal::ManifestManager_RequestManifestAndErrors_Params_Data* params =
          reinterpret_cast<
              internal::ManifestManager_RequestManifestAndErrors_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ManifestManager.1
      bool success = true;
      ManifestManager_RequestManifestAndErrors_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManifestManager::Name_, 1, false);
        return false;
      }
      auto callback =
          ManifestManager_RequestManifestAndErrors_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestManifestAndErrors(std::move(callback));
      return true;
    }
    case messages::ManifestManager::kRequestManifestDebugInfo: {
      internal::ManifestManager_RequestManifestDebugInfo_Params_Data* params =
          reinterpret_cast<
              internal::ManifestManager_RequestManifestDebugInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ManifestManager.2
      bool success = true;
      ManifestManager_RequestManifestDebugInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManifestManager::Name_, 2, false);
        return false;
      }
      auto callback =
          ManifestManager_RequestManifestDebugInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestManifestDebugInfo(std::move(callback));
      return true;
    }
    case messages::ManifestManager::kParseManifestFromString: {
      internal::ManifestManager_ParseManifestFromString_Params_Data* params =
          reinterpret_cast<
              internal::ManifestManager_ParseManifestFromString_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ManifestManager.3
      bool success = true;
      ::blink::KURL p_document_url{};
      ::blink::KURL p_manifest_url{};
      ::blink::String p_manifest_content{};
      ManifestManager_ParseManifestFromString_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDocumentUrl(&p_document_url))
        success = false;
      if (success && !input_data_view.ReadManifestUrl(&p_manifest_url))
        success = false;
      if (success && !input_data_view.ReadManifestContent(&p_manifest_content))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ManifestManager::Name_, 3, false);
        return false;
      }
      auto callback =
          ManifestManager_ParseManifestFromString_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseManifestFromString(        
        std::move(p_document_url), 
        std::move(p_manifest_url), 
        std::move(p_manifest_content), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kManifestManagerValidationInfo[] = {
    { &internal::ManifestManager_RequestManifest_Params_Data::Validate,
     &internal::ManifestManager_RequestManifest_ResponseParams_Data::Validate},
    { &internal::ManifestManager_RequestManifestAndErrors_Params_Data::Validate,
     &internal::ManifestManager_RequestManifestAndErrors_ResponseParams_Data::Validate},
    { &internal::ManifestManager_RequestManifestDebugInfo_Params_Data::Validate,
     &internal::ManifestManager_RequestManifestDebugInfo_ResponseParams_Data::Validate},
    { &internal::ManifestManager_ParseManifestFromString_Params_Data::Validate,
     &internal::ManifestManager_ParseManifestFromString_ResponseParams_Data::Validate},
};

bool ManifestManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ManifestManager::Name_,
    kManifestManagerValidationInfo);
}

bool ManifestManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::ManifestManager::Name_,
    kManifestManagerValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::RequestManifestError::DataView, ::blink::mojom::blink::RequestManifestErrorPtr>::Read(
    ::blink::mojom::blink::RequestManifestError::DataView input,
    ::blink::mojom::blink::RequestManifestErrorPtr* output) {
  bool success = true;
  ::blink::mojom::blink::RequestManifestErrorPtr result(::blink::mojom::blink::RequestManifestError::New());
  
      if (success && !input.ReadError(&result->error))
        success = false;
      if (success && !input.ReadDetails(&result->details))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_Result::DataView, ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr>::Read(
    ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_Result::DataView input,
    ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_ResultPtr* output) {
  using UnionType = ::blink::mojom::blink::ManifestManager_RequestManifestAndErrors_ResponseParam_Result;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::blink::mojom::blink::ManifestPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kFailure: {
      ::blink::mojom::blink::RequestManifestErrorPtr result_failure{};
      if (!input.ReadFailure(&result_failure))
        return false;

      *output = UnionType::NewFailure(
          std::move(result_failure));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ManifestManagerInterceptorForTesting::RequestManifest(RequestManifestCallback callback) {
  GetForwardingInterface()->RequestManifest(std::move(callback));
}
void ManifestManagerInterceptorForTesting::RequestManifestAndErrors(RequestManifestAndErrorsCallback callback) {
  GetForwardingInterface()->RequestManifestAndErrors(std::move(callback));
}
void ManifestManagerInterceptorForTesting::RequestManifestDebugInfo(RequestManifestDebugInfoCallback callback) {
  GetForwardingInterface()->RequestManifestDebugInfo(std::move(callback));
}
void ManifestManagerInterceptorForTesting::ParseManifestFromString(const ::blink::KURL& document_url, const ::blink::KURL& manifest_url, const ::blink::String& manifest_content, ParseManifestFromStringCallback callback) {
  GetForwardingInterface()->ParseManifestFromString(
    std::move(document_url)
    , 
    std::move(manifest_url)
    , 
    std::move(manifest_content)
    , std::move(callback));
}
ManifestManagerAsyncWaiter::ManifestManagerAsyncWaiter(
    ManifestManager* proxy) : proxy_(proxy) {}

ManifestManagerAsyncWaiter::~ManifestManagerAsyncWaiter() = default;


void ManifestManagerAsyncWaiter::RequestManifest(
    ::blink::mojom::blink::ManifestRequestResult* out_result, ::blink::KURL* out_url, ::blink::mojom::blink::ManifestPtr* out_manifest) {
  base::RunLoop loop;
  proxy_->RequestManifest(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ManifestRequestResult* out_result
,
             ::blink::KURL* out_url
,
             ::blink::mojom::blink::ManifestPtr* out_manifest
,
             ::blink::mojom::blink::ManifestRequestResult result,
             const ::blink::KURL& url,
             ::blink::mojom::blink::ManifestPtr manifest) {*out_result = std::move(result);*out_url = std::move(url);*out_manifest = std::move(manifest);
            loop->Quit();
          },
          &loop,
          out_result,
          out_url,
          out_manifest));
  loop.Run();
}



void ManifestManagerAsyncWaiter::RequestManifestDebugInfo(
    ::blink::KURL* out_url, ::blink::mojom::blink::ManifestPtr* out_parsed_manifest, ::blink::mojom::blink::ManifestDebugInfoPtr* out_debug_info) {
  base::RunLoop loop;
  proxy_->RequestManifestDebugInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::KURL* out_url
,
             ::blink::mojom::blink::ManifestPtr* out_parsed_manifest
,
             ::blink::mojom::blink::ManifestDebugInfoPtr* out_debug_info
,
             const ::blink::KURL& url,
             ::blink::mojom::blink::ManifestPtr parsed_manifest,
             ::blink::mojom::blink::ManifestDebugInfoPtr debug_info) {*out_url = std::move(url);*out_parsed_manifest = std::move(parsed_manifest);*out_debug_info = std::move(debug_info);
            loop->Quit();
          },
          &loop,
          out_url,
          out_parsed_manifest,
          out_debug_info));
  loop.Run();
}



void ManifestManagerAsyncWaiter::ParseManifestFromString(
    const ::blink::KURL& document_url, const ::blink::KURL& manifest_url, const ::blink::String& manifest_content, ::blink::mojom::blink::ManifestPtr* out_parsed_manifest) {
  base::RunLoop loop;
  proxy_->ParseManifestFromString(
      std::move(document_url),
      std::move(manifest_url),
      std::move(manifest_content),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::ManifestPtr* out_parsed_manifest
,
             ::blink::mojom::blink::ManifestPtr parsed_manifest) {*out_parsed_manifest = std::move(parsed_manifest);
            loop->Quit();
          },
          &loop,
          out_parsed_manifest));
  loop.Run();
}

::blink::mojom::blink::ManifestPtr ManifestManagerAsyncWaiter::ParseManifestFromString(
    const ::blink::KURL& document_url, const ::blink::KURL& manifest_url, const ::blink::String& manifest_content) {
  ::blink::mojom::blink::ManifestPtr async_wait_result;
  ParseManifestFromString(std::move(document_url),std::move(manifest_url),std::move(manifest_content),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif