// third_party/blink/public/mojom/locks/lock_manager.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOCKS_LOCK_MANAGER_MOJOM_PARAMS_DATA_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOCKS_LOCK_MANAGER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace blink::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) LockRequest_Granted_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedInterface_Data lock_handle;

 private:
  friend class mojo::internal::MessageFragment<LockRequest_Granted_Params_Data>;

  LockRequest_Granted_Params_Data();
  ~LockRequest_Granted_Params_Data() = delete;
};
static_assert(sizeof(LockRequest_Granted_Params_Data) == 16,
              "Bad sizeof(LockRequest_Granted_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) LockRequest_Failed_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<LockRequest_Failed_Params_Data>;

  LockRequest_Failed_Params_Data();
  ~LockRequest_Failed_Params_Data() = delete;
};
static_assert(sizeof(LockRequest_Failed_Params_Data) == 8,
              "Bad sizeof(LockRequest_Failed_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) LockManager_RequestLock_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  int32_t mode;
  int32_t wait;
  mojo::internal::AssociatedInterface_Data request;

 private:
  friend class mojo::internal::MessageFragment<LockManager_RequestLock_Params_Data>;

  LockManager_RequestLock_Params_Data();
  ~LockManager_RequestLock_Params_Data() = delete;
};
static_assert(sizeof(LockManager_RequestLock_Params_Data) == 32,
              "Bad sizeof(LockManager_RequestLock_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) LockManager_QueryState_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<LockManager_QueryState_Params_Data>;

  LockManager_QueryState_Params_Data();
  ~LockManager_QueryState_Params_Data() = delete;
};
static_assert(sizeof(LockManager_QueryState_Params_Data) == 8,
              "Bad sizeof(LockManager_QueryState_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) LockManager_QueryState_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::LockInfo_Data>>> requested;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::LockInfo_Data>>> held;

 private:
  friend class mojo::internal::MessageFragment<LockManager_QueryState_ResponseParams_Data>;

  LockManager_QueryState_ResponseParams_Data();
  ~LockManager_QueryState_ResponseParams_Data() = delete;
};
static_assert(sizeof(LockManager_QueryState_ResponseParams_Data) == 24,
              "Bad sizeof(LockManager_QueryState_ResponseParams_Data)");

}  // namespace internal


class LockRequest_Granted_ParamsDataView {
 public:
  LockRequest_Granted_ParamsDataView() = default;

  LockRequest_Granted_ParamsDataView(
      internal::LockRequest_Granted_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeLockHandle() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::LockHandleAssociatedPtrInfoDataView>(
            &data_->lock_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::LockRequest_Granted_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LockRequest_Failed_ParamsDataView {
 public:
  LockRequest_Failed_ParamsDataView() = default;

  LockRequest_Failed_ParamsDataView(
      internal::LockRequest_Failed_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::LockRequest_Failed_Params_Data* data_ = nullptr;
};


class LockManager_RequestLock_ParamsDataView {
 public:
  LockManager_RequestLock_ParamsDataView() = default;

  LockManager_RequestLock_ParamsDataView(
      internal::LockManager_RequestLock_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::blink::mojom::LockMode>(
        data_value, output);
  }
  LockMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::LockMode>(data_->mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWait(UserType* output) const {
    auto data_value = data_->wait;
    return mojo::internal::Deserialize<::blink::mojom::LockManager_WaitMode>(
        data_value, output);
  }
  LockManager_WaitMode wait() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::LockManager_WaitMode>(data_->wait));
  }
  template <typename UserType>
  UserType TakeRequest() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::LockRequestAssociatedPtrInfoDataView>(
            &data_->request, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::LockManager_RequestLock_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LockManager_QueryState_ParamsDataView {
 public:
  LockManager_QueryState_ParamsDataView() = default;

  LockManager_QueryState_ParamsDataView(
      internal::LockManager_QueryState_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::LockManager_QueryState_Params_Data* data_ = nullptr;
};


class LockManager_QueryState_ResponseParamsDataView {
 public:
  LockManager_QueryState_ResponseParamsDataView() = default;

  LockManager_QueryState_ResponseParamsDataView(
      internal::LockManager_QueryState_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestedDataView(
      mojo::ArrayDataView<LockInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequested(UserType* output) {
    
    auto* pointer = data_->requested.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::LockInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetHeldDataView(
      mojo::ArrayDataView<LockInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeld(UserType* output) {
    
    auto* pointer = data_->held.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::LockInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::LockManager_QueryState_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};





inline void LockManager_RequestLock_ParamsDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void LockManager_QueryState_ResponseParamsDataView::GetRequestedDataView(
    mojo::ArrayDataView<LockInfoDataView>* output) {
  auto pointer = data_->requested.Get();
  *output = mojo::ArrayDataView<LockInfoDataView>(pointer, message_);
}
inline void LockManager_QueryState_ResponseParamsDataView::GetHeldDataView(
    mojo::ArrayDataView<LockInfoDataView>* output) {
  auto pointer = data_->held.Get();
  *output = mojo::ArrayDataView<LockInfoDataView>(pointer, message_);
}



}  // blink::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOCKS_LOCK_MANAGER_MOJOM_PARAMS_DATA_H_