// third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_PARAMS_DATA_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace blink::mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::network::mojom::internal::URLRequestRedirectInfo_Data> redirect_info;
  mojo::internal::Pointer<::network::mojom::internal::URLResponseHead_Data> redirect_response;

 private:
  friend class mojo::internal::MessageFragment<ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data>;

  ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data();
  ~ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data() = delete;
};
static_assert(sizeof(ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data) == 24,
              "Bad sizeof(ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t request_id;
  mojo::internal::Pointer<::url::mojom::internal::SchemeHostPort_Data> final_response_url;
  mojo::internal::Pointer<::network::mojom::internal::URLResponseHead_Data> head;
  int32_t request_destination;
  uint8_t is_ad_resource : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data>;

  ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data();
  ~ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data() = delete;
};
static_assert(sizeof(ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data) == 40,
              "Bad sizeof(ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t request_id;
  int32_t transfer_size_diff;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data>;

  ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data();
  ~ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data() = delete;
};
static_assert(sizeof(ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data) == 24,
              "Bad sizeof(ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::blink::mojom::internal::ResourceLoadInfo_Data> resource_load_info;
  mojo::internal::Pointer<::network::mojom::internal::URLLoaderCompletionStatus_Data> status;

 private:
  friend class mojo::internal::MessageFragment<ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data>;

  ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data();
  ~ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data() = delete;
};
static_assert(sizeof(ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data) == 24,
              "Bad sizeof(ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t request_id;

 private:
  friend class mojo::internal::MessageFragment<ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data>;

  ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data();
  ~ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data() = delete;
};
static_assert(sizeof(ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data) == 16,
              "Bad sizeof(ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) ResourceLoadInfoNotifier_Clone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data pending_resource_load_info_notifier;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<ResourceLoadInfoNotifier_Clone_Params_Data>;

  ResourceLoadInfoNotifier_Clone_Params_Data();
  ~ResourceLoadInfoNotifier_Clone_Params_Data() = delete;
};
static_assert(sizeof(ResourceLoadInfoNotifier_Clone_Params_Data) == 16,
              "Bad sizeof(ResourceLoadInfoNotifier_Clone_Params_Data)");

}  // namespace internal


class ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsDataView {
 public:
  ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsDataView() = default;

  ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsDataView(
      internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRedirectInfoDataView(
      ::network::mojom::URLRequestRedirectInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectInfo(UserType* output) {
    
    auto* pointer = data_->redirect_info.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestRedirectInfoDataView>(
        pointer, output, message_);
  }
  inline void GetRedirectResponseDataView(
      ::network::mojom::URLResponseHeadDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRedirectResponse(UserType* output) {
    
    auto* pointer = data_->redirect_response.Get();
    return mojo::internal::Deserialize<::network::mojom::URLResponseHeadDataView>(
        pointer, output, message_);
  }
 private:
  internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsDataView {
 public:
  ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsDataView() = default;

  ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsDataView(
      internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t request_id() const {
    return data_->request_id;
  }
  inline void GetFinalResponseUrlDataView(
      ::url::mojom::SchemeHostPortDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFinalResponseUrl(UserType* output) {
    
    auto* pointer = data_->final_response_url.Get();
    return mojo::internal::Deserialize<::url::mojom::SchemeHostPortDataView>(
        pointer, output, message_);
  }
  inline void GetHeadDataView(
      ::network::mojom::URLResponseHeadDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHead(UserType* output) {
    
    auto* pointer = data_->head.Get();
    return mojo::internal::Deserialize<::network::mojom::URLResponseHeadDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRequestDestination(UserType* output) const {
    auto data_value = data_->request_destination;
    return mojo::internal::Deserialize<::network::mojom::RequestDestination>(
        data_value, output);
  }
  ::network::mojom::RequestDestination request_destination() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestDestination>(data_->request_destination));
  }
  bool is_ad_resource() const {
    return data_->is_ad_resource;
  }
 private:
  internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_ParamsDataView {
 public:
  ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_ParamsDataView() = default;

  ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_ParamsDataView(
      internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t request_id() const {
    return data_->request_id;
  }
  int32_t transfer_size_diff() const {
    return data_->transfer_size_diff;
  }
 private:
  internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data* data_ = nullptr;
};


class ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsDataView {
 public:
  ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsDataView() = default;

  ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsDataView(
      internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResourceLoadInfoDataView(
      ::blink::mojom::ResourceLoadInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResourceLoadInfo(UserType* output) {
    
    auto* pointer = data_->resource_load_info.Get();
    return mojo::internal::Deserialize<::blink::mojom::ResourceLoadInfoDataView>(
        pointer, output, message_);
  }
  inline void GetStatusDataView(
      ::network::mojom::URLLoaderCompletionStatusDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<::network::mojom::URLLoaderCompletionStatusDataView>(
        pointer, output, message_);
  }
 private:
  internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_ParamsDataView {
 public:
  ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_ParamsDataView() = default;

  ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_ParamsDataView(
      internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t request_id() const {
    return data_->request_id;
  }
 private:
  internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data* data_ = nullptr;
};


class ResourceLoadInfoNotifier_Clone_ParamsDataView {
 public:
  ResourceLoadInfoNotifier_Clone_ParamsDataView() = default;

  ResourceLoadInfoNotifier_Clone_ParamsDataView(
      internal::ResourceLoadInfoNotifier_Clone_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePendingResourceLoadInfoNotifier() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::blink::mojom::ResourceLoadInfoNotifierInterfaceBase>>(
            &data_->pending_resource_load_info_notifier, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::ResourceLoadInfoNotifier_Clone_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsDataView::GetRedirectInfoDataView(
    ::network::mojom::URLRequestRedirectInfoDataView* output) {
  auto pointer = data_->redirect_info.Get();
  *output = ::network::mojom::URLRequestRedirectInfoDataView(pointer, message_);
}
inline void ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsDataView::GetRedirectResponseDataView(
    ::network::mojom::URLResponseHeadDataView* output) {
  auto pointer = data_->redirect_response.Get();
  *output = ::network::mojom::URLResponseHeadDataView(pointer, message_);
}


inline void ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsDataView::GetFinalResponseUrlDataView(
    ::url::mojom::SchemeHostPortDataView* output) {
  auto pointer = data_->final_response_url.Get();
  *output = ::url::mojom::SchemeHostPortDataView(pointer, message_);
}
inline void ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsDataView::GetHeadDataView(
    ::network::mojom::URLResponseHeadDataView* output) {
  auto pointer = data_->head.Get();
  *output = ::network::mojom::URLResponseHeadDataView(pointer, message_);
}




inline void ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsDataView::GetResourceLoadInfoDataView(
    ::blink::mojom::ResourceLoadInfoDataView* output) {
  auto pointer = data_->resource_load_info.Get();
  *output = ::blink::mojom::ResourceLoadInfoDataView(pointer, message_);
}
inline void ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsDataView::GetStatusDataView(
    ::network::mojom::URLLoaderCompletionStatusDataView* output) {
  auto pointer = data_->status.Get();
  *output = ::network::mojom::URLLoaderCompletionStatusDataView(pointer, message_);
}







}  // blink::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_PARAMS_DATA_H_