// third_party/blink/public/mojom/loader/resource_load_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_count.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "third_party/blink/public/mojom/loader/resource_load_info.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::ResourceType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ResourceType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ResourceType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ResourceType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ResourceType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CommonNetworkInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CommonNetworkInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CommonNetworkInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->network_accessed = Traits::network_accessed(input);

    fragment->always_access_network = Traits::always_access_network(input);

    decltype(Traits::remote_endpoint(input)) in_remote_endpoint = Traits::remote_endpoint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->remote_endpoint)::BaseType> remote_endpoint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_remote_endpoint,
      remote_endpoint_fragment);

    fragment->remote_endpoint.Set(
        remote_endpoint_fragment.is_null() ? nullptr : remote_endpoint_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::CommonNetworkInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CommonNetworkInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RedirectInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RedirectInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::RedirectInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::origin_of_new_url(input)) in_origin_of_new_url = Traits::origin_of_new_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin_of_new_url)::BaseType> origin_of_new_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin_of_new_url,
      origin_of_new_url_fragment);

    fragment->origin_of_new_url.Set(
        origin_of_new_url_fragment.is_null() ? nullptr : origin_of_new_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin_of_new_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin_of_new_url in RedirectInfo struct");

    decltype(Traits::network_info(input)) in_network_info = Traits::network_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->network_info)::BaseType> network_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::CommonNetworkInfoDataView>(
      in_network_info,
      network_info_fragment);

    fragment->network_info.Set(
        network_info_fragment.is_null() ? nullptr : network_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->network_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_info in RedirectInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::RedirectInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::RedirectInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ResourceLoadInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ResourceLoadInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ResourceLoadInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->request_id = Traits::request_id(input);

    decltype(Traits::final_url(input)) in_final_url = Traits::final_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->final_url)::BaseType> final_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_final_url,
      final_url_fragment);

    fragment->final_url.Set(
        final_url_fragment.is_null() ? nullptr : final_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->final_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null final_url in ResourceLoadInfo struct");

    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_referrer,
      referrer_fragment);

    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->referrer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null referrer in ResourceLoadInfo struct");

    decltype(Traits::original_url(input)) in_original_url = Traits::original_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->original_url)::BaseType> original_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_original_url,
      original_url_fragment);

    fragment->original_url.Set(
        original_url_fragment.is_null() ? nullptr : original_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->original_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null original_url in ResourceLoadInfo struct");

    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method)::BaseType> method_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_method,
      method_fragment);

    fragment->method.Set(
        method_fragment.is_null() ? nullptr : method_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method in ResourceLoadInfo struct");

    
    mojo::internal::Serialize<::network::mojom::RequestDestination>(
      Traits::request_destination(input),
      &fragment->request_destination);

    
    mojo::internal::Serialize<::network::mojom::RequestPriority>(
      Traits::request_priority(input),
      &fragment->request_priority);

    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_mime_type,
      mime_type_fragment);

    fragment->mime_type.Set(
        mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mime_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in ResourceLoadInfo struct");

    fragment->was_cached = Traits::was_cached(input);

    decltype(Traits::network_info(input)) in_network_info = Traits::network_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->network_info)::BaseType> network_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::CommonNetworkInfoDataView>(
      in_network_info,
      network_info_fragment);

    fragment->network_info.Set(
        network_info_fragment.is_null() ? nullptr : network_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->network_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_info in ResourceLoadInfo struct");

    fragment->net_error = Traits::net_error(input);

    decltype(Traits::proxy_chain(input)) in_proxy_chain = Traits::proxy_chain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxy_chain)::BaseType> proxy_chain_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ProxyChainDataView>(
      in_proxy_chain,
      proxy_chain_fragment);

    fragment->proxy_chain.Set(
        proxy_chain_fragment.is_null() ? nullptr : proxy_chain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->proxy_chain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxy_chain in ResourceLoadInfo struct");

    decltype(Traits::load_timing_info(input)) in_load_timing_info = Traits::load_timing_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->load_timing_info)::BaseType> load_timing_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView>(
      in_load_timing_info,
      load_timing_info_fragment);

    fragment->load_timing_info.Set(
        load_timing_info_fragment.is_null() ? nullptr : load_timing_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->load_timing_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null load_timing_info in ResourceLoadInfo struct");

    decltype(Traits::raw_body_bytes(input)) in_raw_body_bytes = Traits::raw_body_bytes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raw_body_bytes)::BaseType> raw_body_bytes_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_raw_body_bytes,
      raw_body_bytes_fragment);

    fragment->raw_body_bytes.Set(
        raw_body_bytes_fragment.is_null() ? nullptr : raw_body_bytes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->raw_body_bytes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_body_bytes in ResourceLoadInfo struct");

    decltype(Traits::total_received_bytes(input)) in_total_received_bytes = Traits::total_received_bytes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->total_received_bytes)::BaseType> total_received_bytes_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteCountDataView>(
      in_total_received_bytes,
      total_received_bytes_fragment);

    fragment->total_received_bytes.Set(
        total_received_bytes_fragment.is_null() ? nullptr : total_received_bytes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->total_received_bytes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null total_received_bytes in ResourceLoadInfo struct");

    decltype(Traits::redirect_info_chain(input)) in_redirect_info_chain = Traits::redirect_info_chain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->redirect_info_chain)::BaseType>
        redirect_info_chain_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& redirect_info_chain_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::RedirectInfoDataView>>(
      in_redirect_info_chain,
      redirect_info_chain_fragment,
      &redirect_info_chain_validate_params);

    fragment->redirect_info_chain.Set(
        redirect_info_chain_fragment.is_null() ? nullptr : redirect_info_chain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->redirect_info_chain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null redirect_info_chain in ResourceLoadInfo struct");

    fragment->http_status_code = Traits::http_status_code(input);
  }

  static bool Deserialize(::blink::mojom::internal::ResourceLoadInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ResourceLoadInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void CommonNetworkInfoDataView::GetRemoteEndpointDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->remote_endpoint.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}


inline void RedirectInfoDataView::GetOriginOfNewUrlDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin_of_new_url.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void RedirectInfoDataView::GetNetworkInfoDataView(
    CommonNetworkInfoDataView* output) {
  auto pointer = data_->network_info.Get();
  *output = CommonNetworkInfoDataView(pointer, message_);
}


inline void ResourceLoadInfoDataView::GetFinalUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->final_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ResourceLoadInfoDataView::GetReferrerDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ResourceLoadInfoDataView::GetOriginalUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->original_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ResourceLoadInfoDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ResourceLoadInfoDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ResourceLoadInfoDataView::GetNetworkInfoDataView(
    CommonNetworkInfoDataView* output) {
  auto pointer = data_->network_info.Get();
  *output = CommonNetworkInfoDataView(pointer, message_);
}
inline void ResourceLoadInfoDataView::GetProxyChainDataView(
    ::network::mojom::ProxyChainDataView* output) {
  auto pointer = data_->proxy_chain.Get();
  *output = ::network::mojom::ProxyChainDataView(pointer, message_);
}
inline void ResourceLoadInfoDataView::GetLoadTimingInfoDataView(
    ::network::mojom::LoadTimingInfoDataView* output) {
  auto pointer = data_->load_timing_info.Get();
  *output = ::network::mojom::LoadTimingInfoDataView(pointer, message_);
}
inline void ResourceLoadInfoDataView::GetRawBodyBytesDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->raw_body_bytes.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}
inline void ResourceLoadInfoDataView::GetTotalReceivedBytesDataView(
    ::mojo_base::mojom::ByteCountDataView* output) {
  auto pointer = data_->total_received_bytes.Get();
  *output = ::mojo_base::mojom::ByteCountDataView(pointer, message_);
}
inline void ResourceLoadInfoDataView::GetRedirectInfoChainDataView(
    mojo::ArrayDataView<RedirectInfoDataView>* output) {
  auto pointer = data_->redirect_info_chain.Get();
  *output = mojo::ArrayDataView<RedirectInfoDataView>(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ResourceType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ResourceType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_MOJOM_SHARED_H_