// third_party/blink/public/mojom/loader/navigation_predictor.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/loader/navigation_predictor.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
AnchorElementMetrics::AnchorElementMetrics()
    : anchor_id(),
      ratio_area(),
      ratio_distance_top_to_visible_top(),
      ratio_distance_root_top(),
      is_in_iframe(),
      contains_image(),
      is_same_host(),
      is_url_incremented_by_one(),
      has_text_sibling(),
      font_size_px(),
      font_weight(),
      target_url(),
      viewport_size() {}

AnchorElementMetrics::AnchorElementMetrics(
    uint32_t anchor_id_in,
    float ratio_area_in,
    float ratio_distance_top_to_visible_top_in,
    float ratio_distance_root_top_in,
    bool is_in_iframe_in,
    bool contains_image_in,
    bool is_same_host_in,
    bool is_url_incremented_by_one_in,
    bool has_text_sibling_in,
    uint32_t font_size_px_in,
    uint32_t font_weight_in,
    const ::blink::KURL& target_url_in,
    const ::gfx::Size& viewport_size_in)
    : anchor_id(std::move(anchor_id_in)),
      ratio_area(std::move(ratio_area_in)),
      ratio_distance_top_to_visible_top(std::move(ratio_distance_top_to_visible_top_in)),
      ratio_distance_root_top(std::move(ratio_distance_root_top_in)),
      is_in_iframe(std::move(is_in_iframe_in)),
      contains_image(std::move(contains_image_in)),
      is_same_host(std::move(is_same_host_in)),
      is_url_incremented_by_one(std::move(is_url_incremented_by_one_in)),
      has_text_sibling(std::move(has_text_sibling_in)),
      font_size_px(std::move(font_size_px_in)),
      font_weight(std::move(font_weight_in)),
      target_url(std::move(target_url_in)),
      viewport_size(std::move(viewport_size_in)) {}

AnchorElementMetrics::~AnchorElementMetrics() = default;

void AnchorElementMetrics::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_area"), this->ratio_area,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_distance_top_to_visible_top"), this->ratio_distance_top_to_visible_top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ratio_distance_root_top"), this->ratio_distance_root_top,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_in_iframe"), this->is_in_iframe,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contains_image"), this->contains_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_same_host"), this->is_same_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_url_incremented_by_one"), this->is_url_incremented_by_one,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_text_sibling"), this->has_text_sibling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "font_size_px"), this->font_size_px,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "font_weight"), this->font_weight,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_url"), this->target_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "viewport_size"), this->viewport_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementMetrics::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorElementClick::AnchorElementClick()
    : anchor_id(),
      target_url(),
      navigation_start_to_click() {}

AnchorElementClick::AnchorElementClick(
    uint32_t anchor_id_in,
    const ::blink::KURL& target_url_in,
    ::base::TimeDelta navigation_start_to_click_in)
    : anchor_id(std::move(anchor_id_in)),
      target_url(std::move(target_url_in)),
      navigation_start_to_click(std::move(navigation_start_to_click_in)) {}

AnchorElementClick::~AnchorElementClick() = default;

void AnchorElementClick::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_url"), this->target_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_start_to_click"), this->navigation_start_to_click,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementClick::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorElementPointerDataOnHoverTimerFired::AnchorElementPointerDataOnHoverTimerFired()
    : anchor_id(),
      pointer_data() {}

AnchorElementPointerDataOnHoverTimerFired::AnchorElementPointerDataOnHoverTimerFired(
    uint32_t anchor_id_in,
    ::blink::mojom::blink::AnchorElementPointerDataPtr pointer_data_in)
    : anchor_id(std::move(anchor_id_in)),
      pointer_data(std::move(pointer_data_in)) {}

AnchorElementPointerDataOnHoverTimerFired::~AnchorElementPointerDataOnHoverTimerFired() = default;
size_t AnchorElementPointerDataOnHoverTimerFired::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->anchor_id);
  seed = mojo::internal::WTFHash(seed, this->pointer_data);
  return seed;
}

void AnchorElementPointerDataOnHoverTimerFired::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pointer_data"), this->pointer_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::mojom::blink::AnchorElementPointerDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementPointerDataOnHoverTimerFired::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorElementEnteredViewport::AnchorElementEnteredViewport()
    : anchor_id(),
      navigation_start_to_entered_viewport() {}

AnchorElementEnteredViewport::AnchorElementEnteredViewport(
    uint32_t anchor_id_in,
    ::base::TimeDelta navigation_start_to_entered_viewport_in)
    : anchor_id(std::move(anchor_id_in)),
      navigation_start_to_entered_viewport(std::move(navigation_start_to_entered_viewport_in)) {}

AnchorElementEnteredViewport::~AnchorElementEnteredViewport() = default;

void AnchorElementEnteredViewport::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_start_to_entered_viewport"), this->navigation_start_to_entered_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementEnteredViewport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorElementLeftViewport::AnchorElementLeftViewport()
    : anchor_id(),
      time_in_viewport() {}

AnchorElementLeftViewport::AnchorElementLeftViewport(
    uint32_t anchor_id_in,
    ::base::TimeDelta time_in_viewport_in)
    : anchor_id(std::move(anchor_id_in)),
      time_in_viewport(std::move(time_in_viewport_in)) {}

AnchorElementLeftViewport::~AnchorElementLeftViewport() = default;

void AnchorElementLeftViewport::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_in_viewport"), this->time_in_viewport,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementLeftViewport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorElementPointerOver::AnchorElementPointerOver()
    : anchor_id(),
      navigation_start_to_pointer_over() {}

AnchorElementPointerOver::AnchorElementPointerOver(
    uint32_t anchor_id_in,
    ::base::TimeDelta navigation_start_to_pointer_over_in)
    : anchor_id(std::move(anchor_id_in)),
      navigation_start_to_pointer_over(std::move(navigation_start_to_pointer_over_in)) {}

AnchorElementPointerOver::~AnchorElementPointerOver() = default;

void AnchorElementPointerOver::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_start_to_pointer_over"), this->navigation_start_to_pointer_over,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementPointerOver::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorElementPointerOut::AnchorElementPointerOut()
    : anchor_id(),
      hover_dwell_time() {}

AnchorElementPointerOut::AnchorElementPointerOut(
    uint32_t anchor_id_in,
    ::base::TimeDelta hover_dwell_time_in)
    : anchor_id(std::move(anchor_id_in)),
      hover_dwell_time(std::move(hover_dwell_time_in)) {}

AnchorElementPointerOut::~AnchorElementPointerOut() = default;

void AnchorElementPointerOut::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hover_dwell_time"), this->hover_dwell_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementPointerOut::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorElementPointerEventForMLModel::AnchorElementPointerEventForMLModel()
    : anchor_id(),
      is_mouse(),
      user_interaction_event_type() {}

AnchorElementPointerEventForMLModel::AnchorElementPointerEventForMLModel(
    uint32_t anchor_id_in,
    bool is_mouse_in,
    AnchorElementUserInteractionEventForMLModelType user_interaction_event_type_in)
    : anchor_id(std::move(anchor_id_in)),
      is_mouse(std::move(is_mouse_in)),
      user_interaction_event_type(std::move(user_interaction_event_type_in)) {}

AnchorElementPointerEventForMLModel::~AnchorElementPointerEventForMLModel() = default;
size_t AnchorElementPointerEventForMLModel::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->anchor_id);
  seed = mojo::internal::WTFHash(seed, this->is_mouse);
  seed = mojo::internal::WTFHash(seed, this->user_interaction_event_type);
  return seed;
}

void AnchorElementPointerEventForMLModel::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_mouse"), this->is_mouse,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_interaction_event_type"), this->user_interaction_event_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AnchorElementUserInteractionEventForMLModelType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementPointerEventForMLModel::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorElementPointerDown::AnchorElementPointerDown()
    : anchor_id(),
      navigation_start_to_pointer_down() {}

AnchorElementPointerDown::AnchorElementPointerDown(
    uint32_t anchor_id_in,
    ::base::TimeDelta navigation_start_to_pointer_down_in)
    : anchor_id(std::move(anchor_id_in)),
      navigation_start_to_pointer_down(std::move(navigation_start_to_pointer_down_in)) {}

AnchorElementPointerDown::~AnchorElementPointerDown() = default;

void AnchorElementPointerDown::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "navigation_start_to_pointer_down"), this->navigation_start_to_pointer_down,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementPointerDown::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnchorElementPositionUpdate::AnchorElementPositionUpdate()
    : anchor_id(),
      vertical_position_ratio(),
      distance_from_pointer_down_ratio() {}

AnchorElementPositionUpdate::AnchorElementPositionUpdate(
    uint32_t anchor_id_in,
    float vertical_position_ratio_in,
    std::optional<float> distance_from_pointer_down_ratio_in)
    : anchor_id(std::move(anchor_id_in)),
      vertical_position_ratio(std::move(vertical_position_ratio_in)),
      distance_from_pointer_down_ratio(std::move(distance_from_pointer_down_ratio_in)) {}

AnchorElementPositionUpdate::~AnchorElementPositionUpdate() = default;

void AnchorElementPositionUpdate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_id"), this->anchor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vertical_position_ratio"), this->vertical_position_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "distance_from_pointer_down_ratio"), this->distance_from_pointer_down_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<float>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AnchorElementPositionUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AnchorElementMetricsHost::IPCStableHashFunction AnchorElementMetricsHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AnchorElementMetricsHost>(message.name())) {
    case messages::AnchorElementMetricsHost::kReportAnchorElementClick: {
      return &AnchorElementMetricsHost::ReportAnchorElementClick_Sym::IPCStableHash;
    }
    case messages::AnchorElementMetricsHost::kReportNewAnchorElements: {
      return &AnchorElementMetricsHost::ReportNewAnchorElements_Sym::IPCStableHash;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementsEnteredViewport: {
      return &AnchorElementMetricsHost::ReportAnchorElementsEnteredViewport_Sym::IPCStableHash;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementsLeftViewport: {
      return &AnchorElementMetricsHost::ReportAnchorElementsLeftViewport_Sym::IPCStableHash;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementsPositionUpdate: {
      return &AnchorElementMetricsHost::ReportAnchorElementsPositionUpdate_Sym::IPCStableHash;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerOver: {
      return &AnchorElementMetricsHost::ReportAnchorElementPointerOver_Sym::IPCStableHash;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerOut: {
      return &AnchorElementMetricsHost::ReportAnchorElementPointerOut_Sym::IPCStableHash;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerDown: {
      return &AnchorElementMetricsHost::ReportAnchorElementPointerDown_Sym::IPCStableHash;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerDataOnHoverTimerFired: {
      return &AnchorElementMetricsHost::ReportAnchorElementPointerDataOnHoverTimerFired_Sym::IPCStableHash;
    }
    case messages::AnchorElementMetricsHost::kProcessPointerEventUsingMLModel: {
      return &AnchorElementMetricsHost::ProcessPointerEventUsingMLModel_Sym::IPCStableHash;
    }
    case messages::AnchorElementMetricsHost::kShouldSkipUpdateDelays: {
      return &AnchorElementMetricsHost::ShouldSkipUpdateDelays_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AnchorElementMetricsHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AnchorElementMetricsHost>(message.name())) {
      case messages::AnchorElementMetricsHost::kReportAnchorElementClick:
            return "Receive blink::mojom::AnchorElementMetricsHost::ReportAnchorElementClick";
      case messages::AnchorElementMetricsHost::kReportNewAnchorElements:
            return "Receive blink::mojom::AnchorElementMetricsHost::ReportNewAnchorElements";
      case messages::AnchorElementMetricsHost::kReportAnchorElementsEnteredViewport:
            return "Receive blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsEnteredViewport";
      case messages::AnchorElementMetricsHost::kReportAnchorElementsLeftViewport:
            return "Receive blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsLeftViewport";
      case messages::AnchorElementMetricsHost::kReportAnchorElementsPositionUpdate:
            return "Receive blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsPositionUpdate";
      case messages::AnchorElementMetricsHost::kReportAnchorElementPointerOver:
            return "Receive blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerOver";
      case messages::AnchorElementMetricsHost::kReportAnchorElementPointerOut:
            return "Receive blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerOut";
      case messages::AnchorElementMetricsHost::kReportAnchorElementPointerDown:
            return "Receive blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerDown";
      case messages::AnchorElementMetricsHost::kReportAnchorElementPointerDataOnHoverTimerFired:
            return "Receive blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerDataOnHoverTimerFired";
      case messages::AnchorElementMetricsHost::kProcessPointerEventUsingMLModel:
            return "Receive blink::mojom::AnchorElementMetricsHost::ProcessPointerEventUsingMLModel";
      case messages::AnchorElementMetricsHost::kShouldSkipUpdateDelays:
            return "Receive blink::mojom::AnchorElementMetricsHost::ShouldSkipUpdateDelays";
    }
  } else {
    switch (static_cast<messages::AnchorElementMetricsHost>(message.name())) {
      case messages::AnchorElementMetricsHost::kReportAnchorElementClick:
            return "Receive reply blink::mojom::AnchorElementMetricsHost::ReportAnchorElementClick";
      case messages::AnchorElementMetricsHost::kReportNewAnchorElements:
            return "Receive reply blink::mojom::AnchorElementMetricsHost::ReportNewAnchorElements";
      case messages::AnchorElementMetricsHost::kReportAnchorElementsEnteredViewport:
            return "Receive reply blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsEnteredViewport";
      case messages::AnchorElementMetricsHost::kReportAnchorElementsLeftViewport:
            return "Receive reply blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsLeftViewport";
      case messages::AnchorElementMetricsHost::kReportAnchorElementsPositionUpdate:
            return "Receive reply blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsPositionUpdate";
      case messages::AnchorElementMetricsHost::kReportAnchorElementPointerOver:
            return "Receive reply blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerOver";
      case messages::AnchorElementMetricsHost::kReportAnchorElementPointerOut:
            return "Receive reply blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerOut";
      case messages::AnchorElementMetricsHost::kReportAnchorElementPointerDown:
            return "Receive reply blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerDown";
      case messages::AnchorElementMetricsHost::kReportAnchorElementPointerDataOnHoverTimerFired:
            return "Receive reply blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerDataOnHoverTimerFired";
      case messages::AnchorElementMetricsHost::kProcessPointerEventUsingMLModel:
            return "Receive reply blink::mojom::AnchorElementMetricsHost::ProcessPointerEventUsingMLModel";
      case messages::AnchorElementMetricsHost::kShouldSkipUpdateDelays:
            return "Receive reply blink::mojom::AnchorElementMetricsHost::ShouldSkipUpdateDelays";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AnchorElementMetricsHost::ReportAnchorElementClick_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfc0b90e4;  // IPCStableHash for blink::mojom::AnchorElementMetricsHost::ReportAnchorElementClick
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementMetricsHost::ReportNewAnchorElements_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7f89f022;  // IPCStableHash for blink::mojom::AnchorElementMetricsHost::ReportNewAnchorElements
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementMetricsHost::ReportAnchorElementsEnteredViewport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71ae9bb0;  // IPCStableHash for blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsEnteredViewport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementMetricsHost::ReportAnchorElementsLeftViewport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf4b4fd84;  // IPCStableHash for blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsLeftViewport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementMetricsHost::ReportAnchorElementsPositionUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6f801ccf;  // IPCStableHash for blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsPositionUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementMetricsHost::ReportAnchorElementPointerOver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4033bfd9;  // IPCStableHash for blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerOver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementMetricsHost::ReportAnchorElementPointerOut_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc1be6196;  // IPCStableHash for blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerOut
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementMetricsHost::ReportAnchorElementPointerDown_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1282bd08;  // IPCStableHash for blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerDown
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementMetricsHost::ReportAnchorElementPointerDataOnHoverTimerFired_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x32c88409;  // IPCStableHash for blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerDataOnHoverTimerFired
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementMetricsHost::ProcessPointerEventUsingMLModel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc213c182;  // IPCStableHash for blink::mojom::AnchorElementMetricsHost::ProcessPointerEventUsingMLModel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t AnchorElementMetricsHost::ShouldSkipUpdateDelays_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc37847f9;  // IPCStableHash for blink::mojom::AnchorElementMetricsHost::ShouldSkipUpdateDelays
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AnchorElementMetricsHost_ShouldSkipUpdateDelays_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AnchorElementMetricsHost_ShouldSkipUpdateDelays_ForwardToCallback(
      AnchorElementMetricsHost::ShouldSkipUpdateDelaysCallback callback
      ) : callback_(std::move(callback)) {
  }

  AnchorElementMetricsHost_ShouldSkipUpdateDelays_ForwardToCallback(const AnchorElementMetricsHost_ShouldSkipUpdateDelays_ForwardToCallback&) = delete;
  AnchorElementMetricsHost_ShouldSkipUpdateDelays_ForwardToCallback& operator=(const AnchorElementMetricsHost_ShouldSkipUpdateDelays_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AnchorElementMetricsHost::ShouldSkipUpdateDelaysCallback callback_;
};

AnchorElementMetricsHostProxy::AnchorElementMetricsHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AnchorElementMetricsHostProxy::ReportAnchorElementClick(
    AnchorElementClickPtr in_clicked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementMetricsHost::ReportAnchorElementClick", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clicked"), in_clicked,
                        "<value of type AnchorElementClickPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kReportAnchorElementClick), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementClick_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->clicked)::BaseType> clicked_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AnchorElementClickDataView>(
    in_clicked,
    clicked_fragment);

  params->clicked.Set(
      clicked_fragment.is_null() ? nullptr : clicked_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->clicked.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null clicked in AnchorElementMetricsHost.ReportAnchorElementClick request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementClick");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementMetricsHostProxy::ReportNewAnchorElements(
    ::blink::Vector<AnchorElementMetricsPtr> in_metrics, const ::blink::Vector<uint32_t>& in_removed_elements) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementMetricsHost::ReportNewAnchorElements", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metrics"), in_metrics,
                        "<value of type ::blink::Vector<AnchorElementMetricsPtr>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("removed_elements"), in_removed_elements,
                        "<value of type const ::blink::Vector<uint32_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kReportNewAnchorElements), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportNewAnchorElements_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->metrics)::BaseType>
      metrics_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& metrics_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AnchorElementMetricsDataView>>(
    in_metrics,
    metrics_fragment,
    &metrics_validate_params);

  params->metrics.Set(
      metrics_fragment.is_null() ? nullptr : metrics_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->metrics.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null metrics in AnchorElementMetricsHost.ReportNewAnchorElements request");
  mojo::internal::MessageFragment<
      typename decltype(params->removed_elements)::BaseType>
      removed_elements_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& removed_elements_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
    in_removed_elements,
    removed_elements_fragment,
    &removed_elements_validate_params);

  params->removed_elements.Set(
      removed_elements_fragment.is_null() ? nullptr : removed_elements_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->removed_elements.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null removed_elements in AnchorElementMetricsHost.ReportNewAnchorElements request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportNewAnchorElements");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementMetricsHostProxy::ReportAnchorElementsEnteredViewport(
    ::blink::Vector<AnchorElementEnteredViewportPtr> in_elements) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsEnteredViewport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elements"), in_elements,
                        "<value of type ::blink::Vector<AnchorElementEnteredViewportPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kReportAnchorElementsEnteredViewport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->elements)::BaseType>
      elements_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AnchorElementEnteredViewportDataView>>(
    in_elements,
    elements_fragment,
    &elements_validate_params);

  params->elements.Set(
      elements_fragment.is_null() ? nullptr : elements_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->elements.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null elements in AnchorElementMetricsHost.ReportAnchorElementsEnteredViewport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementsEnteredViewport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementMetricsHostProxy::ReportAnchorElementsLeftViewport(
    ::blink::Vector<AnchorElementLeftViewportPtr> in_elements) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsLeftViewport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elements"), in_elements,
                        "<value of type ::blink::Vector<AnchorElementLeftViewportPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kReportAnchorElementsLeftViewport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->elements)::BaseType>
      elements_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AnchorElementLeftViewportDataView>>(
    in_elements,
    elements_fragment,
    &elements_validate_params);

  params->elements.Set(
      elements_fragment.is_null() ? nullptr : elements_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->elements.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null elements in AnchorElementMetricsHost.ReportAnchorElementsLeftViewport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementsLeftViewport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementMetricsHostProxy::ReportAnchorElementsPositionUpdate(
    ::blink::Vector<AnchorElementPositionUpdatePtr> in_elements) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementMetricsHost::ReportAnchorElementsPositionUpdate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("elements"), in_elements,
                        "<value of type ::blink::Vector<AnchorElementPositionUpdatePtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kReportAnchorElementsPositionUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->elements)::BaseType>
      elements_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::AnchorElementPositionUpdateDataView>>(
    in_elements,
    elements_fragment,
    &elements_validate_params);

  params->elements.Set(
      elements_fragment.is_null() ? nullptr : elements_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->elements.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null elements in AnchorElementMetricsHost.ReportAnchorElementsPositionUpdate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementsPositionUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementMetricsHostProxy::ReportAnchorElementPointerOver(
    AnchorElementPointerOverPtr in_pointer_over_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerOver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pointer_over_event"), in_pointer_over_event,
                        "<value of type AnchorElementPointerOverPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kReportAnchorElementPointerOver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pointer_over_event)::BaseType> pointer_over_event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AnchorElementPointerOverDataView>(
    in_pointer_over_event,
    pointer_over_event_fragment);

  params->pointer_over_event.Set(
      pointer_over_event_fragment.is_null() ? nullptr : pointer_over_event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pointer_over_event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pointer_over_event in AnchorElementMetricsHost.ReportAnchorElementPointerOver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementPointerOver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementMetricsHostProxy::ReportAnchorElementPointerOut(
    AnchorElementPointerOutPtr in_hover_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerOut", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hover_event"), in_hover_event,
                        "<value of type AnchorElementPointerOutPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kReportAnchorElementPointerOut), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hover_event)::BaseType> hover_event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AnchorElementPointerOutDataView>(
    in_hover_event,
    hover_event_fragment);

  params->hover_event.Set(
      hover_event_fragment.is_null() ? nullptr : hover_event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->hover_event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null hover_event in AnchorElementMetricsHost.ReportAnchorElementPointerOut request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementPointerOut");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementMetricsHostProxy::ReportAnchorElementPointerDown(
    AnchorElementPointerDownPtr in_pointer_down_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerDown", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pointer_down_event"), in_pointer_down_event,
                        "<value of type AnchorElementPointerDownPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kReportAnchorElementPointerDown), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pointer_down_event)::BaseType> pointer_down_event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AnchorElementPointerDownDataView>(
    in_pointer_down_event,
    pointer_down_event_fragment);

  params->pointer_down_event.Set(
      pointer_down_event_fragment.is_null() ? nullptr : pointer_down_event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pointer_down_event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pointer_down_event in AnchorElementMetricsHost.ReportAnchorElementPointerDown request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementPointerDown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementMetricsHostProxy::ReportAnchorElementPointerDataOnHoverTimerFired(
    AnchorElementPointerDataOnHoverTimerFiredPtr in_pointer_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementMetricsHost::ReportAnchorElementPointerDataOnHoverTimerFired", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pointer_data"), in_pointer_data,
                        "<value of type AnchorElementPointerDataOnHoverTimerFiredPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kReportAnchorElementPointerDataOnHoverTimerFired), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pointer_data)::BaseType> pointer_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AnchorElementPointerDataOnHoverTimerFiredDataView>(
    in_pointer_data,
    pointer_data_fragment);

  params->pointer_data.Set(
      pointer_data_fragment.is_null() ? nullptr : pointer_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pointer_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pointer_data in AnchorElementMetricsHost.ReportAnchorElementPointerDataOnHoverTimerFired request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ReportAnchorElementPointerDataOnHoverTimerFired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementMetricsHostProxy::ProcessPointerEventUsingMLModel(
    AnchorElementPointerEventForMLModelPtr in_pointer_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::AnchorElementMetricsHost::ProcessPointerEventUsingMLModel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pointer_event"), in_pointer_event,
                        "<value of type AnchorElementPointerEventForMLModelPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kProcessPointerEventUsingMLModel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pointer_event)::BaseType> pointer_event_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::AnchorElementPointerEventForMLModelDataView>(
    in_pointer_event,
    pointer_event_fragment);

  params->pointer_event.Set(
      pointer_event_fragment.is_null() ? nullptr : pointer_event_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pointer_event.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pointer_event in AnchorElementMetricsHost.ProcessPointerEventUsingMLModel request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ProcessPointerEventUsingMLModel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void AnchorElementMetricsHostProxy::ShouldSkipUpdateDelays(
    ShouldSkipUpdateDelaysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::AnchorElementMetricsHost::ShouldSkipUpdateDelays");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kShouldSkipUpdateDelays), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ShouldSkipUpdateDelays");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AnchorElementMetricsHost_ShouldSkipUpdateDelays_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AnchorElementMetricsHost_ShouldSkipUpdateDelays_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AnchorElementMetricsHost::ShouldSkipUpdateDelaysCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AnchorElementMetricsHost_ShouldSkipUpdateDelays_ProxyToResponder> proxy(
        new AnchorElementMetricsHost_ShouldSkipUpdateDelays_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AnchorElementMetricsHost_ShouldSkipUpdateDelays_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AnchorElementMetricsHost_ShouldSkipUpdateDelays_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AnchorElementMetricsHost_ShouldSkipUpdateDelays_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AnchorElementMetricsHost::ShouldSkipUpdateDelaysCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_should_skip_for_testing);
};

bool AnchorElementMetricsHost_ShouldSkipUpdateDelays_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AnchorElementMetricsHost.10
  bool success = true;
  bool p_should_skip_for_testing{};
  AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_should_skip_for_testing = input_data_view.should_skip_for_testing();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AnchorElementMetricsHost::Name_, 10, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_should_skip_for_testing));
  }
  return true;
}

void AnchorElementMetricsHost_ShouldSkipUpdateDelays_ProxyToResponder::Run(
    bool in_should_skip_for_testing) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::AnchorElementMetricsHost::ShouldSkipUpdateDelays", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("should_skip_for_testing"), in_should_skip_for_testing,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AnchorElementMetricsHost::kShouldSkipUpdateDelays), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->should_skip_for_testing = in_should_skip_for_testing;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AnchorElementMetricsHost::Name_);
  message.set_method_name("ShouldSkipUpdateDelays");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AnchorElementMetricsHostStubDispatch::Accept(
    AnchorElementMetricsHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AnchorElementMetricsHost>(message->header()->name)) {
    case messages::AnchorElementMetricsHost::kReportAnchorElementClick: {
      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementClick_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementClick_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementMetricsHost.0
      bool success = true;
      AnchorElementClickPtr p_clicked{};
      AnchorElementMetricsHost_ReportAnchorElementClick_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadClicked(&p_clicked))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementClick(        
        std::move(p_clicked));
      return true;
    }
    case messages::AnchorElementMetricsHost::kReportNewAnchorElements: {
      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportNewAnchorElements_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportNewAnchorElements_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementMetricsHost.1
      bool success = true;
      ::blink::Vector<AnchorElementMetricsPtr> p_metrics{};
      ::blink::Vector<uint32_t> p_removed_elements{};
      AnchorElementMetricsHost_ReportNewAnchorElements_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMetrics(&p_metrics))
        success = false;
      if (success && !input_data_view.ReadRemovedElements(&p_removed_elements))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportNewAnchorElements(        
        std::move(p_metrics), 
        std::move(p_removed_elements));
      return true;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementsEnteredViewport: {
      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementMetricsHost.2
      bool success = true;
      ::blink::Vector<AnchorElementEnteredViewportPtr> p_elements{};
      AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadElements(&p_elements))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementsEnteredViewport(        
        std::move(p_elements));
      return true;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementsLeftViewport: {
      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementMetricsHost.3
      bool success = true;
      ::blink::Vector<AnchorElementLeftViewportPtr> p_elements{};
      AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadElements(&p_elements))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementsLeftViewport(        
        std::move(p_elements));
      return true;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementsPositionUpdate: {
      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementMetricsHost.4
      bool success = true;
      ::blink::Vector<AnchorElementPositionUpdatePtr> p_elements{};
      AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadElements(&p_elements))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementsPositionUpdate(        
        std::move(p_elements));
      return true;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerOver: {
      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementMetricsHost.5
      bool success = true;
      AnchorElementPointerOverPtr p_pointer_over_event{};
      AnchorElementMetricsHost_ReportAnchorElementPointerOver_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPointerOverEvent(&p_pointer_over_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementPointerOver(        
        std::move(p_pointer_over_event));
      return true;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerOut: {
      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementMetricsHost.6
      bool success = true;
      AnchorElementPointerOutPtr p_hover_event{};
      AnchorElementMetricsHost_ReportAnchorElementPointerOut_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHoverEvent(&p_hover_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementPointerOut(        
        std::move(p_hover_event));
      return true;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerDown: {
      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementMetricsHost.7
      bool success = true;
      AnchorElementPointerDownPtr p_pointer_down_event{};
      AnchorElementMetricsHost_ReportAnchorElementPointerDown_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPointerDownEvent(&p_pointer_down_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementPointerDown(        
        std::move(p_pointer_down_event));
      return true;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerDataOnHoverTimerFired: {
      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementMetricsHost.8
      bool success = true;
      AnchorElementPointerDataOnHoverTimerFiredPtr p_pointer_data{};
      AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPointerData(&p_pointer_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportAnchorElementPointerDataOnHoverTimerFired(        
        std::move(p_pointer_data));
      return true;
    }
    case messages::AnchorElementMetricsHost::kProcessPointerEventUsingMLModel: {
      DCHECK(message->is_serialized());
      internal::AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params_Data* params =
          reinterpret_cast<internal::AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for AnchorElementMetricsHost.9
      bool success = true;
      AnchorElementPointerEventForMLModelPtr p_pointer_event{};
      AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPointerEvent(&p_pointer_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ProcessPointerEventUsingMLModel(        
        std::move(p_pointer_event));
      return true;
    }
    case messages::AnchorElementMetricsHost::kShouldSkipUpdateDelays: {
      break;
    }
  }
  return false;
}

// static
bool AnchorElementMetricsHostStubDispatch::AcceptWithResponder(
    AnchorElementMetricsHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AnchorElementMetricsHost>(message->header()->name)) {
    case messages::AnchorElementMetricsHost::kReportAnchorElementClick: {
      break;
    }
    case messages::AnchorElementMetricsHost::kReportNewAnchorElements: {
      break;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementsEnteredViewport: {
      break;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementsLeftViewport: {
      break;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementsPositionUpdate: {
      break;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerOver: {
      break;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerOut: {
      break;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerDown: {
      break;
    }
    case messages::AnchorElementMetricsHost::kReportAnchorElementPointerDataOnHoverTimerFired: {
      break;
    }
    case messages::AnchorElementMetricsHost::kProcessPointerEventUsingMLModel: {
      break;
    }
    case messages::AnchorElementMetricsHost::kShouldSkipUpdateDelays: {
      internal::AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params_Data* params =
          reinterpret_cast<
              internal::AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AnchorElementMetricsHost.10
      bool success = true;
      AnchorElementMetricsHost_ShouldSkipUpdateDelays_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AnchorElementMetricsHost::Name_, 10, false);
        return false;
      }
      auto callback =
          AnchorElementMetricsHost_ShouldSkipUpdateDelays_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShouldSkipUpdateDelays(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAnchorElementMetricsHostValidationInfo[] = {
    { &internal::AnchorElementMetricsHost_ReportAnchorElementClick_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementMetricsHost_ReportNewAnchorElements_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementMetricsHost_ReportAnchorElementsEnteredViewport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementMetricsHost_ReportAnchorElementsLeftViewport_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementMetricsHost_ReportAnchorElementsPositionUpdate_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementMetricsHost_ReportAnchorElementPointerOver_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementMetricsHost_ReportAnchorElementPointerOut_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementMetricsHost_ReportAnchorElementPointerDown_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementMetricsHost_ReportAnchorElementPointerDataOnHoverTimerFired_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementMetricsHost_ProcessPointerEventUsingMLModel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::AnchorElementMetricsHost_ShouldSkipUpdateDelays_Params_Data::Validate,
     &internal::AnchorElementMetricsHost_ShouldSkipUpdateDelays_ResponseParams_Data::Validate},
};

bool AnchorElementMetricsHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::AnchorElementMetricsHost::Name_,
    kAnchorElementMetricsHostValidationInfo);
}

bool AnchorElementMetricsHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::AnchorElementMetricsHost::Name_,
    kAnchorElementMetricsHostValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::AnchorElementMetrics::DataView, ::blink::mojom::blink::AnchorElementMetricsPtr>::Read(
    ::blink::mojom::blink::AnchorElementMetrics::DataView input,
    ::blink::mojom::blink::AnchorElementMetricsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AnchorElementMetricsPtr result(::blink::mojom::blink::AnchorElementMetrics::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success)
        result->ratio_area = input.ratio_area();
      if (success)
        result->ratio_distance_top_to_visible_top = input.ratio_distance_top_to_visible_top();
      if (success)
        result->ratio_distance_root_top = input.ratio_distance_root_top();
      if (success)
        result->is_in_iframe = input.is_in_iframe();
      if (success)
        result->contains_image = input.contains_image();
      if (success)
        result->is_same_host = input.is_same_host();
      if (success)
        result->is_url_incremented_by_one = input.is_url_incremented_by_one();
      if (success)
        result->has_text_sibling = input.has_text_sibling();
      if (success)
        result->font_size_px = input.font_size_px();
      if (success)
        result->font_weight = input.font_weight();
      if (success && !input.ReadTargetUrl(&result->target_url))
        success = false;
      if (success && !input.ReadViewportSize(&result->viewport_size))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AnchorElementClick::DataView, ::blink::mojom::blink::AnchorElementClickPtr>::Read(
    ::blink::mojom::blink::AnchorElementClick::DataView input,
    ::blink::mojom::blink::AnchorElementClickPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AnchorElementClickPtr result(::blink::mojom::blink::AnchorElementClick::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success && !input.ReadTargetUrl(&result->target_url))
        success = false;
      if (success && !input.ReadNavigationStartToClick(&result->navigation_start_to_click))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFired::DataView, ::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFiredPtr>::Read(
    ::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFired::DataView input,
    ::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFiredPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFiredPtr result(::blink::mojom::blink::AnchorElementPointerDataOnHoverTimerFired::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success && !input.ReadPointerData(&result->pointer_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AnchorElementEnteredViewport::DataView, ::blink::mojom::blink::AnchorElementEnteredViewportPtr>::Read(
    ::blink::mojom::blink::AnchorElementEnteredViewport::DataView input,
    ::blink::mojom::blink::AnchorElementEnteredViewportPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AnchorElementEnteredViewportPtr result(::blink::mojom::blink::AnchorElementEnteredViewport::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success && !input.ReadNavigationStartToEnteredViewport(&result->navigation_start_to_entered_viewport))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AnchorElementLeftViewport::DataView, ::blink::mojom::blink::AnchorElementLeftViewportPtr>::Read(
    ::blink::mojom::blink::AnchorElementLeftViewport::DataView input,
    ::blink::mojom::blink::AnchorElementLeftViewportPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AnchorElementLeftViewportPtr result(::blink::mojom::blink::AnchorElementLeftViewport::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success && !input.ReadTimeInViewport(&result->time_in_viewport))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AnchorElementPointerOver::DataView, ::blink::mojom::blink::AnchorElementPointerOverPtr>::Read(
    ::blink::mojom::blink::AnchorElementPointerOver::DataView input,
    ::blink::mojom::blink::AnchorElementPointerOverPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AnchorElementPointerOverPtr result(::blink::mojom::blink::AnchorElementPointerOver::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success && !input.ReadNavigationStartToPointerOver(&result->navigation_start_to_pointer_over))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AnchorElementPointerOut::DataView, ::blink::mojom::blink::AnchorElementPointerOutPtr>::Read(
    ::blink::mojom::blink::AnchorElementPointerOut::DataView input,
    ::blink::mojom::blink::AnchorElementPointerOutPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AnchorElementPointerOutPtr result(::blink::mojom::blink::AnchorElementPointerOut::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success && !input.ReadHoverDwellTime(&result->hover_dwell_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AnchorElementPointerEventForMLModel::DataView, ::blink::mojom::blink::AnchorElementPointerEventForMLModelPtr>::Read(
    ::blink::mojom::blink::AnchorElementPointerEventForMLModel::DataView input,
    ::blink::mojom::blink::AnchorElementPointerEventForMLModelPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AnchorElementPointerEventForMLModelPtr result(::blink::mojom::blink::AnchorElementPointerEventForMLModel::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success)
        result->is_mouse = input.is_mouse();
      if (success && !input.ReadUserInteractionEventType(&result->user_interaction_event_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AnchorElementPointerDown::DataView, ::blink::mojom::blink::AnchorElementPointerDownPtr>::Read(
    ::blink::mojom::blink::AnchorElementPointerDown::DataView input,
    ::blink::mojom::blink::AnchorElementPointerDownPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AnchorElementPointerDownPtr result(::blink::mojom::blink::AnchorElementPointerDown::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success && !input.ReadNavigationStartToPointerDown(&result->navigation_start_to_pointer_down))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AnchorElementPositionUpdate::DataView, ::blink::mojom::blink::AnchorElementPositionUpdatePtr>::Read(
    ::blink::mojom::blink::AnchorElementPositionUpdate::DataView input,
    ::blink::mojom::blink::AnchorElementPositionUpdatePtr* output) {
  bool success = true;
  ::blink::mojom::blink::AnchorElementPositionUpdatePtr result(::blink::mojom::blink::AnchorElementPositionUpdate::New());
  
      if (success)
        result->anchor_id = input.anchor_id();
      if (success)
        result->vertical_position_ratio = input.vertical_position_ratio();
      if (success) {
        result->distance_from_pointer_down_ratio = input.distance_from_pointer_down_ratio();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void AnchorElementMetricsHostInterceptorForTesting::ReportAnchorElementClick(AnchorElementClickPtr clicked) {
  GetForwardingInterface()->ReportAnchorElementClick(
    std::move(clicked)
    );
}
void AnchorElementMetricsHostInterceptorForTesting::ReportNewAnchorElements(::blink::Vector<AnchorElementMetricsPtr> metrics, const ::blink::Vector<uint32_t>& removed_elements) {
  GetForwardingInterface()->ReportNewAnchorElements(
    std::move(metrics)
    , 
    std::move(removed_elements)
    );
}
void AnchorElementMetricsHostInterceptorForTesting::ReportAnchorElementsEnteredViewport(::blink::Vector<AnchorElementEnteredViewportPtr> elements) {
  GetForwardingInterface()->ReportAnchorElementsEnteredViewport(
    std::move(elements)
    );
}
void AnchorElementMetricsHostInterceptorForTesting::ReportAnchorElementsLeftViewport(::blink::Vector<AnchorElementLeftViewportPtr> elements) {
  GetForwardingInterface()->ReportAnchorElementsLeftViewport(
    std::move(elements)
    );
}
void AnchorElementMetricsHostInterceptorForTesting::ReportAnchorElementsPositionUpdate(::blink::Vector<AnchorElementPositionUpdatePtr> elements) {
  GetForwardingInterface()->ReportAnchorElementsPositionUpdate(
    std::move(elements)
    );
}
void AnchorElementMetricsHostInterceptorForTesting::ReportAnchorElementPointerOver(AnchorElementPointerOverPtr pointer_over_event) {
  GetForwardingInterface()->ReportAnchorElementPointerOver(
    std::move(pointer_over_event)
    );
}
void AnchorElementMetricsHostInterceptorForTesting::ReportAnchorElementPointerOut(AnchorElementPointerOutPtr hover_event) {
  GetForwardingInterface()->ReportAnchorElementPointerOut(
    std::move(hover_event)
    );
}
void AnchorElementMetricsHostInterceptorForTesting::ReportAnchorElementPointerDown(AnchorElementPointerDownPtr pointer_down_event) {
  GetForwardingInterface()->ReportAnchorElementPointerDown(
    std::move(pointer_down_event)
    );
}
void AnchorElementMetricsHostInterceptorForTesting::ReportAnchorElementPointerDataOnHoverTimerFired(AnchorElementPointerDataOnHoverTimerFiredPtr pointer_data) {
  GetForwardingInterface()->ReportAnchorElementPointerDataOnHoverTimerFired(
    std::move(pointer_data)
    );
}
void AnchorElementMetricsHostInterceptorForTesting::ProcessPointerEventUsingMLModel(AnchorElementPointerEventForMLModelPtr pointer_event) {
  GetForwardingInterface()->ProcessPointerEventUsingMLModel(
    std::move(pointer_event)
    );
}
void AnchorElementMetricsHostInterceptorForTesting::ShouldSkipUpdateDelays(ShouldSkipUpdateDelaysCallback callback) {
  GetForwardingInterface()->ShouldSkipUpdateDelays(std::move(callback));
}
AnchorElementMetricsHostAsyncWaiter::AnchorElementMetricsHostAsyncWaiter(
    AnchorElementMetricsHost* proxy) : proxy_(proxy) {}

AnchorElementMetricsHostAsyncWaiter::~AnchorElementMetricsHostAsyncWaiter() = default;


void AnchorElementMetricsHostAsyncWaiter::ShouldSkipUpdateDelays(
    bool* out_should_skip_for_testing) {
  base::RunLoop loop;
  proxy_->ShouldSkipUpdateDelays(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_should_skip_for_testing
,
             bool should_skip_for_testing) {*out_should_skip_for_testing = std::move(should_skip_for_testing);
            loop->Quit();
          },
          &loop,
          out_should_skip_for_testing));
  loop.Run();
}

bool AnchorElementMetricsHostAsyncWaiter::ShouldSkipUpdateDelays(
    ) {
  bool async_wait_result;
  ShouldSkipUpdateDelays(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif