// third_party/blink/public/mojom/loader/code_cache.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_CODE_CACHE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_CODE_CACHE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/loader/code_cache.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/code_cache.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/code_cache.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/origin.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class CodeCacheHostProxy;

template <typename ImplRefTraits>
class CodeCacheHostStub;

class CodeCacheHostRequestValidator;
class CodeCacheHostResponseValidator;


class BLINK_COMMON_EXPORT CodeCacheHost
    : public CodeCacheHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.CodeCacheHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CodeCacheHostInterfaceBase;
  using Proxy_ = CodeCacheHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = CodeCacheHostStub<ImplRefTraits>;

  using RequestValidator_ = CodeCacheHostRequestValidator;
  using ResponseValidator_ = CodeCacheHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDidGenerateCacheableMetadataMinVersion = 0,
    kFetchCachedCodeMinVersion = 0,
    kClearCodeCacheEntryMinVersion = 0,
    kDidGenerateCacheableMetadataInCacheStorageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidGenerateCacheableMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FetchCachedCode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearCodeCacheEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidGenerateCacheableMetadataInCacheStorage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CodeCacheHost() = default;

  virtual void DidGenerateCacheableMetadata(CodeCacheType cache_type, const ::GURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data) = 0;

  using FetchCachedCodeCallback = base::OnceCallback<void(::base::Time, ::mojo_base::BigBuffer)>;
  using FetchCachedCodeMojoCallback = base::OnceCallback<void(::base::Time, ::mojo_base::BigBuffer)>;

  virtual void FetchCachedCode(CodeCacheType cache_type, const ::GURL& url, FetchCachedCodeCallback callback) = 0;

  virtual void ClearCodeCacheEntry(CodeCacheType cache_type, const ::GURL& url) = 0;

  virtual void DidGenerateCacheableMetadataInCacheStorage(const ::GURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, const std::string& cache_storage_cache_name) = 0;
};



class BLINK_COMMON_EXPORT CodeCacheHostProxy
    : public CodeCacheHost {
 public:
  using InterfaceType = CodeCacheHost;

  explicit CodeCacheHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidGenerateCacheableMetadata(CodeCacheType cache_type, const ::GURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data) final;
  
  void FetchCachedCode(CodeCacheType cache_type, const ::GURL& url, FetchCachedCodeCallback callback) final;
  
  void ClearCodeCacheEntry(CodeCacheType cache_type, const ::GURL& url) final;
  
  void DidGenerateCacheableMetadataInCacheStorage(const ::GURL& url, ::base::Time expected_response_time, ::mojo_base::BigBuffer data, const std::string& cache_storage_cache_name) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT CodeCacheHostStubDispatch {
 public:
  static bool Accept(CodeCacheHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CodeCacheHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CodeCacheHost>>
class CodeCacheHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CodeCacheHostStub() = default;
  ~CodeCacheHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CodeCacheHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CodeCacheHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT CodeCacheHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT CodeCacheHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_CODE_CACHE_MOJOM_H_