// third_party/blink/public/mojom/leak_detector/leak_detector.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LEAK_DETECTOR_LEAK_DETECTOR_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LEAK_DETECTOR_LEAK_DETECTOR_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class LeakDetectorProxy;

template <typename ImplRefTraits>
class LeakDetectorStub;

class LeakDetectorRequestValidator;
class LeakDetectorResponseValidator;


class PLATFORM_EXPORT LeakDetector
    : public LeakDetectorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.LeakDetector";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = LeakDetectorInterfaceBase;
  using Proxy_ = LeakDetectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = LeakDetectorStub<ImplRefTraits>;

  using RequestValidator_ = LeakDetectorRequestValidator;
  using ResponseValidator_ = LeakDetectorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kPerformLeakDetectionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PerformLeakDetection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~LeakDetector() = default;

  using PerformLeakDetectionCallback = base::OnceCallback<void(LeakDetectionResultPtr)>;
  using PerformLeakDetectionMojoCallback = base::OnceCallback<void(LeakDetectionResultPtr)>;

  virtual void PerformLeakDetection(PerformLeakDetectionCallback callback) = 0;
};



class PLATFORM_EXPORT LeakDetectorProxy
    : public LeakDetector {
 public:
  using InterfaceType = LeakDetector;

  explicit LeakDetectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PerformLeakDetection(PerformLeakDetectionCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT LeakDetectorStubDispatch {
 public:
  static bool Accept(LeakDetector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      LeakDetector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<LeakDetector>>
class LeakDetectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  LeakDetectorStub() = default;
  ~LeakDetectorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LeakDetectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return LeakDetectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT LeakDetectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT LeakDetectorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT LeakDetectionResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LeakDetectionResult, T>::value>;
  using DataView = LeakDetectionResultDataView;
  using Data_ = internal::LeakDetectionResult_Data;

  template <typename... Args>
  static LeakDetectionResultPtr New(Args&&... args) {
    return LeakDetectionResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LeakDetectionResultPtr From(const U& u) {
    return mojo::TypeConverter<LeakDetectionResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LeakDetectionResult>::Convert(*this);
  }


  LeakDetectionResult();

  LeakDetectionResult(
      uint32_t number_of_live_audio_nodes,
      uint32_t number_of_live_documents,
      uint32_t number_of_live_nodes,
      uint32_t number_of_live_layout_objects,
      uint32_t number_of_live_resources,
      uint32_t number_of_live_context_lifecycle_state_observers,
      uint32_t number_of_live_frames,
      uint32_t number_of_live_v8_per_context_data,
      uint32_t number_of_worker_global_scopes,
      uint32_t number_of_live_ua_css_resources,
      uint32_t number_of_live_resource_fetchers);


  ~LeakDetectionResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LeakDetectionResultPtr>
  LeakDetectionResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LeakDetectionResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LeakDetectionResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LeakDetectionResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LeakDetectionResult::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LeakDetectionResult::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LeakDetectionResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LeakDetectionResult_UnserializedMessageContext<
            UserType, LeakDetectionResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LeakDetectionResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LeakDetectionResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LeakDetectionResult_UnserializedMessageContext<
            UserType, LeakDetectionResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LeakDetectionResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t number_of_live_audio_nodes;
  
  uint32_t number_of_live_documents;
  
  uint32_t number_of_live_nodes;
  
  uint32_t number_of_live_layout_objects;
  
  uint32_t number_of_live_resources;
  
  uint32_t number_of_live_context_lifecycle_state_observers;
  
  uint32_t number_of_live_frames;
  
  uint32_t number_of_live_v8_per_context_data;
  
  uint32_t number_of_worker_global_scopes;
  
  uint32_t number_of_live_ua_css_resources;
  
  uint32_t number_of_live_resource_fetchers;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LeakDetectionResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LeakDetectionResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LeakDetectionResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LeakDetectionResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LeakDetectionResultPtr LeakDetectionResult::Clone() const {
  return New(
      mojo::Clone(number_of_live_audio_nodes),
      mojo::Clone(number_of_live_documents),
      mojo::Clone(number_of_live_nodes),
      mojo::Clone(number_of_live_layout_objects),
      mojo::Clone(number_of_live_resources),
      mojo::Clone(number_of_live_context_lifecycle_state_observers),
      mojo::Clone(number_of_live_frames),
      mojo::Clone(number_of_live_v8_per_context_data),
      mojo::Clone(number_of_worker_global_scopes),
      mojo::Clone(number_of_live_ua_css_resources),
      mojo::Clone(number_of_live_resource_fetchers)
  );
}

template <typename T, LeakDetectionResult::EnableIfSame<T>*>
bool LeakDetectionResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->number_of_live_audio_nodes, other_struct.number_of_live_audio_nodes))
    return false;
  if (!mojo::Equals(this->number_of_live_documents, other_struct.number_of_live_documents))
    return false;
  if (!mojo::Equals(this->number_of_live_nodes, other_struct.number_of_live_nodes))
    return false;
  if (!mojo::Equals(this->number_of_live_layout_objects, other_struct.number_of_live_layout_objects))
    return false;
  if (!mojo::Equals(this->number_of_live_resources, other_struct.number_of_live_resources))
    return false;
  if (!mojo::Equals(this->number_of_live_context_lifecycle_state_observers, other_struct.number_of_live_context_lifecycle_state_observers))
    return false;
  if (!mojo::Equals(this->number_of_live_frames, other_struct.number_of_live_frames))
    return false;
  if (!mojo::Equals(this->number_of_live_v8_per_context_data, other_struct.number_of_live_v8_per_context_data))
    return false;
  if (!mojo::Equals(this->number_of_worker_global_scopes, other_struct.number_of_worker_global_scopes))
    return false;
  if (!mojo::Equals(this->number_of_live_ua_css_resources, other_struct.number_of_live_ua_css_resources))
    return false;
  if (!mojo::Equals(this->number_of_live_resource_fetchers, other_struct.number_of_live_resource_fetchers))
    return false;
  return true;
}

template <typename T, LeakDetectionResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.number_of_live_audio_nodes < rhs.number_of_live_audio_nodes)
    return true;
  if (rhs.number_of_live_audio_nodes < lhs.number_of_live_audio_nodes)
    return false;
  if (lhs.number_of_live_documents < rhs.number_of_live_documents)
    return true;
  if (rhs.number_of_live_documents < lhs.number_of_live_documents)
    return false;
  if (lhs.number_of_live_nodes < rhs.number_of_live_nodes)
    return true;
  if (rhs.number_of_live_nodes < lhs.number_of_live_nodes)
    return false;
  if (lhs.number_of_live_layout_objects < rhs.number_of_live_layout_objects)
    return true;
  if (rhs.number_of_live_layout_objects < lhs.number_of_live_layout_objects)
    return false;
  if (lhs.number_of_live_resources < rhs.number_of_live_resources)
    return true;
  if (rhs.number_of_live_resources < lhs.number_of_live_resources)
    return false;
  if (lhs.number_of_live_context_lifecycle_state_observers < rhs.number_of_live_context_lifecycle_state_observers)
    return true;
  if (rhs.number_of_live_context_lifecycle_state_observers < lhs.number_of_live_context_lifecycle_state_observers)
    return false;
  if (lhs.number_of_live_frames < rhs.number_of_live_frames)
    return true;
  if (rhs.number_of_live_frames < lhs.number_of_live_frames)
    return false;
  if (lhs.number_of_live_v8_per_context_data < rhs.number_of_live_v8_per_context_data)
    return true;
  if (rhs.number_of_live_v8_per_context_data < lhs.number_of_live_v8_per_context_data)
    return false;
  if (lhs.number_of_worker_global_scopes < rhs.number_of_worker_global_scopes)
    return true;
  if (rhs.number_of_worker_global_scopes < lhs.number_of_worker_global_scopes)
    return false;
  if (lhs.number_of_live_ua_css_resources < rhs.number_of_live_ua_css_resources)
    return true;
  if (rhs.number_of_live_ua_css_resources < lhs.number_of_live_ua_css_resources)
    return false;
  if (lhs.number_of_live_resource_fetchers < rhs.number_of_live_resource_fetchers)
    return true;
  if (rhs.number_of_live_resource_fetchers < lhs.number_of_live_resource_fetchers)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::LeakDetectionResult::DataView,
                                         ::blink::mojom::blink::LeakDetectionResultPtr> {
  static bool IsNull(const ::blink::mojom::blink::LeakDetectionResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::LeakDetectionResultPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::LeakDetectionResult::number_of_live_audio_nodes) number_of_live_audio_nodes(
      const ::blink::mojom::blink::LeakDetectionResultPtr& input) {
    return input->number_of_live_audio_nodes;
  }

  static decltype(::blink::mojom::blink::LeakDetectionResult::number_of_live_documents) number_of_live_documents(
      const ::blink::mojom::blink::LeakDetectionResultPtr& input) {
    return input->number_of_live_documents;
  }

  static decltype(::blink::mojom::blink::LeakDetectionResult::number_of_live_nodes) number_of_live_nodes(
      const ::blink::mojom::blink::LeakDetectionResultPtr& input) {
    return input->number_of_live_nodes;
  }

  static decltype(::blink::mojom::blink::LeakDetectionResult::number_of_live_layout_objects) number_of_live_layout_objects(
      const ::blink::mojom::blink::LeakDetectionResultPtr& input) {
    return input->number_of_live_layout_objects;
  }

  static decltype(::blink::mojom::blink::LeakDetectionResult::number_of_live_resources) number_of_live_resources(
      const ::blink::mojom::blink::LeakDetectionResultPtr& input) {
    return input->number_of_live_resources;
  }

  static decltype(::blink::mojom::blink::LeakDetectionResult::number_of_live_context_lifecycle_state_observers) number_of_live_context_lifecycle_state_observers(
      const ::blink::mojom::blink::LeakDetectionResultPtr& input) {
    return input->number_of_live_context_lifecycle_state_observers;
  }

  static decltype(::blink::mojom::blink::LeakDetectionResult::number_of_live_frames) number_of_live_frames(
      const ::blink::mojom::blink::LeakDetectionResultPtr& input) {
    return input->number_of_live_frames;
  }

  static decltype(::blink::mojom::blink::LeakDetectionResult::number_of_live_v8_per_context_data) number_of_live_v8_per_context_data(
      const ::blink::mojom::blink::LeakDetectionResultPtr& input) {
    return input->number_of_live_v8_per_context_data;
  }

  static decltype(::blink::mojom::blink::LeakDetectionResult::number_of_worker_global_scopes) number_of_worker_global_scopes(
      const ::blink::mojom::blink::LeakDetectionResultPtr& input) {
    return input->number_of_worker_global_scopes;
  }

  static decltype(::blink::mojom::blink::LeakDetectionResult::number_of_live_ua_css_resources) number_of_live_ua_css_resources(
      const ::blink::mojom::blink::LeakDetectionResultPtr& input) {
    return input->number_of_live_ua_css_resources;
  }

  static decltype(::blink::mojom::blink::LeakDetectionResult::number_of_live_resource_fetchers) number_of_live_resource_fetchers(
      const ::blink::mojom::blink::LeakDetectionResultPtr& input) {
    return input->number_of_live_resource_fetchers;
  }

  static bool Read(::blink::mojom::blink::LeakDetectionResult::DataView input, ::blink::mojom::blink::LeakDetectionResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LEAK_DETECTOR_LEAK_DETECTOR_MOJOM_BLINK_H_