// third_party/blink/public/mojom/leak_detector/leak_detector.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-params-data.h"
#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/leak_detector/leak_detector.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
LeakDetectionResult::LeakDetectionResult()
    : number_of_live_audio_nodes(),
      number_of_live_documents(),
      number_of_live_nodes(),
      number_of_live_layout_objects(),
      number_of_live_resources(),
      number_of_live_context_lifecycle_state_observers(),
      number_of_live_frames(),
      number_of_live_v8_per_context_data(),
      number_of_worker_global_scopes(),
      number_of_live_ua_css_resources(),
      number_of_live_resource_fetchers() {}

LeakDetectionResult::LeakDetectionResult(
    uint32_t number_of_live_audio_nodes_in,
    uint32_t number_of_live_documents_in,
    uint32_t number_of_live_nodes_in,
    uint32_t number_of_live_layout_objects_in,
    uint32_t number_of_live_resources_in,
    uint32_t number_of_live_context_lifecycle_state_observers_in,
    uint32_t number_of_live_frames_in,
    uint32_t number_of_live_v8_per_context_data_in,
    uint32_t number_of_worker_global_scopes_in,
    uint32_t number_of_live_ua_css_resources_in,
    uint32_t number_of_live_resource_fetchers_in)
    : number_of_live_audio_nodes(std::move(number_of_live_audio_nodes_in)),
      number_of_live_documents(std::move(number_of_live_documents_in)),
      number_of_live_nodes(std::move(number_of_live_nodes_in)),
      number_of_live_layout_objects(std::move(number_of_live_layout_objects_in)),
      number_of_live_resources(std::move(number_of_live_resources_in)),
      number_of_live_context_lifecycle_state_observers(std::move(number_of_live_context_lifecycle_state_observers_in)),
      number_of_live_frames(std::move(number_of_live_frames_in)),
      number_of_live_v8_per_context_data(std::move(number_of_live_v8_per_context_data_in)),
      number_of_worker_global_scopes(std::move(number_of_worker_global_scopes_in)),
      number_of_live_ua_css_resources(std::move(number_of_live_ua_css_resources_in)),
      number_of_live_resource_fetchers(std::move(number_of_live_resource_fetchers_in)) {}

LeakDetectionResult::~LeakDetectionResult() = default;
size_t LeakDetectionResult::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->number_of_live_audio_nodes);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_documents);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_nodes);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_layout_objects);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_resources);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_context_lifecycle_state_observers);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_frames);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_v8_per_context_data);
  seed = mojo::internal::WTFHash(seed, this->number_of_worker_global_scopes);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_ua_css_resources);
  seed = mojo::internal::WTFHash(seed, this->number_of_live_resource_fetchers);
  return seed;
}

void LeakDetectionResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_audio_nodes"), this->number_of_live_audio_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_documents"), this->number_of_live_documents,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_nodes"), this->number_of_live_nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_layout_objects"), this->number_of_live_layout_objects,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_resources"), this->number_of_live_resources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_context_lifecycle_state_observers"), this->number_of_live_context_lifecycle_state_observers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_frames"), this->number_of_live_frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_v8_per_context_data"), this->number_of_live_v8_per_context_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_worker_global_scopes"), this->number_of_worker_global_scopes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_ua_css_resources"), this->number_of_live_ua_css_resources,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "number_of_live_resource_fetchers"), this->number_of_live_resource_fetchers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool LeakDetectionResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

LeakDetector::IPCStableHashFunction LeakDetector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::LeakDetector>(message.name())) {
    case messages::LeakDetector::kPerformLeakDetection: {
      return &LeakDetector::PerformLeakDetection_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* LeakDetector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::LeakDetector>(message.name())) {
      case messages::LeakDetector::kPerformLeakDetection:
            return "Receive blink::mojom::LeakDetector::PerformLeakDetection";
    }
  } else {
    switch (static_cast<messages::LeakDetector>(message.name())) {
      case messages::LeakDetector::kPerformLeakDetection:
            return "Receive reply blink::mojom::LeakDetector::PerformLeakDetection";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t LeakDetector::PerformLeakDetection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x07bb694a;  // IPCStableHash for blink::mojom::LeakDetector::PerformLeakDetection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class LeakDetector_PerformLeakDetection_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  LeakDetector_PerformLeakDetection_ForwardToCallback(
      LeakDetector::PerformLeakDetectionCallback callback
      ) : callback_(std::move(callback)) {
  }

  LeakDetector_PerformLeakDetection_ForwardToCallback(const LeakDetector_PerformLeakDetection_ForwardToCallback&) = delete;
  LeakDetector_PerformLeakDetection_ForwardToCallback& operator=(const LeakDetector_PerformLeakDetection_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  LeakDetector::PerformLeakDetectionCallback callback_;
};

LeakDetectorProxy::LeakDetectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void LeakDetectorProxy::PerformLeakDetection(
    PerformLeakDetectionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::LeakDetector::PerformLeakDetection");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LeakDetector::kPerformLeakDetection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LeakDetector_PerformLeakDetection_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LeakDetector::Name_);
  message.set_method_name("PerformLeakDetection");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new LeakDetector_PerformLeakDetection_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class LeakDetector_PerformLeakDetection_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static LeakDetector::PerformLeakDetectionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<LeakDetector_PerformLeakDetection_ProxyToResponder> proxy(
        new LeakDetector_PerformLeakDetection_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&LeakDetector_PerformLeakDetection_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~LeakDetector_PerformLeakDetection_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  LeakDetector_PerformLeakDetection_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "LeakDetector::PerformLeakDetectionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      LeakDetectionResultPtr in_result);
};

bool LeakDetector_PerformLeakDetection_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::LeakDetector_PerformLeakDetection_ResponseParams_Data* params =
      reinterpret_cast<
          internal::LeakDetector_PerformLeakDetection_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for LeakDetector.0
  bool success = true;
  LeakDetectionResultPtr p_result{};
  LeakDetector_PerformLeakDetection_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        LeakDetector::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void LeakDetector_PerformLeakDetection_ProxyToResponder::Run(
    LeakDetectionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::LeakDetector::PerformLeakDetection", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type LeakDetectionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::LeakDetector::kPerformLeakDetection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::LeakDetector_PerformLeakDetection_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LeakDetectionResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(LeakDetector::Name_);
  message.set_method_name("PerformLeakDetection");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool LeakDetectorStubDispatch::Accept(
    LeakDetector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::LeakDetector>(message->header()->name)) {
    case messages::LeakDetector::kPerformLeakDetection: {
      break;
    }
  }
  return false;
}

// static
bool LeakDetectorStubDispatch::AcceptWithResponder(
    LeakDetector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::LeakDetector>(message->header()->name)) {
    case messages::LeakDetector::kPerformLeakDetection: {
      internal::LeakDetector_PerformLeakDetection_Params_Data* params =
          reinterpret_cast<
              internal::LeakDetector_PerformLeakDetection_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for LeakDetector.0
      bool success = true;
      LeakDetector_PerformLeakDetection_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            LeakDetector::Name_, 0, false);
        return false;
      }
      auto callback =
          LeakDetector_PerformLeakDetection_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformLeakDetection(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kLeakDetectorValidationInfo[] = {
    { &internal::LeakDetector_PerformLeakDetection_Params_Data::Validate,
     &internal::LeakDetector_PerformLeakDetection_ResponseParams_Data::Validate},
};

bool LeakDetectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::LeakDetector::Name_,
    kLeakDetectorValidationInfo);
}

bool LeakDetectorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::LeakDetector::Name_,
    kLeakDetectorValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::LeakDetectionResult::DataView, ::blink::mojom::blink::LeakDetectionResultPtr>::Read(
    ::blink::mojom::blink::LeakDetectionResult::DataView input,
    ::blink::mojom::blink::LeakDetectionResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::LeakDetectionResultPtr result(::blink::mojom::blink::LeakDetectionResult::New());
  
      if (success)
        result->number_of_live_audio_nodes = input.number_of_live_audio_nodes();
      if (success)
        result->number_of_live_documents = input.number_of_live_documents();
      if (success)
        result->number_of_live_nodes = input.number_of_live_nodes();
      if (success)
        result->number_of_live_layout_objects = input.number_of_live_layout_objects();
      if (success)
        result->number_of_live_resources = input.number_of_live_resources();
      if (success)
        result->number_of_live_context_lifecycle_state_observers = input.number_of_live_context_lifecycle_state_observers();
      if (success)
        result->number_of_live_frames = input.number_of_live_frames();
      if (success)
        result->number_of_live_v8_per_context_data = input.number_of_live_v8_per_context_data();
      if (success)
        result->number_of_worker_global_scopes = input.number_of_worker_global_scopes();
      if (success)
        result->number_of_live_ua_css_resources = input.number_of_live_ua_css_resources();
      if (success)
        result->number_of_live_resource_fetchers = input.number_of_live_resource_fetchers();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void LeakDetectorInterceptorForTesting::PerformLeakDetection(PerformLeakDetectionCallback callback) {
  GetForwardingInterface()->PerformLeakDetection(std::move(callback));
}
LeakDetectorAsyncWaiter::LeakDetectorAsyncWaiter(
    LeakDetector* proxy) : proxy_(proxy) {}

LeakDetectorAsyncWaiter::~LeakDetectorAsyncWaiter() = default;


void LeakDetectorAsyncWaiter::PerformLeakDetection(
    LeakDetectionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->PerformLeakDetection(
      base::BindOnce(
          [](base::RunLoop* loop,
             LeakDetectionResultPtr* out_result
,
             LeakDetectionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

LeakDetectionResultPtr LeakDetectorAsyncWaiter::PerformLeakDetection(
    ) {
  LeakDetectionResultPtr async_wait_result;
  PerformLeakDetection(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif