// third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const KeyboardLockRequestResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const KeyboardLockRequestResult = {
  
  kSuccess: 0,
  kFrameDetachedError: 1,
  kNoValidKeyCodesError: 2,
  kChildFrameError: 3,
  kRequestFailedError: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const GetKeyboardLayoutMapStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const GetKeyboardLayoutMapStatus = {
  
  kSuccess: 0,
  kFail: 1,
  kDenied: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class KeyboardLockServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.KeyboardLockService', scope);
  }
}

/** @interface */
export class KeyboardLockServiceInterface {
  
  /**
   * @param { !Array<!string> } keyCodes
   * @return {!Promise<{
        result: !KeyboardLockRequestResult,
   *  }>}
   */

  requestKeyboardLock(keyCodes) {}
  
  /**
   */

  cancelKeyboardLock() {}
  
  /**
   * @return {!Promise<{
        result: !GetKeyboardLayoutMapResult,
   *  }>}
   */

  getKeyboardLayoutMap() {}
}

/**
 * @implements { KeyboardLockServiceInterface }
 */
export class KeyboardLockServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!KeyboardLockServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          KeyboardLockServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!KeyboardLockServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!string> } keyCodes
   * @return {!Promise<{
        result: !KeyboardLockRequestResult,
   *  }>}
   */

  requestKeyboardLock(
      keyCodes) {
    return this.proxy.sendMessage(
        0,
        KeyboardLockService_RequestKeyboardLock_ParamsSpec.$,
        KeyboardLockService_RequestKeyboardLock_ResponseParamsSpec.$,
        [
          keyCodes
        ],
        false);
  }

  
  /**
   */

  cancelKeyboardLock() {
    this.proxy.sendMessage(
        1,
        KeyboardLockService_CancelKeyboardLock_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        result: !GetKeyboardLayoutMapResult,
   *  }>}
   */

  getKeyboardLayoutMap() {
    return this.proxy.sendMessage(
        2,
        KeyboardLockService_GetKeyboardLayoutMap_ParamsSpec.$,
        KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the KeyboardLockService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeyboardLockServiceReceiver {
  /**
   * @param {!KeyboardLockServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!KeyboardLockServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        KeyboardLockServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeyboardLockServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        KeyboardLockService_RequestKeyboardLock_ParamsSpec.$,
        KeyboardLockService_RequestKeyboardLock_ResponseParamsSpec.$,
        impl.requestKeyboardLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        KeyboardLockService_CancelKeyboardLock_ParamsSpec.$,
        null,
        impl.cancelKeyboardLock.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        KeyboardLockService_GetKeyboardLayoutMap_ParamsSpec.$,
        KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsSpec.$,
        impl.getKeyboardLayoutMap.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class KeyboardLockService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.KeyboardLockService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!KeyboardLockServiceRemote}
   */
  static getRemote() {
    let remote = new KeyboardLockServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the KeyboardLockService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeyboardLockServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      KeyboardLockServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeyboardLockServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestKeyboardLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        KeyboardLockService_RequestKeyboardLock_ParamsSpec.$,
        KeyboardLockService_RequestKeyboardLock_ResponseParamsSpec.$,
        this.requestKeyboardLock.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelKeyboardLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        KeyboardLockService_CancelKeyboardLock_ParamsSpec.$,
        null,
        this.cancelKeyboardLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getKeyboardLayoutMap =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        KeyboardLockService_GetKeyboardLayoutMap_ParamsSpec.$,
        KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsSpec.$,
        this.getKeyboardLayoutMap.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const GetKeyboardLayoutMapResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeyboardLockService_RequestKeyboardLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeyboardLockService_RequestKeyboardLock_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeyboardLockService_CancelKeyboardLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeyboardLockService_GetKeyboardLayoutMap_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    GetKeyboardLayoutMapResultSpec.$,
    'GetKeyboardLayoutMapResult',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        GetKeyboardLayoutMapStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'layoutMap', 8,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class GetKeyboardLayoutMapResult {
  constructor() {
    /** @type { !GetKeyboardLayoutMapStatus } */
    this.status;
    /** @type { !Object<!string, !string> } */
    this.layoutMap;
  }
}



mojo.internal.Struct(
    KeyboardLockService_RequestKeyboardLock_ParamsSpec.$,
    'KeyboardLockService_RequestKeyboardLock_Params',
    [
      mojo.internal.StructField(
        'keyCodes', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class KeyboardLockService_RequestKeyboardLock_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.keyCodes;
  }
}



mojo.internal.Struct(
    KeyboardLockService_RequestKeyboardLock_ResponseParamsSpec.$,
    'KeyboardLockService_RequestKeyboardLock_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        KeyboardLockRequestResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class KeyboardLockService_RequestKeyboardLock_ResponseParams {
  constructor() {
    /** @type { !KeyboardLockRequestResult } */
    this.result;
  }
}



mojo.internal.Struct(
    KeyboardLockService_CancelKeyboardLock_ParamsSpec.$,
    'KeyboardLockService_CancelKeyboardLock_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class KeyboardLockService_CancelKeyboardLock_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    KeyboardLockService_GetKeyboardLayoutMap_ParamsSpec.$,
    'KeyboardLockService_GetKeyboardLayoutMap_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class KeyboardLockService_GetKeyboardLayoutMap_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsSpec.$,
    'KeyboardLockService_GetKeyboardLayoutMap_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        GetKeyboardLayoutMapResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class KeyboardLockService_GetKeyboardLayoutMap_ResponseParams {
  constructor() {
    /** @type { !GetKeyboardLayoutMapResult } */
    this.result;
  }
}

