// third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-params-data.h"
#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/keyboard_lock/keyboard_lock.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
GetKeyboardLayoutMapResult::GetKeyboardLayoutMapResult()
    : status(),
      layout_map() {}

GetKeyboardLayoutMapResult::GetKeyboardLayoutMapResult(
    GetKeyboardLayoutMapStatus status_in,
    const ::blink::HashMap<::blink::String, ::blink::String>& layout_map_in)
    : status(std::move(status_in)),
      layout_map(std::move(layout_map_in)) {}

GetKeyboardLayoutMapResult::~GetKeyboardLayoutMapResult() = default;

void GetKeyboardLayoutMapResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type GetKeyboardLayoutMapStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout_map"), this->layout_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::HashMap<::blink::String, ::blink::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetKeyboardLayoutMapResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

KeyboardLockService::IPCStableHashFunction KeyboardLockService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::KeyboardLockService>(message.name())) {
    case messages::KeyboardLockService::kRequestKeyboardLock: {
      return &KeyboardLockService::RequestKeyboardLock_Sym::IPCStableHash;
    }
    case messages::KeyboardLockService::kCancelKeyboardLock: {
      return &KeyboardLockService::CancelKeyboardLock_Sym::IPCStableHash;
    }
    case messages::KeyboardLockService::kGetKeyboardLayoutMap: {
      return &KeyboardLockService::GetKeyboardLayoutMap_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* KeyboardLockService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::KeyboardLockService>(message.name())) {
      case messages::KeyboardLockService::kRequestKeyboardLock:
            return "Receive blink::mojom::KeyboardLockService::RequestKeyboardLock";
      case messages::KeyboardLockService::kCancelKeyboardLock:
            return "Receive blink::mojom::KeyboardLockService::CancelKeyboardLock";
      case messages::KeyboardLockService::kGetKeyboardLayoutMap:
            return "Receive blink::mojom::KeyboardLockService::GetKeyboardLayoutMap";
    }
  } else {
    switch (static_cast<messages::KeyboardLockService>(message.name())) {
      case messages::KeyboardLockService::kRequestKeyboardLock:
            return "Receive reply blink::mojom::KeyboardLockService::RequestKeyboardLock";
      case messages::KeyboardLockService::kCancelKeyboardLock:
            return "Receive reply blink::mojom::KeyboardLockService::CancelKeyboardLock";
      case messages::KeyboardLockService::kGetKeyboardLayoutMap:
            return "Receive reply blink::mojom::KeyboardLockService::GetKeyboardLayoutMap";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t KeyboardLockService::RequestKeyboardLock_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95b86b71;  // IPCStableHash for blink::mojom::KeyboardLockService::RequestKeyboardLock
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t KeyboardLockService::CancelKeyboardLock_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x079c6c7c;  // IPCStableHash for blink::mojom::KeyboardLockService::CancelKeyboardLock
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t KeyboardLockService::GetKeyboardLayoutMap_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x08d125f0;  // IPCStableHash for blink::mojom::KeyboardLockService::GetKeyboardLayoutMap
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class KeyboardLockService_RequestKeyboardLock_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  KeyboardLockService_RequestKeyboardLock_ForwardToCallback(
      KeyboardLockService::RequestKeyboardLockCallback callback
      ) : callback_(std::move(callback)) {
  }

  KeyboardLockService_RequestKeyboardLock_ForwardToCallback(const KeyboardLockService_RequestKeyboardLock_ForwardToCallback&) = delete;
  KeyboardLockService_RequestKeyboardLock_ForwardToCallback& operator=(const KeyboardLockService_RequestKeyboardLock_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  KeyboardLockService::RequestKeyboardLockCallback callback_;
};

class KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback(
      KeyboardLockService::GetKeyboardLayoutMapCallback callback
      ) : callback_(std::move(callback)) {
  }

  KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback(const KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback&) = delete;
  KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback& operator=(const KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  KeyboardLockService::GetKeyboardLayoutMapCallback callback_;
};

KeyboardLockServiceProxy::KeyboardLockServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void KeyboardLockServiceProxy::RequestKeyboardLock(
    const ::blink::Vector<::blink::String>& in_key_codes, RequestKeyboardLockCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::KeyboardLockService::RequestKeyboardLock", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("key_codes"), in_key_codes,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::KeyboardLockService::kRequestKeyboardLock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::KeyboardLockService_RequestKeyboardLock_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->key_codes)::BaseType>
      key_codes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& key_codes_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_key_codes,
    key_codes_fragment,
    &key_codes_validate_params);

  params->key_codes.Set(
      key_codes_fragment.is_null() ? nullptr : key_codes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->key_codes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null key_codes in KeyboardLockService.RequestKeyboardLock request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeyboardLockService::Name_);
  message.set_method_name("RequestKeyboardLock");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new KeyboardLockService_RequestKeyboardLock_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void KeyboardLockServiceProxy::CancelKeyboardLock(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::KeyboardLockService::CancelKeyboardLock");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::KeyboardLockService::kCancelKeyboardLock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::KeyboardLockService_CancelKeyboardLock_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeyboardLockService::Name_);
  message.set_method_name("CancelKeyboardLock");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void KeyboardLockServiceProxy::GetKeyboardLayoutMap(
    GetKeyboardLayoutMapCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::KeyboardLockService::GetKeyboardLayoutMap");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::KeyboardLockService::kGetKeyboardLayoutMap), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::KeyboardLockService_GetKeyboardLayoutMap_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeyboardLockService::Name_);
  message.set_method_name("GetKeyboardLayoutMap");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class KeyboardLockService_RequestKeyboardLock_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static KeyboardLockService::RequestKeyboardLockCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<KeyboardLockService_RequestKeyboardLock_ProxyToResponder> proxy(
        new KeyboardLockService_RequestKeyboardLock_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&KeyboardLockService_RequestKeyboardLock_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~KeyboardLockService_RequestKeyboardLock_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  KeyboardLockService_RequestKeyboardLock_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "KeyboardLockService::RequestKeyboardLockCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      KeyboardLockRequestResult in_result);
};

bool KeyboardLockService_RequestKeyboardLock_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::KeyboardLockService_RequestKeyboardLock_ResponseParams_Data* params =
      reinterpret_cast<
          internal::KeyboardLockService_RequestKeyboardLock_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for KeyboardLockService.0
  bool success = true;
  KeyboardLockRequestResult p_result{};
  KeyboardLockService_RequestKeyboardLock_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        KeyboardLockService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void KeyboardLockService_RequestKeyboardLock_ProxyToResponder::Run(
    KeyboardLockRequestResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::KeyboardLockService::RequestKeyboardLock", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type KeyboardLockRequestResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::KeyboardLockService::kRequestKeyboardLock), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::KeyboardLockService_RequestKeyboardLock_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::KeyboardLockRequestResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeyboardLockService::Name_);
  message.set_method_name("RequestKeyboardLock");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static KeyboardLockService::GetKeyboardLayoutMapCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder> proxy(
        new KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "KeyboardLockService::GetKeyboardLayoutMapCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetKeyboardLayoutMapResultPtr in_result);
};

bool KeyboardLockService_GetKeyboardLayoutMap_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data* params =
      reinterpret_cast<
          internal::KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for KeyboardLockService.2
  bool success = true;
  GetKeyboardLayoutMapResultPtr p_result{};
  KeyboardLockService_GetKeyboardLayoutMap_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        KeyboardLockService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder::Run(
    GetKeyboardLayoutMapResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::KeyboardLockService::GetKeyboardLayoutMap", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type GetKeyboardLayoutMapResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::KeyboardLockService::kGetKeyboardLayoutMap), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::GetKeyboardLayoutMapResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(KeyboardLockService::Name_);
  message.set_method_name("GetKeyboardLayoutMap");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool KeyboardLockServiceStubDispatch::Accept(
    KeyboardLockService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::KeyboardLockService>(message->header()->name)) {
    case messages::KeyboardLockService::kRequestKeyboardLock: {
      break;
    }
    case messages::KeyboardLockService::kCancelKeyboardLock: {
      DCHECK(message->is_serialized());
      internal::KeyboardLockService_CancelKeyboardLock_Params_Data* params =
          reinterpret_cast<internal::KeyboardLockService_CancelKeyboardLock_Params_Data*>(
              message->mutable_payload());
      

      // Validation for KeyboardLockService.1
      bool success = true;
      KeyboardLockService_CancelKeyboardLock_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            KeyboardLockService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelKeyboardLock(        );
      return true;
    }
    case messages::KeyboardLockService::kGetKeyboardLayoutMap: {
      break;
    }
  }
  return false;
}

// static
bool KeyboardLockServiceStubDispatch::AcceptWithResponder(
    KeyboardLockService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::KeyboardLockService>(message->header()->name)) {
    case messages::KeyboardLockService::kRequestKeyboardLock: {
      internal::KeyboardLockService_RequestKeyboardLock_Params_Data* params =
          reinterpret_cast<
              internal::KeyboardLockService_RequestKeyboardLock_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for KeyboardLockService.0
      bool success = true;
      ::blink::Vector<::blink::String> p_key_codes{};
      KeyboardLockService_RequestKeyboardLock_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadKeyCodes(&p_key_codes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            KeyboardLockService::Name_, 0, false);
        return false;
      }
      auto callback =
          KeyboardLockService_RequestKeyboardLock_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RequestKeyboardLock(        
        std::move(p_key_codes), std::move(callback));
      return true;
    }
    case messages::KeyboardLockService::kCancelKeyboardLock: {
      break;
    }
    case messages::KeyboardLockService::kGetKeyboardLayoutMap: {
      internal::KeyboardLockService_GetKeyboardLayoutMap_Params_Data* params =
          reinterpret_cast<
              internal::KeyboardLockService_GetKeyboardLayoutMap_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for KeyboardLockService.2
      bool success = true;
      KeyboardLockService_GetKeyboardLayoutMap_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            KeyboardLockService::Name_, 2, false);
        return false;
      }
      auto callback =
          KeyboardLockService_GetKeyboardLayoutMap_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetKeyboardLayoutMap(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kKeyboardLockServiceValidationInfo[] = {
    { &internal::KeyboardLockService_RequestKeyboardLock_Params_Data::Validate,
     &internal::KeyboardLockService_RequestKeyboardLock_ResponseParams_Data::Validate},
    { &internal::KeyboardLockService_CancelKeyboardLock_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::KeyboardLockService_GetKeyboardLayoutMap_Params_Data::Validate,
     &internal::KeyboardLockService_GetKeyboardLayoutMap_ResponseParams_Data::Validate},
};

bool KeyboardLockServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::KeyboardLockService::Name_,
    kKeyboardLockServiceValidationInfo);
}

bool KeyboardLockServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::KeyboardLockService::Name_,
    kKeyboardLockServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::GetKeyboardLayoutMapResult::DataView, ::blink::mojom::blink::GetKeyboardLayoutMapResultPtr>::Read(
    ::blink::mojom::blink::GetKeyboardLayoutMapResult::DataView input,
    ::blink::mojom::blink::GetKeyboardLayoutMapResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::GetKeyboardLayoutMapResultPtr result(::blink::mojom::blink::GetKeyboardLayoutMapResult::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadLayoutMap(&result->layout_map))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void KeyboardLockServiceInterceptorForTesting::RequestKeyboardLock(const ::blink::Vector<::blink::String>& key_codes, RequestKeyboardLockCallback callback) {
  GetForwardingInterface()->RequestKeyboardLock(
    std::move(key_codes)
    , std::move(callback));
}
void KeyboardLockServiceInterceptorForTesting::CancelKeyboardLock() {
  GetForwardingInterface()->CancelKeyboardLock();
}
void KeyboardLockServiceInterceptorForTesting::GetKeyboardLayoutMap(GetKeyboardLayoutMapCallback callback) {
  GetForwardingInterface()->GetKeyboardLayoutMap(std::move(callback));
}
KeyboardLockServiceAsyncWaiter::KeyboardLockServiceAsyncWaiter(
    KeyboardLockService* proxy) : proxy_(proxy) {}

KeyboardLockServiceAsyncWaiter::~KeyboardLockServiceAsyncWaiter() = default;


void KeyboardLockServiceAsyncWaiter::RequestKeyboardLock(
    const ::blink::Vector<::blink::String>& key_codes, KeyboardLockRequestResult* out_result) {
  base::RunLoop loop;
  proxy_->RequestKeyboardLock(
      std::move(key_codes),
      base::BindOnce(
          [](base::RunLoop* loop,
             KeyboardLockRequestResult* out_result
,
             KeyboardLockRequestResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

KeyboardLockRequestResult KeyboardLockServiceAsyncWaiter::RequestKeyboardLock(
    const ::blink::Vector<::blink::String>& key_codes) {
  KeyboardLockRequestResult async_wait_result;
  RequestKeyboardLock(std::move(key_codes),&async_wait_result);
  return async_wait_result;
}

void KeyboardLockServiceAsyncWaiter::GetKeyboardLayoutMap(
    GetKeyboardLayoutMapResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->GetKeyboardLayoutMap(
      base::BindOnce(
          [](base::RunLoop* loop,
             GetKeyboardLayoutMapResultPtr* out_result
,
             GetKeyboardLayoutMapResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

GetKeyboardLayoutMapResultPtr KeyboardLockServiceAsyncWaiter::GetKeyboardLayoutMap(
    ) {
  GetKeyboardLayoutMapResultPtr async_wait_result;
  GetKeyboardLayoutMap(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif