// third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* InterestGroup_ExecutionModeToStringHelper(InterestGroup_ExecutionMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InterestGroup_ExecutionMode::kCompatibilityMode:
      return "kCompatibilityMode";
    case InterestGroup_ExecutionMode::kGroupedByOriginMode:
      return "kGroupedByOriginMode";
    case InterestGroup_ExecutionMode::kFrozenContext:
      return "kFrozenContext";
    default:
      return nullptr;
  }
}

std::string InterestGroup_ExecutionModeToString(InterestGroup_ExecutionMode value) {
  const char *str = InterestGroup_ExecutionModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InterestGroup_ExecutionMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InterestGroup_ExecutionMode value) {
  return os << InterestGroup_ExecutionModeToString(value);
}

NOINLINE static const char* InterestGroup_TrustedBiddingSignalsSlotSizeModeToStringHelper(InterestGroup_TrustedBiddingSignalsSlotSizeMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case InterestGroup_TrustedBiddingSignalsSlotSizeMode::kNone:
      return "kNone";
    case InterestGroup_TrustedBiddingSignalsSlotSizeMode::kSlotSize:
      return "kSlotSize";
    case InterestGroup_TrustedBiddingSignalsSlotSizeMode::kAllSlotsRequestedSizes:
      return "kAllSlotsRequestedSizes";
    default:
      return nullptr;
  }
}

std::string InterestGroup_TrustedBiddingSignalsSlotSizeModeToString(InterestGroup_TrustedBiddingSignalsSlotSizeMode value) {
  const char *str = InterestGroup_TrustedBiddingSignalsSlotSizeModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown InterestGroup_TrustedBiddingSignalsSlotSizeMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, InterestGroup_TrustedBiddingSignalsSlotSizeMode value) {
  return os << InterestGroup_TrustedBiddingSignalsSlotSizeModeToString(value);
}

NOINLINE static const char* AuctionAdConfigNonSharedParams_BuyerReportTypeToStringHelper(AuctionAdConfigNonSharedParams_BuyerReportType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AuctionAdConfigNonSharedParams_BuyerReportType::kInterestGroupCount:
      return "kInterestGroupCount";
    case AuctionAdConfigNonSharedParams_BuyerReportType::kBidCount:
      return "kBidCount";
    case AuctionAdConfigNonSharedParams_BuyerReportType::kTotalGenerateBidLatency:
      return "kTotalGenerateBidLatency";
    case AuctionAdConfigNonSharedParams_BuyerReportType::kTotalSignalsFetchLatency:
      return "kTotalSignalsFetchLatency";
    default:
      return nullptr;
  }
}

std::string AuctionAdConfigNonSharedParams_BuyerReportTypeToString(AuctionAdConfigNonSharedParams_BuyerReportType value) {
  const char *str = AuctionAdConfigNonSharedParams_BuyerReportTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AuctionAdConfigNonSharedParams_BuyerReportType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AuctionAdConfigNonSharedParams_BuyerReportType value) {
  return os << AuctionAdConfigNonSharedParams_BuyerReportTypeToString(value);
}

NOINLINE static const char* AuctionAdConfigNonSharedParams_RealTimeReportingTypeToStringHelper(AuctionAdConfigNonSharedParams_RealTimeReportingType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AuctionAdConfigNonSharedParams_RealTimeReportingType::kDefaultLocalReporting:
      return "kDefaultLocalReporting";
    default:
      return nullptr;
  }
}

std::string AuctionAdConfigNonSharedParams_RealTimeReportingTypeToString(AuctionAdConfigNonSharedParams_RealTimeReportingType value) {
  const char *str = AuctionAdConfigNonSharedParams_RealTimeReportingTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AuctionAdConfigNonSharedParams_RealTimeReportingType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AuctionAdConfigNonSharedParams_RealTimeReportingType value) {
  return os << AuctionAdConfigNonSharedParams_RealTimeReportingTypeToString(value);
}

namespace internal {
// static
bool AuctionAdConfigMaybePromiseJson_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AuctionAdConfigMaybePromiseJson_Data* object = static_cast<const AuctionAdConfigMaybePromiseJson_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AuctionAdConfigMaybePromiseJson_Tag::kPromise: {

      return true;
    }
    case AuctionAdConfigMaybePromiseJson_Tag::kValue: {

      constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_value, validation_context,
                                             &value_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AuctionAdConfigMaybePromiseJson");
      return false;
    }
  }
}
// static
bool AuctionAdConfigMaybePromisePerBuyerSignals_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AuctionAdConfigMaybePromisePerBuyerSignals_Data* object = static_cast<const AuctionAdConfigMaybePromisePerBuyerSignals_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AuctionAdConfigMaybePromisePerBuyerSignals_Tag::kPromise: {

      return true;
    }
    case AuctionAdConfigMaybePromisePerBuyerSignals_Tag::kValue: {

      constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
      if (!mojo::internal::ValidateContainer(object->data.f_value, validation_context,
                                             &value_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AuctionAdConfigMaybePromisePerBuyerSignals");
      return false;
    }
  }
}
// static
bool AuctionAdConfigMaybePromiseBuyerTimeouts_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AuctionAdConfigMaybePromiseBuyerTimeouts_Data* object = static_cast<const AuctionAdConfigMaybePromiseBuyerTimeouts_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AuctionAdConfigMaybePromiseBuyerTimeouts_Tag::kPromise: {

      return true;
    }
    case AuctionAdConfigMaybePromiseBuyerTimeouts_Tag::kValue: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_value, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_value, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AuctionAdConfigMaybePromiseBuyerTimeouts");
      return false;
    }
  }
}
// static
bool AuctionAdConfigMaybePromiseBuyerCurrencies_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AuctionAdConfigMaybePromiseBuyerCurrencies_Data* object = static_cast<const AuctionAdConfigMaybePromiseBuyerCurrencies_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AuctionAdConfigMaybePromiseBuyerCurrencies_Tag::kPromise: {

      return true;
    }
    case AuctionAdConfigMaybePromiseBuyerCurrencies_Tag::kValue: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_value, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_value, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AuctionAdConfigMaybePromiseBuyerCurrencies");
      return false;
    }
  }
}
// static
bool AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data* object = static_cast<const AuctionAdConfigMaybePromiseDirectFromSellerSignals_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AuctionAdConfigMaybePromiseDirectFromSellerSignals_Tag::kPromise: {

      return true;
    }
    case AuctionAdConfigMaybePromiseDirectFromSellerSignals_Tag::kValue: {

      if (!mojo::internal::ValidateStruct(object->data.f_value, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AuctionAdConfigMaybePromiseDirectFromSellerSignals");
      return false;
    }
  }
}
// static
bool AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data* object = static_cast<const AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Tag::kPromise: {

      return true;
    }
    case AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements_Tag::kValue: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_value, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_value, validation_context,
                                             &value_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AuctionAdConfigMaybePromiseDeprecatedRenderURLReplacements");
      return false;
    }
  }
}
// static
bool AdAuctionRequestOrError_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const AdAuctionRequestOrError_Data* object = static_cast<const AdAuctionRequestOrError_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case AdAuctionRequestOrError_Tag::kRequest: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_request, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateNonInlinedUnion(object->data.f_request,
                                                   validation_context))
        return false;
      return true;
    }
    case AdAuctionRequestOrError_Tag::kError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& error_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_error, validation_context,
                                             &error_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in AdAuctionRequestOrError");
      return false;
    }
  }
}


// static
bool InterestGroupAd_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InterestGroupAd_Data* object =
      static_cast<const InterestGroupAd_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->render_url, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& render_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->render_url, validation_context,
                                         &render_url_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& size_group_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->size_group, validation_context,
                                         &size_group_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& buyer_reporting_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->buyer_reporting_id, validation_context,
                                         &buyer_reporting_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& buyer_and_seller_reporting_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->buyer_and_seller_reporting_id, validation_context,
                                         &buyer_and_seller_reporting_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& selectable_buyer_and_seller_reporting_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->selectable_buyer_and_seller_reporting_ids, validation_context,
                                         &selectable_buyer_and_seller_reporting_ids_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& metadata_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->metadata, validation_context,
                                         &metadata_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& ad_render_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ad_render_id, validation_context,
                                         &ad_render_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& allowed_reporting_origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->allowed_reporting_origins, validation_context,
                                         &allowed_reporting_origins_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& creative_scanning_metadata_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->creative_scanning_metadata, validation_context,
                                         &creative_scanning_metadata_validate_params)) {
    return false;
  }

  return true;
}

InterestGroupAd_Data::InterestGroupAd_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SellerCapabilities_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SellerCapabilities_Data* object =
      static_cast<const SellerCapabilities_Data*>(data);

  return true;
}

SellerCapabilities_Data::SellerCapabilities_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionServerRequestFlags_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionServerRequestFlags_Data* object =
      static_cast<const AuctionServerRequestFlags_Data*>(data);

  return true;
}

AuctionServerRequestFlags_Data::AuctionServerRequestFlags_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdKeywordReplacement_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdKeywordReplacement_Data* object =
      static_cast<const AdKeywordReplacement_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->match, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& match_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->match, validation_context,
                                         &match_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->replacement, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& replacement_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->replacement, validation_context,
                                         &replacement_validate_params)) {
    return false;
  }

  return true;
}

AdKeywordReplacement_Data::AdKeywordReplacement_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool InterestGroup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 208, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const InterestGroup_Data* object =
      static_cast<const InterestGroup_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiry, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expiry, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->owner, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->owner, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& priority_vector_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->priority_vector, validation_context,
                                         &priority_vector_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& priority_signals_overrides_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->priority_signals_overrides, validation_context,
                                         &priority_signals_overrides_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& seller_capabilities_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->seller_capabilities, validation_context,
                                         &seller_capabilities_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_sellers_capabilities, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->all_sellers_capabilities, validation_context))
    return false;


  if (!::blink::mojom::internal::InterestGroup_ExecutionMode_Data
        ::Validate(object->execution_mode, validation_context))
    return false;


  if (!::blink::mojom::internal::InterestGroup_TrustedBiddingSignalsSlotSizeMode_Data
        ::Validate(object->trusted_bidding_signals_slot_size_mode, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bidding_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->bidding_wasm_helper_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->update_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trusted_bidding_signals_url, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& trusted_bidding_signals_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->trusted_bidding_signals_keys, validation_context,
                                         &trusted_bidding_signals_keys_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->trusted_bidding_signals_coordinator, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& view_and_click_counts_providers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->view_and_click_counts_providers, validation_context,
                                         &view_and_click_counts_providers_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& user_bidding_signals_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_bidding_signals, validation_context,
                                         &user_bidding_signals_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& ads_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ads, validation_context,
                                         &ads_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& ad_components_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ad_components, validation_context,
                                         &ad_components_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& ad_sizes_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->ad_sizes, validation_context,
                                         &ad_sizes_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& size_groups_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
  if (!mojo::internal::ValidateContainer(object->size_groups, validation_context,
                                         &size_groups_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->auction_server_request_flags, 25, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->auction_server_request_flags, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& additional_bid_key_validate_params =
      mojo::internal::GetArrayValidator<32, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->additional_bid_key, validation_context,
                                         &additional_bid_key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->aggregation_coordinator_origin, validation_context))
    return false;

  return true;
}

InterestGroup_Data::InterestGroup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PreviousWin_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PreviousWin_Data* object =
      static_cast<const PreviousWin_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ad_json, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ad_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ad_json, validation_context,
                                         &ad_json_validate_params)) {
    return false;
  }

  return true;
}

PreviousWin_Data::PreviousWin_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ViewOrClickCounts_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ViewOrClickCounts_Data* object =
      static_cast<const ViewOrClickCounts_Data*>(data);

  return true;
}

ViewOrClickCounts_Data::ViewOrClickCounts_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ViewAndClickCounts_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ViewAndClickCounts_Data* object =
      static_cast<const ViewAndClickCounts_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->view_counts, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->view_counts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->click_counts, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->click_counts, validation_context))
    return false;

  return true;
}

ViewAndClickCounts_Data::ViewAndClickCounts_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BiddingBrowserSignals_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BiddingBrowserSignals_Data* object =
      static_cast<const BiddingBrowserSignals_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prev_wins, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& prev_wins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prev_wins, validation_context,
                                         &prev_wins_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->view_and_click_counts, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->view_and_click_counts, validation_context))
    return false;

  return true;
}

BiddingBrowserSignals_Data::BiddingBrowserSignals_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool StorageInterestGroup_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const StorageInterestGroup_Data* object =
      static_cast<const StorageInterestGroup_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->interest_group, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->interest_group, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bidding_browser_signals, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bidding_browser_signals, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->joining_origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->joining_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->join_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->join_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_updated, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_updated, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->next_update_after, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->next_update_after, validation_context))
    return false;

  return true;
}

StorageInterestGroup_Data::StorageInterestGroup_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectFromSellerSignalsSubresource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectFromSellerSignalsSubresource_Data* object =
      static_cast<const DirectFromSellerSignalsSubresource_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bundle_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bundle_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->token, validation_context))
    return false;

  return true;
}

DirectFromSellerSignalsSubresource_Data::DirectFromSellerSignalsSubresource_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DirectFromSellerSignals_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DirectFromSellerSignals_Data* object =
      static_cast<const DirectFromSellerSignals_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prefix, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->prefix, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->per_buyer_signals, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& per_buyer_signals_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_signals, validation_context,
                                         &per_buyer_signals_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->seller_signals, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->auction_signals, validation_context))
    return false;

  return true;
}

DirectFromSellerSignals_Data::DirectFromSellerSignals_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionAdConfigBuyerTimeouts_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionAdConfigBuyerTimeouts_Data* object =
      static_cast<const AuctionAdConfigBuyerTimeouts_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->all_buyers_timeout, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& per_buyer_timeouts_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_timeouts, validation_context,
                                         &per_buyer_timeouts_validate_params)) {
    return false;
  }

  return true;
}

AuctionAdConfigBuyerTimeouts_Data::AuctionAdConfigBuyerTimeouts_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdCurrency_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdCurrency_Data* object =
      static_cast<const AdCurrency_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->currency_code, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& currency_code_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->currency_code, validation_context,
                                         &currency_code_validate_params)) {
    return false;
  }

  return true;
}

AdCurrency_Data::AdCurrency_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionAdConfigBuyerCurrencies_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionAdConfigBuyerCurrencies_Data* object =
      static_cast<const AuctionAdConfigBuyerCurrencies_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->all_buyers_currency, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& per_buyer_currencies_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_currencies, validation_context,
                                         &per_buyer_currencies_validate_params)) {
    return false;
  }

  return true;
}

AuctionAdConfigBuyerCurrencies_Data::AuctionAdConfigBuyerCurrencies_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionAdServerResponseConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionAdServerResponseConfig_Data* object =
      static_cast<const AuctionAdServerResponseConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_id, validation_context))
    return false;

  return true;
}

AuctionAdServerResponseConfig_Data::AuctionAdServerResponseConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionReportBuyerDebugModeConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionReportBuyerDebugModeConfig_Data* object =
      static_cast<const AuctionReportBuyerDebugModeConfig_Data*>(data);

  return true;
}

AuctionReportBuyerDebugModeConfig_Data::AuctionReportBuyerDebugModeConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionReportBuyersConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionReportBuyersConfig_Data* object =
      static_cast<const AuctionReportBuyersConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bucket, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bucket, validation_context))
    return false;

  return true;
}

AuctionReportBuyersConfig_Data::AuctionReportBuyersConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionAdConfigNonSharedParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 312, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionAdConfigNonSharedParams_Data* object =
      static_cast<const AuctionAdConfigNonSharedParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& interest_group_buyers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->interest_group_buyers, validation_context,
                                         &interest_group_buyers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->auction_signals, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->auction_signals, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->seller_signals, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->seller_signals, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->seller_tkv_signals, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->seller_tkv_signals, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->seller_timeout, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->per_buyer_signals, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->per_buyer_signals, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->per_buyer_tkv_signals, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& per_buyer_tkv_signals_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_tkv_signals, validation_context,
                                         &per_buyer_tkv_signals_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->buyer_timeouts, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->buyer_timeouts, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->reporting_timeout, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->seller_currency, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->buyer_currencies, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->buyer_currencies, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->buyer_cumulative_timeouts, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->buyer_cumulative_timeouts, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->per_buyer_group_limits, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& per_buyer_group_limits_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_group_limits, validation_context,
                                         &per_buyer_group_limits_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& per_buyer_priority_signals_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_priority_signals, validation_context,
                                         &per_buyer_priority_signals_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& all_buyers_priority_signals_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->all_buyers_priority_signals, validation_context,
                                         &all_buyers_priority_signals_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& auction_report_buyer_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->auction_report_buyer_keys, validation_context,
                                         &auction_report_buyer_keys_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& auction_report_buyers_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AuctionAdConfigNonSharedParams_BuyerReportType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->auction_report_buyers, validation_context,
                                         &auction_report_buyers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->auction_report_buyer_debug_mode_config, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->required_seller_capabilities, 20, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->required_seller_capabilities, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->requested_size, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& all_slots_requested_sizes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->all_slots_requested_sizes, validation_context,
                                         &all_slots_requested_sizes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->per_buyer_multi_bid_limits, 23, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& per_buyer_multi_bid_limits_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_multi_bid_limits, validation_context,
                                         &per_buyer_multi_bid_limits_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->auction_nonce, validation_context))
    return false;


  if (!::blink::mojom::internal::AuctionAdConfigNonSharedParams_RealTimeReportingType_Data
        ::Validate(object->seller_real_time_reporting_type_$value, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& per_buyer_real_time_reporting_types_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::AuctionAdConfigNonSharedParams_RealTimeReportingType_Data::Validate>()>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_real_time_reporting_types, validation_context,
                                         &per_buyer_real_time_reporting_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->component_auctions, 29, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& component_auctions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->component_auctions, validation_context,
                                         &component_auctions_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->deprecated_render_url_replacements, 30, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->deprecated_render_url_replacements, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trusted_scoring_signals_coordinator, validation_context))
    return false;


  if (!::blink::mojom::internal::InterestGroup_ExecutionMode_Data
        ::Validate(object->execution_mode, validation_context))
    return false;

  return true;
}

AuctionAdConfigNonSharedParams_Data::AuctionAdConfigNonSharedParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionAdConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionAdConfig_Data* object =
      static_cast<const AuctionAdConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seller, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seller, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->server_response, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->decision_logic_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trusted_scoring_signals_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->auction_ad_config_non_shared_params, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->auction_ad_config_non_shared_params, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->direct_from_seller_signals, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->direct_from_seller_signals, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->per_buyer_experiment_group_ids, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& per_buyer_experiment_group_ids_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_experiment_group_ids, validation_context,
                                         &per_buyer_experiment_group_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->aggregation_coordinator_origin, validation_context))
    return false;

  return true;
}

AuctionAdConfig_Data::AuctionAdConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionDataBuyerConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionDataBuyerConfig_Data* object =
      static_cast<const AuctionDataBuyerConfig_Data*>(data);

  return true;
}

AuctionDataBuyerConfig_Data::AuctionDataBuyerConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AuctionDataConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AuctionDataConfig_Data* object =
      static_cast<const AuctionDataConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->per_buyer_configs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& per_buyer_configs_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->per_buyer_configs, validation_context,
                                         &per_buyer_configs_validate_params)) {
    return false;
  }

  return true;
}

AuctionDataConfig_Data::AuctionDataConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool AdAuctionPerSellerRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AdAuctionPerSellerRequest_Data* object =
      static_cast<const AdAuctionPerSellerRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seller, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seller, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

AdAuctionPerSellerRequest_Data::AdAuctionPerSellerRequest_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::InterestGroup_ExecutionMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::InterestGroup_ExecutionMode value) {
  return std::move(context).WriteString(::blink::mojom::InterestGroup_ExecutionModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeMode value) {
  return std::move(context).WriteString(::blink::mojom::InterestGroup_TrustedBiddingSignalsSlotSizeModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportType value) {
  return std::move(context).WriteString(::blink::mojom::AuctionAdConfigNonSharedParams_BuyerReportTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingType value) {
  return std::move(context).WriteString(::blink::mojom::AuctionAdConfigNonSharedParams_RealTimeReportingTypeToString(value));
}

} // namespace perfetto