// third_party/blink/public/mojom/interest_group/ad_display_size.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_DISPLAY_SIZE_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_DISPLAY_SIZE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/interest_group/ad_display_size.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>




#include "third_party/blink/public/common/interest_group/ad_display_size_mojom_traits.h"
#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {





class BLINK_COMMON_EXPORT AdSize {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdSize, T>::value>;
  using DataView = AdSizeDataView;
  using Data_ = internal::AdSize_Data;
  using LengthUnit = AdSize_LengthUnit;

  template <typename... Args>
  static AdSizePtr New(Args&&... args) {
    return AdSizePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdSizePtr From(const U& u) {
    return mojo::TypeConverter<AdSizePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdSize>::Convert(*this);
  }


  AdSize();

  AdSize(
      double width,
      AdSize::LengthUnit width_units,
      double height,
      AdSize::LengthUnit height_units);


  ~AdSize();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdSizePtr>
  AdSizePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdSize::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdSize::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdSize::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdSize::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdSize::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdSize::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdSize_UnserializedMessageContext<
            UserType, AdSize::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdSize::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdSize::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdSize_UnserializedMessageContext<
            UserType, AdSize::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdSize::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double width;
  
  AdSize::LengthUnit width_units;
  
  double height;
  
  AdSize::LengthUnit height_units;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdSize::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdSize::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdSize::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdSize::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_COMMON_EXPORT AdDescriptor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdDescriptor, T>::value>;
  using DataView = AdDescriptorDataView;
  using Data_ = internal::AdDescriptor_Data;

  template <typename... Args>
  static AdDescriptorPtr New(Args&&... args) {
    return AdDescriptorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdDescriptorPtr From(const U& u) {
    return mojo::TypeConverter<AdDescriptorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdDescriptor>::Convert(*this);
  }


  AdDescriptor();

  AdDescriptor(
      const ::GURL& url,
      const std::optional<::blink::AdSize>& size);


  ~AdDescriptor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdDescriptorPtr>
  AdDescriptorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdDescriptor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdDescriptor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdDescriptor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdDescriptor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdDescriptor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdDescriptor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdDescriptor_UnserializedMessageContext<
            UserType, AdDescriptor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdDescriptor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdDescriptor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdDescriptor_UnserializedMessageContext<
            UserType, AdDescriptor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdDescriptor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  std::optional<::blink::AdSize> size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdDescriptor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdDescriptor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdDescriptor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdDescriptor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AdSizePtr AdSize::Clone() const {
  return New(
      mojo::Clone(width),
      mojo::Clone(width_units),
      mojo::Clone(height),
      mojo::Clone(height_units)
  );
}

template <typename T, AdSize::EnableIfSame<T>*>
bool AdSize::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->width_units, other_struct.width_units))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->height_units, other_struct.height_units))
    return false;
  return true;
}

template <typename T, AdSize::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.width_units < rhs.width_units)
    return true;
  if (rhs.width_units < lhs.width_units)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.height_units < rhs.height_units)
    return true;
  if (rhs.height_units < lhs.height_units)
    return false;
  return false;
}
template <typename StructPtrType>
AdDescriptorPtr AdDescriptor::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(size)
  );
}

template <typename T, AdDescriptor::EnableIfSame<T>*>
bool AdDescriptor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  return true;
}

template <typename T, AdDescriptor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AdSize::DataView,
                                         ::blink::mojom::AdSizePtr> {
  static bool IsNull(const ::blink::mojom::AdSizePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AdSizePtr* output) { output->reset(); }

  static decltype(::blink::mojom::AdSize::width) width(
      const ::blink::mojom::AdSizePtr& input) {
    return input->width;
  }

  static decltype(::blink::mojom::AdSize::width_units) width_units(
      const ::blink::mojom::AdSizePtr& input) {
    return input->width_units;
  }

  static decltype(::blink::mojom::AdSize::height) height(
      const ::blink::mojom::AdSizePtr& input) {
    return input->height;
  }

  static decltype(::blink::mojom::AdSize::height_units) height_units(
      const ::blink::mojom::AdSizePtr& input) {
    return input->height_units;
  }

  static bool Read(::blink::mojom::AdSize::DataView input, ::blink::mojom::AdSizePtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::AdDescriptor::DataView,
                                         ::blink::mojom::AdDescriptorPtr> {
  static bool IsNull(const ::blink::mojom::AdDescriptorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::AdDescriptorPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::AdDescriptor::url)& url(
      const ::blink::mojom::AdDescriptorPtr& input) {
    return input->url;
  }

  static const decltype(::blink::mojom::AdDescriptor::size)& size(
      const ::blink::mojom::AdDescriptorPtr& input) {
    return input->size;
  }

  static bool Read(::blink::mojom::AdDescriptor::DataView input, ::blink::mojom::AdDescriptorPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INTEREST_GROUP_AD_DISPLAY_SIZE_MOJOM_H_