// third_party/blink/public/mojom/input/input_handler.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/input/input_handler.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT WidgetInputHandlerHostInterceptorForTesting : public WidgetInputHandlerHost {
  virtual WidgetInputHandlerHost* GetForwardingInterface() = 0;
  void SetTouchActionFromMain(::cc::TouchAction touch_action) override;
  void SetPanAction(PanAction pan_action) override;
  void DidOverscroll(DidOverscrollParamsPtr params) override;
  void DidStartScrollingViewport() override;
  void ImeCancelComposition() override;
  void ImeCompositionRangeChanged(const ::gfx::Range& range, const std::optional<std::vector<::gfx::Rect>>& character_bounds) override;
  void SetMouseCapture(bool capture) override;
  void SetAutoscrollSelectionActiveInMainFrame(bool autoscroll_selection) override;
  void RequestMouseLock(bool from_user_gesture, bool unadjusted_movement, RequestMouseLockCallback callback) override;
};
class BLINK_COMMON_EXPORT WidgetInputHandlerHostAsyncWaiter {
 public:
  explicit WidgetInputHandlerHostAsyncWaiter(WidgetInputHandlerHost* proxy);

  WidgetInputHandlerHostAsyncWaiter(const WidgetInputHandlerHostAsyncWaiter&) = delete;
  WidgetInputHandlerHostAsyncWaiter& operator=(const WidgetInputHandlerHostAsyncWaiter&) = delete;

  ~WidgetInputHandlerHostAsyncWaiter();
  void RequestMouseLock(
      bool from_user_gesture, bool unadjusted_movement, ::blink::mojom::PointerLockResult* out_result, ::mojo::PendingRemote<::blink::mojom::PointerLockContext>* out_context);
  

 private:
  WidgetInputHandlerHost* const proxy_;
};


class BLINK_COMMON_EXPORT FrameWidgetInputHandlerInterceptorForTesting : public FrameWidgetInputHandler {
  virtual FrameWidgetInputHandler* GetForwardingInterface() = 0;
  void AddImeTextSpansToExistingText(uint32_t start, uint32_t end, const std::vector<::ui::ImeTextSpan>& ime_text_spans) override;
  void ClearImeTextSpansByType(uint32_t start, uint32_t end, ::ui::ImeTextSpan::Type type) override;
  void SetCompositionFromExistingText(int32_t start, int32_t end, const std::vector<::ui::ImeTextSpan>& ime_text_spans) override;
  void ExtendSelectionAndDelete(int32_t before, int32_t after) override;
  void ExtendSelectionAndReplace(uint32_t before, uint32_t after, const ::std::u16string& replacement_text) override;
  void DeleteSurroundingText(int32_t before, int32_t after) override;
  void DeleteSurroundingTextInCodePoints(int32_t before, int32_t after) override;
  void SetEditableSelectionOffsets(int32_t start, int32_t end) override;
  void HandleStylusWritingGestureAction(::blink::mojom::StylusWritingGestureDataPtr gesture_data, HandleStylusWritingGestureActionCallback callback) override;
  void ExecuteEditCommand(const std::string& command, const std::optional<::std::u16string>& value) override;
  void Undo() override;
  void Redo() override;
  void Cut() override;
  void Copy() override;
  void CopyToFindPboard() override;
  void CenterSelection() override;
  void Paste() override;
  void PasteAndMatchStyle() override;
  void Delete() override;
  void SelectAll() override;
  void CollapseSelection() override;
  void CopyWithConfirmation(int32_t token, CopyWithConfirmationCallback callback) override;
  void PasteWithConfirmation(int32_t token, PasteWithConfirmationCallback callback) override;
  void Replace(const ::std::u16string& word) override;
  void ReplaceMisspelling(const ::std::u16string& word) override;
  void SelectRange(const ::gfx::Point& base, const ::gfx::Point& extent) override;
  void AdjustSelectionByCharacterOffset(int32_t start, int32_t end, ::blink::mojom::SelectionMenuBehavior behavior) override;
  void SelectAroundCaret(SelectionGranularity granularity, bool should_show_handle, bool should_show_context_menu, SelectAroundCaretCallback callback) override;
  void MoveRangeSelectionExtent(const ::gfx::Point& extent) override;
  void ScrollFocusedEditableNodeIntoView() override;
  void WaitForPageScaleAnimationForTesting(WaitForPageScaleAnimationForTestingCallback callback) override;
  void MoveCaret(const ::gfx::Point& point) override;
};
class BLINK_COMMON_EXPORT FrameWidgetInputHandlerAsyncWaiter {
 public:
  explicit FrameWidgetInputHandlerAsyncWaiter(FrameWidgetInputHandler* proxy);

  FrameWidgetInputHandlerAsyncWaiter(const FrameWidgetInputHandlerAsyncWaiter&) = delete;
  FrameWidgetInputHandlerAsyncWaiter& operator=(const FrameWidgetInputHandlerAsyncWaiter&) = delete;

  ~FrameWidgetInputHandlerAsyncWaiter();
  void HandleStylusWritingGestureAction(
      ::blink::mojom::StylusWritingGestureDataPtr gesture_data, ::blink::mojom::HandwritingGestureResult* out_result);
  ::blink::mojom::HandwritingGestureResult HandleStylusWritingGestureAction(::blink::mojom::StylusWritingGestureDataPtr gesture_data);
  void CopyWithConfirmation(
      int32_t token, int32_t* out_token);
  int32_t CopyWithConfirmation(int32_t token);
  void PasteWithConfirmation(
      int32_t token, int32_t* out_token);
  int32_t PasteWithConfirmation(int32_t token);
  void SelectAroundCaret(
      SelectionGranularity granularity, bool should_show_handle, bool should_show_context_menu, SelectAroundCaretResultPtr* out_result);
  SelectAroundCaretResultPtr SelectAroundCaret(SelectionGranularity granularity, bool should_show_handle, bool should_show_context_menu);
  void WaitForPageScaleAnimationForTesting(
      );
  

 private:
  FrameWidgetInputHandler* const proxy_;
};


class BLINK_COMMON_EXPORT WidgetInputHandlerInterceptorForTesting : public WidgetInputHandler {
  virtual WidgetInputHandler* GetForwardingInterface() = 0;
  void SetFocus(FocusState state) override;
  void MouseCaptureLost() override;
  void SetEditCommandsForNextKeyEvent(std::vector<EditCommandPtr> commands) override;
  void CursorVisibilityChanged(bool visible) override;
  void ImeSetComposition(const ::std::u16string& text, const std::vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t start, int32_t end, ImeSetCompositionCallback callback) override;
  void ImeCommitText(const ::std::u16string& text, const std::vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t relative_cursor_position, ImeCommitTextCallback callback) override;
  void ImeFinishComposingText(bool keep_selection) override;
  void RequestTextInputStateUpdate() override;
  void RequestCompositionUpdates(bool immediate_request, bool monitor_request) override;
  void DispatchEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, std::optional<::std::unique_ptr<::blink::WebCoalescedInputEvent>> original_event_for_gesture, DispatchEventCallback callback) override;
  void DispatchNonBlockingEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event) override;
  void WaitForInputProcessed(WaitForInputProcessedCallback callback) override;
  void GetFrameWidgetInputHandler(::mojo::PendingAssociatedReceiver<FrameWidgetInputHandler> interface_request) override;
  void UpdateBrowserControlsState(::cc::BrowserControlsState constraints, ::cc::BrowserControlsState current, bool animate, const std::optional<::cc::BrowserControlsOffsetTagModifications>& offset_tag_modifications) override;
};
class BLINK_COMMON_EXPORT WidgetInputHandlerAsyncWaiter {
 public:
  explicit WidgetInputHandlerAsyncWaiter(WidgetInputHandler* proxy);

  WidgetInputHandlerAsyncWaiter(const WidgetInputHandlerAsyncWaiter&) = delete;
  WidgetInputHandlerAsyncWaiter& operator=(const WidgetInputHandlerAsyncWaiter&) = delete;

  ~WidgetInputHandlerAsyncWaiter();
  void ImeSetComposition(
      const ::std::u16string& text, const std::vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t start, int32_t end);
  
  void ImeCommitText(
      const ::std::u16string& text, const std::vector<::ui::ImeTextSpan>& ime_text_spans, const ::gfx::Range& range, int32_t relative_cursor_position);
  
  void DispatchEvent(
      ::std::unique_ptr<::blink::WebCoalescedInputEvent> event, std::optional<::std::unique_ptr<::blink::WebCoalescedInputEvent>> original_event_for_gesture, ::blink::mojom::InputEventResultSource* out_source, ::ui::LatencyInfo* out_updated_latency, ::blink::mojom::InputEventResultState* out_state, DidOverscrollParamsPtr* out_overscroll, TouchActionOptionalPtr* out_touch_action);
  
  void WaitForInputProcessed(
      );
  

 private:
  WidgetInputHandler* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INPUT_INPUT_HANDLER_MOJOM_TEST_UTILS_H_