// third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::IDBCursorDirection>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IDBCursorDirection> {};

template <>
struct hash<::blink::mojom::IDBDataLoss>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IDBDataLoss> {};

template <>
struct hash<::blink::mojom::IDBKeyType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IDBKeyType> {};

template <>
struct hash<::blink::mojom::IDBTransactionDurability>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IDBTransactionDurability> {};

template <>
struct hash<::blink::mojom::IDBGetAllResultType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IDBGetAllResultType> {};

template <>
struct hash<::blink::mojom::IDBKeyPathType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IDBKeyPathType> {};

template <>
struct hash<::blink::mojom::IDBOperationType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IDBOperationType> {};

template <>
struct hash<::blink::mojom::IDBPutMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IDBPutMode> {};

template <>
struct hash<::blink::mojom::IDBTaskType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IDBTaskType> {};

template <>
struct hash<::blink::mojom::IDBTransactionMode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IDBTransactionMode> {};

template <>
struct hash<::blink::mojom::IDBException>
    : public mojo::internal::EnumHashImpl<::blink::mojom::IDBException> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBCursorDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IDBCursorDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IDBCursorDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBDataLoss, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IDBDataLoss, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IDBDataLoss>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBKeyType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IDBKeyType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IDBKeyType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBTransactionDurability, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IDBTransactionDurability, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IDBTransactionDurability>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBGetAllResultType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IDBGetAllResultType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IDBGetAllResultType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBKeyPathType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IDBKeyPathType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IDBKeyPathType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBOperationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IDBOperationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IDBOperationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBPutMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IDBPutMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IDBPutMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBTaskType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IDBTaskType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IDBTaskType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBTransactionMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IDBTransactionMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IDBTransactionMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBException, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::IDBException, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::IDBException>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBKeyPathDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBKeyPathDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBKeyPath_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    
    mojo::internal::Serialize<::blink::mojom::IDBKeyPathDataDataView>(
      in_data,
      data_fragment,
      true);
  }

  static bool Deserialize(::blink::mojom::internal::IDBKeyPath_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBKeyPathDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBKeyRangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBKeyRangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBKeyRange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::lower(input)) in_lower = Traits::lower(input);
    mojo::internal::MessageFragment<decltype(fragment->lower)>
        lower_fragment(fragment.message());
    lower_fragment.Claim(&fragment->lower);
    
    mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
      in_lower,
      lower_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->lower.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null lower in IDBKeyRange struct");

    decltype(Traits::upper(input)) in_upper = Traits::upper(input);
    mojo::internal::MessageFragment<decltype(fragment->upper)>
        upper_fragment(fragment.message());
    upper_fragment.Claim(&fragment->upper);
    
    mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
      in_upper,
      upper_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->upper.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null upper in IDBKeyRange struct");

    fragment->lower_open = Traits::lower_open(input);

    fragment->upper_open = Traits::upper_open(input);
  }

  static bool Deserialize(::blink::mojom::internal::IDBKeyRange_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBKeyRangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBIndexMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBIndexMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBIndexMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IDBIndexMetadata struct");

    decltype(Traits::key_path(input)) in_key_path = Traits::key_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_path)::BaseType> key_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::IDBKeyPathDataView>(
      in_key_path,
      key_path_fragment);

    fragment->key_path.Set(
        key_path_fragment.is_null() ? nullptr : key_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_path in IDBIndexMetadata struct");

    fragment->unique = Traits::unique(input);

    fragment->multi_entry = Traits::multi_entry(input);
  }

  static bool Deserialize(::blink::mojom::internal::IDBIndexMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBIndexMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBObjectStoreMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBObjectStoreMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBObjectStoreMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IDBObjectStoreMetadata struct");

    decltype(Traits::key_path(input)) in_key_path = Traits::key_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_path)::BaseType> key_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::IDBKeyPathDataView>(
      in_key_path,
      key_path_fragment);

    fragment->key_path.Set(
        key_path_fragment.is_null() ? nullptr : key_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_path in IDBObjectStoreMetadata struct");

    fragment->auto_increment = Traits::auto_increment(input);

    fragment->max_index_id = Traits::max_index_id(input);

    decltype(Traits::indexes(input)) in_indexes = Traits::indexes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->indexes)::BaseType>
        indexes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& indexes_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<int64_t, ::blink::mojom::IDBIndexMetadataDataView>>(
      in_indexes,
      indexes_fragment,
      &indexes_validate_params);

    fragment->indexes.Set(
        indexes_fragment.is_null() ? nullptr : indexes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->indexes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null indexes in IDBObjectStoreMetadata struct");
  }

  static bool Deserialize(::blink::mojom::internal::IDBObjectStoreMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBObjectStoreMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBDatabaseMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBDatabaseMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBDatabaseMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IDBDatabaseMetadata struct");

    fragment->version = Traits::version(input);

    fragment->max_object_store_id = Traits::max_object_store_id(input);

    decltype(Traits::object_stores(input)) in_object_stores = Traits::object_stores(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->object_stores)::BaseType>
        object_stores_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& object_stores_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<int64_t, ::blink::mojom::IDBObjectStoreMetadataDataView>>(
      in_object_stores,
      object_stores_fragment,
      &object_stores_validate_params);

    fragment->object_stores.Set(
        object_stores_fragment.is_null() ? nullptr : object_stores_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->object_stores.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null object_stores in IDBDatabaseMetadata struct");

    fragment->was_cold_open = Traits::was_cold_open(input);

    fragment->is_sqlite = Traits::is_sqlite(input);
  }

  static bool Deserialize(::blink::mojom::internal::IDBDatabaseMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBDatabaseMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBNameAndVersionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBNameAndVersionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBNameAndVersion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IDBNameAndVersion struct");

    fragment->version = Traits::version(input);
  }

  static bool Deserialize(::blink::mojom::internal::IDBNameAndVersion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBNameAndVersionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBIndexKeysDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBIndexKeysDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBIndexKeys_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->index_id = Traits::index_id(input);

    decltype(Traits::index_keys(input)) in_index_keys = Traits::index_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->index_keys)::BaseType>
        index_keys_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& index_keys_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>>(
      in_index_keys,
      index_keys_fragment,
      &index_keys_validate_params);

    fragment->index_keys.Set(
        index_keys_fragment.is_null() ? nullptr : index_keys_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->index_keys.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null index_keys in IDBIndexKeys struct");
  }

  static bool Deserialize(::blink::mojom::internal::IDBIndexKeys_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBIndexKeysDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBFileInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBFileInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBFileInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in IDBFileInfo struct");

    decltype(Traits::last_modified(input)) in_last_modified = Traits::last_modified(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_modified)::BaseType> last_modified_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_last_modified,
      last_modified_fragment);

    fragment->last_modified.Set(
        last_modified_fragment.is_null() ? nullptr : last_modified_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_modified.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_modified in IDBFileInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::IDBFileInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBFileInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBBlobInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBBlobInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBBlobInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::blob(input)) in_blob = Traits::blob(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob,
      &fragment->blob,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->blob)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in IDBBlobInfo struct");

    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_mime_type,
      mime_type_fragment);

    fragment->mime_type.Set(
        mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mime_type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mime_type in IDBBlobInfo struct");

    fragment->size = Traits::size(input);

    decltype(Traits::file(input)) in_file = Traits::file(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file)::BaseType> file_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::IDBFileInfoDataView>(
      in_file,
      file_fragment);

    fragment->file.Set(
        file_fragment.is_null() ? nullptr : file_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::IDBBlobInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBBlobInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::bits(input)) in_bits = Traits::bits(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bits)::BaseType>
        bits_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bits_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_bits,
      bits_fragment,
      &bits_validate_params);

    fragment->bits.Set(
        bits_fragment.is_null() ? nullptr : bits_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bits.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bits in IDBValue struct");

    decltype(Traits::external_objects(input)) in_external_objects = Traits::external_objects(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->external_objects)::BaseType>
        external_objects_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& external_objects_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBExternalObjectDataView>>(
      in_external_objects,
      external_objects_fragment,
      &external_objects_validate_params);

    fragment->external_objects.Set(
        external_objects_fragment.is_null() ? nullptr : external_objects_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->external_objects.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null external_objects in IDBValue struct");
  }

  static bool Deserialize(::blink::mojom::internal::IDBValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBReturnValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBReturnValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBReturnValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::IDBValueDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in IDBReturnValue struct");

    decltype(Traits::primary_key(input)) in_primary_key = Traits::primary_key(input);
    mojo::internal::MessageFragment<decltype(fragment->primary_key)>
        primary_key_fragment(fragment.message());
    primary_key_fragment.Claim(&fragment->primary_key);
    
    mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
      in_primary_key,
      primary_key_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->primary_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null primary_key in IDBReturnValue struct");

    decltype(Traits::key_path(input)) in_key_path = Traits::key_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key_path)::BaseType> key_path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::IDBKeyPathDataView>(
      in_key_path,
      key_path_fragment);

    fragment->key_path.Set(
        key_path_fragment.is_null() ? nullptr : key_path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key_path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key_path in IDBReturnValue struct");
  }

  static bool Deserialize(::blink::mojom::internal::IDBReturnValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBReturnValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBRecordDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBRecordDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBRecord_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::primary_key(input)) in_primary_key = Traits::primary_key(input);
    mojo::internal::MessageFragment<decltype(fragment->primary_key)>
        primary_key_fragment(fragment.message());
    primary_key_fragment.Claim(&fragment->primary_key);
    
    mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
      in_primary_key,
      primary_key_fragment,
      true);

    decltype(Traits::return_value(input)) in_return_value = Traits::return_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->return_value)::BaseType> return_value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::IDBReturnValueDataView>(
      in_return_value,
      return_value_fragment);

    fragment->return_value.Set(
        return_value_fragment.is_null() ? nullptr : return_value_fragment.data());

    decltype(Traits::index_key(input)) in_index_key = Traits::index_key(input);
    mojo::internal::MessageFragment<decltype(fragment->index_key)>
        index_key_fragment(fragment.message());
    index_key_fragment.Claim(&fragment->index_key);
    
    mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
      in_index_key,
      index_key_fragment,
      true);
  }

  static bool Deserialize(::blink::mojom::internal::IDBRecord_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBRecordDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBErrorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBErrorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBError_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::IDBException>(
      Traits::error_code(input),
      &fragment->error_code);

    decltype(Traits::error_message(input)) in_error_message = Traits::error_message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->error_message)::BaseType> error_message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_error_message,
      error_message_fragment);

    fragment->error_message.Set(
        error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->error_message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null error_message in IDBError struct");
  }

  static bool Deserialize(::blink::mojom::internal::IDBError_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBErrorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBCursorValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBCursorValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBCursorValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::keys(input)) in_keys = Traits::keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keys)::BaseType>
        keys_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>>(
      in_keys,
      keys_fragment,
      &keys_validate_params);

    fragment->keys.Set(
        keys_fragment.is_null() ? nullptr : keys_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->keys.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keys in IDBCursorValue struct");

    decltype(Traits::primary_keys(input)) in_primary_keys = Traits::primary_keys(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->primary_keys)::BaseType>
        primary_keys_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& primary_keys_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>>(
      in_primary_keys,
      primary_keys_fragment,
      &primary_keys_validate_params);

    fragment->primary_keys.Set(
        primary_keys_fragment.is_null() ? nullptr : primary_keys_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->primary_keys.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null primary_keys in IDBCursorValue struct");

    decltype(Traits::values(input)) in_values = Traits::values(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->values)::BaseType>
        values_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& values_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBValueDataView>>(
      in_values,
      values_fragment,
      &values_validate_params);

    fragment->values.Set(
        values_fragment.is_null() ? nullptr : values_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->values.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null values in IDBCursorValue struct");
  }

  static bool Deserialize(::blink::mojom::internal::IDBCursorValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBCursorValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBDatabaseOpenCursorValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::IDBDatabaseOpenCursorValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::IDBDatabaseOpenCursorValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::cursor(input)) in_cursor = Traits::cursor(input);

    
    mojo::internal::Serialize<::blink::mojom::IDBCursorAssociatedPtrInfoDataView>(
      in_cursor,
      &fragment->cursor,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->cursor)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
      "invalid cursor in IDBDatabaseOpenCursorValue struct");

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<decltype(fragment->key)>
        key_fragment(fragment.message());
    key_fragment.Claim(&fragment->key);
    
    mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
      in_key,
      key_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in IDBDatabaseOpenCursorValue struct");

    decltype(Traits::primary_key(input)) in_primary_key = Traits::primary_key(input);
    mojo::internal::MessageFragment<decltype(fragment->primary_key)>
        primary_key_fragment(fragment.message());
    primary_key_fragment.Claim(&fragment->primary_key);
    
    mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
      in_primary_key,
      primary_key_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->primary_key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null primary_key in IDBDatabaseOpenCursorValue struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::IDBValueDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::IDBDatabaseOpenCursorValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBDatabaseOpenCursorValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBKeyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBKey_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBKeyDataView::Tag::kKeyArray: {
    decltype(Traits::key_array(input))
    in_key_array = Traits::key_array(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_key_array)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& key_array_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::IDBKeyDataView>>(
  in_key_array,
  value_fragment,
  &key_array_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null key_array in IDBKey union");
    fragment->data.f_key_array.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBKeyDataView::Tag::kBinary: {
    decltype(Traits::binary(input))
    in_binary = Traits::binary(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_binary)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& binary_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
  in_binary,
  value_fragment,
  &binary_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null binary in IDBKey union");
    fragment->data.f_binary.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBKeyDataView::Tag::kString: {
    decltype(Traits::string(input))
    in_string = Traits::string(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
  in_string,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string in IDBKey union");
    fragment->data.f_string.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBKeyDataView::Tag::kDate: {
    decltype(Traits::date(input))
    in_date = Traits::date(input);
    fragment->data.f_date = in_date;
    break;
  }
  case ::blink::mojom::IDBKeyDataView::Tag::kNumber: {
    decltype(Traits::number(input))
    in_number = Traits::number(input);
    fragment->data.f_number = in_number;
    break;
  }
  case ::blink::mojom::IDBKeyDataView::Tag::kOtherNone: {
    decltype(Traits::other_none(input))
    in_other_none = Traits::other_none(input);
    fragment->data.f_other_none = in_other_none;
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::IDBKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBKeyPathDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBKeyPathDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBKeyPathData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBKeyPathDataDataView::Tag::kString: {
    decltype(Traits::string(input))
    in_string = Traits::string(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
  in_string,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string in IDBKeyPathData union");
    fragment->data.f_string.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBKeyPathDataDataView::Tag::kStringArray: {
    decltype(Traits::string_array(input))
    in_string_array = Traits::string_array(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_string_array)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& string_array_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
  in_string_array,
  value_fragment,
  &string_array_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null string_array in IDBKeyPathData union");
    fragment->data.f_string_array.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::IDBKeyPathData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBKeyPathDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBExternalObjectDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBExternalObjectDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBExternalObject_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBExternalObjectDataView::Tag::kBlobOrFile: {
    decltype(Traits::blob_or_file(input))
    in_blob_or_file = Traits::blob_or_file(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_blob_or_file)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBBlobInfoDataView>(
  in_blob_or_file,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null blob_or_file in IDBExternalObject union");
    fragment->data.f_blob_or_file.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBExternalObjectDataView::Tag::kFileSystemAccessToken: {
    decltype(Traits::file_system_access_token(input))
    in_file_system_access_token = Traits::file_system_access_token(input);
        
mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
  in_file_system_access_token,
  &fragment->data.f_file_system_access_token,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_file_system_access_token)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null file_system_access_token in IDBExternalObject union");
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::IDBExternalObject_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBExternalObjectDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBCursorResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBCursorResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBCursorResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBCursorResultDataView::Tag::kErrorResult: {
    decltype(Traits::error_result(input))
    in_error_result = Traits::error_result(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_result)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBErrorDataView>(
  in_error_result,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_result in IDBCursorResult union");
    fragment->data.f_error_result.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBCursorResultDataView::Tag::kEmpty: {
    decltype(Traits::empty(input))
    in_empty = Traits::empty(input);
    fragment->data.f_empty = in_empty;
    break;
  }
  case ::blink::mojom::IDBCursorResultDataView::Tag::kValues: {
    decltype(Traits::values(input))
    in_values = Traits::values(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_values)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBCursorValueDataView>(
  in_values,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null values in IDBCursorResult union");
    fragment->data.f_values.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::IDBCursorResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBCursorResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBTransactionPutResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBTransactionPutResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBTransactionPutResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBTransactionPutResultDataView::Tag::kErrorResult: {
    decltype(Traits::error_result(input))
    in_error_result = Traits::error_result(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_result)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBErrorDataView>(
  in_error_result,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_result in IDBTransactionPutResult union");
    fragment->data.f_error_result.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBTransactionPutResultDataView::Tag::kKey: {
    decltype(Traits::key(input))
    in_key = Traits::key(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_key)::BaseType>
    value_fragment(fragment.message());
  
mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
  in_key,
  value_fragment,
  false);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null key in IDBTransactionPutResult union");
    fragment->data.f_key.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::IDBTransactionPutResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBTransactionPutResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBDatabaseGetResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBDatabaseGetResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBDatabaseGetResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBDatabaseGetResultDataView::Tag::kErrorResult: {
    decltype(Traits::error_result(input))
    in_error_result = Traits::error_result(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_result)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBErrorDataView>(
  in_error_result,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_result in IDBDatabaseGetResult union");
    fragment->data.f_error_result.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBDatabaseGetResultDataView::Tag::kEmpty: {
    decltype(Traits::empty(input))
    in_empty = Traits::empty(input);
    fragment->data.f_empty = in_empty;
    break;
  }
  case ::blink::mojom::IDBDatabaseGetResultDataView::Tag::kKey: {
    decltype(Traits::key(input))
    in_key = Traits::key(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_key)::BaseType>
    value_fragment(fragment.message());
  
mojo::internal::Serialize<::blink::mojom::IDBKeyDataView>(
  in_key,
  value_fragment,
  false);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null key in IDBDatabaseGetResult union");
    fragment->data.f_key.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBDatabaseGetResultDataView::Tag::kValue: {
    decltype(Traits::value(input))
    in_value = Traits::value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBReturnValueDataView>(
  in_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null value in IDBDatabaseGetResult union");
    fragment->data.f_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::IDBDatabaseGetResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBDatabaseGetResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::IDBDatabaseOpenCursorResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::IDBDatabaseOpenCursorResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::IDBDatabaseOpenCursorResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::IDBDatabaseOpenCursorResultDataView::Tag::kErrorResult: {
    decltype(Traits::error_result(input))
    in_error_result = Traits::error_result(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_result)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBErrorDataView>(
  in_error_result,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_result in IDBDatabaseOpenCursorResult union");
    fragment->data.f_error_result.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::IDBDatabaseOpenCursorResultDataView::Tag::kEmpty: {
    decltype(Traits::empty(input))
    in_empty = Traits::empty(input);
    fragment->data.f_empty = in_empty;
    break;
  }
  case ::blink::mojom::IDBDatabaseOpenCursorResultDataView::Tag::kValue: {
    decltype(Traits::value(input))
    in_value = Traits::value(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_value)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::IDBDatabaseOpenCursorValueDataView>(
  in_value,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null value in IDBDatabaseOpenCursorResult union");
    fragment->data.f_value.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::blink::mojom::internal::IDBDatabaseOpenCursorResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::IDBDatabaseOpenCursorResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void IDBKeyPathDataView::GetDataDataView(
    IDBKeyPathDataDataView* output) {
  auto pointer = &data_->data;
  *output = IDBKeyPathDataDataView(pointer, message_);
}


inline void IDBKeyRangeDataView::GetLowerDataView(
    IDBKeyDataView* output) {
  auto pointer = &data_->lower;
  *output = IDBKeyDataView(pointer, message_);
}
inline void IDBKeyRangeDataView::GetUpperDataView(
    IDBKeyDataView* output) {
  auto pointer = &data_->upper;
  *output = IDBKeyDataView(pointer, message_);
}


inline void IDBIndexMetadataDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void IDBIndexMetadataDataView::GetKeyPathDataView(
    IDBKeyPathDataView* output) {
  auto pointer = data_->key_path.Get();
  *output = IDBKeyPathDataView(pointer, message_);
}


inline void IDBObjectStoreMetadataDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void IDBObjectStoreMetadataDataView::GetKeyPathDataView(
    IDBKeyPathDataView* output) {
  auto pointer = data_->key_path.Get();
  *output = IDBKeyPathDataView(pointer, message_);
}
inline void IDBObjectStoreMetadataDataView::GetIndexesDataView(
    mojo::MapDataView<int64_t, IDBIndexMetadataDataView>* output) {
  auto pointer = data_->indexes.Get();
  *output = mojo::MapDataView<int64_t, IDBIndexMetadataDataView>(pointer, message_);
}


inline void IDBDatabaseMetadataDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void IDBDatabaseMetadataDataView::GetObjectStoresDataView(
    mojo::MapDataView<int64_t, IDBObjectStoreMetadataDataView>* output) {
  auto pointer = data_->object_stores.Get();
  *output = mojo::MapDataView<int64_t, IDBObjectStoreMetadataDataView>(pointer, message_);
}


inline void IDBNameAndVersionDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void IDBIndexKeysDataView::GetIndexKeysDataView(
    mojo::ArrayDataView<IDBKeyDataView>* output) {
  auto pointer = data_->index_keys.Get();
  *output = mojo::ArrayDataView<IDBKeyDataView>(pointer, message_);
}


inline void IDBFileInfoDataView::GetNameDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->name.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void IDBFileInfoDataView::GetLastModifiedDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_modified.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void IDBBlobInfoDataView::GetMimeTypeDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void IDBBlobInfoDataView::GetFileDataView(
    IDBFileInfoDataView* output) {
  auto pointer = data_->file.Get();
  *output = IDBFileInfoDataView(pointer, message_);
}


inline void IDBValueDataView::GetBitsDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->bits.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void IDBValueDataView::GetExternalObjectsDataView(
    mojo::ArrayDataView<IDBExternalObjectDataView>* output) {
  auto pointer = data_->external_objects.Get();
  *output = mojo::ArrayDataView<IDBExternalObjectDataView>(pointer, message_);
}


inline void IDBReturnValueDataView::GetValueDataView(
    IDBValueDataView* output) {
  auto pointer = data_->value.Get();
  *output = IDBValueDataView(pointer, message_);
}
inline void IDBReturnValueDataView::GetPrimaryKeyDataView(
    IDBKeyDataView* output) {
  auto pointer = &data_->primary_key;
  *output = IDBKeyDataView(pointer, message_);
}
inline void IDBReturnValueDataView::GetKeyPathDataView(
    IDBKeyPathDataView* output) {
  auto pointer = data_->key_path.Get();
  *output = IDBKeyPathDataView(pointer, message_);
}


inline void IDBRecordDataView::GetPrimaryKeyDataView(
    IDBKeyDataView* output) {
  auto pointer = &data_->primary_key;
  *output = IDBKeyDataView(pointer, message_);
}
inline void IDBRecordDataView::GetReturnValueDataView(
    IDBReturnValueDataView* output) {
  auto pointer = data_->return_value.Get();
  *output = IDBReturnValueDataView(pointer, message_);
}
inline void IDBRecordDataView::GetIndexKeyDataView(
    IDBKeyDataView* output) {
  auto pointer = &data_->index_key;
  *output = IDBKeyDataView(pointer, message_);
}


inline void IDBErrorDataView::GetErrorMessageDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->error_message.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void IDBCursorValueDataView::GetKeysDataView(
    mojo::ArrayDataView<IDBKeyDataView>* output) {
  auto pointer = data_->keys.Get();
  *output = mojo::ArrayDataView<IDBKeyDataView>(pointer, message_);
}
inline void IDBCursorValueDataView::GetPrimaryKeysDataView(
    mojo::ArrayDataView<IDBKeyDataView>* output) {
  auto pointer = data_->primary_keys.Get();
  *output = mojo::ArrayDataView<IDBKeyDataView>(pointer, message_);
}
inline void IDBCursorValueDataView::GetValuesDataView(
    mojo::ArrayDataView<IDBValueDataView>* output) {
  auto pointer = data_->values.Get();
  *output = mojo::ArrayDataView<IDBValueDataView>(pointer, message_);
}


inline void IDBDatabaseOpenCursorValueDataView::GetKeyDataView(
    IDBKeyDataView* output) {
  auto pointer = &data_->key;
  *output = IDBKeyDataView(pointer, message_);
}
inline void IDBDatabaseOpenCursorValueDataView::GetPrimaryKeyDataView(
    IDBKeyDataView* output) {
  auto pointer = &data_->primary_key;
  *output = IDBKeyDataView(pointer, message_);
}
inline void IDBDatabaseOpenCursorValueDataView::GetValueDataView(
    IDBValueDataView* output) {
  auto pointer = data_->value.Get();
  *output = IDBValueDataView(pointer, message_);
}


inline void IDBKeyDataView::GetKeyArrayDataView(
    mojo::ArrayDataView<IDBKeyDataView>* output) const {
  CHECK(is_key_array());
  *output = mojo::ArrayDataView<IDBKeyDataView>(data_->data.f_key_array.Get(), message_);
}
inline void IDBKeyDataView::GetBinaryDataView(
    mojo::ArrayDataView<uint8_t>* output) const {
  CHECK(is_binary());
  *output = mojo::ArrayDataView<uint8_t>(data_->data.f_binary.Get(), message_);
}
inline void IDBKeyDataView::GetStringDataView(
    ::mojo_base::mojom::String16DataView* output) const {
  CHECK(is_string());
  *output = ::mojo_base::mojom::String16DataView(data_->data.f_string.Get(), message_);
}

inline void IDBKeyPathDataDataView::GetStringDataView(
    ::mojo_base::mojom::String16DataView* output) const {
  CHECK(is_string());
  *output = ::mojo_base::mojom::String16DataView(data_->data.f_string.Get(), message_);
}
inline void IDBKeyPathDataDataView::GetStringArrayDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) const {
  CHECK(is_string_array());
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(data_->data.f_string_array.Get(), message_);
}

inline void IDBExternalObjectDataView::GetBlobOrFileDataView(
    IDBBlobInfoDataView* output) const {
  CHECK(is_blob_or_file());
  *output = IDBBlobInfoDataView(data_->data.f_blob_or_file.Get(), message_);
}

inline void IDBCursorResultDataView::GetErrorResultDataView(
    IDBErrorDataView* output) const {
  CHECK(is_error_result());
  *output = IDBErrorDataView(data_->data.f_error_result.Get(), message_);
}
inline void IDBCursorResultDataView::GetValuesDataView(
    IDBCursorValueDataView* output) const {
  CHECK(is_values());
  *output = IDBCursorValueDataView(data_->data.f_values.Get(), message_);
}

inline void IDBTransactionPutResultDataView::GetErrorResultDataView(
    IDBErrorDataView* output) const {
  CHECK(is_error_result());
  *output = IDBErrorDataView(data_->data.f_error_result.Get(), message_);
}
inline void IDBTransactionPutResultDataView::GetKeyDataView(
    IDBKeyDataView* output) const {
  CHECK(is_key());
  *output = IDBKeyDataView(data_->data.f_key.Get(), message_);
}

inline void IDBDatabaseGetResultDataView::GetErrorResultDataView(
    IDBErrorDataView* output) const {
  CHECK(is_error_result());
  *output = IDBErrorDataView(data_->data.f_error_result.Get(), message_);
}
inline void IDBDatabaseGetResultDataView::GetKeyDataView(
    IDBKeyDataView* output) const {
  CHECK(is_key());
  *output = IDBKeyDataView(data_->data.f_key.Get(), message_);
}
inline void IDBDatabaseGetResultDataView::GetValueDataView(
    IDBReturnValueDataView* output) const {
  CHECK(is_value());
  *output = IDBReturnValueDataView(data_->data.f_value.Get(), message_);
}

inline void IDBDatabaseOpenCursorResultDataView::GetErrorResultDataView(
    IDBErrorDataView* output) const {
  CHECK(is_error_result());
  *output = IDBErrorDataView(data_->data.f_error_result.Get(), message_);
}
inline void IDBDatabaseOpenCursorResultDataView::GetValueDataView(
    IDBDatabaseOpenCursorValueDataView* output) const {
  CHECK(is_value());
  *output = IDBDatabaseOpenCursorValueDataView(data_->data.f_value.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IDBCursorDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IDBCursorDirection value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IDBDataLoss> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IDBDataLoss value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IDBKeyType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IDBKeyType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IDBTransactionDurability> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IDBTransactionDurability value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IDBGetAllResultType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IDBGetAllResultType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IDBKeyPathType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IDBKeyPathType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IDBOperationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IDBOperationType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IDBPutMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IDBPutMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IDBTaskType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IDBTaskType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IDBTransactionMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IDBTransactionMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::IDBException> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::IDBException value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_SHARED_H_