// third_party/blink/public/mojom/indexeddb/indexeddb.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_SHARED_INTERNAL_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/blob/blob.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace blink::mojom {
namespace internal {
class IDBKeyPath_Data;
class IDBKeyRange_Data;
class IDBIndexMetadata_Data;
class IDBObjectStoreMetadata_Data;
class IDBDatabaseMetadata_Data;
class IDBNameAndVersion_Data;
class IDBIndexKeys_Data;
class IDBFileInfo_Data;
class IDBBlobInfo_Data;
class IDBValue_Data;
class IDBReturnValue_Data;
class IDBRecord_Data;
class IDBError_Data;
class IDBCursorValue_Data;
class IDBDatabaseOpenCursorValue_Data;
class IDBKey_Data;
class IDBKeyPathData_Data;
class IDBExternalObject_Data;
class IDBCursorResult_Data;
class IDBTransactionPutResult_Data;
class IDBDatabaseGetResult_Data;
class IDBDatabaseOpenCursorResult_Data;

struct IDBCursorDirection_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct IDBDataLoss_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct IDBKeyType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct IDBTransactionDurability_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct IDBGetAllResultType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct IDBKeyPathType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct IDBOperationType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct IDBPutMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct IDBTaskType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct IDBTransactionMode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct IDBException_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 11:
      case 20:
      case 22:
      case 23:
      case 28:
      case 29:
      case 30:
      case 33:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBKey_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  IDBKey_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~IDBKey_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<IDBKey_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class IDBKey_Tag : uint32_t {

    
    kKeyArray,
    
    kBinary,
    
    kString,
    
    kDate,
    
    kNumber,
    
    kOtherNone,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<mojo::internal::Array_Data<internal::IDBKey_Data>> f_key_array;
    mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> f_binary;
    mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> f_string;
    double f_date;
    double f_number;
    uint8_t f_other_none : 1;
    uint64_t unknown;
  };

  uint32_t size;
  IDBKey_Tag tag;
  Union_ data;
};
static_assert(sizeof(IDBKey_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(IDBKey_Data)");


class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBKeyPathData_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  IDBKeyPathData_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~IDBKeyPathData_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<IDBKeyPathData_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class IDBKeyPathData_Tag : uint32_t {

    
    kString,
    
    kStringArray,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> f_string;
    mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data>>> f_string_array;
    uint64_t unknown;
  };

  uint32_t size;
  IDBKeyPathData_Tag tag;
  Union_ data;
};
static_assert(sizeof(IDBKeyPathData_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(IDBKeyPathData_Data)");


class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBExternalObject_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  IDBExternalObject_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~IDBExternalObject_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<IDBExternalObject_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class IDBExternalObject_Tag : uint32_t {

    
    kBlobOrFile,
    
    kFileSystemAccessToken,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::IDBBlobInfo_Data> f_blob_or_file;
    mojo::internal::Interface_Data f_file_system_access_token;
    uint64_t unknown;
  };

  uint32_t size;
  IDBExternalObject_Tag tag;
  Union_ data;
};
static_assert(sizeof(IDBExternalObject_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(IDBExternalObject_Data)");


class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBCursorResult_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  IDBCursorResult_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~IDBCursorResult_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<IDBCursorResult_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class IDBCursorResult_Tag : uint32_t {

    
    kErrorResult,
    
    kEmpty,
    
    kValues,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::IDBError_Data> f_error_result;
    uint8_t f_empty : 1;
    mojo::internal::Pointer<internal::IDBCursorValue_Data> f_values;
    uint64_t unknown;
  };

  uint32_t size;
  IDBCursorResult_Tag tag;
  Union_ data;
};
static_assert(sizeof(IDBCursorResult_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(IDBCursorResult_Data)");


class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBTransactionPutResult_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  IDBTransactionPutResult_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~IDBTransactionPutResult_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<IDBTransactionPutResult_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class IDBTransactionPutResult_Tag : uint32_t {

    
    kErrorResult,
    
    kKey,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::IDBError_Data> f_error_result;
    mojo::internal::Pointer<internal::IDBKey_Data> f_key;
    uint64_t unknown;
  };

  uint32_t size;
  IDBTransactionPutResult_Tag tag;
  Union_ data;
};
static_assert(sizeof(IDBTransactionPutResult_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(IDBTransactionPutResult_Data)");


class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBDatabaseGetResult_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  IDBDatabaseGetResult_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~IDBDatabaseGetResult_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<IDBDatabaseGetResult_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class IDBDatabaseGetResult_Tag : uint32_t {

    
    kErrorResult,
    
    kEmpty,
    
    kKey,
    
    kValue,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::IDBError_Data> f_error_result;
    uint8_t f_empty : 1;
    mojo::internal::Pointer<internal::IDBKey_Data> f_key;
    mojo::internal::Pointer<internal::IDBReturnValue_Data> f_value;
    uint64_t unknown;
  };

  uint32_t size;
  IDBDatabaseGetResult_Tag tag;
  Union_ data;
};
static_assert(sizeof(IDBDatabaseGetResult_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(IDBDatabaseGetResult_Data)");


class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBDatabaseOpenCursorResult_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  IDBDatabaseOpenCursorResult_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~IDBDatabaseOpenCursorResult_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<IDBDatabaseOpenCursorResult_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class IDBDatabaseOpenCursorResult_Tag : uint32_t {

    
    kErrorResult,
    
    kEmpty,
    
    kValue,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::IDBError_Data> f_error_result;
    uint8_t f_empty : 1;
    mojo::internal::Pointer<internal::IDBDatabaseOpenCursorValue_Data> f_value;
    uint64_t unknown;
  };

  uint32_t size;
  IDBDatabaseOpenCursorResult_Tag tag;
  Union_ data;
};
static_assert(sizeof(IDBDatabaseOpenCursorResult_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(IDBDatabaseOpenCursorResult_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBKeyPath_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::IDBKeyPathData_Data data;

 private:
  friend class mojo::internal::MessageFragment<IDBKeyPath_Data>;

  IDBKeyPath_Data();
  ~IDBKeyPath_Data() = delete;
};
static_assert(sizeof(IDBKeyPath_Data) == 24,
              "Bad sizeof(IDBKeyPath_Data)");
// Used by IDBKeyPath::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBKeyPath_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBKeyPath_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBKeyPath_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBKeyPath_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBKeyPath_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBKeyRange_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::IDBKey_Data lower;
  internal::IDBKey_Data upper;
  uint8_t lower_open : 1;
  uint8_t upper_open : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<IDBKeyRange_Data>;

  IDBKeyRange_Data();
  ~IDBKeyRange_Data() = delete;
};
static_assert(sizeof(IDBKeyRange_Data) == 48,
              "Bad sizeof(IDBKeyRange_Data)");
// Used by IDBKeyRange::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBKeyRange_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBKeyRange_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBKeyRange_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBKeyRange_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBKeyRange_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBIndexMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> name;
  mojo::internal::Pointer<internal::IDBKeyPath_Data> key_path;
  uint8_t unique : 1;
  uint8_t multi_entry : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<IDBIndexMetadata_Data>;

  IDBIndexMetadata_Data();
  ~IDBIndexMetadata_Data() = delete;
};
static_assert(sizeof(IDBIndexMetadata_Data) == 40,
              "Bad sizeof(IDBIndexMetadata_Data)");
// Used by IDBIndexMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBIndexMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBIndexMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBIndexMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBIndexMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBIndexMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBObjectStoreMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t id;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> name;
  mojo::internal::Pointer<internal::IDBKeyPath_Data> key_path;
  uint8_t auto_increment : 1;
  uint8_t pad3_[7];
  int64_t max_index_id;
  mojo::internal::Pointer<mojo::internal::Map_Data<int64_t, mojo::internal::Pointer<internal::IDBIndexMetadata_Data>>> indexes;

 private:
  friend class mojo::internal::MessageFragment<IDBObjectStoreMetadata_Data>;

  IDBObjectStoreMetadata_Data();
  ~IDBObjectStoreMetadata_Data() = delete;
};
static_assert(sizeof(IDBObjectStoreMetadata_Data) == 56,
              "Bad sizeof(IDBObjectStoreMetadata_Data)");
// Used by IDBObjectStoreMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBObjectStoreMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBObjectStoreMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBObjectStoreMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBObjectStoreMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBObjectStoreMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBDatabaseMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> name;
  int64_t version;
  int64_t max_object_store_id;
  mojo::internal::Pointer<mojo::internal::Map_Data<int64_t, mojo::internal::Pointer<internal::IDBObjectStoreMetadata_Data>>> object_stores;
  uint8_t was_cold_open : 1;
  uint8_t is_sqlite : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<IDBDatabaseMetadata_Data>;

  IDBDatabaseMetadata_Data();
  ~IDBDatabaseMetadata_Data() = delete;
};
static_assert(sizeof(IDBDatabaseMetadata_Data) == 48,
              "Bad sizeof(IDBDatabaseMetadata_Data)");
// Used by IDBDatabaseMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBDatabaseMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBDatabaseMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBDatabaseMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBDatabaseMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBDatabaseMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBNameAndVersion_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> name;
  int64_t version;

 private:
  friend class mojo::internal::MessageFragment<IDBNameAndVersion_Data>;

  IDBNameAndVersion_Data();
  ~IDBNameAndVersion_Data() = delete;
};
static_assert(sizeof(IDBNameAndVersion_Data) == 24,
              "Bad sizeof(IDBNameAndVersion_Data)");
// Used by IDBNameAndVersion::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBNameAndVersion_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBNameAndVersion_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBNameAndVersion_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBNameAndVersion_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBNameAndVersion_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBIndexKeys_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int64_t index_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<internal::IDBKey_Data>> index_keys;

 private:
  friend class mojo::internal::MessageFragment<IDBIndexKeys_Data>;

  IDBIndexKeys_Data();
  ~IDBIndexKeys_Data() = delete;
};
static_assert(sizeof(IDBIndexKeys_Data) == 24,
              "Bad sizeof(IDBIndexKeys_Data)");
// Used by IDBIndexKeys::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBIndexKeys_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBIndexKeys_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBIndexKeys_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBIndexKeys_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBIndexKeys_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBFileInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> name;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> last_modified;

 private:
  friend class mojo::internal::MessageFragment<IDBFileInfo_Data>;

  IDBFileInfo_Data();
  ~IDBFileInfo_Data() = delete;
};
static_assert(sizeof(IDBFileInfo_Data) == 24,
              "Bad sizeof(IDBFileInfo_Data)");
// Used by IDBFileInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBFileInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBFileInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBFileInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBFileInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBFileInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBBlobInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data blob;
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> mime_type;
  int64_t size;
  mojo::internal::Pointer<internal::IDBFileInfo_Data> file;

 private:
  friend class mojo::internal::MessageFragment<IDBBlobInfo_Data>;

  IDBBlobInfo_Data();
  ~IDBBlobInfo_Data() = delete;
};
static_assert(sizeof(IDBBlobInfo_Data) == 40,
              "Bad sizeof(IDBBlobInfo_Data)");
// Used by IDBBlobInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBBlobInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBBlobInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBBlobInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBBlobInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBBlobInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBValue_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> bits;
  mojo::internal::Pointer<mojo::internal::Array_Data<internal::IDBExternalObject_Data>> external_objects;

 private:
  friend class mojo::internal::MessageFragment<IDBValue_Data>;

  IDBValue_Data();
  ~IDBValue_Data() = delete;
};
static_assert(sizeof(IDBValue_Data) == 24,
              "Bad sizeof(IDBValue_Data)");
// Used by IDBValue::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBValue_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBValue_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBValue_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBValue_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBValue_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBReturnValue_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::IDBValue_Data> value;
  internal::IDBKey_Data primary_key;
  mojo::internal::Pointer<internal::IDBKeyPath_Data> key_path;

 private:
  friend class mojo::internal::MessageFragment<IDBReturnValue_Data>;

  IDBReturnValue_Data();
  ~IDBReturnValue_Data() = delete;
};
static_assert(sizeof(IDBReturnValue_Data) == 40,
              "Bad sizeof(IDBReturnValue_Data)");
// Used by IDBReturnValue::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBReturnValue_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBReturnValue_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBReturnValue_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBReturnValue_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBReturnValue_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBRecord_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::IDBKey_Data primary_key;
  mojo::internal::Pointer<internal::IDBReturnValue_Data> return_value;
  internal::IDBKey_Data index_key;

 private:
  friend class mojo::internal::MessageFragment<IDBRecord_Data>;

  IDBRecord_Data();
  ~IDBRecord_Data() = delete;
};
static_assert(sizeof(IDBRecord_Data) == 48,
              "Bad sizeof(IDBRecord_Data)");
// Used by IDBRecord::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBRecord_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBRecord_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBRecord_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBRecord_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBRecord_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBError_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::String16_Data> error_message;

 private:
  friend class mojo::internal::MessageFragment<IDBError_Data>;

  IDBError_Data();
  ~IDBError_Data() = delete;
};
static_assert(sizeof(IDBError_Data) == 24,
              "Bad sizeof(IDBError_Data)");
// Used by IDBError::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBError_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBError_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBError_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBError_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBError_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBCursorValue_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<internal::IDBKey_Data>> keys;
  mojo::internal::Pointer<mojo::internal::Array_Data<internal::IDBKey_Data>> primary_keys;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::IDBValue_Data>>> values;

 private:
  friend class mojo::internal::MessageFragment<IDBCursorValue_Data>;

  IDBCursorValue_Data();
  ~IDBCursorValue_Data() = delete;
};
static_assert(sizeof(IDBCursorValue_Data) == 32,
              "Bad sizeof(IDBCursorValue_Data)");
// Used by IDBCursorValue::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBCursorValue_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBCursorValue_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBCursorValue_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBCursorValue_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBCursorValue_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) IDBDatabaseOpenCursorValue_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::AssociatedInterface_Data cursor;
  internal::IDBKey_Data key;
  internal::IDBKey_Data primary_key;
  mojo::internal::Pointer<internal::IDBValue_Data> value;

 private:
  friend class mojo::internal::MessageFragment<IDBDatabaseOpenCursorValue_Data>;

  IDBDatabaseOpenCursorValue_Data();
  ~IDBDatabaseOpenCursorValue_Data() = delete;
};
static_assert(sizeof(IDBDatabaseOpenCursorValue_Data) == 56,
              "Bad sizeof(IDBDatabaseOpenCursorValue_Data)");
// Used by IDBDatabaseOpenCursorValue::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct IDBDatabaseOpenCursorValue_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  IDBDatabaseOpenCursorValue_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~IDBDatabaseOpenCursorValue_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<IDBDatabaseOpenCursorValue_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    IDBDatabaseOpenCursorValue_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_INDEXEDDB_INDEXEDDB_MOJOM_SHARED_INTERNAL_H_