// third_party/blink/public/mojom/hyphenation/hyphenation.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ReadOnlyFile as mojoBase_mojom_ReadOnlyFile,
  ReadOnlyFileSpec as mojoBase_mojom_ReadOnlyFileSpec
} from '../../../../../mojo/public/mojom/base/file.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HyphenationPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.Hyphenation', scope);
  }
}

/** @interface */
export class HyphenationInterface {
  
  /**
   * @param { !string } locale
   * @return {!Promise<{
        hyphenationDictionaryHandle: ?mojoBase_mojom_ReadOnlyFile,
   *  }>}
   */

  openDictionary(locale) {}
}

/**
 * @implements { HyphenationInterface }
 */
export class HyphenationRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HyphenationPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HyphenationPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HyphenationPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } locale
   * @return {!Promise<{
        hyphenationDictionaryHandle: ?mojoBase_mojom_ReadOnlyFile,
   *  }>}
   */

  openDictionary(
      locale) {
    return this.proxy.sendMessage(
        0,
        Hyphenation_OpenDictionary_ParamsSpec.$,
        Hyphenation_OpenDictionary_ResponseParamsSpec.$,
        [
          locale
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Hyphenation
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HyphenationReceiver {
  /**
   * @param {!HyphenationInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HyphenationRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HyphenationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HyphenationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Hyphenation_OpenDictionary_ParamsSpec.$,
        Hyphenation_OpenDictionary_ResponseParamsSpec.$,
        impl.openDictionary.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Hyphenation {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.Hyphenation";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HyphenationRemote}
   */
  static getRemote() {
    let remote = new HyphenationRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Hyphenation
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HyphenationCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HyphenationRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HyphenationRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openDictionary =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Hyphenation_OpenDictionary_ParamsSpec.$,
        Hyphenation_OpenDictionary_ResponseParamsSpec.$,
        this.openDictionary.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Hyphenation_OpenDictionary_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Hyphenation_OpenDictionary_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    Hyphenation_OpenDictionary_ParamsSpec.$,
    'Hyphenation_OpenDictionary_Params',
    [
      mojo.internal.StructField(
        'locale', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Hyphenation_OpenDictionary_Params {
  constructor() {
    /** @type { !string } */
    this.locale;
  }
}



mojo.internal.Struct(
    Hyphenation_OpenDictionary_ResponseParamsSpec.$,
    'Hyphenation_OpenDictionary_ResponseParams',
    [
      mojo.internal.StructField(
        'hyphenationDictionaryHandle', 0,
        0,
        mojoBase_mojom_ReadOnlyFileSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Hyphenation_OpenDictionary_ResponseParams {
  constructor() {
    /** @type { (mojoBase_mojom_ReadOnlyFile|undefined) } */
    this.hyphenationDictionaryHandle;
  }
}

