// third_party/blink/public/mojom/hid/hid.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/hid/hid.mojom-shared-internal.h"
#include "services/device/public/mojom/hid.mojom-shared.h"


namespace blink::mojom {
class VendorAndProductDataView;

class HidDeviceFilterDataView;

class DeviceIdFilterDataView;
class UsageFilterDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::VendorAndProductDataView> {
  using Data = ::blink::mojom::internal::VendorAndProduct_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::HidDeviceFilterDataView> {
  using Data = ::blink::mojom::internal::HidDeviceFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DeviceIdFilterDataView> {
  using Data = ::blink::mojom::internal::DeviceIdFilter_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::blink::mojom::UsageFilterDataView> {
  using Data = ::blink::mojom::internal::UsageFilter_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class HidServiceInterfaceBase {};

using HidServicePtrDataView =
    mojo::InterfacePtrDataView<HidServiceInterfaceBase>;
using HidServiceRequestDataView =
    mojo::InterfaceRequestDataView<HidServiceInterfaceBase>;
using HidServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HidServiceInterfaceBase>;
using HidServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HidServiceInterfaceBase>;


class VendorAndProductDataView {
 public:
  VendorAndProductDataView() = default;

  VendorAndProductDataView(
      internal::VendorAndProduct_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t vendor() const {
    return data_->vendor;
  }
  uint16_t product() const {
    return data_->product;
  }
 private:
  internal::VendorAndProduct_Data* data_ = nullptr;
};


class HidDeviceFilterDataView {
 public:
  HidDeviceFilterDataView() = default;

  HidDeviceFilterDataView(
      internal::HidDeviceFilter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDeviceIdsDataView(
      DeviceIdFilterDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceIds(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DeviceIdFilterDataView, UserType>(),
    "Attempting to read the optional `device_ids` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeviceIds` instead "
    "of `ReadDeviceIds if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->device_ids.is_null() ? &data_->device_ids : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::DeviceIdFilterDataView>(
        pointer, output, message_);
  }
  inline void GetUsageDataView(
      UsageFilterDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::UsageFilterDataView, UserType>(),
    "Attempting to read the optional `usage` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUsage` instead "
    "of `ReadUsage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->usage.is_null() ? &data_->usage : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::UsageFilterDataView>(
        pointer, output, message_);
  }
 private:
  internal::HidDeviceFilter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeviceIdFilterDataView {
 public:
  using Tag = internal::DeviceIdFilter_Data::DeviceIdFilter_Tag;

  DeviceIdFilterDataView() = default;

  DeviceIdFilterDataView(
      internal::DeviceIdFilter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_vendor() const { return data_->tag == Tag::kVendor; }
  uint16_t vendor() const {
    CHECK(is_vendor());
    return data_->data.f_vendor;
  }
  bool is_vendor_and_product() const { return data_->tag == Tag::kVendorAndProduct; }
  inline void GetVendorAndProductDataView(
      VendorAndProductDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadVendorAndProduct(UserType* output) const {
    
    CHECK(is_vendor_and_product());
    return mojo::internal::Deserialize<::blink::mojom::VendorAndProductDataView>(
        data_->data.f_vendor_and_product.Get(), output, message_);
  }

 private:
  internal::DeviceIdFilter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class UsageFilterDataView {
 public:
  using Tag = internal::UsageFilter_Data::UsageFilter_Tag;

  UsageFilterDataView() = default;

  UsageFilterDataView(
      internal::UsageFilter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_page() const { return data_->tag == Tag::kPage; }
  uint16_t page() const {
    CHECK(is_page());
    return data_->data.f_page;
  }
  bool is_usage_and_page() const { return data_->tag == Tag::kUsageAndPage; }
  inline void GetUsageAndPageDataView(
      ::device::mojom::HidUsageAndPageDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUsageAndPage(UserType* output) const {
    
    CHECK(is_usage_and_page());
    return mojo::internal::Deserialize<::device::mojom::HidUsageAndPageDataView>(
        data_->data.f_usage_and_page.Get(), output, message_);
  }

 private:
  internal::UsageFilter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_HID_HID_MOJOM_DATA_VIEW_H_