// third_party/blink/public/mojom/frame/view_transition_state.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEW_TRANSITION_STATE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEW_TRANSITION_STATE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-shared-internal.h"
#include "services/viz/public/mojom/compositing/view_transition_element_resource_id.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/transform.mojom-shared.h"


namespace blink::mojom {
class ViewTransitionElementLayeredBoxPropertiesDataView;

class ViewTransitionElementDataView;

class ViewTransitionStateDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ViewTransitionElementLayeredBoxPropertiesDataView> {
  using Data = ::blink::mojom::internal::ViewTransitionElementLayeredBoxProperties_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ViewTransitionElementDataView> {
  using Data = ::blink::mojom::internal::ViewTransitionElement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ViewTransitionStateDataView> {
  using Data = ::blink::mojom::internal::ViewTransitionState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ViewTransitionPropertyId : int32_t {
  
  kBackdropFilter = 0,
  
  kBorderRadius = 1,
  
  kBorderWidth = 2,
  
  kColorScheme = 3,
  
  kCornerShape = 4,
  
  kMixBlendMode = 5,
  
  kTextOrientation = 6,
  
  kWritingMode = 7,
  kMinValue = 0,
  kMaxValue = 7,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ViewTransitionPropertyId value);
inline bool IsKnownEnumValue(ViewTransitionPropertyId value) {
  return internal::ViewTransitionPropertyId_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ViewTransitionElementBoxSizing : int32_t {
  
  kBorderBox = 0,
  
  kContentBox = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ViewTransitionElementBoxSizing value);
inline bool IsKnownEnumValue(ViewTransitionElementBoxSizing value) {
  return internal::ViewTransitionElementBoxSizing_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ViewTransitionElementLayeredBoxPropertiesDataView {
 public:
  ViewTransitionElementLayeredBoxPropertiesDataView() = default;

  ViewTransitionElementLayeredBoxPropertiesDataView(
      internal::ViewTransitionElementLayeredBoxProperties_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetContentBoxDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentBox(UserType* output) {
    
    auto* pointer = data_->content_box.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetPaddingBoxDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPaddingBox(UserType* output) {
    
    auto* pointer = data_->padding_box.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBoxSizing(UserType* output) const {
    auto data_value = data_->box_sizing;
    return mojo::internal::Deserialize<::blink::mojom::ViewTransitionElementBoxSizing>(
        data_value, output);
  }
  ViewTransitionElementBoxSizing box_sizing() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ViewTransitionElementBoxSizing>(data_->box_sizing));
  }
 private:
  internal::ViewTransitionElementLayeredBoxProperties_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ViewTransitionElementDataView {
 public:
  ViewTransitionElementDataView() = default;

  ViewTransitionElementDataView(
      internal::ViewTransitionElement_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTagNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTagName(UserType* output) {
    
    auto* pointer = data_->tag_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetBorderBoxRectInEnclosingLayerCssSpaceDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBorderBoxRectInEnclosingLayerCssSpace(UserType* output) {
    
    auto* pointer = data_->border_box_rect_in_enclosing_layer_css_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetViewportMatrixDataView(
      ::gfx::mojom::TransformDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewportMatrix(UserType* output) {
    
    auto* pointer = data_->viewport_matrix.Get();
    return mojo::internal::Deserialize<::gfx::mojom::TransformDataView>(
        pointer, output, message_);
  }
  inline void GetOverflowRectInLayoutSpaceDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOverflowRectInLayoutSpace(UserType* output) {
    
    auto* pointer = data_->overflow_rect_in_layout_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetCapturedRectInLayoutSpaceDataView(
      ::gfx::mojom::RectFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCapturedRectInLayoutSpace(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::RectFDataView, UserType>(),
    "Attempting to read the optional `captured_rect_in_layout_space` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCapturedRectInLayoutSpace` instead "
    "of `ReadCapturedRectInLayoutSpace if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->captured_rect_in_layout_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectFDataView>(
        pointer, output, message_);
  }
  inline void GetSnapshotIdDataView(
      ::viz::mojom::ViewTransitionElementResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSnapshotId(UserType* output) {
    
    auto* pointer = data_->snapshot_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
        pointer, output, message_);
  }
  int32_t paint_order() const {
    return data_->paint_order;
  }
  inline void GetCapturedCssPropertiesDataView(
      mojo::MapDataView<ViewTransitionPropertyId, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCapturedCssProperties(UserType* output) {
    
    auto* pointer = data_->captured_css_properties.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::ViewTransitionPropertyId, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetGroupChildrenCssPropertiesDataView(
      mojo::MapDataView<ViewTransitionPropertyId, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupChildrenCssProperties(UserType* output) {
    
    auto* pointer = data_->group_children_css_properties.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<::blink::mojom::ViewTransitionPropertyId, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetBorderOffsetDataView(
      ::gfx::mojom::Vector2dDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBorderOffset(UserType* output) {
    
    auto* pointer = data_->border_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::Vector2dDataView>(
        pointer, output, message_);
  }
  inline void GetClassListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClassList(UserType* output) {
    
    auto* pointer = data_->class_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetContainingGroupNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContainingGroupName(UserType* output) {
    
    auto* pointer = data_->containing_group_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLayeredBoxPropertiesDataView(
      ViewTransitionElementLayeredBoxPropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLayeredBoxProperties(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ViewTransitionElementLayeredBoxPropertiesDataView, UserType>(),
    "Attempting to read the optional `layered_box_properties` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLayeredBoxProperties` instead "
    "of `ReadLayeredBoxProperties if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->layered_box_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewTransitionElementLayeredBoxPropertiesDataView>(
        pointer, output, message_);
  }
 private:
  internal::ViewTransitionElement_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ViewTransitionStateDataView {
 public:
  ViewTransitionStateDataView() = default;

  ViewTransitionStateDataView(
      internal::ViewTransitionState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetElementsDataView(
      mojo::ArrayDataView<ViewTransitionElementDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElements(UserType* output) {
    
    auto* pointer = data_->elements.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ViewTransitionElementDataView>>(
        pointer, output, message_);
  }
  inline void GetTransitionTokenDataView(
      ::blink::mojom::ViewTransitionTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransitionToken(UserType* output) {
    
    auto* pointer = data_->transition_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewTransitionTokenDataView>(
        pointer, output, message_);
  }
  inline void GetSnapshotRootSizeAtCaptureDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSnapshotRootSizeAtCapture(UserType* output) {
    
    auto* pointer = data_->snapshot_root_size_at_capture.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float device_pixel_ratio() const {
    return data_->device_pixel_ratio;
  }
  uint32_t next_element_resource_id() const {
    return data_->next_element_resource_id;
  }
  inline void GetSubframeSnapshotIdDataView(
      ::viz::mojom::ViewTransitionElementResourceIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubframeSnapshotId(UserType* output) {
    
    auto* pointer = data_->subframe_snapshot_id.Get();
    return mojo::internal::Deserialize<::viz::mojom::ViewTransitionElementResourceIdDataView>(
        pointer, output, message_);
  }
  inline void GetIdToAutoNameMapDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIdToAutoNameMap(UserType* output) {
    
    auto* pointer = data_->id_to_auto_name_map.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ViewTransitionState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_VIEW_TRANSITION_STATE_MOJOM_DATA_VIEW_H_