// third_party/blink/public/mojom/frame/policy_container.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  ConnectionAllowlists as network_mojom_ConnectionAllowlists,
  ConnectionAllowlistsSpec as network_mojom_ConnectionAllowlistsSpec
} from '../../../../../services/network/public/mojom/connection_allowlist.mojom.m.js';

import {
  ContentSecurityPolicy as network_mojom_ContentSecurityPolicy,
  ContentSecurityPolicySpec as network_mojom_ContentSecurityPolicySpec
} from '../../../../../services/network/public/mojom/content_security_policy.mojom.m.js';

import {
  CrossOriginEmbedderPolicy as network_mojom_CrossOriginEmbedderPolicy,
  CrossOriginEmbedderPolicySpec as network_mojom_CrossOriginEmbedderPolicySpec
} from '../../../../../services/network/public/mojom/cross_origin_embedder_policy.mojom.m.js';

import {
  IntegrityPolicy as network_mojom_IntegrityPolicy,
  IntegrityPolicySpec as network_mojom_IntegrityPolicySpec
} from '../../../../../services/network/public/mojom/integrity_policy.mojom.m.js';

import {
  IPAddressSpace as network_mojom_IPAddressSpace,
  IPAddressSpaceSpec as network_mojom_IPAddressSpaceSpec
} from '../../../../../services/network/public/mojom/ip_address_space.mojom.m.js';

import {
  ReferrerPolicy as network_mojom_ReferrerPolicy,
  ReferrerPolicySpec as network_mojom_ReferrerPolicySpec
} from '../../../../../services/network/public/mojom/referrer_policy.mojom.m.js';

import {
  WebSandboxFlags as network_mojom_WebSandboxFlags,
  WebSandboxFlagsSpec as network_mojom_WebSandboxFlagsSpec
} from '../../../../../services/network/public/mojom/web_sandbox_flags.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PolicyContainerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.PolicyContainerHost', scope);
  }
}

/** @interface */
export class PolicyContainerHostInterface {
  
  /**
   * @param { !network_mojom_ReferrerPolicy } referrerPolicy
   */

  setReferrerPolicy(referrerPolicy) {}
  
  /**
   * @param { !Array<!network_mojom_ContentSecurityPolicy> } contentSecurityPolicies
   */

  addContentSecurityPolicies(contentSecurityPolicies) {}
}

/**
 * @implements { PolicyContainerHostInterface }
 */
export class PolicyContainerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PolicyContainerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PolicyContainerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PolicyContainerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_ReferrerPolicy } referrerPolicy
   */

  setReferrerPolicy(
      referrerPolicy) {
    this.proxy.sendMessage(
        0,
        PolicyContainerHost_SetReferrerPolicy_ParamsSpec.$,
        null,
        [
          referrerPolicy
        ],
        false);
  }

  
  /**
   * @param { !Array<!network_mojom_ContentSecurityPolicy> } contentSecurityPolicies
   */

  addContentSecurityPolicies(
      contentSecurityPolicies) {
    this.proxy.sendMessage(
        1,
        PolicyContainerHost_AddContentSecurityPolicies_ParamsSpec.$,
        null,
        [
          contentSecurityPolicies
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PolicyContainerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PolicyContainerHostReceiver {
  /**
   * @param {!PolicyContainerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PolicyContainerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PolicyContainerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PolicyContainerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PolicyContainerHost_SetReferrerPolicy_ParamsSpec.$,
        null,
        impl.setReferrerPolicy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PolicyContainerHost_AddContentSecurityPolicies_ParamsSpec.$,
        null,
        impl.addContentSecurityPolicies.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PolicyContainerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.PolicyContainerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PolicyContainerHostRemote}
   */
  static getRemote() {
    let remote = new PolicyContainerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PolicyContainerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PolicyContainerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PolicyContainerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PolicyContainerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReferrerPolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PolicyContainerHost_SetReferrerPolicy_ParamsSpec.$,
        null,
        this.setReferrerPolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addContentSecurityPolicies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PolicyContainerHost_AddContentSecurityPolicies_ParamsSpec.$,
        null,
        this.addContentSecurityPolicies.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PolicyContainerPoliciesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PolicyContainerSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PolicyContainerBindParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PolicyContainerHost_SetReferrerPolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PolicyContainerHost_AddContentSecurityPolicies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PolicyContainerPoliciesSpec.$,
    'PolicyContainerPolicies',
    [
      mojo.internal.StructField(
        'connectionAllowlists', 0,
        0,
        network_mojom_ConnectionAllowlistsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'crossOriginEmbedderPolicy', 8,
        0,
        network_mojom_CrossOriginEmbedderPolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'integrityPolicy', 16,
        0,
        network_mojom_IntegrityPolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'integrityPolicyReportOnly', 24,
        0,
        network_mojom_IntegrityPolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'referrerPolicy', 32,
        0,
        network_mojom_ReferrerPolicySpec.$,
        network_mojom_ReferrerPolicy.kDefault,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentSecurityPolicies', 40,
        0,
        mojo.internal.Array(network_mojom_ContentSecurityPolicySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isCredentialless', 36,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sandboxFlags', 48,
        0,
        network_mojom_WebSandboxFlagsSpec.$,
        network_mojom_WebSandboxFlags.kNone,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ipAddressSpace', 52,
        0,
        network_mojom_IPAddressSpaceSpec.$,
        network_mojom_IPAddressSpace.kUnknown,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'canNavigateTopWithoutUserGesture', 36,
        1,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'crossOriginIsolationEnabledByDip', 36,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class PolicyContainerPolicies {
  constructor() {
    /** @type { !network_mojom_ConnectionAllowlists } */
    this.connectionAllowlists;
    /** @type { !network_mojom_CrossOriginEmbedderPolicy } */
    this.crossOriginEmbedderPolicy;
    /** @type { !network_mojom_IntegrityPolicy } */
    this.integrityPolicy;
    /** @type { !network_mojom_IntegrityPolicy } */
    this.integrityPolicyReportOnly;
    /** @type { !network_mojom_ReferrerPolicy } */
    this.referrerPolicy;
    /** @type { !Array<!network_mojom_ContentSecurityPolicy> } */
    this.contentSecurityPolicies;
    /** @type { !boolean } */
    this.isCredentialless;
    /** @type { !network_mojom_WebSandboxFlags } */
    this.sandboxFlags;
    /** @type { !network_mojom_IPAddressSpace } */
    this.ipAddressSpace;
    /** @type { !boolean } */
    this.canNavigateTopWithoutUserGesture;
    /** @type { !boolean } */
    this.crossOriginIsolationEnabledByDip;
  }
}



mojo.internal.Struct(
    PolicyContainerSpec.$,
    'PolicyContainer',
    [
      mojo.internal.StructField(
        'policies', 0,
        0,
        PolicyContainerPoliciesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remote', 8,
        0,
        mojo.internal.AssociatedInterfaceProxy(PolicyContainerHostRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PolicyContainer {
  constructor() {
    /** @type { !PolicyContainerPolicies } */
    this.policies;
    /** @type { !Object } */
    this.remote;
  }
}



mojo.internal.Struct(
    PolicyContainerBindParamsSpec.$,
    'PolicyContainerBindParams',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.AssociatedInterfaceRequest(PolicyContainerHostPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PolicyContainerBindParams {
  constructor() {
    /** @type { !Object } */
    this.receiver;
  }
}



mojo.internal.Struct(
    PolicyContainerHost_SetReferrerPolicy_ParamsSpec.$,
    'PolicyContainerHost_SetReferrerPolicy_Params',
    [
      mojo.internal.StructField(
        'referrerPolicy', 0,
        0,
        network_mojom_ReferrerPolicySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PolicyContainerHost_SetReferrerPolicy_Params {
  constructor() {
    /** @type { !network_mojom_ReferrerPolicy } */
    this.referrerPolicy;
  }
}



mojo.internal.Struct(
    PolicyContainerHost_AddContentSecurityPolicies_ParamsSpec.$,
    'PolicyContainerHost_AddContentSecurityPolicies_Params',
    [
      mojo.internal.StructField(
        'contentSecurityPolicies', 0,
        0,
        mojo.internal.Array(network_mojom_ContentSecurityPolicySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PolicyContainerHost_AddContentSecurityPolicies_Params {
  constructor() {
    /** @type { !Array<!network_mojom_ContentSecurityPolicy> } */
    this.contentSecurityPolicies;
  }
}

