// third_party/blink/public/mojom/frame/frame_policy.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/frame/frame_policy.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var web_sandbox_flags$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/web_sandbox_flags.mojom', '../../../../../services/network/public/mojom/web_sandbox_flags.mojom.js');
  }
  var deferred_fetch_policy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/deferred_fetch_policy.mojom', 'deferred_fetch_policy.mojom.js');
  }
  var permissions_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/permissions_policy/permissions_policy.mojom', '../../../../../services/network/public/mojom/permissions_policy/permissions_policy.mojom.js');
  }
  var document_policy_feature$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/permissions_policy/document_policy_feature.mojom', '../permissions_policy/document_policy_feature.mojom.js');
  }
  var policy_value$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/permissions_policy/policy_value.mojom', '../permissions_policy/policy_value.mojom.js');
  }



  function FramePolicy(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FramePolicy.prototype.initDefaults_ = function() {
    this.sandboxFlags = 0;
    this.deferredFetchPolicy = 0;
    this.containerPolicy = null;
    this.requiredDocumentPolicy = null;
  };
  FramePolicy.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FramePolicy.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FramePolicy.sandboxFlags
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, web_sandbox_flags$.WebSandboxFlags);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FramePolicy.containerPolicy
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FramePolicy.requiredDocumentPolicy
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 16, false, new codec.Enum(document_policy_feature$.DocumentPolicyFeature), policy_value$.PolicyValue, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FramePolicy.deferredFetchPolicy
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, deferred_fetch_policy$.DeferredFetchPolicy);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FramePolicy.encodedSize = codec.kStructHeaderSize + 24;

  FramePolicy.decode = function(decoder) {
    var packed;
    var val = new FramePolicy();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sandboxFlags =
        decoder.decodeStruct(new codec.Enum(web_sandbox_flags$.WebSandboxFlags));
    val.deferredFetchPolicy =
        decoder.decodeStruct(new codec.Enum(deferred_fetch_policy$.DeferredFetchPolicy));
    val.containerPolicy =
        decoder.decodeArrayPointer(new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration));
    val.requiredDocumentPolicy =
        decoder.decodeMapPointer(new codec.Enum(document_policy_feature$.DocumentPolicyFeature), policy_value$.PolicyValue);
    return val;
  };

  FramePolicy.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FramePolicy.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.sandboxFlags);
    encoder.encodeStruct(codec.Int32, val.deferredFetchPolicy);
    encoder.encodeArrayPointer(new codec.PointerTo(permissions_policy$.ParsedPermissionsPolicyDeclaration), val.containerPolicy);
    encoder.encodeMapPointer(new codec.Enum(document_policy_feature$.DocumentPolicyFeature), policy_value$.PolicyValue, val.requiredDocumentPolicy);
  };
  exports.FramePolicy = FramePolicy;
})();