// third_party/blink/public/mojom/frame/find_in_page.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.StopFindActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.StopFindAction = {
  
  kStopFindActionClearSelection: 0,
  kStopFindActionKeepSelection: 1,
  kStopFindActionActivateSelection: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.FindMatchUpdateTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.FindMatchUpdateType = {
  
  kFinalUpdate: 0,
  kMoreUpdatesComing: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FindInPagePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FindInPage.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.FindInPageInterface }
 */
blink.mojom.FindInPageRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FindInPagePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FindInPagePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FindInPagePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } requestId
   * @param { !string } searchText
   * @param { !blink.mojom.FindOptions } options
   */

  find(
      requestId,
      searchText,
      options) {
    this.proxy.sendMessage(
        0,
        blink.mojom.FindInPage_Find_ParamsSpec.$,
        null,
        [
          requestId,
          searchText,
          options
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.StopFindAction } action
   */

  stopFinding(
      action) {
    this.proxy.sendMessage(
        1,
        blink.mojom.FindInPage_StopFinding_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  
  /**
   */

  clearActiveFindMatch() {
    this.proxy.sendMessage(
        2,
        blink.mojom.FindInPage_ClearActiveFindMatch_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FindInPageClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        3,
        blink.mojom.FindInPage_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FindInPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FindInPageReceiver = class {
  /**
   * @param {!blink.mojom.FindInPageInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FindInPageRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FindInPageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FindInPageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FindInPage_Find_ParamsSpec.$,
        null,
        impl.find.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FindInPage_StopFinding_ParamsSpec.$,
        null,
        impl.stopFinding.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FindInPage_ClearActiveFindMatch_ParamsSpec.$,
        null,
        impl.clearActiveFindMatch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FindInPage_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FindInPage = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FindInPage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FindInPageRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FindInPageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FindInPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FindInPageCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FindInPageRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FindInPageRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.find =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FindInPage_Find_ParamsSpec.$,
        null,
        this.find.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopFinding =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FindInPage_StopFinding_ParamsSpec.$,
        null,
        this.stopFinding.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearActiveFindMatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FindInPage_ClearActiveFindMatch_ParamsSpec.$,
        null,
        this.clearActiveFindMatch.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FindInPage_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FindInPageClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FindInPageClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.FindInPageClientInterface }
 */
blink.mojom.FindInPageClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FindInPageClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FindInPageClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FindInPageClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } requestId
   * @param { !number } numberOfMatches
   * @param { !blink.mojom.FindMatchUpdateType } updateType
   */

  setNumberOfMatches(
      requestId,
      numberOfMatches,
      updateType) {
    this.proxy.sendMessage(
        0,
        blink.mojom.FindInPageClient_SetNumberOfMatches_ParamsSpec.$,
        null,
        [
          requestId,
          numberOfMatches,
          updateType
        ],
        false);
  }

  
  /**
   * @param { !number } requestId
   * @param { !gfx.mojom.Rect } activeMatchRect
   * @param { !number } activeMatchOrdinal
   * @param { !blink.mojom.FindMatchUpdateType } updateType
   */

  setActiveMatch(
      requestId,
      activeMatchRect,
      activeMatchOrdinal,
      updateType) {
    this.proxy.sendMessage(
        1,
        blink.mojom.FindInPageClient_SetActiveMatch_ParamsSpec.$,
        null,
        [
          requestId,
          activeMatchRect,
          activeMatchOrdinal,
          updateType
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FindInPageClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FindInPageClientReceiver = class {
  /**
   * @param {!blink.mojom.FindInPageClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FindInPageClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FindInPageClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FindInPageClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FindInPageClient_SetNumberOfMatches_ParamsSpec.$,
        null,
        impl.setNumberOfMatches.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FindInPageClient_SetActiveMatch_ParamsSpec.$,
        null,
        impl.setActiveMatch.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FindInPageClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FindInPageClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FindInPageClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FindInPageClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FindInPageClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FindInPageClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FindInPageClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FindInPageClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNumberOfMatches =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FindInPageClient_SetNumberOfMatches_ParamsSpec.$,
        null,
        this.setNumberOfMatches.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setActiveMatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FindInPageClient_SetActiveMatch_ParamsSpec.$,
        null,
        this.setActiveMatch.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FindOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FindInPage_Find_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FindInPage_StopFinding_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FindInPage_ClearActiveFindMatch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FindInPage_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FindInPageClient_SetNumberOfMatches_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FindInPageClient_SetActiveMatch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FindOptionsSpec.$,
    'FindOptions',
    [
      mojo.internal.StructField(
        'forward', 0,
        0,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'matchCase', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newSession', 0,
        2,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'findMatch', 0,
        3,
        mojo.internal.Bool,
        true,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'force', 0,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'runSynchronouslyForTesting', 0,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FindOptions = class {
  constructor() {
    /** @export { !boolean } */
    this.forward;
    /** @export { !boolean } */
    this.matchCase;
    /** @export { !boolean } */
    this.newSession;
    /** @export { !boolean } */
    this.findMatch;
    /** @export { !boolean } */
    this.force;
    /** @export { !boolean } */
    this.runSynchronouslyForTesting;
  }
};



mojo.internal.Struct(
    blink.mojom.FindInPage_Find_ParamsSpec.$,
    'FindInPage_Find_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'searchText', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 16,
        0,
        blink.mojom.FindOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.FindInPage_Find_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !string } */
    this.searchText;
    /** @export { !blink.mojom.FindOptions } */
    this.options;
  }
};



mojo.internal.Struct(
    blink.mojom.FindInPage_StopFinding_ParamsSpec.$,
    'FindInPage_StopFinding_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        blink.mojom.StopFindActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FindInPage_StopFinding_Params = class {
  constructor() {
    /** @export { !blink.mojom.StopFindAction } */
    this.action;
  }
};



mojo.internal.Struct(
    blink.mojom.FindInPage_ClearActiveFindMatch_ParamsSpec.$,
    'FindInPage_ClearActiveFindMatch_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.FindInPage_ClearActiveFindMatch_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FindInPage_SetClient_ParamsSpec.$,
    'FindInPage_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FindInPageClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FindInPage_SetClient_Params = class {
  constructor() {
    /** @export { !blink.mojom.FindInPageClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.FindInPageClient_SetNumberOfMatches_ParamsSpec.$,
    'FindInPageClient_SetNumberOfMatches_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'numberOfMatches', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updateType', 8,
        0,
        blink.mojom.FindMatchUpdateTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.FindInPageClient_SetNumberOfMatches_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !number } */
    this.numberOfMatches;
    /** @export { !blink.mojom.FindMatchUpdateType } */
    this.updateType;
  }
};



mojo.internal.Struct(
    blink.mojom.FindInPageClient_SetActiveMatch_ParamsSpec.$,
    'FindInPageClient_SetActiveMatch_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'activeMatchRect', 8,
        0,
        gfx.mojom.RectSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'activeMatchOrdinal', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'updateType', 16,
        0,
        blink.mojom.FindMatchUpdateTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.FindInPageClient_SetActiveMatch_Params = class {
  constructor() {
    /** @export { !number } */
    this.requestId;
    /** @export { !gfx.mojom.Rect } */
    this.activeMatchRect;
    /** @export { !number } */
    this.activeMatchOrdinal;
    /** @export { !blink.mojom.FindMatchUpdateType } */
    this.updateType;
  }
};

