// third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_BACK_FORWARD_CACHE_CONTROLLER_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_BACK_FORWARD_CACHE_CONTROLLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame/back_forward_cache_controller.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/script_source_location.mojom.h"
#include "third_party/blink/public/mojom/navigation/renderer_eviction_reason.mojom-forward.h"
#include "third_party/blink/public/mojom/scheduler/web_scheduler_tracked_feature.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class BackForwardCacheControllerHostProxy;

template <typename ImplRefTraits>
class BackForwardCacheControllerHostStub;

class BackForwardCacheControllerHostRequestValidator;


class BLINK_COMMON_EXPORT BackForwardCacheControllerHost
    : public BackForwardCacheControllerHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.BackForwardCacheControllerHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BackForwardCacheControllerHostInterfaceBase;
  using Proxy_ = BackForwardCacheControllerHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = BackForwardCacheControllerHostStub<ImplRefTraits>;

  using RequestValidator_ = BackForwardCacheControllerHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kEvictFromBackForwardCacheMinVersion = 0,
    kDidChangeBackForwardCacheDisablingFeaturesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EvictFromBackForwardCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DidChangeBackForwardCacheDisablingFeatures_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BackForwardCacheControllerHost() = default;

  virtual void EvictFromBackForwardCache(::blink::mojom::RendererEvictionReason reason, ::blink::mojom::ScriptSourceLocationPtr source) = 0;

  virtual void DidChangeBackForwardCacheDisablingFeatures(std::vector<BlockingDetailsPtr> details) = 0;
};



class BLINK_COMMON_EXPORT BackForwardCacheControllerHostProxy
    : public BackForwardCacheControllerHost {
 public:
  using InterfaceType = BackForwardCacheControllerHost;

  explicit BackForwardCacheControllerHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EvictFromBackForwardCache(::blink::mojom::RendererEvictionReason reason, ::blink::mojom::ScriptSourceLocationPtr source) final;
  
  void DidChangeBackForwardCacheDisablingFeatures(std::vector<BlockingDetailsPtr> details) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT BackForwardCacheControllerHostStubDispatch {
 public:
  static bool Accept(BackForwardCacheControllerHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BackForwardCacheControllerHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BackForwardCacheControllerHost>>
class BackForwardCacheControllerHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BackForwardCacheControllerHostStub() = default;
  ~BackForwardCacheControllerHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackForwardCacheControllerHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BackForwardCacheControllerHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT BackForwardCacheControllerHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT BlockingDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BlockingDetails, T>::value>;
  using DataView = BlockingDetailsDataView;
  using Data_ = internal::BlockingDetails_Data;

  template <typename... Args>
  static BlockingDetailsPtr New(Args&&... args) {
    return BlockingDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BlockingDetailsPtr From(const U& u) {
    return mojo::TypeConverter<BlockingDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BlockingDetails>::Convert(*this);
  }


  BlockingDetails();

  BlockingDetails(
      ::blink::mojom::WebSchedulerTrackedFeature feature,
      ::blink::mojom::ScriptSourceLocationPtr source);

BlockingDetails(const BlockingDetails&) = delete;
BlockingDetails& operator=(const BlockingDetails&) = delete;

  ~BlockingDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BlockingDetailsPtr>
  BlockingDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BlockingDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BlockingDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BlockingDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BlockingDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BlockingDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BlockingDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BlockingDetails_UnserializedMessageContext<
            UserType, BlockingDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BlockingDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BlockingDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BlockingDetails_UnserializedMessageContext<
            UserType, BlockingDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BlockingDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::mojom::WebSchedulerTrackedFeature feature;
  
  ::blink::mojom::ScriptSourceLocationPtr source;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BlockingDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BlockingDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BlockingDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BlockingDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BlockingDetailsPtr BlockingDetails::Clone() const {
  return New(
      mojo::Clone(feature),
      mojo::Clone(source)
  );
}

template <typename T, BlockingDetails::EnableIfSame<T>*>
bool BlockingDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->feature, other_struct.feature))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  return true;
}

template <typename T, BlockingDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.feature < rhs.feature)
    return true;
  if (rhs.feature < lhs.feature)
    return false;
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::BlockingDetails::DataView,
                                         ::blink::mojom::BlockingDetailsPtr> {
  static bool IsNull(const ::blink::mojom::BlockingDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::BlockingDetailsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::BlockingDetails::feature) feature(
      const ::blink::mojom::BlockingDetailsPtr& input) {
    return input->feature;
  }

  static const decltype(::blink::mojom::BlockingDetails::source)& source(
      const ::blink::mojom::BlockingDetailsPtr& input) {
    return input->source;
  }

  static bool Read(::blink::mojom::BlockingDetails::DataView input, ::blink::mojom::BlockingDetailsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_BACK_FORWARD_CACHE_CONTROLLER_MOJOM_H_