// third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_observer_host.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

FileSystemAccessObserverHost::IPCStableHashFunction FileSystemAccessObserverHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemAccessObserverHost>(message.name())) {
    case messages::FileSystemAccessObserverHost::kObserve: {
      return &FileSystemAccessObserverHost::Observe_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessObserverHost::kUnobserve: {
      return &FileSystemAccessObserverHost::Unobserve_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemAccessObserverHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemAccessObserverHost>(message.name())) {
      case messages::FileSystemAccessObserverHost::kObserve:
            return "Receive blink::mojom::FileSystemAccessObserverHost::Observe";
      case messages::FileSystemAccessObserverHost::kUnobserve:
            return "Receive blink::mojom::FileSystemAccessObserverHost::Unobserve";
    }
  } else {
    switch (static_cast<messages::FileSystemAccessObserverHost>(message.name())) {
      case messages::FileSystemAccessObserverHost::kObserve:
            return "Receive reply blink::mojom::FileSystemAccessObserverHost::Observe";
      case messages::FileSystemAccessObserverHost::kUnobserve:
            return "Receive reply blink::mojom::FileSystemAccessObserverHost::Unobserve";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemAccessObserverHost::Observe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaef4700e;  // IPCStableHash for blink::mojom::FileSystemAccessObserverHost::Observe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessObserverHost::Unobserve_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xde21e77e;  // IPCStableHash for blink::mojom::FileSystemAccessObserverHost::Unobserve
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FileSystemAccessObserverHost_Observe_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessObserverHost_Observe_ForwardToCallback(
      FileSystemAccessObserverHost::ObserveCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessObserverHost_Observe_ForwardToCallback(const FileSystemAccessObserverHost_Observe_ForwardToCallback&) = delete;
  FileSystemAccessObserverHost_Observe_ForwardToCallback& operator=(const FileSystemAccessObserverHost_Observe_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessObserverHost::ObserveCallback callback_;
};

FileSystemAccessObserverHostProxy::FileSystemAccessObserverHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessObserverHostProxy::Observe(
    ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> in_token, bool in_is_recursive, ObserveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessObserverHost::Observe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_recursive"), in_is_recursive,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessObserverHost::kObserve), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessObserverHost_Observe_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_token,
    &params->token,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->token)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid token in FileSystemAccessObserverHost.Observe request");

  params->is_recursive = in_is_recursive;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessObserverHost::Name_);
  message.set_method_name("Observe");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessObserverHost_Observe_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessObserverHostProxy::Unobserve(
    ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessObserverHost::Unobserve", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessObserverHost::kUnobserve), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessObserverHost_Unobserve_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::FileSystemAccessTransferTokenInterfaceBase>>(
    in_token,
    &params->token,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->token)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid token in FileSystemAccessObserverHost.Unobserve request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessObserverHost::Name_);
  message.set_method_name("Unobserve");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class FileSystemAccessObserverHost_Observe_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessObserverHost::ObserveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessObserverHost_Observe_ProxyToResponder> proxy(
        new FileSystemAccessObserverHost_Observe_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessObserverHost_Observe_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessObserverHost_Observe_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessObserverHost_Observe_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessObserverHost::ObserveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::FileSystemAccessErrorPtr in_result, ::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessObserver> in_observer_receiver);
};

bool FileSystemAccessObserverHost_Observe_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessObserverHost_Observe_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessObserverHost_Observe_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessObserverHost.0
  bool success = true;
  ::blink::mojom::blink::FileSystemAccessErrorPtr p_result{};
  ::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessObserver> p_observer_receiver{};
  FileSystemAccessObserverHost_Observe_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success) {
    p_observer_receiver =
        input_data_view.TakeObserverReceiver<decltype(p_observer_receiver)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessObserverHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_observer_receiver));
  }
  return true;
}

void FileSystemAccessObserverHost_Observe_ProxyToResponder::Run(
    ::blink::mojom::blink::FileSystemAccessErrorPtr in_result, ::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessObserver> in_observer_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessObserverHost::Observe", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::blink::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer_receiver"), in_observer_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessObserver>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessObserverHost::kObserve), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessObserverHost_Observe_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::FileSystemAccessObserverInterfaceBase>>(
    in_observer_receiver,
    &params->observer_receiver,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessObserverHost::Name_);
  message.set_method_name("Observe");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessObserverHostStubDispatch::Accept(
    FileSystemAccessObserverHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemAccessObserverHost>(message->header()->name)) {
    case messages::FileSystemAccessObserverHost::kObserve: {
      break;
    }
    case messages::FileSystemAccessObserverHost::kUnobserve: {
      DCHECK(message->is_serialized());
      internal::FileSystemAccessObserverHost_Unobserve_Params_Data* params =
          reinterpret_cast<internal::FileSystemAccessObserverHost_Unobserve_Params_Data*>(
              message->mutable_payload());
      

      // Validation for FileSystemAccessObserverHost.1
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> p_token{};
      FileSystemAccessObserverHost_Unobserve_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessObserverHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unobserve(        
        std::move(p_token));
      return true;
    }
  }
  return false;
}

// static
bool FileSystemAccessObserverHostStubDispatch::AcceptWithResponder(
    FileSystemAccessObserverHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemAccessObserverHost>(message->header()->name)) {
    case messages::FileSystemAccessObserverHost::kObserve: {
      internal::FileSystemAccessObserverHost_Observe_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessObserverHost_Observe_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessObserverHost.0
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> p_token{};
      bool p_is_recursive{};
      FileSystemAccessObserverHost_Observe_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (success)
        p_is_recursive = input_data_view.is_recursive();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessObserverHost::Name_, 0, false);
        return false;
      }
      auto callback =
          FileSystemAccessObserverHost_Observe_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Observe(        
        std::move(p_token), 
        std::move(p_is_recursive), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessObserverHost::kUnobserve: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemAccessObserverHostValidationInfo[] = {
    { &internal::FileSystemAccessObserverHost_Observe_Params_Data::Validate,
     &internal::FileSystemAccessObserverHost_Observe_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessObserverHost_Unobserve_Params_Data::Validate,
     nullptr /* no response */},
};

bool FileSystemAccessObserverHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::FileSystemAccessObserverHost::Name_,
    kFileSystemAccessObserverHostValidationInfo);
}

bool FileSystemAccessObserverHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::FileSystemAccessObserverHost::Name_,
    kFileSystemAccessObserverHostValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void FileSystemAccessObserverHostInterceptorForTesting::Observe(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> token, bool is_recursive, ObserveCallback callback) {
  GetForwardingInterface()->Observe(
    std::move(token)
    , 
    std::move(is_recursive)
    , std::move(callback));
}
void FileSystemAccessObserverHostInterceptorForTesting::Unobserve(::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> token) {
  GetForwardingInterface()->Unobserve(
    std::move(token)
    );
}
FileSystemAccessObserverHostAsyncWaiter::FileSystemAccessObserverHostAsyncWaiter(
    FileSystemAccessObserverHost* proxy) : proxy_(proxy) {}

FileSystemAccessObserverHostAsyncWaiter::~FileSystemAccessObserverHostAsyncWaiter() = default;


void FileSystemAccessObserverHostAsyncWaiter::Observe(
    ::mojo::PendingRemote<::blink::mojom::blink::FileSystemAccessTransferToken> token, bool is_recursive, ::blink::mojom::blink::FileSystemAccessErrorPtr* out_result, ::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessObserver>* out_observer_receiver) {
  base::RunLoop loop;
  proxy_->Observe(
      std::move(token),
      std::move(is_recursive),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::FileSystemAccessErrorPtr* out_result
,
             ::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessObserver>* out_observer_receiver
,
             ::blink::mojom::blink::FileSystemAccessErrorPtr result,
             ::mojo::PendingReceiver<::blink::mojom::blink::FileSystemAccessObserver> observer_receiver) {*out_result = std::move(result);*out_observer_receiver = std::move(observer_receiver);
            loop->Quit();
          },
          &loop,
          out_result,
          out_observer_receiver));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif