// third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var file_system_access_error$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_error.mojom', 'file_system_access_error.mojom.js');
  }



  function FileSystemAccessFileWriter_Write_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileWriter_Write_Params.prototype.initDefaults_ = function() {
    this.offset = 0;
    this.stream = null;
  };
  FileSystemAccessFileWriter_Write_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileWriter_Write_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate FileSystemAccessFileWriter_Write_Params.stream
    err = messageValidator.validateHandle(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileWriter_Write_Params.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessFileWriter_Write_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileWriter_Write_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.offset =
        decoder.decodeStruct(codec.Uint64);
    val.stream =
        decoder.decodeStruct(codec.Handle);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FileSystemAccessFileWriter_Write_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileWriter_Write_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.offset);
    encoder.encodeStruct(codec.Handle, val.stream);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FileSystemAccessFileWriter_Write_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileWriter_Write_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
    this.bytesWritten = 0;
  };
  FileSystemAccessFileWriter_Write_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileWriter_Write_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileWriter_Write_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessFileWriter_Write_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  FileSystemAccessFileWriter_Write_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileWriter_Write_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    val.bytesWritten =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  FileSystemAccessFileWriter_Write_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileWriter_Write_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
    encoder.encodeStruct(codec.Uint64, val.bytesWritten);
  };
  function FileSystemAccessFileWriter_Truncate_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileWriter_Truncate_Params.prototype.initDefaults_ = function() {
    this.length = 0;
  };
  FileSystemAccessFileWriter_Truncate_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileWriter_Truncate_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessFileWriter_Truncate_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileWriter_Truncate_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileWriter_Truncate_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.length =
        decoder.decodeStruct(codec.Uint64);
    return val;
  };

  FileSystemAccessFileWriter_Truncate_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileWriter_Truncate_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint64, val.length);
  };
  function FileSystemAccessFileWriter_Truncate_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileWriter_Truncate_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  FileSystemAccessFileWriter_Truncate_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileWriter_Truncate_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileWriter_Truncate_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileWriter_Truncate_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileWriter_Truncate_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileWriter_Truncate_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    return val;
  };

  FileSystemAccessFileWriter_Truncate_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileWriter_Truncate_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
  };
  function FileSystemAccessFileWriter_Close_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileWriter_Close_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessFileWriter_Close_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileWriter_Close_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileWriter_Close_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessFileWriter_Close_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileWriter_Close_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessFileWriter_Close_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileWriter_Close_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessFileWriter_Close_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileWriter_Close_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  FileSystemAccessFileWriter_Close_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileWriter_Close_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileWriter_Close_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileWriter_Close_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileWriter_Close_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileWriter_Close_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    return val;
  };

  FileSystemAccessFileWriter_Close_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileWriter_Close_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
  };
  function FileSystemAccessFileWriter_Abort_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileWriter_Abort_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessFileWriter_Abort_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileWriter_Abort_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileWriter_Abort_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessFileWriter_Abort_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileWriter_Abort_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessFileWriter_Abort_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileWriter_Abort_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function FileSystemAccessFileWriter_Abort_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileWriter_Abort_ResponseParams.prototype.initDefaults_ = function() {
    this.result = null;
  };
  FileSystemAccessFileWriter_Abort_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileWriter_Abort_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FileSystemAccessFileWriter_Abort_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_system_access_error$.FileSystemAccessError, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileWriter_Abort_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileWriter_Abort_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileWriter_Abort_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.result =
        decoder.decodeStructPointer(file_system_access_error$.FileSystemAccessError);
    return val;
  };

  FileSystemAccessFileWriter_Abort_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileWriter_Abort_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_system_access_error$.FileSystemAccessError, val.result);
  };
  var kFileSystemAccessFileWriter_Write_Name = 0;
  var kFileSystemAccessFileWriter_Truncate_Name = 1;
  var kFileSystemAccessFileWriter_Close_Name = 2;
  var kFileSystemAccessFileWriter_Abort_Name = 3;

  function FileSystemAccessFileWriterPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileSystemAccessFileWriter,
                                                   handleOrPtrInfo);
  }

  function FileSystemAccessFileWriterAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileSystemAccessFileWriter, associatedInterfacePtrInfo);
  }

  FileSystemAccessFileWriterAssociatedPtr.prototype =
      Object.create(FileSystemAccessFileWriterPtr.prototype);
  FileSystemAccessFileWriterAssociatedPtr.prototype.constructor =
      FileSystemAccessFileWriterAssociatedPtr;

  function FileSystemAccessFileWriterProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileSystemAccessFileWriterPtr.prototype.write = function() {
    return FileSystemAccessFileWriterProxy.prototype.write
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileWriterProxy.prototype.write = function(offset, stream) {
    var params_ = new FileSystemAccessFileWriter_Write_Params();
    params_.offset = offset;
    params_.stream = stream;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileWriter_Write_Name,
          codec.align(FileSystemAccessFileWriter_Write_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileWriter_Write_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileWriter_Write_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileWriterPtr.prototype.truncate = function() {
    return FileSystemAccessFileWriterProxy.prototype.truncate
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileWriterProxy.prototype.truncate = function(length) {
    var params_ = new FileSystemAccessFileWriter_Truncate_Params();
    params_.length = length;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileWriter_Truncate_Name,
          codec.align(FileSystemAccessFileWriter_Truncate_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileWriter_Truncate_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileWriter_Truncate_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileWriterPtr.prototype.close = function() {
    return FileSystemAccessFileWriterProxy.prototype.close
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileWriterProxy.prototype.close = function() {
    var params_ = new FileSystemAccessFileWriter_Close_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileWriter_Close_Name,
          codec.align(FileSystemAccessFileWriter_Close_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileWriter_Close_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileWriter_Close_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileWriterPtr.prototype.abort = function() {
    return FileSystemAccessFileWriterProxy.prototype.abort
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileWriterProxy.prototype.abort = function() {
    var params_ = new FileSystemAccessFileWriter_Abort_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileWriter_Abort_Name,
          codec.align(FileSystemAccessFileWriter_Abort_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileWriter_Abort_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileWriter_Abort_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function FileSystemAccessFileWriterStub(delegate) {
    this.delegate_ = delegate;
  }
  FileSystemAccessFileWriterStub.prototype.write = function(offset, stream) {
    return this.delegate_ && this.delegate_.write && this.delegate_.write(offset, stream);
  }
  FileSystemAccessFileWriterStub.prototype.truncate = function(length) {
    return this.delegate_ && this.delegate_.truncate && this.delegate_.truncate(length);
  }
  FileSystemAccessFileWriterStub.prototype.close = function() {
    return this.delegate_ && this.delegate_.close && this.delegate_.close();
  }
  FileSystemAccessFileWriterStub.prototype.abort = function() {
    return this.delegate_ && this.delegate_.abort && this.delegate_.abort();
  }

  FileSystemAccessFileWriterStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  FileSystemAccessFileWriterStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessFileWriter_Write_Name:
      var params = reader.decodeStruct(FileSystemAccessFileWriter_Write_Params);
      this.write(params.offset, params.stream).then(function(response) {
        var responseParams =
            new FileSystemAccessFileWriter_Write_ResponseParams();
        responseParams.result = response.result;
        responseParams.bytesWritten = response.bytesWritten;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileWriter_Write_Name,
            codec.align(FileSystemAccessFileWriter_Write_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileWriter_Write_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileWriter_Truncate_Name:
      var params = reader.decodeStruct(FileSystemAccessFileWriter_Truncate_Params);
      this.truncate(params.length).then(function(response) {
        var responseParams =
            new FileSystemAccessFileWriter_Truncate_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileWriter_Truncate_Name,
            codec.align(FileSystemAccessFileWriter_Truncate_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileWriter_Truncate_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileWriter_Close_Name:
      var params = reader.decodeStruct(FileSystemAccessFileWriter_Close_Params);
      this.close().then(function(response) {
        var responseParams =
            new FileSystemAccessFileWriter_Close_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileWriter_Close_Name,
            codec.align(FileSystemAccessFileWriter_Close_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileWriter_Close_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kFileSystemAccessFileWriter_Abort_Name:
      var params = reader.decodeStruct(FileSystemAccessFileWriter_Abort_Params);
      this.abort().then(function(response) {
        var responseParams =
            new FileSystemAccessFileWriter_Abort_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileWriter_Abort_Name,
            codec.align(FileSystemAccessFileWriter_Abort_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileWriter_Abort_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFileSystemAccessFileWriterRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileSystemAccessFileWriter_Write_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileWriter_Write_Params;
      break;
      case kFileSystemAccessFileWriter_Truncate_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileWriter_Truncate_Params;
      break;
      case kFileSystemAccessFileWriter_Close_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileWriter_Close_Params;
      break;
      case kFileSystemAccessFileWriter_Abort_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileWriter_Abort_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileSystemAccessFileWriterResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFileSystemAccessFileWriter_Write_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileWriter_Write_ResponseParams;
        break;
      case kFileSystemAccessFileWriter_Truncate_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileWriter_Truncate_ResponseParams;
        break;
      case kFileSystemAccessFileWriter_Close_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileWriter_Close_ResponseParams;
        break;
      case kFileSystemAccessFileWriter_Abort_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileWriter_Abort_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FileSystemAccessFileWriter = {
    name: 'blink.mojom.FileSystemAccessFileWriter',
    kVersion: 0,
    ptrClass: FileSystemAccessFileWriterPtr,
    proxyClass: FileSystemAccessFileWriterProxy,
    stubClass: FileSystemAccessFileWriterStub,
    validateRequest: validateFileSystemAccessFileWriterRequest,
    validateResponse: validateFileSystemAccessFileWriterResponse,
  };
  FileSystemAccessFileWriterStub.prototype.validator = validateFileSystemAccessFileWriterRequest;
  FileSystemAccessFileWriterProxy.prototype.validator = validateFileSystemAccessFileWriterResponse;
  exports.FileSystemAccessFileWriter = FileSystemAccessFileWriter;
  exports.FileSystemAccessFileWriterPtr = FileSystemAccessFileWriterPtr;
  exports.FileSystemAccessFileWriterAssociatedPtr = FileSystemAccessFileWriterAssociatedPtr;
})();