// third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-import-headers.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_writer.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

FileSystemAccessFileWriter::IPCStableHashFunction FileSystemAccessFileWriter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileSystemAccessFileWriter>(message.name())) {
    case messages::FileSystemAccessFileWriter::kWrite: {
      return &FileSystemAccessFileWriter::Write_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileWriter::kTruncate: {
      return &FileSystemAccessFileWriter::Truncate_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileWriter::kClose: {
      return &FileSystemAccessFileWriter::Close_Sym::IPCStableHash;
    }
    case messages::FileSystemAccessFileWriter::kAbort: {
      return &FileSystemAccessFileWriter::Abort_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileSystemAccessFileWriter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileSystemAccessFileWriter>(message.name())) {
      case messages::FileSystemAccessFileWriter::kWrite:
            return "Receive blink::mojom::FileSystemAccessFileWriter::Write";
      case messages::FileSystemAccessFileWriter::kTruncate:
            return "Receive blink::mojom::FileSystemAccessFileWriter::Truncate";
      case messages::FileSystemAccessFileWriter::kClose:
            return "Receive blink::mojom::FileSystemAccessFileWriter::Close";
      case messages::FileSystemAccessFileWriter::kAbort:
            return "Receive blink::mojom::FileSystemAccessFileWriter::Abort";
    }
  } else {
    switch (static_cast<messages::FileSystemAccessFileWriter>(message.name())) {
      case messages::FileSystemAccessFileWriter::kWrite:
            return "Receive reply blink::mojom::FileSystemAccessFileWriter::Write";
      case messages::FileSystemAccessFileWriter::kTruncate:
            return "Receive reply blink::mojom::FileSystemAccessFileWriter::Truncate";
      case messages::FileSystemAccessFileWriter::kClose:
            return "Receive reply blink::mojom::FileSystemAccessFileWriter::Close";
      case messages::FileSystemAccessFileWriter::kAbort:
            return "Receive reply blink::mojom::FileSystemAccessFileWriter::Abort";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileSystemAccessFileWriter::Write_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x50076d60;  // IPCStableHash for blink::mojom::FileSystemAccessFileWriter::Write
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileWriter::Truncate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4da4971e;  // IPCStableHash for blink::mojom::FileSystemAccessFileWriter::Truncate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileWriter::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x14611040;  // IPCStableHash for blink::mojom::FileSystemAccessFileWriter::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t FileSystemAccessFileWriter::Abort_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2d68ea15;  // IPCStableHash for blink::mojom::FileSystemAccessFileWriter::Abort
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class FileSystemAccessFileWriter_Write_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileWriter_Write_ForwardToCallback(
      FileSystemAccessFileWriter::WriteCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileWriter_Write_ForwardToCallback(const FileSystemAccessFileWriter_Write_ForwardToCallback&) = delete;
  FileSystemAccessFileWriter_Write_ForwardToCallback& operator=(const FileSystemAccessFileWriter_Write_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileWriter::WriteCallback callback_;
};

class FileSystemAccessFileWriter_Truncate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileWriter_Truncate_ForwardToCallback(
      FileSystemAccessFileWriter::TruncateCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileWriter_Truncate_ForwardToCallback(const FileSystemAccessFileWriter_Truncate_ForwardToCallback&) = delete;
  FileSystemAccessFileWriter_Truncate_ForwardToCallback& operator=(const FileSystemAccessFileWriter_Truncate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileWriter::TruncateCallback callback_;
};

class FileSystemAccessFileWriter_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileWriter_Close_ForwardToCallback(
      FileSystemAccessFileWriter::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileWriter_Close_ForwardToCallback(const FileSystemAccessFileWriter_Close_ForwardToCallback&) = delete;
  FileSystemAccessFileWriter_Close_ForwardToCallback& operator=(const FileSystemAccessFileWriter_Close_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileWriter::CloseCallback callback_;
};

class FileSystemAccessFileWriter_Abort_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileSystemAccessFileWriter_Abort_ForwardToCallback(
      FileSystemAccessFileWriter::AbortCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileSystemAccessFileWriter_Abort_ForwardToCallback(const FileSystemAccessFileWriter_Abort_ForwardToCallback&) = delete;
  FileSystemAccessFileWriter_Abort_ForwardToCallback& operator=(const FileSystemAccessFileWriter_Abort_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileSystemAccessFileWriter::AbortCallback callback_;
};

FileSystemAccessFileWriterProxy::FileSystemAccessFileWriterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FileSystemAccessFileWriterProxy::Write(
    uint64_t in_offset, ::mojo::ScopedDataPipeConsumerHandle in_stream, WriteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileWriter::Write", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("offset"), in_offset,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("stream"), in_stream,
                        "<value of type ::mojo::ScopedDataPipeConsumerHandle>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileWriter::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileWriter_Write_Params_Data> params(
          message);
  params.Allocate();

  params->offset = in_offset;

  
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
    in_stream,
    &params->stream,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->stream)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid stream in FileSystemAccessFileWriter.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileWriter::Name_);
  message.set_method_name("Write");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileWriter_Write_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileWriterProxy::Truncate(
    uint64_t in_length, TruncateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::FileSystemAccessFileWriter::Truncate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("length"), in_length,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileWriter::kTruncate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileWriter_Truncate_Params_Data> params(
          message);
  params.Allocate();

  params->length = in_length;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileWriter::Name_);
  message.set_method_name("Truncate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileWriter_Truncate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileWriterProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessFileWriter::Close");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileWriter::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileWriter_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileWriter::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileWriter_Close_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void FileSystemAccessFileWriterProxy::Abort(
    AbortCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::FileSystemAccessFileWriter::Abort");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileWriter::kAbort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileWriter_Abort_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileWriter::Name_);
  message.set_method_name("Abort");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileSystemAccessFileWriter_Abort_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FileSystemAccessFileWriter_Write_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileWriter::WriteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileWriter_Write_ProxyToResponder> proxy(
        new FileSystemAccessFileWriter_Write_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileWriter_Write_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileWriter_Write_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileWriter_Write_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileWriter::WriteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result, uint64_t in_bytes_written);
};

bool FileSystemAccessFileWriter_Write_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileWriter_Write_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileWriter_Write_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileWriter.0
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  uint64_t p_bytes_written{};
  FileSystemAccessFileWriter_Write_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_bytes_written = input_data_view.bytes_written();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileWriter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_bytes_written));
  }
  return true;
}

void FileSystemAccessFileWriter_Write_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result, uint64_t in_bytes_written) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileWriter::Write", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes_written"), in_bytes_written,
                        "<value of type uint64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileWriter::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileWriter_Write_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

  params->bytes_written = in_bytes_written;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileWriter::Name_);
  message.set_method_name("Write");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileWriter_Truncate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileWriter::TruncateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileWriter_Truncate_ProxyToResponder> proxy(
        new FileSystemAccessFileWriter_Truncate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileWriter_Truncate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileWriter_Truncate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileWriter_Truncate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileWriter::TruncateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);
};

bool FileSystemAccessFileWriter_Truncate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileWriter_Truncate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileWriter_Truncate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileWriter.1
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessFileWriter_Truncate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileWriter::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileSystemAccessFileWriter_Truncate_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileWriter::Truncate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileWriter::kTruncate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileWriter_Truncate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileWriter::Name_);
  message.set_method_name("Truncate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileWriter_Close_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileWriter::CloseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileWriter_Close_ProxyToResponder> proxy(
        new FileSystemAccessFileWriter_Close_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileWriter_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileWriter_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileWriter_Close_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileWriter::CloseCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);
};

bool FileSystemAccessFileWriter_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileWriter_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileWriter_Close_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileWriter.2
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessFileWriter_Close_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileWriter::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileSystemAccessFileWriter_Close_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileWriter::Close", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileWriter::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileWriter_Close_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileWriter::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class FileSystemAccessFileWriter_Abort_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileSystemAccessFileWriter::AbortCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileSystemAccessFileWriter_Abort_ProxyToResponder> proxy(
        new FileSystemAccessFileWriter_Abort_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileSystemAccessFileWriter_Abort_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileSystemAccessFileWriter_Abort_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileSystemAccessFileWriter_Abort_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "FileSystemAccessFileWriter::AbortCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::FileSystemAccessErrorPtr in_result);
};

bool FileSystemAccessFileWriter_Abort_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileSystemAccessFileWriter_Abort_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileSystemAccessFileWriter_Abort_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for FileSystemAccessFileWriter.3
  bool success = true;
  ::blink::mojom::FileSystemAccessErrorPtr p_result{};
  FileSystemAccessFileWriter_Abort_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileSystemAccessFileWriter::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void FileSystemAccessFileWriter_Abort_ProxyToResponder::Run(
    ::blink::mojom::FileSystemAccessErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::FileSystemAccessFileWriter::Abort", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::mojom::FileSystemAccessErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileSystemAccessFileWriter::kAbort), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::FileSystemAccessFileWriter_Abort_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::FileSystemAccessErrorDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileSystemAccessFileWriter::Name_);
  message.set_method_name("Abort");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FileSystemAccessFileWriterStubDispatch::Accept(
    FileSystemAccessFileWriter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileSystemAccessFileWriter>(message->header()->name)) {
    case messages::FileSystemAccessFileWriter::kWrite: {
      break;
    }
    case messages::FileSystemAccessFileWriter::kTruncate: {
      break;
    }
    case messages::FileSystemAccessFileWriter::kClose: {
      break;
    }
    case messages::FileSystemAccessFileWriter::kAbort: {
      break;
    }
  }
  return false;
}

// static
bool FileSystemAccessFileWriterStubDispatch::AcceptWithResponder(
    FileSystemAccessFileWriter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileSystemAccessFileWriter>(message->header()->name)) {
    case messages::FileSystemAccessFileWriter::kWrite: {
      internal::FileSystemAccessFileWriter_Write_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileWriter_Write_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileWriter.0
      bool success = true;
      uint64_t p_offset{};
      ::mojo::ScopedDataPipeConsumerHandle p_stream{};
      FileSystemAccessFileWriter_Write_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_stream = input_data_view.TakeStream();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileWriter::Name_, 0, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileWriter_Write_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Write(        
        std::move(p_offset), 
        std::move(p_stream), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileWriter::kTruncate: {
      internal::FileSystemAccessFileWriter_Truncate_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileWriter_Truncate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileWriter.1
      bool success = true;
      uint64_t p_length{};
      FileSystemAccessFileWriter_Truncate_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileWriter::Name_, 1, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileWriter_Truncate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Truncate(        
        std::move(p_length), std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileWriter::kClose: {
      internal::FileSystemAccessFileWriter_Close_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileWriter_Close_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileWriter.2
      bool success = true;
      FileSystemAccessFileWriter_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileWriter::Name_, 2, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileWriter_Close_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
    case messages::FileSystemAccessFileWriter::kAbort: {
      internal::FileSystemAccessFileWriter_Abort_Params_Data* params =
          reinterpret_cast<
              internal::FileSystemAccessFileWriter_Abort_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for FileSystemAccessFileWriter.3
      bool success = true;
      FileSystemAccessFileWriter_Abort_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileSystemAccessFileWriter::Name_, 3, false);
        return false;
      }
      auto callback =
          FileSystemAccessFileWriter_Abort_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Abort(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kFileSystemAccessFileWriterValidationInfo[] = {
    { &internal::FileSystemAccessFileWriter_Write_Params_Data::Validate,
     &internal::FileSystemAccessFileWriter_Write_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileWriter_Truncate_Params_Data::Validate,
     &internal::FileSystemAccessFileWriter_Truncate_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileWriter_Close_Params_Data::Validate,
     &internal::FileSystemAccessFileWriter_Close_ResponseParams_Data::Validate},
    { &internal::FileSystemAccessFileWriter_Abort_Params_Data::Validate,
     &internal::FileSystemAccessFileWriter_Abort_ResponseParams_Data::Validate},
};

bool FileSystemAccessFileWriterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessFileWriter::Name_,
    kFileSystemAccessFileWriterValidationInfo);
}

bool FileSystemAccessFileWriterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::FileSystemAccessFileWriter::Name_,
    kFileSystemAccessFileWriterValidationInfo);
}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void FileSystemAccessFileWriterInterceptorForTesting::Write(uint64_t offset, ::mojo::ScopedDataPipeConsumerHandle stream, WriteCallback callback) {
  GetForwardingInterface()->Write(
    std::move(offset)
    , 
    std::move(stream)
    , std::move(callback));
}
void FileSystemAccessFileWriterInterceptorForTesting::Truncate(uint64_t length, TruncateCallback callback) {
  GetForwardingInterface()->Truncate(
    std::move(length)
    , std::move(callback));
}
void FileSystemAccessFileWriterInterceptorForTesting::Close(CloseCallback callback) {
  GetForwardingInterface()->Close(std::move(callback));
}
void FileSystemAccessFileWriterInterceptorForTesting::Abort(AbortCallback callback) {
  GetForwardingInterface()->Abort(std::move(callback));
}
FileSystemAccessFileWriterAsyncWaiter::FileSystemAccessFileWriterAsyncWaiter(
    FileSystemAccessFileWriter* proxy) : proxy_(proxy) {}

FileSystemAccessFileWriterAsyncWaiter::~FileSystemAccessFileWriterAsyncWaiter() = default;


void FileSystemAccessFileWriterAsyncWaiter::Write(
    uint64_t offset, ::mojo::ScopedDataPipeConsumerHandle stream, ::blink::mojom::FileSystemAccessErrorPtr* out_result, uint64_t* out_bytes_written) {
  base::RunLoop loop;
  proxy_->Write(
      std::move(offset),
      std::move(stream),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             uint64_t* out_bytes_written
,
             ::blink::mojom::FileSystemAccessErrorPtr result,
             uint64_t bytes_written) {*out_result = std::move(result);*out_bytes_written = std::move(bytes_written);
            loop->Quit();
          },
          &loop,
          out_result,
          out_bytes_written));
  loop.Run();
}



void FileSystemAccessFileWriterAsyncWaiter::Truncate(
    uint64_t length, ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Truncate(
      std::move(length),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::FileSystemAccessErrorPtr FileSystemAccessFileWriterAsyncWaiter::Truncate(
    uint64_t length) {
  ::blink::mojom::FileSystemAccessErrorPtr async_wait_result;
  Truncate(std::move(length),&async_wait_result);
  return async_wait_result;
}

void FileSystemAccessFileWriterAsyncWaiter::Close(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Close(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::FileSystemAccessErrorPtr FileSystemAccessFileWriterAsyncWaiter::Close(
    ) {
  ::blink::mojom::FileSystemAccessErrorPtr async_wait_result;
  Close(&async_wait_result);
  return async_wait_result;
}

void FileSystemAccessFileWriterAsyncWaiter::Abort(
    ::blink::mojom::FileSystemAccessErrorPtr* out_result) {
  base::RunLoop loop;
  proxy_->Abort(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::FileSystemAccessErrorPtr* out_result
,
             ::blink::mojom::FileSystemAccessErrorPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::mojom::FileSystemAccessErrorPtr FileSystemAccessFileWriterAsyncWaiter::Abort(
    ) {
  ::blink::mojom::FileSystemAccessErrorPtr async_wait_result;
  Abort(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif