// third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/file_system_access/file_system_access_file_modification_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');



  function FileSystemAccessFileModificationHost_RequestCapacityChange_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileModificationHost_RequestCapacityChange_Params.prototype.initDefaults_ = function() {
    this.capacityDelta = 0;
  };
  FileSystemAccessFileModificationHost_RequestCapacityChange_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileModificationHost_RequestCapacityChange_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessFileModificationHost_RequestCapacityChange_Params.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileModificationHost_RequestCapacityChange_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileModificationHost_RequestCapacityChange_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.capacityDelta =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  FileSystemAccessFileModificationHost_RequestCapacityChange_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileModificationHost_RequestCapacityChange_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.capacityDelta);
  };
  function FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams.prototype.initDefaults_ = function() {
    this.grantedCapacityDelta = 0;
  };
  FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.grantedCapacityDelta =
        decoder.decodeStruct(codec.Int64);
    return val;
  };

  FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.grantedCapacityDelta);
  };
  function FileSystemAccessFileModificationHost_OnContentsModified_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FileSystemAccessFileModificationHost_OnContentsModified_Params.prototype.initDefaults_ = function() {
  };
  FileSystemAccessFileModificationHost_OnContentsModified_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FileSystemAccessFileModificationHost_OnContentsModified_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FileSystemAccessFileModificationHost_OnContentsModified_Params.encodedSize = codec.kStructHeaderSize + 0;

  FileSystemAccessFileModificationHost_OnContentsModified_Params.decode = function(decoder) {
    var packed;
    var val = new FileSystemAccessFileModificationHost_OnContentsModified_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  FileSystemAccessFileModificationHost_OnContentsModified_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FileSystemAccessFileModificationHost_OnContentsModified_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kFileSystemAccessFileModificationHost_RequestCapacityChange_Name = 0;
  var kFileSystemAccessFileModificationHost_OnContentsModified_Name = 1;

  function FileSystemAccessFileModificationHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FileSystemAccessFileModificationHost,
                                                   handleOrPtrInfo);
  }

  function FileSystemAccessFileModificationHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FileSystemAccessFileModificationHost, associatedInterfacePtrInfo);
  }

  FileSystemAccessFileModificationHostAssociatedPtr.prototype =
      Object.create(FileSystemAccessFileModificationHostPtr.prototype);
  FileSystemAccessFileModificationHostAssociatedPtr.prototype.constructor =
      FileSystemAccessFileModificationHostAssociatedPtr;

  function FileSystemAccessFileModificationHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  FileSystemAccessFileModificationHostPtr.prototype.requestCapacityChange = function() {
    return FileSystemAccessFileModificationHostProxy.prototype.requestCapacityChange
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileModificationHostProxy.prototype.requestCapacityChange = function(capacityDelta) {
    var params_ = new FileSystemAccessFileModificationHost_RequestCapacityChange_Params();
    params_.capacityDelta = capacityDelta;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kFileSystemAccessFileModificationHost_RequestCapacityChange_Name,
          codec.align(FileSystemAccessFileModificationHost_RequestCapacityChange_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(FileSystemAccessFileModificationHost_RequestCapacityChange_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  FileSystemAccessFileModificationHostPtr.prototype.onContentsModified = function() {
    return FileSystemAccessFileModificationHostProxy.prototype.onContentsModified
        .apply(this.ptr.getProxy(), arguments);
  };

  FileSystemAccessFileModificationHostProxy.prototype.onContentsModified = function() {
    var params_ = new FileSystemAccessFileModificationHost_OnContentsModified_Params();
    var builder = new codec.MessageV0Builder(
        kFileSystemAccessFileModificationHost_OnContentsModified_Name,
        codec.align(FileSystemAccessFileModificationHost_OnContentsModified_Params.encodedSize));
    builder.encodeStruct(FileSystemAccessFileModificationHost_OnContentsModified_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FileSystemAccessFileModificationHostStub(delegate) {
    this.delegate_ = delegate;
  }
  FileSystemAccessFileModificationHostStub.prototype.requestCapacityChange = function(capacityDelta) {
    return this.delegate_ && this.delegate_.requestCapacityChange && this.delegate_.requestCapacityChange(capacityDelta);
  }
  FileSystemAccessFileModificationHostStub.prototype.onContentsModified = function() {
    return this.delegate_ && this.delegate_.onContentsModified && this.delegate_.onContentsModified();
  }

  FileSystemAccessFileModificationHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessFileModificationHost_OnContentsModified_Name:
      var params = reader.decodeStruct(FileSystemAccessFileModificationHost_OnContentsModified_Params);
      this.onContentsModified();
      return true;
    default:
      return false;
    }
  };

  FileSystemAccessFileModificationHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFileSystemAccessFileModificationHost_RequestCapacityChange_Name:
      var params = reader.decodeStruct(FileSystemAccessFileModificationHost_RequestCapacityChange_Params);
      this.requestCapacityChange(params.capacityDelta).then(function(response) {
        var responseParams =
            new FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams();
        responseParams.grantedCapacityDelta = response.grantedCapacityDelta;
        var builder = new codec.MessageV1Builder(
            kFileSystemAccessFileModificationHost_RequestCapacityChange_Name,
            codec.align(FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateFileSystemAccessFileModificationHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFileSystemAccessFileModificationHost_RequestCapacityChange_Name:
        if (message.expectsResponse())
          paramsClass = FileSystemAccessFileModificationHost_RequestCapacityChange_Params;
      break;
      case kFileSystemAccessFileModificationHost_OnContentsModified_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FileSystemAccessFileModificationHost_OnContentsModified_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFileSystemAccessFileModificationHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kFileSystemAccessFileModificationHost_RequestCapacityChange_Name:
        if (message.isResponse())
          paramsClass = FileSystemAccessFileModificationHost_RequestCapacityChange_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var FileSystemAccessFileModificationHost = {
    name: 'blink.mojom.FileSystemAccessFileModificationHost',
    kVersion: 0,
    ptrClass: FileSystemAccessFileModificationHostPtr,
    proxyClass: FileSystemAccessFileModificationHostProxy,
    stubClass: FileSystemAccessFileModificationHostStub,
    validateRequest: validateFileSystemAccessFileModificationHostRequest,
    validateResponse: validateFileSystemAccessFileModificationHostResponse,
  };
  FileSystemAccessFileModificationHostStub.prototype.validator = validateFileSystemAccessFileModificationHostRequest;
  FileSystemAccessFileModificationHostProxy.prototype.validator = validateFileSystemAccessFileModificationHostResponse;
  exports.FileSystemAccessFileModificationHost = FileSystemAccessFileModificationHost;
  exports.FileSystemAccessFileModificationHostPtr = FileSystemAccessFileModificationHostPtr;
  exports.FileSystemAccessFileModificationHostAssociatedPtr = FileSystemAccessFileModificationHostAssociatedPtr;
})();