// third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.FileError');
goog.require('mojoBase.mojom.BigBuffer');






goog.provide('blink.mojom.FileSystemAccessFileDelegateHost');
goog.provide('blink.mojom.FileSystemAccessFileDelegateHostReceiver');
goog.provide('blink.mojom.FileSystemAccessFileDelegateHostCallbackRouter');
goog.provide('blink.mojom.FileSystemAccessFileDelegateHostInterface');
goog.provide('blink.mojom.FileSystemAccessFileDelegateHostRemote');
goog.provide('blink.mojom.FileSystemAccessFileDelegateHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessFileDelegateHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessFileDelegateHost.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.FileSystemAccessFileDelegateHostInterface = class {
  
  /**
   * @param { !bigint } offset
   * @param { !number } bytesToRead
   * @return {!Promise<{
        data: ?mojoBase.mojom.BigBuffer,
        error: !mojoBase.mojom.FileError,
        bytesRead: !number,
   *  }>}
   */

  read(offset, bytesToRead) {}
  
  /**
   * @param { !bigint } offset
   * @param { !MojoHandle } data
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
        bytesWritten: !number,
   *  }>}
   */

  write(offset, data) {}
  
  /**
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
        length: !bigint,
   *  }>}
   */

  getLength() {}
  
  /**
   * @param { !bigint } length
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  setLength(length) {}
};

/**
 * @export
 * @implements { blink.mojom.FileSystemAccessFileDelegateHostInterface }
 */
blink.mojom.FileSystemAccessFileDelegateHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessFileDelegateHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessFileDelegateHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessFileDelegateHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } offset
   * @param { !number } bytesToRead
   * @return {!Promise<{
        data: ?mojoBase.mojom.BigBuffer,
        error: !mojoBase.mojom.FileError,
        bytesRead: !number,
   *  }>}
   */

  read(
      offset,
      bytesToRead) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessFileDelegateHost_Read_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_Read_ResponseParamsSpec.$,
        [
          offset,
          bytesToRead
        ],
        false);
  }

  
  /**
   * @param { !bigint } offset
   * @param { !MojoHandle } data
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
        bytesWritten: !number,
   *  }>}
   */

  write(
      offset,
      data) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.FileSystemAccessFileDelegateHost_Write_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_Write_ResponseParamsSpec.$,
        [
          offset,
          data
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
        length: !bigint,
   *  }>}
   */

  getLength() {
    return this.proxy.sendMessage(
        2,
        blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !bigint } length
   * @return {!Promise<{
        error: !mojoBase.mojom.FileError,
   *  }>}
   */

  setLength(
      length) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ResponseParamsSpec.$,
        [
          length
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessFileDelegateHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessFileDelegateHostReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessFileDelegateHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessFileDelegateHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessFileDelegateHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessFileDelegateHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessFileDelegateHost_Read_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessFileDelegateHost_Write_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_Write_ResponseParamsSpec.$,
        impl.write.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ResponseParamsSpec.$,
        impl.getLength.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ResponseParamsSpec.$,
        impl.setLength.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessFileDelegateHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessFileDelegateHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessFileDelegateHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessFileDelegateHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessFileDelegateHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessFileDelegateHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessFileDelegateHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessFileDelegateHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessFileDelegateHost_Read_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.write =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessFileDelegateHost_Write_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_Write_ResponseParamsSpec.$,
        this.write.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getLength =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ResponseParamsSpec.$,
        this.getLength.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setLength =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ParamsSpec.$,
        blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ResponseParamsSpec.$,
        this.setLength.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_Read_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileDelegateHost_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_Read_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileDelegateHost_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_Write_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileDelegateHost_Write_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_Write_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileDelegateHost_Write_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileDelegateHost_Read_ParamsSpec.$,
    'FileSystemAccessFileDelegateHost_Read_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bytesToRead', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_Read_Params');

/** @record */
blink.mojom.FileSystemAccessFileDelegateHost_Read_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.offset;
    /** @export { !number } */
    this.bytesToRead;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileDelegateHost_Read_ResponseParamsSpec.$,
    'FileSystemAccessFileDelegateHost_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.BigBufferSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'error', 16,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bytesRead', 20,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_Read_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileDelegateHost_Read_ResponseParams = class {
  constructor() {
    /** @export { (mojoBase.mojom.BigBuffer|undefined) } */
    this.data;
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
    /** @export { !number } */
    this.bytesRead;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileDelegateHost_Write_ParamsSpec.$,
    'FileSystemAccessFileDelegateHost_Write_Params',
    [
      mojo.internal.StructField(
        'offset', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojo.internal.Handle,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_Write_Params');

/** @record */
blink.mojom.FileSystemAccessFileDelegateHost_Write_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.offset;
    /** @export { !MojoHandle } */
    this.data;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileDelegateHost_Write_ResponseParamsSpec.$,
    'FileSystemAccessFileDelegateHost_Write_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bytesWritten', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_Write_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileDelegateHost_Write_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
    /** @export { !number } */
    this.bytesWritten;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ParamsSpec.$,
    'FileSystemAccessFileDelegateHost_GetLength_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_GetLength_Params');

/** @record */
blink.mojom.FileSystemAccessFileDelegateHost_GetLength_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ResponseParamsSpec.$,
    'FileSystemAccessFileDelegateHost_GetLength_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'length', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileDelegateHost_GetLength_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
    /** @export { !bigint } */
    this.length;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ParamsSpec.$,
    'FileSystemAccessFileDelegateHost_SetLength_Params',
    [
      mojo.internal.StructField(
        'length', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_SetLength_Params');

/** @record */
blink.mojom.FileSystemAccessFileDelegateHost_SetLength_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.length;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ResponseParamsSpec.$,
    'FileSystemAccessFileDelegateHost_SetLength_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        mojoBase.mojom.FileErrorSpec.$,
        -16,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ResponseParams');

/** @record */
blink.mojom.FileSystemAccessFileDelegateHost_SetLength_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.FileError } */
    this.error;
  }
};

