// third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_DELEGATE_HOST_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_DELEGATE_HOST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/file_system_access/file_system_access_file_delegate_host.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "mojo/public/mojom/base/file_error.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class FileSystemAccessFileDelegateHostProxy;

template <typename ImplRefTraits>
class FileSystemAccessFileDelegateHostStub;

class FileSystemAccessFileDelegateHostRequestValidator;
class FileSystemAccessFileDelegateHostResponseValidator;


class PLATFORM_EXPORT FileSystemAccessFileDelegateHost
    : public FileSystemAccessFileDelegateHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FileSystemAccessFileDelegateHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0, 
    1, 
    2, 
    3
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileSystemAccessFileDelegateHostInterfaceBase;
  using Proxy_ = FileSystemAccessFileDelegateHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileSystemAccessFileDelegateHostStub<ImplRefTraits>;

  using RequestValidator_ = FileSystemAccessFileDelegateHostRequestValidator;
  using ResponseValidator_ = FileSystemAccessFileDelegateHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReadMinVersion = 0,
    kWriteMinVersion = 0,
    kGetLengthMinVersion = 0,
    kSetLengthMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Read_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Write_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetLength_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetLength_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileSystemAccessFileDelegateHost() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Read(int64_t offset, int32_t bytes_to_read, std::optional<::mojo_base::BigBuffer>* out_data, ::base::File::Error* out_error, int32_t* out_bytes_read);
  using ReadCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>, ::base::File::Error, int32_t)>;
  using ReadMojoCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>, ::base::File::Error, int32_t)>;

  virtual void Read(int64_t offset, int32_t bytes_to_read, ReadCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Write(int64_t offset, ::mojo::ScopedDataPipeConsumerHandle data, ::base::File::Error* out_error, int32_t* out_bytes_written);
  using WriteCallback = base::OnceCallback<void(::base::File::Error, int32_t)>;
  using WriteMojoCallback = base::OnceCallback<void(::base::File::Error, int32_t)>;

  virtual void Write(int64_t offset, ::mojo::ScopedDataPipeConsumerHandle data, WriteCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetLength(::base::File::Error* out_error, int64_t* out_length);
  using GetLengthCallback = base::OnceCallback<void(::base::File::Error, int64_t)>;
  using GetLengthMojoCallback = base::OnceCallback<void(::base::File::Error, int64_t)>;

  virtual void GetLength(GetLengthCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetLength(int64_t length, ::base::File::Error* out_error);
  using SetLengthCallback = base::OnceCallback<void(::base::File::Error)>;
  using SetLengthMojoCallback = base::OnceCallback<void(::base::File::Error)>;

  virtual void SetLength(int64_t length, SetLengthCallback callback) = 0;
};



class PLATFORM_EXPORT FileSystemAccessFileDelegateHostProxy
    : public FileSystemAccessFileDelegateHost {
 public:
  using InterfaceType = FileSystemAccessFileDelegateHost;

  explicit FileSystemAccessFileDelegateHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool Read(int64_t offset, int32_t bytes_to_read, std::optional<::mojo_base::BigBuffer>* out_data, ::base::File::Error* out_error, int32_t* out_bytes_read) final;
  
  void Read(int64_t offset, int32_t bytes_to_read, ReadCallback callback) final;
  
  bool Write(int64_t offset, ::mojo::ScopedDataPipeConsumerHandle data, ::base::File::Error* out_error, int32_t* out_bytes_written) final;
  
  void Write(int64_t offset, ::mojo::ScopedDataPipeConsumerHandle data, WriteCallback callback) final;
  
  bool GetLength(::base::File::Error* out_error, int64_t* out_length) final;
  
  void GetLength(GetLengthCallback callback) final;
  
  bool SetLength(int64_t length, ::base::File::Error* out_error) final;
  
  void SetLength(int64_t length, SetLengthCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT FileSystemAccessFileDelegateHostStubDispatch {
 public:
  static bool Accept(FileSystemAccessFileDelegateHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileSystemAccessFileDelegateHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileSystemAccessFileDelegateHost>>
class FileSystemAccessFileDelegateHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileSystemAccessFileDelegateHostStub() = default;
  ~FileSystemAccessFileDelegateHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessFileDelegateHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileSystemAccessFileDelegateHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT FileSystemAccessFileDelegateHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT FileSystemAccessFileDelegateHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_FILE_DELEGATE_HOST_MOJOM_BLINK_H_