// third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT FileSystemAccessDirectoryEntriesListenerInterceptorForTesting : public FileSystemAccessDirectoryEntriesListener {
  virtual FileSystemAccessDirectoryEntriesListener* GetForwardingInterface() = 0;
  void DidReadDirectory(::blink::mojom::FileSystemAccessErrorPtr result, std::vector<FileSystemAccessEntryPtr> entries, bool has_more_entries) override;
};
class BLINK_COMMON_EXPORT FileSystemAccessDirectoryEntriesListenerAsyncWaiter {
 public:
  explicit FileSystemAccessDirectoryEntriesListenerAsyncWaiter(FileSystemAccessDirectoryEntriesListener* proxy);

  FileSystemAccessDirectoryEntriesListenerAsyncWaiter(const FileSystemAccessDirectoryEntriesListenerAsyncWaiter&) = delete;
  FileSystemAccessDirectoryEntriesListenerAsyncWaiter& operator=(const FileSystemAccessDirectoryEntriesListenerAsyncWaiter&) = delete;

  ~FileSystemAccessDirectoryEntriesListenerAsyncWaiter();

 private:
  FileSystemAccessDirectoryEntriesListener* const proxy_;
};


class BLINK_COMMON_EXPORT FileSystemAccessDirectoryHandleInterceptorForTesting : public FileSystemAccessDirectoryHandle {
  virtual FileSystemAccessDirectoryHandle* GetForwardingInterface() = 0;
  void GetPermissionStatus(::blink::mojom::FileSystemAccessPermissionMode mode, GetPermissionStatusCallback callback) override;
  void RequestPermission(::blink::mojom::FileSystemAccessPermissionMode mode, RequestPermissionCallback callback) override;
  void GetFile(const std::string& basename, bool create, GetFileCallback callback) override;
  void GetDirectory(const std::string& basename, bool create, GetDirectoryCallback callback) override;
  void GetEntries(::mojo::PendingRemote<FileSystemAccessDirectoryEntriesListener> listener) override;
  void Rename(const std::string& new_entry_name, RenameCallback callback) override;
  void Move(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> destination_directory, const std::string& new_entry_name, MoveCallback callback) override;
  void Remove(bool recurse, RemoveCallback callback) override;
  void RemoveEntry(const std::string& basename, bool recurse, RemoveEntryCallback callback) override;
  void Resolve(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> possible_child, ResolveCallback callback) override;
  void Transfer(::mojo::PendingReceiver<::blink::mojom::FileSystemAccessTransferToken> token) override;
  void GetUniqueId(GetUniqueIdCallback callback) override;
  void GetCloudIdentifiers(GetCloudIdentifiersCallback callback) override;
};
class BLINK_COMMON_EXPORT FileSystemAccessDirectoryHandleAsyncWaiter {
 public:
  explicit FileSystemAccessDirectoryHandleAsyncWaiter(FileSystemAccessDirectoryHandle* proxy);

  FileSystemAccessDirectoryHandleAsyncWaiter(const FileSystemAccessDirectoryHandleAsyncWaiter&) = delete;
  FileSystemAccessDirectoryHandleAsyncWaiter& operator=(const FileSystemAccessDirectoryHandleAsyncWaiter&) = delete;

  ~FileSystemAccessDirectoryHandleAsyncWaiter();
  void GetPermissionStatus(
      ::blink::mojom::FileSystemAccessPermissionMode mode, ::blink::mojom::PermissionStatus* out_status);
  ::blink::mojom::PermissionStatus GetPermissionStatus(::blink::mojom::FileSystemAccessPermissionMode mode);
  void RequestPermission(
      ::blink::mojom::FileSystemAccessPermissionMode mode, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::blink::mojom::PermissionStatus* out_status);
  
  void GetFile(
      const std::string& basename, bool create, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<::blink::mojom::FileSystemAccessFileHandle>* out_file);
  
  void GetDirectory(
      const std::string& basename, bool create, ::blink::mojom::FileSystemAccessErrorPtr* out_result, ::mojo::PendingRemote<FileSystemAccessDirectoryHandle>* out_directory);
  
  void Rename(
      const std::string& new_entry_name, ::blink::mojom::FileSystemAccessErrorPtr* out_result);
  ::blink::mojom::FileSystemAccessErrorPtr Rename(const std::string& new_entry_name);
  void Move(
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> destination_directory, const std::string& new_entry_name, ::blink::mojom::FileSystemAccessErrorPtr* out_result);
  ::blink::mojom::FileSystemAccessErrorPtr Move(::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> destination_directory, const std::string& new_entry_name);
  void Remove(
      bool recurse, ::blink::mojom::FileSystemAccessErrorPtr* out_result);
  ::blink::mojom::FileSystemAccessErrorPtr Remove(bool recurse);
  void RemoveEntry(
      const std::string& basename, bool recurse, ::blink::mojom::FileSystemAccessErrorPtr* out_result);
  ::blink::mojom::FileSystemAccessErrorPtr RemoveEntry(const std::string& basename, bool recurse);
  void Resolve(
      ::mojo::PendingRemote<::blink::mojom::FileSystemAccessTransferToken> possible_child, ::blink::mojom::FileSystemAccessErrorPtr* out_result, std::optional<std::vector<std::string>>* out_path);
  
  void GetUniqueId(
      ::blink::mojom::FileSystemAccessErrorPtr* out_result, std::string* out_id);
  
  void GetCloudIdentifiers(
      ::blink::mojom::FileSystemAccessErrorPtr* out_result, std::vector<::blink::mojom::FileSystemAccessCloudIdentifierPtr>* out_cloud_identifiers);
  

 private:
  FileSystemAccessDirectoryHandle* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_FILE_SYSTEM_ACCESS_DIRECTORY_HANDLE_MOJOM_TEST_UTILS_H_