// third_party/blink/public/mojom/fenced_frame/fenced_frame.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';

import {
  FramePolicy as blink_mojom_FramePolicy,
  FramePolicySpec as blink_mojom_FramePolicySpec
} from '../frame/frame_policy.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FencedFrameOwnerHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.FencedFrameOwnerHost', scope);
  }
}

/** @interface */
export class FencedFrameOwnerHostInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_TimeTicks } navigationStartTime
   * @param { ?mojoBase_mojom_String16 } embedderSharedStorageContext
   */

  navigate(url, navigationStartTime, embedderSharedStorageContext) {}
  
  /**
   * @param { !blink_mojom_FramePolicy } framePolicy
   */

  didChangeFramePolicy(framePolicy) {}
}

/**
 * @implements { FencedFrameOwnerHostInterface }
 */
export class FencedFrameOwnerHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FencedFrameOwnerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FencedFrameOwnerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FencedFrameOwnerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !mojoBase_mojom_TimeTicks } navigationStartTime
   * @param { ?mojoBase_mojom_String16 } embedderSharedStorageContext
   */

  navigate(
      url,
      navigationStartTime,
      embedderSharedStorageContext) {
    this.proxy.sendMessage(
        0,
        FencedFrameOwnerHost_Navigate_ParamsSpec.$,
        null,
        [
          url,
          navigationStartTime,
          embedderSharedStorageContext
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FramePolicy } framePolicy
   */

  didChangeFramePolicy(
      framePolicy) {
    this.proxy.sendMessage(
        1,
        FencedFrameOwnerHost_DidChangeFramePolicy_ParamsSpec.$,
        null,
        [
          framePolicy
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FencedFrameOwnerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FencedFrameOwnerHostReceiver {
  /**
   * @param {!FencedFrameOwnerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FencedFrameOwnerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FencedFrameOwnerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FencedFrameOwnerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FencedFrameOwnerHost_Navigate_ParamsSpec.$,
        null,
        impl.navigate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FencedFrameOwnerHost_DidChangeFramePolicy_ParamsSpec.$,
        null,
        impl.didChangeFramePolicy.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FencedFrameOwnerHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FencedFrameOwnerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FencedFrameOwnerHostRemote}
   */
  static getRemote() {
    let remote = new FencedFrameOwnerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FencedFrameOwnerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FencedFrameOwnerHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FencedFrameOwnerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FencedFrameOwnerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.navigate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FencedFrameOwnerHost_Navigate_ParamsSpec.$,
        null,
        this.navigate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.didChangeFramePolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FencedFrameOwnerHost_DidChangeFramePolicy_ParamsSpec.$,
        null,
        this.didChangeFramePolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FencedFrameOwnerHost_Navigate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FencedFrameOwnerHost_DidChangeFramePolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FencedFrameOwnerHost_Navigate_ParamsSpec.$,
    'FencedFrameOwnerHost_Navigate_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'navigationStartTime', 8,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'embedderSharedStorageContext', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FencedFrameOwnerHost_Navigate_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.navigationStartTime;
    /** @type { (mojoBase_mojom_String16|undefined) } */
    this.embedderSharedStorageContext;
  }
}



mojo.internal.Struct(
    FencedFrameOwnerHost_DidChangeFramePolicy_ParamsSpec.$,
    'FencedFrameOwnerHost_DidChangeFramePolicy_Params',
    [
      mojo.internal.StructField(
        'framePolicy', 0,
        0,
        blink_mojom_FramePolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FencedFrameOwnerHost_DidChangeFramePolicy_Params {
  constructor() {
    /** @type { !blink_mojom_FramePolicy } */
    this.framePolicy;
  }
}

