// third_party/blink/public/mojom/dom_storage/storage_area.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');







goog.provide('blink.mojom.StorageAreaObserver');
goog.provide('blink.mojom.StorageAreaObserverReceiver');
goog.provide('blink.mojom.StorageAreaObserverCallbackRouter');
goog.provide('blink.mojom.StorageAreaObserverInterface');
goog.provide('blink.mojom.StorageAreaObserverRemote');
goog.provide('blink.mojom.StorageAreaObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.StorageAreaObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.StorageAreaObserver.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.StorageAreaObserverInterface = class {
  
  /**
   * @param { !Array<!number> } key
   * @param { !Array<!number> } newValue
   * @param { ?Array<!number> } oldValue
   * @param { !string } source
   */

  keyChanged(key, newValue, oldValue, source) {}
  
  /**
   * @param { !Array<!number> } key
   * @param { !string } source
   */

  keyChangeFailed(key, source) {}
  
  /**
   * @param { !Array<!number> } key
   * @param { ?Array<!number> } oldValue
   * @param { !string } source
   */

  keyDeleted(key, oldValue, source) {}
  
  /**
   * @param { !boolean } wasNonempty
   * @param { !string } source
   */

  allDeleted(wasNonempty, source) {}
  
  /**
   * @param { !boolean } value
   */

  shouldSendOldValueOnMutations(value) {}
};

/**
 * @export
 * @implements { blink.mojom.StorageAreaObserverInterface }
 */
blink.mojom.StorageAreaObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.StorageAreaObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.StorageAreaObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.StorageAreaObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } key
   * @param { !Array<!number> } newValue
   * @param { ?Array<!number> } oldValue
   * @param { !string } source
   */

  keyChanged(
      key,
      newValue,
      oldValue,
      source) {
    this.proxy.sendMessage(
        0,
        blink.mojom.StorageAreaObserver_KeyChanged_ParamsSpec.$,
        null,
        [
          key,
          newValue,
          oldValue,
          source
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } key
   * @param { !string } source
   */

  keyChangeFailed(
      key,
      source) {
    this.proxy.sendMessage(
        1,
        blink.mojom.StorageAreaObserver_KeyChangeFailed_ParamsSpec.$,
        null,
        [
          key,
          source
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } key
   * @param { ?Array<!number> } oldValue
   * @param { !string } source
   */

  keyDeleted(
      key,
      oldValue,
      source) {
    this.proxy.sendMessage(
        2,
        blink.mojom.StorageAreaObserver_KeyDeleted_ParamsSpec.$,
        null,
        [
          key,
          oldValue,
          source
        ],
        false);
  }

  
  /**
   * @param { !boolean } wasNonempty
   * @param { !string } source
   */

  allDeleted(
      wasNonempty,
      source) {
    this.proxy.sendMessage(
        3,
        blink.mojom.StorageAreaObserver_AllDeleted_ParamsSpec.$,
        null,
        [
          wasNonempty,
          source
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   */

  shouldSendOldValueOnMutations(
      value) {
    this.proxy.sendMessage(
        4,
        blink.mojom.StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsSpec.$,
        null,
        [
          value
        ],
        false);
  }
};

/**
 * An object which receives request messages for the StorageAreaObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.StorageAreaObserverReceiver = class {
  /**
   * @param {!blink.mojom.StorageAreaObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.StorageAreaObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.StorageAreaObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.StorageAreaObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.StorageAreaObserver_KeyChanged_ParamsSpec.$,
        null,
        impl.keyChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.StorageAreaObserver_KeyChangeFailed_ParamsSpec.$,
        null,
        impl.keyChangeFailed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.StorageAreaObserver_KeyDeleted_ParamsSpec.$,
        null,
        impl.keyDeleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.StorageAreaObserver_AllDeleted_ParamsSpec.$,
        null,
        impl.allDeleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsSpec.$,
        null,
        impl.shouldSendOldValueOnMutations.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.StorageAreaObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.StorageAreaObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.StorageAreaObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.StorageAreaObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the StorageAreaObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.StorageAreaObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.StorageAreaObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.StorageAreaObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keyChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.StorageAreaObserver_KeyChanged_ParamsSpec.$,
        null,
        this.keyChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keyChangeFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.StorageAreaObserver_KeyChangeFailed_ParamsSpec.$,
        null,
        this.keyChangeFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.keyDeleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.StorageAreaObserver_KeyDeleted_ParamsSpec.$,
        null,
        this.keyDeleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allDeleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.StorageAreaObserver_AllDeleted_ParamsSpec.$,
        null,
        this.allDeleted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.shouldSendOldValueOnMutations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsSpec.$,
        null,
        this.shouldSendOldValueOnMutations.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.StorageArea');
goog.provide('blink.mojom.StorageAreaReceiver');
goog.provide('blink.mojom.StorageAreaCallbackRouter');
goog.provide('blink.mojom.StorageAreaInterface');
goog.provide('blink.mojom.StorageAreaRemote');
goog.provide('blink.mojom.StorageAreaPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.StorageAreaPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.StorageArea.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.StorageAreaInterface = class {
  
  /**
   * @param { !blink.mojom.StorageAreaObserverRemote } observer
   */

  addObserver(observer) {}
  
  /**
   * @param { !Array<!number> } key
   * @param { !Array<!number> } value
   * @param { ?Array<!number> } clientOldValue
   * @param { !string } source
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  put(key, value, clientOldValue, source) {}
  
  /**
   * @param { !Array<!number> } key
   * @param { ?Array<!number> } clientOldValue
   * @param { !string } source
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  delete(key, clientOldValue, source) {}
  
  /**
   * @param { !string } source
   * @param { ?blink.mojom.StorageAreaObserverRemote } newObserver
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteAll(source, newObserver) {}
  
  /**
   * @param { !Array<!number> } key
   * @return {!Promise<{
        success: !boolean,
        value: !Array<!number>,
   *  }>}
   */

  get(key) {}
  
  /**
   * @param { ?blink.mojom.StorageAreaObserverRemote } newObserver
   * @return {!Promise<{
        data: !Array<!blink.mojom.KeyValue>,
   *  }>}
   */

  getAll(newObserver) {}
};

/**
 * @export
 * @implements { blink.mojom.StorageAreaInterface }
 */
blink.mojom.StorageAreaRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.StorageAreaPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.StorageAreaPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.StorageAreaPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.StorageAreaObserverRemote } observer
   */

  addObserver(
      observer) {
    this.proxy.sendMessage(
        0,
        blink.mojom.StorageArea_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } key
   * @param { !Array<!number> } value
   * @param { ?Array<!number> } clientOldValue
   * @param { !string } source
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  put(
      key,
      value,
      clientOldValue,
      source) {
    return this.proxy.sendMessage(
        1,
        blink.mojom.StorageArea_Put_ParamsSpec.$,
        blink.mojom.StorageArea_Put_ResponseParamsSpec.$,
        [
          key,
          value,
          clientOldValue,
          source
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } key
   * @param { ?Array<!number> } clientOldValue
   * @param { !string } source
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  delete(
      key,
      clientOldValue,
      source) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.StorageArea_Delete_ParamsSpec.$,
        blink.mojom.StorageArea_Delete_ResponseParamsSpec.$,
        [
          key,
          clientOldValue,
          source
        ],
        false);
  }

  
  /**
   * @param { !string } source
   * @param { ?blink.mojom.StorageAreaObserverRemote } newObserver
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteAll(
      source,
      newObserver) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.StorageArea_DeleteAll_ParamsSpec.$,
        blink.mojom.StorageArea_DeleteAll_ResponseParamsSpec.$,
        [
          source,
          newObserver
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } key
   * @return {!Promise<{
        success: !boolean,
        value: !Array<!number>,
   *  }>}
   */

  get(
      key) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.StorageArea_Get_ParamsSpec.$,
        blink.mojom.StorageArea_Get_ResponseParamsSpec.$,
        [
          key
        ],
        false);
  }

  
  /**
   * @param { ?blink.mojom.StorageAreaObserverRemote } newObserver
   * @return {!Promise<{
        data: !Array<!blink.mojom.KeyValue>,
   *  }>}
   */

  getAll(
      newObserver) {
    return this.proxy.sendMessage(
        5,
        blink.mojom.StorageArea_GetAll_ParamsSpec.$,
        blink.mojom.StorageArea_GetAll_ResponseParamsSpec.$,
        [
          newObserver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the StorageArea
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.StorageAreaReceiver = class {
  /**
   * @param {!blink.mojom.StorageAreaInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.StorageAreaRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.StorageAreaRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.StorageAreaRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.StorageArea_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.StorageArea_Put_ParamsSpec.$,
        blink.mojom.StorageArea_Put_ResponseParamsSpec.$,
        impl.put.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.StorageArea_Delete_ParamsSpec.$,
        blink.mojom.StorageArea_Delete_ResponseParamsSpec.$,
        impl.delete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.StorageArea_DeleteAll_ParamsSpec.$,
        blink.mojom.StorageArea_DeleteAll_ResponseParamsSpec.$,
        impl.deleteAll.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.StorageArea_Get_ParamsSpec.$,
        blink.mojom.StorageArea_Get_ResponseParamsSpec.$,
        impl.get.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        blink.mojom.StorageArea_GetAll_ParamsSpec.$,
        blink.mojom.StorageArea_GetAll_ResponseParamsSpec.$,
        impl.getAll.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.StorageArea = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.StorageArea";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.StorageAreaRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.StorageAreaRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the StorageArea
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.StorageAreaCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.StorageAreaRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.StorageAreaRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.StorageArea_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.put =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.StorageArea_Put_ParamsSpec.$,
        blink.mojom.StorageArea_Put_ResponseParamsSpec.$,
        this.put.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.delete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.StorageArea_Delete_ParamsSpec.$,
        blink.mojom.StorageArea_Delete_ResponseParamsSpec.$,
        this.delete.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.StorageArea_DeleteAll_ParamsSpec.$,
        blink.mojom.StorageArea_DeleteAll_ResponseParamsSpec.$,
        this.deleteAll.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.get =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.StorageArea_Get_ParamsSpec.$,
        blink.mojom.StorageArea_Get_ResponseParamsSpec.$,
        this.get.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAll =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        blink.mojom.StorageArea_GetAll_ParamsSpec.$,
        blink.mojom.StorageArea_GetAll_ResponseParamsSpec.$,
        this.getAll.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.KeyValueSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.KeyValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAreaObserver_KeyChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAreaObserver_KeyChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAreaObserver_KeyChangeFailed_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAreaObserver_KeyChangeFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAreaObserver_KeyDeleted_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAreaObserver_KeyDeleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAreaObserver_AllDeleted_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAreaObserver_AllDeleted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageArea_AddObserver_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageArea_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageArea_Put_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageArea_Put_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageArea_Put_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageArea_Put_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageArea_Delete_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageArea_Delete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageArea_Delete_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageArea_Delete_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageArea_DeleteAll_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageArea_DeleteAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageArea_DeleteAll_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageArea_DeleteAll_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageArea_Get_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageArea_Get_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageArea_Get_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageArea_Get_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageArea_GetAll_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageArea_GetAll_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.StorageArea_GetAll_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.StorageArea_GetAll_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.KeyValueSpec.$,
    'KeyValue',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.KeyValue');

/** @record */
blink.mojom.KeyValue = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.key;
    /** @export { !Array<!number> } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAreaObserver_KeyChanged_ParamsSpec.$,
    'StorageAreaObserver_KeyChanged_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newValue', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'oldValue', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.StorageAreaObserver_KeyChanged_Params');

/** @record */
blink.mojom.StorageAreaObserver_KeyChanged_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.key;
    /** @export { !Array<!number> } */
    this.newValue;
    /** @export { (Array<!number>|undefined) } */
    this.oldValue;
    /** @export { !string } */
    this.source;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAreaObserver_KeyChangeFailed_ParamsSpec.$,
    'StorageAreaObserver_KeyChangeFailed_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.StorageAreaObserver_KeyChangeFailed_Params');

/** @record */
blink.mojom.StorageAreaObserver_KeyChangeFailed_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.key;
    /** @export { !string } */
    this.source;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAreaObserver_KeyDeleted_ParamsSpec.$,
    'StorageAreaObserver_KeyDeleted_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'oldValue', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.StorageAreaObserver_KeyDeleted_Params');

/** @record */
blink.mojom.StorageAreaObserver_KeyDeleted_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.key;
    /** @export { (Array<!number>|undefined) } */
    this.oldValue;
    /** @export { !string } */
    this.source;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAreaObserver_AllDeleted_ParamsSpec.$,
    'StorageAreaObserver_AllDeleted_Params',
    [
      mojo.internal.StructField(
        'wasNonempty', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.StorageAreaObserver_AllDeleted_Params');

/** @record */
blink.mojom.StorageAreaObserver_AllDeleted_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.wasNonempty;
    /** @export { !string } */
    this.source;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageAreaObserver_ShouldSendOldValueOnMutations_ParamsSpec.$,
    'StorageAreaObserver_ShouldSendOldValueOnMutations_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageAreaObserver_ShouldSendOldValueOnMutations_Params');

/** @record */
blink.mojom.StorageAreaObserver_ShouldSendOldValueOnMutations_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageArea_AddObserver_ParamsSpec.$,
    'StorageArea_AddObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.StorageAreaObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageArea_AddObserver_Params');

/** @record */
blink.mojom.StorageArea_AddObserver_Params = class {
  constructor() {
    /** @export { !blink.mojom.StorageAreaObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageArea_Put_ParamsSpec.$,
    'StorageArea_Put_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientOldValue', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('blink.mojom.StorageArea_Put_Params');

/** @record */
blink.mojom.StorageArea_Put_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.key;
    /** @export { !Array<!number> } */
    this.value;
    /** @export { (Array<!number>|undefined) } */
    this.clientOldValue;
    /** @export { !string } */
    this.source;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageArea_Put_ResponseParamsSpec.$,
    'StorageArea_Put_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageArea_Put_ResponseParams');

/** @record */
blink.mojom.StorageArea_Put_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageArea_Delete_ParamsSpec.$,
    'StorageArea_Delete_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientOldValue', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.StorageArea_Delete_Params');

/** @record */
blink.mojom.StorageArea_Delete_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.key;
    /** @export { (Array<!number>|undefined) } */
    this.clientOldValue;
    /** @export { !string } */
    this.source;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageArea_Delete_ResponseParamsSpec.$,
    'StorageArea_Delete_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageArea_Delete_ResponseParams');

/** @record */
blink.mojom.StorageArea_Delete_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageArea_DeleteAll_ParamsSpec.$,
    'StorageArea_DeleteAll_Params',
    [
      mojo.internal.StructField(
        'source', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'newObserver', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.StorageAreaObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.StorageArea_DeleteAll_Params');

/** @record */
blink.mojom.StorageArea_DeleteAll_Params = class {
  constructor() {
    /** @export { !string } */
    this.source;
    /** @export { (blink.mojom.StorageAreaObserverRemote|undefined) } */
    this.newObserver;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageArea_DeleteAll_ResponseParamsSpec.$,
    'StorageArea_DeleteAll_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageArea_DeleteAll_ResponseParams');

/** @record */
blink.mojom.StorageArea_DeleteAll_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageArea_Get_ParamsSpec.$,
    'StorageArea_Get_Params',
    [
      mojo.internal.StructField(
        'key', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageArea_Get_Params');

/** @record */
blink.mojom.StorageArea_Get_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.key;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageArea_Get_ResponseParamsSpec.$,
    'StorageArea_Get_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.StorageArea_Get_ResponseParams');

/** @record */
blink.mojom.StorageArea_Get_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
    /** @export { !Array<!number> } */
    this.value;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageArea_GetAll_ParamsSpec.$,
    'StorageArea_GetAll_Params',
    [
      mojo.internal.StructField(
        'newObserver', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.StorageAreaObserverRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageArea_GetAll_Params');

/** @record */
blink.mojom.StorageArea_GetAll_Params = class {
  constructor() {
    /** @export { (blink.mojom.StorageAreaObserverRemote|undefined) } */
    this.newObserver;
  }
};



mojo.internal.Struct(
    blink.mojom.StorageArea_GetAll_ResponseParamsSpec.$,
    'StorageArea_GetAll_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Array(blink.mojom.KeyValueSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.StorageArea_GetAll_ResponseParams');

/** @record */
blink.mojom.StorageArea_GetAll_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.KeyValue> } */
    this.data;
  }
};

