// third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-params-data.h"
#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/dom_storage/session_storage_namespace.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

SessionStorageNamespace::IPCStableHashFunction SessionStorageNamespace::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SessionStorageNamespace>(message.name())) {
    case messages::SessionStorageNamespace::kClone: {
      return &SessionStorageNamespace::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SessionStorageNamespace::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SessionStorageNamespace>(message.name())) {
      case messages::SessionStorageNamespace::kClone:
            return "Receive blink::mojom::SessionStorageNamespace::Clone";
    }
  } else {
    switch (static_cast<messages::SessionStorageNamespace>(message.name())) {
      case messages::SessionStorageNamespace::kClone:
            return "Receive reply blink::mojom::SessionStorageNamespace::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SessionStorageNamespace::Clone_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe19cffe1;  // IPCStableHash for blink::mojom::SessionStorageNamespace::Clone
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SessionStorageNamespaceProxy::SessionStorageNamespaceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SessionStorageNamespaceProxy::Clone(
    const ::blink::String& in_clone_to_namespace) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SessionStorageNamespace::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("clone_to_namespace"), in_clone_to_namespace,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SessionStorageNamespace::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SessionStorageNamespace_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->clone_to_namespace)::BaseType> clone_to_namespace_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_clone_to_namespace,
    clone_to_namespace_fragment);

  params->clone_to_namespace.Set(
      clone_to_namespace_fragment.is_null() ? nullptr : clone_to_namespace_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->clone_to_namespace.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null clone_to_namespace in SessionStorageNamespace.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SessionStorageNamespace::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SessionStorageNamespaceStubDispatch::Accept(
    SessionStorageNamespace* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SessionStorageNamespace>(message->header()->name)) {
    case messages::SessionStorageNamespace::kClone: {
      DCHECK(message->is_serialized());
      internal::SessionStorageNamespace_Clone_Params_Data* params =
          reinterpret_cast<internal::SessionStorageNamespace_Clone_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SessionStorageNamespace.0
      bool success = true;
      ::blink::String p_clone_to_namespace{};
      SessionStorageNamespace_Clone_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCloneToNamespace(&p_clone_to_namespace))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SessionStorageNamespace::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_clone_to_namespace));
      return true;
    }
  }
  return false;
}

// static
bool SessionStorageNamespaceStubDispatch::AcceptWithResponder(
    SessionStorageNamespace* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SessionStorageNamespace>(message->header()->name)) {
    case messages::SessionStorageNamespace::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSessionStorageNamespaceValidationInfo[] = {
    { &internal::SessionStorageNamespace_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool SessionStorageNamespaceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::SessionStorageNamespace::Name_,
    kSessionStorageNamespaceValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void SessionStorageNamespaceInterceptorForTesting::Clone(const ::blink::String& clone_to_namespace) {
  GetForwardingInterface()->Clone(
    std::move(clone_to_namespace)
    );
}
SessionStorageNamespaceAsyncWaiter::SessionStorageNamespaceAsyncWaiter(
    SessionStorageNamespace* proxy) : proxy_(proxy) {}

SessionStorageNamespaceAsyncWaiter::~SessionStorageNamespaceAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif