// third_party/blink/public/mojom/dom_storage/dom_storage.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-params-data.h"
#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/dom_storage/dom_storage.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

DomStorageProvider::IPCStableHashFunction DomStorageProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DomStorageProvider>(message.name())) {
    case messages::DomStorageProvider::kBindDomStorage: {
      return &DomStorageProvider::BindDomStorage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DomStorageProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DomStorageProvider>(message.name())) {
      case messages::DomStorageProvider::kBindDomStorage:
            return "Receive blink::mojom::DomStorageProvider::BindDomStorage";
    }
  } else {
    switch (static_cast<messages::DomStorageProvider>(message.name())) {
      case messages::DomStorageProvider::kBindDomStorage:
            return "Receive reply blink::mojom::DomStorageProvider::BindDomStorage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DomStorageProvider::BindDomStorage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5cbd4f6f;  // IPCStableHash for blink::mojom::DomStorageProvider::BindDomStorage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DomStorageProviderProxy::DomStorageProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DomStorageProviderProxy::BindDomStorage(
    ::mojo::PendingReceiver<DomStorage> in_receiver, ::mojo::PendingRemote<DomStorageClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DomStorageProvider::BindDomStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<DomStorage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<DomStorageClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DomStorageProvider::kBindDomStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DomStorageProvider_BindDomStorage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::DomStorageInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DomStorageProvider.BindDomStorage request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DomStorageClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in DomStorageProvider.BindDomStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DomStorageProvider::Name_);
  message.set_method_name("BindDomStorage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DomStorageProviderStubDispatch::Accept(
    DomStorageProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DomStorageProvider>(message->header()->name)) {
    case messages::DomStorageProvider::kBindDomStorage: {
      DCHECK(message->is_serialized());
      internal::DomStorageProvider_BindDomStorage_Params_Data* params =
          reinterpret_cast<internal::DomStorageProvider_BindDomStorage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DomStorageProvider.0
      bool success = true;
      ::mojo::PendingReceiver<DomStorage> p_receiver{};
      ::mojo::PendingRemote<DomStorageClient> p_client{};
      DomStorageProvider_BindDomStorage_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DomStorageProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindDomStorage(        
        std::move(p_receiver), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool DomStorageProviderStubDispatch::AcceptWithResponder(
    DomStorageProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DomStorageProvider>(message->header()->name)) {
    case messages::DomStorageProvider::kBindDomStorage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDomStorageProviderValidationInfo[] = {
    { &internal::DomStorageProvider_BindDomStorage_Params_Data::Validate,
     nullptr /* no response */},
};

bool DomStorageProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DomStorageProvider::Name_,
    kDomStorageProviderValidationInfo);
}

// The declaration includes the definition on other builds.

DomStorage::IPCStableHashFunction DomStorage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DomStorage>(message.name())) {
    case messages::DomStorage::kOpenLocalStorage: {
      return &DomStorage::OpenLocalStorage_Sym::IPCStableHash;
    }
    case messages::DomStorage::kBindSessionStorageNamespace: {
      return &DomStorage::BindSessionStorageNamespace_Sym::IPCStableHash;
    }
    case messages::DomStorage::kBindSessionStorageArea: {
      return &DomStorage::BindSessionStorageArea_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DomStorage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DomStorage>(message.name())) {
      case messages::DomStorage::kOpenLocalStorage:
            return "Receive blink::mojom::DomStorage::OpenLocalStorage";
      case messages::DomStorage::kBindSessionStorageNamespace:
            return "Receive blink::mojom::DomStorage::BindSessionStorageNamespace";
      case messages::DomStorage::kBindSessionStorageArea:
            return "Receive blink::mojom::DomStorage::BindSessionStorageArea";
    }
  } else {
    switch (static_cast<messages::DomStorage>(message.name())) {
      case messages::DomStorage::kOpenLocalStorage:
            return "Receive reply blink::mojom::DomStorage::OpenLocalStorage";
      case messages::DomStorage::kBindSessionStorageNamespace:
            return "Receive reply blink::mojom::DomStorage::BindSessionStorageNamespace";
      case messages::DomStorage::kBindSessionStorageArea:
            return "Receive reply blink::mojom::DomStorage::BindSessionStorageArea";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DomStorage::OpenLocalStorage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb1478de4;  // IPCStableHash for blink::mojom::DomStorage::OpenLocalStorage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DomStorage::BindSessionStorageNamespace_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc50d3e8b;  // IPCStableHash for blink::mojom::DomStorage::BindSessionStorageNamespace
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DomStorage::BindSessionStorageArea_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x40885723;  // IPCStableHash for blink::mojom::DomStorage::BindSessionStorageArea
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DomStorageProxy::DomStorageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DomStorageProxy::OpenLocalStorage(
    const ::blink::BlinkStorageKey& in_storage_key, const ::blink::LocalFrameToken& in_local_frame_token, ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> in_area) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DomStorage::OpenLocalStorage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::BlinkStorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_frame_token"), in_local_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("area"), in_area,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DomStorage::kOpenLocalStorage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DomStorage_OpenLocalStorage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_storage_key,
    storage_key_fragment);

  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->storage_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null storage_key in DomStorage.OpenLocalStorage request");
  mojo::internal::MessageFragment<
      typename decltype(params->local_frame_token)::BaseType> local_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_local_frame_token,
    local_frame_token_fragment);

  params->local_frame_token.Set(
      local_frame_token_fragment.is_null() ? nullptr : local_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->local_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null local_frame_token in DomStorage.OpenLocalStorage request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::StorageAreaInterfaceBase>>(
    in_area,
    &params->area,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->area)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid area in DomStorage.OpenLocalStorage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DomStorage::Name_);
  message.set_method_name("OpenLocalStorage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DomStorageProxy::BindSessionStorageNamespace(
    const ::blink::String& in_namespace_id, ::mojo::PendingReceiver<::blink::mojom::blink::SessionStorageNamespace> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DomStorage::BindSessionStorageNamespace", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::SessionStorageNamespace>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DomStorage::kBindSessionStorageNamespace), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DomStorage_BindSessionStorageNamespace_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_namespace_id,
    namespace_id_fragment);

  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->namespace_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null namespace_id in DomStorage.BindSessionStorageNamespace request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::SessionStorageNamespaceInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in DomStorage.BindSessionStorageNamespace request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DomStorage::Name_);
  message.set_method_name("BindSessionStorageNamespace");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DomStorageProxy::BindSessionStorageArea(
    const ::blink::BlinkStorageKey& in_storage_key, const ::blink::LocalFrameToken& in_local_frame_token, const ::blink::String& in_namespace_id, ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> in_session_namespace) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::DomStorage::BindSessionStorageArea", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_key"), in_storage_key,
                        "<value of type const ::blink::BlinkStorageKey&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("local_frame_token"), in_local_frame_token,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("namespace_id"), in_namespace_id,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("session_namespace"), in_session_namespace,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DomStorage::kBindSessionStorageArea), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DomStorage_BindSessionStorageArea_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_key)::BaseType> storage_key_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::StorageKeyDataView>(
    in_storage_key,
    storage_key_fragment);

  params->storage_key.Set(
      storage_key_fragment.is_null() ? nullptr : storage_key_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->storage_key.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null storage_key in DomStorage.BindSessionStorageArea request");
  mojo::internal::MessageFragment<
      typename decltype(params->local_frame_token)::BaseType> local_frame_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_local_frame_token,
    local_frame_token_fragment);

  params->local_frame_token.Set(
      local_frame_token_fragment.is_null() ? nullptr : local_frame_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->local_frame_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null local_frame_token in DomStorage.BindSessionStorageArea request");
  mojo::internal::MessageFragment<
      typename decltype(params->namespace_id)::BaseType> namespace_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_namespace_id,
    namespace_id_fragment);

  params->namespace_id.Set(
      namespace_id_fragment.is_null() ? nullptr : namespace_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->namespace_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null namespace_id in DomStorage.BindSessionStorageArea request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::StorageAreaInterfaceBase>>(
    in_session_namespace,
    &params->session_namespace,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->session_namespace)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid session_namespace in DomStorage.BindSessionStorageArea request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DomStorage::Name_);
  message.set_method_name("BindSessionStorageArea");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DomStorageStubDispatch::Accept(
    DomStorage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DomStorage>(message->header()->name)) {
    case messages::DomStorage::kOpenLocalStorage: {
      DCHECK(message->is_serialized());
      internal::DomStorage_OpenLocalStorage_Params_Data* params =
          reinterpret_cast<internal::DomStorage_OpenLocalStorage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DomStorage.0
      bool success = true;
      ::blink::BlinkStorageKey p_storage_key{};
      ::blink::LocalFrameToken p_local_frame_token{};
      ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> p_area{};
      DomStorage_OpenLocalStorage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadLocalFrameToken(&p_local_frame_token))
        success = false;
      if (success) {
        p_area =
            input_data_view.TakeArea<decltype(p_area)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DomStorage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenLocalStorage(        
        std::move(p_storage_key), 
        std::move(p_local_frame_token), 
        std::move(p_area));
      return true;
    }
    case messages::DomStorage::kBindSessionStorageNamespace: {
      DCHECK(message->is_serialized());
      internal::DomStorage_BindSessionStorageNamespace_Params_Data* params =
          reinterpret_cast<internal::DomStorage_BindSessionStorageNamespace_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DomStorage.1
      bool success = true;
      ::blink::String p_namespace_id{};
      ::mojo::PendingReceiver<::blink::mojom::blink::SessionStorageNamespace> p_receiver{};
      DomStorage_BindSessionStorageNamespace_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DomStorage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSessionStorageNamespace(        
        std::move(p_namespace_id), 
        std::move(p_receiver));
      return true;
    }
    case messages::DomStorage::kBindSessionStorageArea: {
      DCHECK(message->is_serialized());
      internal::DomStorage_BindSessionStorageArea_Params_Data* params =
          reinterpret_cast<internal::DomStorage_BindSessionStorageArea_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DomStorage.2
      bool success = true;
      ::blink::BlinkStorageKey p_storage_key{};
      ::blink::LocalFrameToken p_local_frame_token{};
      ::blink::String p_namespace_id{};
      ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> p_session_namespace{};
      DomStorage_BindSessionStorageArea_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadStorageKey(&p_storage_key))
        success = false;
      if (success && !input_data_view.ReadLocalFrameToken(&p_local_frame_token))
        success = false;
      if (success && !input_data_view.ReadNamespaceId(&p_namespace_id))
        success = false;
      if (success) {
        p_session_namespace =
            input_data_view.TakeSessionNamespace<decltype(p_session_namespace)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DomStorage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSessionStorageArea(        
        std::move(p_storage_key), 
        std::move(p_local_frame_token), 
        std::move(p_namespace_id), 
        std::move(p_session_namespace));
      return true;
    }
  }
  return false;
}

// static
bool DomStorageStubDispatch::AcceptWithResponder(
    DomStorage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DomStorage>(message->header()->name)) {
    case messages::DomStorage::kOpenLocalStorage: {
      break;
    }
    case messages::DomStorage::kBindSessionStorageNamespace: {
      break;
    }
    case messages::DomStorage::kBindSessionStorageArea: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDomStorageValidationInfo[] = {
    { &internal::DomStorage_OpenLocalStorage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DomStorage_BindSessionStorageNamespace_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DomStorage_BindSessionStorageArea_Params_Data::Validate,
     nullptr /* no response */},
};

bool DomStorageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DomStorage::Name_,
    kDomStorageValidationInfo);
}

// The declaration includes the definition on other builds.

DomStorageClient::IPCStableHashFunction DomStorageClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DomStorageClient>(message.name())) {
    case messages::DomStorageClient::kResetSessionStorageConnections: {
      return &DomStorageClient::ResetSessionStorageConnections_Sym::IPCStableHash;
    }
    case messages::DomStorageClient::kResetLocalStorageConnections: {
      return &DomStorageClient::ResetLocalStorageConnections_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DomStorageClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DomStorageClient>(message.name())) {
      case messages::DomStorageClient::kResetSessionStorageConnections:
            return "Receive blink::mojom::DomStorageClient::ResetSessionStorageConnections";
      case messages::DomStorageClient::kResetLocalStorageConnections:
            return "Receive blink::mojom::DomStorageClient::ResetLocalStorageConnections";
    }
  } else {
    switch (static_cast<messages::DomStorageClient>(message.name())) {
      case messages::DomStorageClient::kResetSessionStorageConnections:
            return "Receive reply blink::mojom::DomStorageClient::ResetSessionStorageConnections";
      case messages::DomStorageClient::kResetLocalStorageConnections:
            return "Receive reply blink::mojom::DomStorageClient::ResetLocalStorageConnections";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DomStorageClient::ResetSessionStorageConnections_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5d6b958d;  // IPCStableHash for blink::mojom::DomStorageClient::ResetSessionStorageConnections
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DomStorageClient::ResetLocalStorageConnections_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6e4df419;  // IPCStableHash for blink::mojom::DomStorageClient::ResetLocalStorageConnections
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DomStorageClientProxy::DomStorageClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DomStorageClientProxy::ResetSessionStorageConnections(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DomStorageClient::ResetSessionStorageConnections");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DomStorageClient::kResetSessionStorageConnections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DomStorageClient_ResetSessionStorageConnections_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DomStorageClient::Name_);
  message.set_method_name("ResetSessionStorageConnections");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DomStorageClientProxy::ResetLocalStorageConnections(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DomStorageClient::ResetLocalStorageConnections");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DomStorageClient::kResetLocalStorageConnections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DomStorageClient_ResetLocalStorageConnections_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DomStorageClient::Name_);
  message.set_method_name("ResetLocalStorageConnections");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DomStorageClientStubDispatch::Accept(
    DomStorageClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DomStorageClient>(message->header()->name)) {
    case messages::DomStorageClient::kResetSessionStorageConnections: {
      DCHECK(message->is_serialized());
      internal::DomStorageClient_ResetSessionStorageConnections_Params_Data* params =
          reinterpret_cast<internal::DomStorageClient_ResetSessionStorageConnections_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DomStorageClient.0
      bool success = true;
      DomStorageClient_ResetSessionStorageConnections_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DomStorageClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetSessionStorageConnections(        );
      return true;
    }
    case messages::DomStorageClient::kResetLocalStorageConnections: {
      DCHECK(message->is_serialized());
      internal::DomStorageClient_ResetLocalStorageConnections_Params_Data* params =
          reinterpret_cast<internal::DomStorageClient_ResetLocalStorageConnections_Params_Data*>(
              message->mutable_payload());
      

      // Validation for DomStorageClient.1
      bool success = true;
      DomStorageClient_ResetLocalStorageConnections_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DomStorageClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetLocalStorageConnections(        );
      return true;
    }
  }
  return false;
}

// static
bool DomStorageClientStubDispatch::AcceptWithResponder(
    DomStorageClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DomStorageClient>(message->header()->name)) {
    case messages::DomStorageClient::kResetSessionStorageConnections: {
      break;
    }
    case messages::DomStorageClient::kResetLocalStorageConnections: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDomStorageClientValidationInfo[] = {
    { &internal::DomStorageClient_ResetSessionStorageConnections_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::DomStorageClient_ResetLocalStorageConnections_Params_Data::Validate,
     nullptr /* no response */},
};

bool DomStorageClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::DomStorageClient::Name_,
    kDomStorageClientValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void DomStorageProviderInterceptorForTesting::BindDomStorage(::mojo::PendingReceiver<DomStorage> receiver, ::mojo::PendingRemote<DomStorageClient> client) {
  GetForwardingInterface()->BindDomStorage(
    std::move(receiver)
    , 
    std::move(client)
    );
}
DomStorageProviderAsyncWaiter::DomStorageProviderAsyncWaiter(
    DomStorageProvider* proxy) : proxy_(proxy) {}

DomStorageProviderAsyncWaiter::~DomStorageProviderAsyncWaiter() = default;





void DomStorageInterceptorForTesting::OpenLocalStorage(const ::blink::BlinkStorageKey& storage_key, const ::blink::LocalFrameToken& local_frame_token, ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> area) {
  GetForwardingInterface()->OpenLocalStorage(
    std::move(storage_key)
    , 
    std::move(local_frame_token)
    , 
    std::move(area)
    );
}
void DomStorageInterceptorForTesting::BindSessionStorageNamespace(const ::blink::String& namespace_id, ::mojo::PendingReceiver<::blink::mojom::blink::SessionStorageNamespace> receiver) {
  GetForwardingInterface()->BindSessionStorageNamespace(
    std::move(namespace_id)
    , 
    std::move(receiver)
    );
}
void DomStorageInterceptorForTesting::BindSessionStorageArea(const ::blink::BlinkStorageKey& storage_key, const ::blink::LocalFrameToken& local_frame_token, const ::blink::String& namespace_id, ::mojo::PendingReceiver<::blink::mojom::blink::StorageArea> session_namespace) {
  GetForwardingInterface()->BindSessionStorageArea(
    std::move(storage_key)
    , 
    std::move(local_frame_token)
    , 
    std::move(namespace_id)
    , 
    std::move(session_namespace)
    );
}
DomStorageAsyncWaiter::DomStorageAsyncWaiter(
    DomStorage* proxy) : proxy_(proxy) {}

DomStorageAsyncWaiter::~DomStorageAsyncWaiter() = default;





void DomStorageClientInterceptorForTesting::ResetSessionStorageConnections() {
  GetForwardingInterface()->ResetSessionStorageConnections();
}
void DomStorageClientInterceptorForTesting::ResetLocalStorageConnections() {
  GetForwardingInterface()->ResetLocalStorageConnections();
}
DomStorageClientAsyncWaiter::DomStorageClientAsyncWaiter(
    DomStorageClient* proxy) : proxy_(proxy) {}

DomStorageClientAsyncWaiter::~DomStorageClientAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif