// third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/direct_sockets/direct_sockets.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/read_only_buffer.mojom-forward.h"
#include "services/network/public/mojom/host_resolver.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-forward.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/restricted_udp_socket.mojom-forward.h"
#include "services/network/public/mojom/tcp_socket.mojom.h"
#include "services/network/public/mojom/udp_socket.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class DirectSocketsServiceProxy;

template <typename ImplRefTraits>
class DirectSocketsServiceStub;

class DirectSocketsServiceRequestValidator;
class DirectSocketsServiceResponseValidator;


class BLINK_COMMON_EXPORT DirectSocketsService
    : public DirectSocketsServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.DirectSocketsService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DirectSocketsServiceInterfaceBase;
  using Proxy_ = DirectSocketsServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DirectSocketsServiceStub<ImplRefTraits>;

  using RequestValidator_ = DirectSocketsServiceRequestValidator;
  using ResponseValidator_ = DirectSocketsServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOpenTCPSocketMinVersion = 0,
    kOpenConnectedUDPSocketMinVersion = 0,
    kOpenBoundUDPSocketMinVersion = 0,
    kOpenTCPServerSocketMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OpenTCPSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenConnectedUDPSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenBoundUDPSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenTCPServerSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DirectSocketsService() = default;

  using OpenTCPSocketCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, const std::optional<::net::IPEndPoint>&, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;
  using OpenTCPSocketMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, const std::optional<::net::IPEndPoint>&, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;

  virtual void OpenTCPSocket(DirectTCPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> receiver, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, OpenTCPSocketCallback callback) = 0;

  using OpenConnectedUDPSocketCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, const std::optional<::net::IPEndPoint>&)>;
  using OpenConnectedUDPSocketMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, const std::optional<::net::IPEndPoint>&)>;

  virtual void OpenConnectedUDPSocket(DirectConnectedUDPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener, OpenConnectedUDPSocketCallback callback) = 0;

  using OpenBoundUDPSocketCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;
  using OpenBoundUDPSocketMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;

  virtual void OpenBoundUDPSocket(DirectBoundUDPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener, OpenBoundUDPSocketCallback callback) = 0;

  using OpenTCPServerSocketCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;
  using OpenTCPServerSocketMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&)>;

  virtual void OpenTCPServerSocket(DirectTCPServerSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> receiver, OpenTCPServerSocketCallback callback) = 0;
};



class BLINK_COMMON_EXPORT DirectSocketsServiceProxy
    : public DirectSocketsService {
 public:
  using InterfaceType = DirectSocketsService;

  explicit DirectSocketsServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OpenTCPSocket(DirectTCPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> receiver, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, OpenTCPSocketCallback callback) final;
  
  void OpenConnectedUDPSocket(DirectConnectedUDPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener, OpenConnectedUDPSocketCallback callback) final;
  
  void OpenBoundUDPSocket(DirectBoundUDPSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener, OpenBoundUDPSocketCallback callback) final;
  
  void OpenTCPServerSocket(DirectTCPServerSocketOptionsPtr options, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> receiver, OpenTCPServerSocketCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT DirectSocketsServiceStubDispatch {
 public:
  static bool Accept(DirectSocketsService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DirectSocketsService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DirectSocketsService>>
class DirectSocketsServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DirectSocketsServiceStub() = default;
  ~DirectSocketsServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DirectSocketsServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DirectSocketsServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT DirectSocketsServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT DirectSocketsServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class BLINK_COMMON_EXPORT DirectTCPSocketOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DirectTCPSocketOptions, T>::value>;
  using DataView = DirectTCPSocketOptionsDataView;
  using Data_ = internal::DirectTCPSocketOptions_Data;

  template <typename... Args>
  static DirectTCPSocketOptionsPtr New(Args&&... args) {
    return DirectTCPSocketOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DirectTCPSocketOptionsPtr From(const U& u) {
    return mojo::TypeConverter<DirectTCPSocketOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DirectTCPSocketOptions>::Convert(*this);
  }


  DirectTCPSocketOptions();

  DirectTCPSocketOptions(
      const ::net::HostPortPair& remote_addr,
      std::optional<int32_t> send_buffer_size,
      std::optional<int32_t> receive_buffer_size,
      bool no_delay,
      ::network::mojom::TCPKeepAliveOptionsPtr keep_alive_options,
      std::optional<::net::DnsQueryType> dns_query_type);

DirectTCPSocketOptions(const DirectTCPSocketOptions&) = delete;
DirectTCPSocketOptions& operator=(const DirectTCPSocketOptions&) = delete;

  ~DirectTCPSocketOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DirectTCPSocketOptionsPtr>
  DirectTCPSocketOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DirectTCPSocketOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DirectTCPSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DirectTCPSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectTCPSocketOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectTCPSocketOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DirectTCPSocketOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DirectTCPSocketOptions_UnserializedMessageContext<
            UserType, DirectTCPSocketOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DirectTCPSocketOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DirectTCPSocketOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DirectTCPSocketOptions_UnserializedMessageContext<
            UserType, DirectTCPSocketOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DirectTCPSocketOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::HostPortPair remote_addr;
  
  std::optional<int32_t> send_buffer_size;
  
  std::optional<int32_t> receive_buffer_size;
  
  bool no_delay;
  
  ::network::mojom::TCPKeepAliveOptionsPtr keep_alive_options;
  
  std::optional<::net::DnsQueryType> dns_query_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DirectTCPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DirectTCPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DirectTCPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DirectTCPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT DirectConnectedUDPSocketOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DirectConnectedUDPSocketOptions, T>::value>;
  using DataView = DirectConnectedUDPSocketOptionsDataView;
  using Data_ = internal::DirectConnectedUDPSocketOptions_Data;

  template <typename... Args>
  static DirectConnectedUDPSocketOptionsPtr New(Args&&... args) {
    return DirectConnectedUDPSocketOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DirectConnectedUDPSocketOptionsPtr From(const U& u) {
    return mojo::TypeConverter<DirectConnectedUDPSocketOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DirectConnectedUDPSocketOptions>::Convert(*this);
  }


  DirectConnectedUDPSocketOptions();

  DirectConnectedUDPSocketOptions(
      const ::net::HostPortPair& remote_addr,
      std::optional<int32_t> send_buffer_size,
      std::optional<int32_t> receive_buffer_size,
      std::optional<::net::DnsQueryType> dns_query_type,
      std::optional<uint8_t> multicast_time_to_live,
      std::optional<bool> multicast_loopback);


  ~DirectConnectedUDPSocketOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DirectConnectedUDPSocketOptionsPtr>
  DirectConnectedUDPSocketOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DirectConnectedUDPSocketOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DirectConnectedUDPSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DirectConnectedUDPSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectConnectedUDPSocketOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectConnectedUDPSocketOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DirectConnectedUDPSocketOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DirectConnectedUDPSocketOptions_UnserializedMessageContext<
            UserType, DirectConnectedUDPSocketOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DirectConnectedUDPSocketOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DirectConnectedUDPSocketOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DirectConnectedUDPSocketOptions_UnserializedMessageContext<
            UserType, DirectConnectedUDPSocketOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DirectConnectedUDPSocketOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::HostPortPair remote_addr;
  
  std::optional<int32_t> send_buffer_size;
  
  std::optional<int32_t> receive_buffer_size;
  
  std::optional<::net::DnsQueryType> dns_query_type;
  
  std::optional<uint8_t> multicast_time_to_live;
  
  std::optional<bool> multicast_loopback;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DirectConnectedUDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DirectConnectedUDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DirectConnectedUDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DirectConnectedUDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT DirectBoundUDPSocketOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DirectBoundUDPSocketOptions, T>::value>;
  using DataView = DirectBoundUDPSocketOptionsDataView;
  using Data_ = internal::DirectBoundUDPSocketOptions_Data;

  template <typename... Args>
  static DirectBoundUDPSocketOptionsPtr New(Args&&... args) {
    return DirectBoundUDPSocketOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DirectBoundUDPSocketOptionsPtr From(const U& u) {
    return mojo::TypeConverter<DirectBoundUDPSocketOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DirectBoundUDPSocketOptions>::Convert(*this);
  }


  DirectBoundUDPSocketOptions();

  DirectBoundUDPSocketOptions(
      const ::net::IPEndPoint& local_addr,
      std::optional<int32_t> send_buffer_size,
      std::optional<int32_t> receive_buffer_size,
      std::optional<bool> ipv6_only,
      std::optional<bool> multicast_allow_address_sharing,
      std::optional<uint8_t> multicast_time_to_live,
      std::optional<bool> multicast_loopback);


  ~DirectBoundUDPSocketOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DirectBoundUDPSocketOptionsPtr>
  DirectBoundUDPSocketOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DirectBoundUDPSocketOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DirectBoundUDPSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DirectBoundUDPSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectBoundUDPSocketOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectBoundUDPSocketOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DirectBoundUDPSocketOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DirectBoundUDPSocketOptions_UnserializedMessageContext<
            UserType, DirectBoundUDPSocketOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DirectBoundUDPSocketOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DirectBoundUDPSocketOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DirectBoundUDPSocketOptions_UnserializedMessageContext<
            UserType, DirectBoundUDPSocketOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DirectBoundUDPSocketOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::IPEndPoint local_addr;
  
  std::optional<int32_t> send_buffer_size;
  
  std::optional<int32_t> receive_buffer_size;
  
  std::optional<bool> ipv6_only;
  
  std::optional<bool> multicast_allow_address_sharing;
  
  std::optional<uint8_t> multicast_time_to_live;
  
  std::optional<bool> multicast_loopback;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DirectBoundUDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DirectBoundUDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DirectBoundUDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DirectBoundUDPSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT DirectTCPServerSocketOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DirectTCPServerSocketOptions, T>::value>;
  using DataView = DirectTCPServerSocketOptionsDataView;
  using Data_ = internal::DirectTCPServerSocketOptions_Data;

  template <typename... Args>
  static DirectTCPServerSocketOptionsPtr New(Args&&... args) {
    return DirectTCPServerSocketOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DirectTCPServerSocketOptionsPtr From(const U& u) {
    return mojo::TypeConverter<DirectTCPServerSocketOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DirectTCPServerSocketOptions>::Convert(*this);
  }


  DirectTCPServerSocketOptions();

  DirectTCPServerSocketOptions(
      const ::net::IPEndPoint& local_addr,
      std::optional<bool> ipv6_only,
      std::optional<uint32_t> backlog);


  ~DirectTCPServerSocketOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DirectTCPServerSocketOptionsPtr>
  DirectTCPServerSocketOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DirectTCPServerSocketOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DirectTCPServerSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DirectTCPServerSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectTCPServerSocketOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DirectTCPServerSocketOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DirectTCPServerSocketOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DirectTCPServerSocketOptions_UnserializedMessageContext<
            UserType, DirectTCPServerSocketOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DirectTCPServerSocketOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DirectTCPServerSocketOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DirectTCPServerSocketOptions_UnserializedMessageContext<
            UserType, DirectTCPServerSocketOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DirectTCPServerSocketOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::IPEndPoint local_addr;
  
  std::optional<bool> ipv6_only;
  
  std::optional<uint32_t> backlog;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DirectTCPServerSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DirectTCPServerSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DirectTCPServerSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DirectTCPServerSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DirectTCPSocketOptionsPtr DirectTCPSocketOptions::Clone() const {
  return New(
      mojo::Clone(remote_addr),
      mojo::Clone(send_buffer_size),
      mojo::Clone(receive_buffer_size),
      mojo::Clone(no_delay),
      mojo::Clone(keep_alive_options),
      mojo::Clone(dns_query_type)
  );
}

template <typename T, DirectTCPSocketOptions::EnableIfSame<T>*>
bool DirectTCPSocketOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->remote_addr, other_struct.remote_addr))
    return false;
  if (!mojo::Equals(this->send_buffer_size, other_struct.send_buffer_size))
    return false;
  if (!mojo::Equals(this->receive_buffer_size, other_struct.receive_buffer_size))
    return false;
  if (!mojo::Equals(this->no_delay, other_struct.no_delay))
    return false;
  if (!mojo::Equals(this->keep_alive_options, other_struct.keep_alive_options))
    return false;
  if (!mojo::Equals(this->dns_query_type, other_struct.dns_query_type))
    return false;
  return true;
}

template <typename T, DirectTCPSocketOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.remote_addr < rhs.remote_addr)
    return true;
  if (rhs.remote_addr < lhs.remote_addr)
    return false;
  if (lhs.send_buffer_size < rhs.send_buffer_size)
    return true;
  if (rhs.send_buffer_size < lhs.send_buffer_size)
    return false;
  if (lhs.receive_buffer_size < rhs.receive_buffer_size)
    return true;
  if (rhs.receive_buffer_size < lhs.receive_buffer_size)
    return false;
  if (lhs.no_delay < rhs.no_delay)
    return true;
  if (rhs.no_delay < lhs.no_delay)
    return false;
  if (lhs.keep_alive_options < rhs.keep_alive_options)
    return true;
  if (rhs.keep_alive_options < lhs.keep_alive_options)
    return false;
  if (lhs.dns_query_type < rhs.dns_query_type)
    return true;
  if (rhs.dns_query_type < lhs.dns_query_type)
    return false;
  return false;
}
template <typename StructPtrType>
DirectConnectedUDPSocketOptionsPtr DirectConnectedUDPSocketOptions::Clone() const {
  return New(
      mojo::Clone(remote_addr),
      mojo::Clone(send_buffer_size),
      mojo::Clone(receive_buffer_size),
      mojo::Clone(dns_query_type),
      mojo::Clone(multicast_time_to_live),
      mojo::Clone(multicast_loopback)
  );
}

template <typename T, DirectConnectedUDPSocketOptions::EnableIfSame<T>*>
bool DirectConnectedUDPSocketOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->remote_addr, other_struct.remote_addr))
    return false;
  if (!mojo::Equals(this->send_buffer_size, other_struct.send_buffer_size))
    return false;
  if (!mojo::Equals(this->receive_buffer_size, other_struct.receive_buffer_size))
    return false;
  if (!mojo::Equals(this->dns_query_type, other_struct.dns_query_type))
    return false;
  if (!mojo::Equals(this->multicast_time_to_live, other_struct.multicast_time_to_live))
    return false;
  if (!mojo::Equals(this->multicast_loopback, other_struct.multicast_loopback))
    return false;
  return true;
}

template <typename T, DirectConnectedUDPSocketOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.remote_addr < rhs.remote_addr)
    return true;
  if (rhs.remote_addr < lhs.remote_addr)
    return false;
  if (lhs.send_buffer_size < rhs.send_buffer_size)
    return true;
  if (rhs.send_buffer_size < lhs.send_buffer_size)
    return false;
  if (lhs.receive_buffer_size < rhs.receive_buffer_size)
    return true;
  if (rhs.receive_buffer_size < lhs.receive_buffer_size)
    return false;
  if (lhs.dns_query_type < rhs.dns_query_type)
    return true;
  if (rhs.dns_query_type < lhs.dns_query_type)
    return false;
  if (lhs.multicast_time_to_live < rhs.multicast_time_to_live)
    return true;
  if (rhs.multicast_time_to_live < lhs.multicast_time_to_live)
    return false;
  if (lhs.multicast_loopback < rhs.multicast_loopback)
    return true;
  if (rhs.multicast_loopback < lhs.multicast_loopback)
    return false;
  return false;
}
template <typename StructPtrType>
DirectBoundUDPSocketOptionsPtr DirectBoundUDPSocketOptions::Clone() const {
  return New(
      mojo::Clone(local_addr),
      mojo::Clone(send_buffer_size),
      mojo::Clone(receive_buffer_size),
      mojo::Clone(ipv6_only),
      mojo::Clone(multicast_allow_address_sharing),
      mojo::Clone(multicast_time_to_live),
      mojo::Clone(multicast_loopback)
  );
}

template <typename T, DirectBoundUDPSocketOptions::EnableIfSame<T>*>
bool DirectBoundUDPSocketOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->local_addr, other_struct.local_addr))
    return false;
  if (!mojo::Equals(this->send_buffer_size, other_struct.send_buffer_size))
    return false;
  if (!mojo::Equals(this->receive_buffer_size, other_struct.receive_buffer_size))
    return false;
  if (!mojo::Equals(this->ipv6_only, other_struct.ipv6_only))
    return false;
  if (!mojo::Equals(this->multicast_allow_address_sharing, other_struct.multicast_allow_address_sharing))
    return false;
  if (!mojo::Equals(this->multicast_time_to_live, other_struct.multicast_time_to_live))
    return false;
  if (!mojo::Equals(this->multicast_loopback, other_struct.multicast_loopback))
    return false;
  return true;
}

template <typename T, DirectBoundUDPSocketOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.local_addr < rhs.local_addr)
    return true;
  if (rhs.local_addr < lhs.local_addr)
    return false;
  if (lhs.send_buffer_size < rhs.send_buffer_size)
    return true;
  if (rhs.send_buffer_size < lhs.send_buffer_size)
    return false;
  if (lhs.receive_buffer_size < rhs.receive_buffer_size)
    return true;
  if (rhs.receive_buffer_size < lhs.receive_buffer_size)
    return false;
  if (lhs.ipv6_only < rhs.ipv6_only)
    return true;
  if (rhs.ipv6_only < lhs.ipv6_only)
    return false;
  if (lhs.multicast_allow_address_sharing < rhs.multicast_allow_address_sharing)
    return true;
  if (rhs.multicast_allow_address_sharing < lhs.multicast_allow_address_sharing)
    return false;
  if (lhs.multicast_time_to_live < rhs.multicast_time_to_live)
    return true;
  if (rhs.multicast_time_to_live < lhs.multicast_time_to_live)
    return false;
  if (lhs.multicast_loopback < rhs.multicast_loopback)
    return true;
  if (rhs.multicast_loopback < lhs.multicast_loopback)
    return false;
  return false;
}
template <typename StructPtrType>
DirectTCPServerSocketOptionsPtr DirectTCPServerSocketOptions::Clone() const {
  return New(
      mojo::Clone(local_addr),
      mojo::Clone(ipv6_only),
      mojo::Clone(backlog)
  );
}

template <typename T, DirectTCPServerSocketOptions::EnableIfSame<T>*>
bool DirectTCPServerSocketOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->local_addr, other_struct.local_addr))
    return false;
  if (!mojo::Equals(this->ipv6_only, other_struct.ipv6_only))
    return false;
  if (!mojo::Equals(this->backlog, other_struct.backlog))
    return false;
  return true;
}

template <typename T, DirectTCPServerSocketOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.local_addr < rhs.local_addr)
    return true;
  if (rhs.local_addr < lhs.local_addr)
    return false;
  if (lhs.ipv6_only < rhs.ipv6_only)
    return true;
  if (rhs.ipv6_only < lhs.ipv6_only)
    return false;
  if (lhs.backlog < rhs.backlog)
    return true;
  if (rhs.backlog < lhs.backlog)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DirectTCPSocketOptions::DataView,
                                         ::blink::mojom::DirectTCPSocketOptionsPtr> {
  static bool IsNull(const ::blink::mojom::DirectTCPSocketOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DirectTCPSocketOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DirectTCPSocketOptions::remote_addr)& remote_addr(
      const ::blink::mojom::DirectTCPSocketOptionsPtr& input) {
    return input->remote_addr;
  }

  static decltype(::blink::mojom::DirectTCPSocketOptions::send_buffer_size) send_buffer_size(
      const ::blink::mojom::DirectTCPSocketOptionsPtr& input) {
    return input->send_buffer_size;
  }

  static decltype(::blink::mojom::DirectTCPSocketOptions::receive_buffer_size) receive_buffer_size(
      const ::blink::mojom::DirectTCPSocketOptionsPtr& input) {
    return input->receive_buffer_size;
  }

  static decltype(::blink::mojom::DirectTCPSocketOptions::no_delay) no_delay(
      const ::blink::mojom::DirectTCPSocketOptionsPtr& input) {
    return input->no_delay;
  }

  static const decltype(::blink::mojom::DirectTCPSocketOptions::keep_alive_options)& keep_alive_options(
      const ::blink::mojom::DirectTCPSocketOptionsPtr& input) {
    return input->keep_alive_options;
  }

  static decltype(::blink::mojom::DirectTCPSocketOptions::dns_query_type) dns_query_type(
      const ::blink::mojom::DirectTCPSocketOptionsPtr& input) {
    return input->dns_query_type;
  }

  static bool Read(::blink::mojom::DirectTCPSocketOptions::DataView input, ::blink::mojom::DirectTCPSocketOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DirectConnectedUDPSocketOptions::DataView,
                                         ::blink::mojom::DirectConnectedUDPSocketOptionsPtr> {
  static bool IsNull(const ::blink::mojom::DirectConnectedUDPSocketOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DirectConnectedUDPSocketOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DirectConnectedUDPSocketOptions::remote_addr)& remote_addr(
      const ::blink::mojom::DirectConnectedUDPSocketOptionsPtr& input) {
    return input->remote_addr;
  }

  static decltype(::blink::mojom::DirectConnectedUDPSocketOptions::send_buffer_size) send_buffer_size(
      const ::blink::mojom::DirectConnectedUDPSocketOptionsPtr& input) {
    return input->send_buffer_size;
  }

  static decltype(::blink::mojom::DirectConnectedUDPSocketOptions::receive_buffer_size) receive_buffer_size(
      const ::blink::mojom::DirectConnectedUDPSocketOptionsPtr& input) {
    return input->receive_buffer_size;
  }

  static decltype(::blink::mojom::DirectConnectedUDPSocketOptions::dns_query_type) dns_query_type(
      const ::blink::mojom::DirectConnectedUDPSocketOptionsPtr& input) {
    return input->dns_query_type;
  }

  static decltype(::blink::mojom::DirectConnectedUDPSocketOptions::multicast_time_to_live) multicast_time_to_live(
      const ::blink::mojom::DirectConnectedUDPSocketOptionsPtr& input) {
    return input->multicast_time_to_live;
  }

  static decltype(::blink::mojom::DirectConnectedUDPSocketOptions::multicast_loopback) multicast_loopback(
      const ::blink::mojom::DirectConnectedUDPSocketOptionsPtr& input) {
    return input->multicast_loopback;
  }

  static bool Read(::blink::mojom::DirectConnectedUDPSocketOptions::DataView input, ::blink::mojom::DirectConnectedUDPSocketOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DirectBoundUDPSocketOptions::DataView,
                                         ::blink::mojom::DirectBoundUDPSocketOptionsPtr> {
  static bool IsNull(const ::blink::mojom::DirectBoundUDPSocketOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DirectBoundUDPSocketOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DirectBoundUDPSocketOptions::local_addr)& local_addr(
      const ::blink::mojom::DirectBoundUDPSocketOptionsPtr& input) {
    return input->local_addr;
  }

  static decltype(::blink::mojom::DirectBoundUDPSocketOptions::send_buffer_size) send_buffer_size(
      const ::blink::mojom::DirectBoundUDPSocketOptionsPtr& input) {
    return input->send_buffer_size;
  }

  static decltype(::blink::mojom::DirectBoundUDPSocketOptions::receive_buffer_size) receive_buffer_size(
      const ::blink::mojom::DirectBoundUDPSocketOptionsPtr& input) {
    return input->receive_buffer_size;
  }

  static decltype(::blink::mojom::DirectBoundUDPSocketOptions::ipv6_only) ipv6_only(
      const ::blink::mojom::DirectBoundUDPSocketOptionsPtr& input) {
    return input->ipv6_only;
  }

  static decltype(::blink::mojom::DirectBoundUDPSocketOptions::multicast_allow_address_sharing) multicast_allow_address_sharing(
      const ::blink::mojom::DirectBoundUDPSocketOptionsPtr& input) {
    return input->multicast_allow_address_sharing;
  }

  static decltype(::blink::mojom::DirectBoundUDPSocketOptions::multicast_time_to_live) multicast_time_to_live(
      const ::blink::mojom::DirectBoundUDPSocketOptionsPtr& input) {
    return input->multicast_time_to_live;
  }

  static decltype(::blink::mojom::DirectBoundUDPSocketOptions::multicast_loopback) multicast_loopback(
      const ::blink::mojom::DirectBoundUDPSocketOptionsPtr& input) {
    return input->multicast_loopback;
  }

  static bool Read(::blink::mojom::DirectBoundUDPSocketOptions::DataView input, ::blink::mojom::DirectBoundUDPSocketOptionsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::DirectTCPServerSocketOptions::DataView,
                                         ::blink::mojom::DirectTCPServerSocketOptionsPtr> {
  static bool IsNull(const ::blink::mojom::DirectTCPServerSocketOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::DirectTCPServerSocketOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::DirectTCPServerSocketOptions::local_addr)& local_addr(
      const ::blink::mojom::DirectTCPServerSocketOptionsPtr& input) {
    return input->local_addr;
  }

  static decltype(::blink::mojom::DirectTCPServerSocketOptions::ipv6_only) ipv6_only(
      const ::blink::mojom::DirectTCPServerSocketOptionsPtr& input) {
    return input->ipv6_only;
  }

  static decltype(::blink::mojom::DirectTCPServerSocketOptions::backlog) backlog(
      const ::blink::mojom::DirectTCPServerSocketOptionsPtr& input) {
    return input->backlog;
  }

  static bool Read(::blink::mojom::DirectTCPServerSocketOptions::DataView input, ::blink::mojom::DirectTCPServerSocketOptionsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DIRECT_SOCKETS_DIRECT_SOCKETS_MOJOM_H_