// third_party/blink/public/mojom/digital_goods/digital_goods.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('payments.mojom.BillingResponseCode');
goog.require('payments.mojom.CreateDigitalGoodsResponseCode');
goog.require('payments.mojom.ItemDetails');
goog.require('payments.mojom.PurchaseReference');






goog.provide('payments.mojom.DigitalGoods');
goog.provide('payments.mojom.DigitalGoodsReceiver');
goog.provide('payments.mojom.DigitalGoodsCallbackRouter');
goog.provide('payments.mojom.DigitalGoodsInterface');
goog.provide('payments.mojom.DigitalGoodsRemote');
goog.provide('payments.mojom.DigitalGoodsPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
payments.mojom.DigitalGoodsPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        payments.mojom.DigitalGoods.$interfaceName,
        scope);
  }
};

/** @interface */
payments.mojom.DigitalGoodsInterface = class {
  
  /**
   * @param { !Array<!string> } itemIds
   * @return {!Promise<{
        code: !payments.mojom.BillingResponseCode,
        itemDetailsList: !Array<!payments.mojom.ItemDetails>,
   *  }>}
   */

  getDetails(itemIds) {}
  
  /**
   * @return {!Promise<{
        code: !payments.mojom.BillingResponseCode,
        purchaseReferenceList: !Array<!payments.mojom.PurchaseReference>,
   *  }>}
   */

  listPurchases() {}
  
  /**
   * @return {!Promise<{
        code: !payments.mojom.BillingResponseCode,
        purchaseReferenceList: !Array<!payments.mojom.PurchaseReference>,
   *  }>}
   */

  listPurchaseHistory() {}
  
  /**
   * @param { !string } purchaseToken
   * @return {!Promise<{
        code: !payments.mojom.BillingResponseCode,
   *  }>}
   */

  consume(purchaseToken) {}
};

/**
 * @export
 * @implements { payments.mojom.DigitalGoodsInterface }
 */
payments.mojom.DigitalGoodsRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!payments.mojom.DigitalGoodsPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          payments.mojom.DigitalGoodsPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!payments.mojom.DigitalGoodsPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!string> } itemIds
   * @return {!Promise<{
        code: !payments.mojom.BillingResponseCode,
        itemDetailsList: !Array<!payments.mojom.ItemDetails>,
   *  }>}
   */

  getDetails(
      itemIds) {
    return this.proxy.sendMessage(
        0,
        payments.mojom.DigitalGoods_GetDetails_ParamsSpec.$,
        payments.mojom.DigitalGoods_GetDetails_ResponseParamsSpec.$,
        [
          itemIds
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        code: !payments.mojom.BillingResponseCode,
        purchaseReferenceList: !Array<!payments.mojom.PurchaseReference>,
   *  }>}
   */

  listPurchases() {
    return this.proxy.sendMessage(
        1,
        payments.mojom.DigitalGoods_ListPurchases_ParamsSpec.$,
        payments.mojom.DigitalGoods_ListPurchases_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        code: !payments.mojom.BillingResponseCode,
        purchaseReferenceList: !Array<!payments.mojom.PurchaseReference>,
   *  }>}
   */

  listPurchaseHistory() {
    return this.proxy.sendMessage(
        2,
        payments.mojom.DigitalGoods_ListPurchaseHistory_ParamsSpec.$,
        payments.mojom.DigitalGoods_ListPurchaseHistory_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } purchaseToken
   * @return {!Promise<{
        code: !payments.mojom.BillingResponseCode,
   *  }>}
   */

  consume(
      purchaseToken) {
    return this.proxy.sendMessage(
        3,
        payments.mojom.DigitalGoods_Consume_ParamsSpec.$,
        payments.mojom.DigitalGoods_Consume_ResponseParamsSpec.$,
        [
          purchaseToken
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DigitalGoods
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
payments.mojom.DigitalGoodsReceiver = class {
  /**
   * @param {!payments.mojom.DigitalGoodsInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!payments.mojom.DigitalGoodsRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        payments.mojom.DigitalGoodsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.DigitalGoodsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        payments.mojom.DigitalGoods_GetDetails_ParamsSpec.$,
        payments.mojom.DigitalGoods_GetDetails_ResponseParamsSpec.$,
        impl.getDetails.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        payments.mojom.DigitalGoods_ListPurchases_ParamsSpec.$,
        payments.mojom.DigitalGoods_ListPurchases_ResponseParamsSpec.$,
        impl.listPurchases.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        payments.mojom.DigitalGoods_ListPurchaseHistory_ParamsSpec.$,
        payments.mojom.DigitalGoods_ListPurchaseHistory_ResponseParamsSpec.$,
        impl.listPurchaseHistory.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        payments.mojom.DigitalGoods_Consume_ParamsSpec.$,
        payments.mojom.DigitalGoods_Consume_ResponseParamsSpec.$,
        impl.consume.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
payments.mojom.DigitalGoods = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.DigitalGoods";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!payments.mojom.DigitalGoodsRemote}
   * @export
   */
  static getRemote() {
    let remote = new payments.mojom.DigitalGoodsRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DigitalGoods
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
payments.mojom.DigitalGoodsCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      payments.mojom.DigitalGoodsRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.DigitalGoodsRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDetails =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        payments.mojom.DigitalGoods_GetDetails_ParamsSpec.$,
        payments.mojom.DigitalGoods_GetDetails_ResponseParamsSpec.$,
        this.getDetails.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.listPurchases =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        payments.mojom.DigitalGoods_ListPurchases_ParamsSpec.$,
        payments.mojom.DigitalGoods_ListPurchases_ResponseParamsSpec.$,
        this.listPurchases.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.listPurchaseHistory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        payments.mojom.DigitalGoods_ListPurchaseHistory_ParamsSpec.$,
        payments.mojom.DigitalGoods_ListPurchaseHistory_ResponseParamsSpec.$,
        this.listPurchaseHistory.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.consume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        payments.mojom.DigitalGoods_Consume_ParamsSpec.$,
        payments.mojom.DigitalGoods_Consume_ResponseParamsSpec.$,
        this.consume.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('payments.mojom.DigitalGoodsFactory');
goog.provide('payments.mojom.DigitalGoodsFactoryReceiver');
goog.provide('payments.mojom.DigitalGoodsFactoryCallbackRouter');
goog.provide('payments.mojom.DigitalGoodsFactoryInterface');
goog.provide('payments.mojom.DigitalGoodsFactoryRemote');
goog.provide('payments.mojom.DigitalGoodsFactoryPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
payments.mojom.DigitalGoodsFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        payments.mojom.DigitalGoodsFactory.$interfaceName,
        scope);
  }
};

/** @interface */
payments.mojom.DigitalGoodsFactoryInterface = class {
  
  /**
   * @param { !string } paymentMethod
   * @return {!Promise<{
        code: !payments.mojom.CreateDigitalGoodsResponseCode,
        digitalGoods: ?payments.mojom.DigitalGoodsRemote,
   *  }>}
   */

  createDigitalGoods(paymentMethod) {}
};

/**
 * @export
 * @implements { payments.mojom.DigitalGoodsFactoryInterface }
 */
payments.mojom.DigitalGoodsFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!payments.mojom.DigitalGoodsFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          payments.mojom.DigitalGoodsFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!payments.mojom.DigitalGoodsFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } paymentMethod
   * @return {!Promise<{
        code: !payments.mojom.CreateDigitalGoodsResponseCode,
        digitalGoods: ?payments.mojom.DigitalGoodsRemote,
   *  }>}
   */

  createDigitalGoods(
      paymentMethod) {
    return this.proxy.sendMessage(
        0,
        payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ParamsSpec.$,
        payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsSpec.$,
        [
          paymentMethod
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DigitalGoodsFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
payments.mojom.DigitalGoodsFactoryReceiver = class {
  /**
   * @param {!payments.mojom.DigitalGoodsFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!payments.mojom.DigitalGoodsFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        payments.mojom.DigitalGoodsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.DigitalGoodsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ParamsSpec.$,
        payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsSpec.$,
        impl.createDigitalGoods.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
payments.mojom.DigitalGoodsFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "payments.mojom.DigitalGoodsFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!payments.mojom.DigitalGoodsFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new payments.mojom.DigitalGoodsFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DigitalGoodsFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
payments.mojom.DigitalGoodsFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      payments.mojom.DigitalGoodsFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!payments.mojom.DigitalGoodsFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createDigitalGoods =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ParamsSpec.$,
        payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsSpec.$,
        this.createDigitalGoods.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('payments.mojom.DigitalGoods_GetDetails_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.DigitalGoods_GetDetails_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.DigitalGoods_GetDetails_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.DigitalGoods_GetDetails_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.DigitalGoods_ListPurchases_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.DigitalGoods_ListPurchases_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.DigitalGoods_ListPurchases_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.DigitalGoods_ListPurchases_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.DigitalGoods_ListPurchaseHistory_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.DigitalGoods_ListPurchaseHistory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.DigitalGoods_ListPurchaseHistory_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.DigitalGoods_ListPurchaseHistory_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.DigitalGoods_Consume_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.DigitalGoods_Consume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.DigitalGoods_Consume_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.DigitalGoods_Consume_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    payments.mojom.DigitalGoods_GetDetails_ParamsSpec.$,
    'DigitalGoods_GetDetails_Params',
    [
      mojo.internal.StructField(
        'itemIds', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('payments.mojom.DigitalGoods_GetDetails_Params');

/** @record */
payments.mojom.DigitalGoods_GetDetails_Params = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.itemIds;
  }
};



mojo.internal.Struct(
    payments.mojom.DigitalGoods_GetDetails_ResponseParamsSpec.$,
    'DigitalGoods_GetDetails_ResponseParams',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        payments.mojom.BillingResponseCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'itemDetailsList', 8,
        0,
        mojo.internal.Array(payments.mojom.ItemDetailsSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('payments.mojom.DigitalGoods_GetDetails_ResponseParams');

/** @record */
payments.mojom.DigitalGoods_GetDetails_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.BillingResponseCode } */
    this.code;
    /** @export { !Array<!payments.mojom.ItemDetails> } */
    this.itemDetailsList;
  }
};



mojo.internal.Struct(
    payments.mojom.DigitalGoods_ListPurchases_ParamsSpec.$,
    'DigitalGoods_ListPurchases_Params',
    [
    ],
    [[0, 8],]);



goog.provide('payments.mojom.DigitalGoods_ListPurchases_Params');

/** @record */
payments.mojom.DigitalGoods_ListPurchases_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    payments.mojom.DigitalGoods_ListPurchases_ResponseParamsSpec.$,
    'DigitalGoods_ListPurchases_ResponseParams',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        payments.mojom.BillingResponseCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'purchaseReferenceList', 8,
        0,
        mojo.internal.Array(payments.mojom.PurchaseReferenceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('payments.mojom.DigitalGoods_ListPurchases_ResponseParams');

/** @record */
payments.mojom.DigitalGoods_ListPurchases_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.BillingResponseCode } */
    this.code;
    /** @export { !Array<!payments.mojom.PurchaseReference> } */
    this.purchaseReferenceList;
  }
};



mojo.internal.Struct(
    payments.mojom.DigitalGoods_ListPurchaseHistory_ParamsSpec.$,
    'DigitalGoods_ListPurchaseHistory_Params',
    [
    ],
    [[0, 8],]);



goog.provide('payments.mojom.DigitalGoods_ListPurchaseHistory_Params');

/** @record */
payments.mojom.DigitalGoods_ListPurchaseHistory_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    payments.mojom.DigitalGoods_ListPurchaseHistory_ResponseParamsSpec.$,
    'DigitalGoods_ListPurchaseHistory_ResponseParams',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        payments.mojom.BillingResponseCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'purchaseReferenceList', 8,
        0,
        mojo.internal.Array(payments.mojom.PurchaseReferenceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('payments.mojom.DigitalGoods_ListPurchaseHistory_ResponseParams');

/** @record */
payments.mojom.DigitalGoods_ListPurchaseHistory_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.BillingResponseCode } */
    this.code;
    /** @export { !Array<!payments.mojom.PurchaseReference> } */
    this.purchaseReferenceList;
  }
};



mojo.internal.Struct(
    payments.mojom.DigitalGoods_Consume_ParamsSpec.$,
    'DigitalGoods_Consume_Params',
    [
      mojo.internal.StructField(
        'purchaseToken', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('payments.mojom.DigitalGoods_Consume_Params');

/** @record */
payments.mojom.DigitalGoods_Consume_Params = class {
  constructor() {
    /** @export { !string } */
    this.purchaseToken;
  }
};



mojo.internal.Struct(
    payments.mojom.DigitalGoods_Consume_ResponseParamsSpec.$,
    'DigitalGoods_Consume_ResponseParams',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        payments.mojom.BillingResponseCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('payments.mojom.DigitalGoods_Consume_ResponseParams');

/** @record */
payments.mojom.DigitalGoods_Consume_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.BillingResponseCode } */
    this.code;
  }
};



mojo.internal.Struct(
    payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ParamsSpec.$,
    'DigitalGoodsFactory_CreateDigitalGoods_Params',
    [
      mojo.internal.StructField(
        'paymentMethod', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_Params');

/** @record */
payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_Params = class {
  constructor() {
    /** @export { !string } */
    this.paymentMethod;
  }
};



mojo.internal.Struct(
    payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ResponseParamsSpec.$,
    'DigitalGoodsFactory_CreateDigitalGoods_ResponseParams',
    [
      mojo.internal.StructField(
        'code', 0,
        0,
        payments.mojom.CreateDigitalGoodsResponseCodeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'digitalGoods', 4,
        0,
        mojo.internal.InterfaceProxy(payments.mojom.DigitalGoodsRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ResponseParams');

/** @record */
payments.mojom.DigitalGoodsFactory_CreateDigitalGoods_ResponseParams = class {
  constructor() {
    /** @export { !payments.mojom.CreateDigitalGoodsResponseCode } */
    this.code;
    /** @export { (payments.mojom.DigitalGoodsRemote|undefined) } */
    this.digitalGoods;
  }
};

