// third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/blocked_by_response_reason.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "third_party/blink/public/mojom/devtools/inspector_issue.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

template <>
struct hash<::blink::mojom::InspectorIssueCode>
    : public mojo::internal::EnumHashImpl<::blink::mojom::InspectorIssueCode> {};

template <>
struct hash<::blink::mojom::HeavyAdResolutionStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::HeavyAdResolutionStatus> {};

template <>
struct hash<::blink::mojom::HeavyAdReason>
    : public mojo::internal::EnumHashImpl<::blink::mojom::HeavyAdReason> {};

template <>
struct hash<::blink::mojom::AttributionReportingIssueType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::AttributionReportingIssueType> {};

template <>
struct hash<::blink::mojom::MixedContentResolutionStatus>
    : public mojo::internal::EnumHashImpl<::blink::mojom::MixedContentResolutionStatus> {};

template <>
struct hash<::blink::mojom::ContentSecurityPolicyViolationType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ContentSecurityPolicyViolationType> {};

template <>
struct hash<::blink::mojom::CookieOperation>
    : public mojo::internal::EnumHashImpl<::blink::mojom::CookieOperation> {};

template <>
struct hash<::blink::mojom::CookieExclusionReason>
    : public mojo::internal::EnumHashImpl<::blink::mojom::CookieExclusionReason> {};

template <>
struct hash<::blink::mojom::CookieWarningReason>
    : public mojo::internal::EnumHashImpl<::blink::mojom::CookieWarningReason> {};

template <>
struct hash<::blink::mojom::SharedArrayBufferIssueType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::SharedArrayBufferIssueType> {};

template <>
struct hash<::blink::mojom::FederatedAuthRequestResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FederatedAuthRequestResult> {};

template <>
struct hash<::blink::mojom::FederatedAuthUserInfoRequestResult>
    : public mojo::internal::EnumHashImpl<::blink::mojom::FederatedAuthUserInfoRequestResult> {};

template <>
struct hash<::blink::mojom::PartitioningBlobURLInfo>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PartitioningBlobURLInfo> {};

template <>
struct hash<::blink::mojom::GenericIssueErrorType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::GenericIssueErrorType> {};

template <>
struct hash<::blink::mojom::DeprecationIssueType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::DeprecationIssueType> {};

template <>
struct hash<::blink::mojom::UserReidentificationIssueType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::UserReidentificationIssueType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InspectorIssueCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::InspectorIssueCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::InspectorIssueCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HeavyAdResolutionStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::HeavyAdResolutionStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::HeavyAdResolutionStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HeavyAdReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::HeavyAdReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::HeavyAdReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AttributionReportingIssueType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::AttributionReportingIssueType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::AttributionReportingIssueType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MixedContentResolutionStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::MixedContentResolutionStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::MixedContentResolutionStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ContentSecurityPolicyViolationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ContentSecurityPolicyViolationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ContentSecurityPolicyViolationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CookieOperation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::CookieOperation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CookieOperation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CookieExclusionReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::CookieExclusionReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CookieExclusionReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CookieWarningReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::CookieWarningReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CookieWarningReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedArrayBufferIssueType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::SharedArrayBufferIssueType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::SharedArrayBufferIssueType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FederatedAuthRequestResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FederatedAuthRequestResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FederatedAuthRequestResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FederatedAuthUserInfoRequestResult, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::FederatedAuthUserInfoRequestResult, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::FederatedAuthUserInfoRequestResult>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PartitioningBlobURLInfo, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PartitioningBlobURLInfo, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::PartitioningBlobURLInfo>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GenericIssueErrorType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::GenericIssueErrorType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::GenericIssueErrorType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DeprecationIssueType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::DeprecationIssueType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::DeprecationIssueType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::UserReidentificationIssueType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::UserReidentificationIssueType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::UserReidentificationIssueType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AffectedCookieDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AffectedCookieDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AffectedCookie_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in AffectedCookie struct");

    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_path,
      path_fragment);

    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in AffectedCookie struct");

    decltype(Traits::domain(input)) in_domain = Traits::domain(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain)::BaseType> domain_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_domain,
      domain_fragment);

    fragment->domain.Set(
        domain_fragment.is_null() ? nullptr : domain_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->domain.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domain in AffectedCookie struct");
  }

  static bool Deserialize(::blink::mojom::internal::AffectedCookie_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AffectedCookieDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AffectedRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AffectedRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AffectedRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::request_id(input)) in_request_id = Traits::request_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_id)::BaseType> request_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_request_id,
      request_id_fragment);

    fragment->request_id.Set(
        request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in AffectedRequest struct");
  }

  static bool Deserialize(::blink::mojom::internal::AffectedRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AffectedRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AffectedFrameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AffectedFrameDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AffectedFrame_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::frame_id(input)) in_frame_id = Traits::frame_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_id)::BaseType> frame_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_frame_id,
      frame_id_fragment);

    fragment->frame_id.Set(
        frame_id_fragment.is_null() ? nullptr : frame_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame_id in AffectedFrame struct");
  }

  static bool Deserialize(::blink::mojom::internal::AffectedFrame_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AffectedFrameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AffectedLocationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AffectedLocationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AffectedLocation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::script_id(input)) in_script_id = Traits::script_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->script_id)::BaseType> script_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_script_id,
      script_id_fragment);

    fragment->script_id.Set(
        script_id_fragment.is_null() ? nullptr : script_id_fragment.data());

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    fragment->line = Traits::line(input);

    fragment->column = Traits::column(input);
  }

  static bool Deserialize(::blink::mojom::internal::AffectedLocation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AffectedLocationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BlockedByResponseIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BlockedByResponseIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BlockedByResponseIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::request(input)) in_request = Traits::request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request)::BaseType> request_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedRequestDataView>(
      in_request,
      request_fragment);

    fragment->request.Set(
        request_fragment.is_null() ? nullptr : request_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->request.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in BlockedByResponseIssueDetails struct");

    decltype(Traits::parentFrame(input)) in_parentFrame = Traits::parentFrame(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parentFrame)::BaseType> parentFrame_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedFrameDataView>(
      in_parentFrame,
      parentFrame_fragment);

    fragment->parentFrame.Set(
        parentFrame_fragment.is_null() ? nullptr : parentFrame_fragment.data());

    decltype(Traits::blockedFrame(input)) in_blockedFrame = Traits::blockedFrame(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blockedFrame)::BaseType> blockedFrame_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedFrameDataView>(
      in_blockedFrame,
      blockedFrame_fragment);

    fragment->blockedFrame.Set(
        blockedFrame_fragment.is_null() ? nullptr : blockedFrame_fragment.data());

    
    mojo::internal::Serialize<::network::mojom::BlockedByResponseReason>(
      Traits::reason(input),
      &fragment->reason);
  }

  static bool Deserialize(::blink::mojom::internal::BlockedByResponseIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BlockedByResponseIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HeavyAdIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::HeavyAdIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::HeavyAdIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::HeavyAdResolutionStatus>(
      Traits::resolution(input),
      &fragment->resolution);

    
    mojo::internal::Serialize<::blink::mojom::HeavyAdReason>(
      Traits::reason(input),
      &fragment->reason);

    decltype(Traits::frame(input)) in_frame = Traits::frame(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame)::BaseType> frame_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedFrameDataView>(
      in_frame,
      frame_fragment);

    fragment->frame.Set(
        frame_fragment.is_null() ? nullptr : frame_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->frame.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null frame in HeavyAdIssueDetails struct");
  }

  static bool Deserialize(::blink::mojom::internal::HeavyAdIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::HeavyAdIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AttributionReportingIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AttributionReportingIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AttributionReportingIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::AttributionReportingIssueType>(
      Traits::violation_type(input),
      &fragment->violation_type);

    decltype(Traits::request(input)) in_request = Traits::request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request)::BaseType> request_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedRequestDataView>(
      in_request,
      request_fragment);

    fragment->request.Set(
        request_fragment.is_null() ? nullptr : request_fragment.data());

    decltype(Traits::invalid_parameter(input)) in_invalid_parameter = Traits::invalid_parameter(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->invalid_parameter)::BaseType> invalid_parameter_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_invalid_parameter,
      invalid_parameter_fragment);

    fragment->invalid_parameter.Set(
        invalid_parameter_fragment.is_null() ? nullptr : invalid_parameter_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::AttributionReportingIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AttributionReportingIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::MixedContentIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MixedContentIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MixedContentIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::RequestContextType>(
      Traits::request_context(input),
      &fragment->request_context);

    
    mojo::internal::Serialize<::blink::mojom::MixedContentResolutionStatus>(
      Traits::resolution_status(input),
      &fragment->resolution_status);

    decltype(Traits::insecure_url(input)) in_insecure_url = Traits::insecure_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->insecure_url)::BaseType> insecure_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_insecure_url,
      insecure_url_fragment);

    fragment->insecure_url.Set(
        insecure_url_fragment.is_null() ? nullptr : insecure_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->insecure_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null insecure_url in MixedContentIssueDetails struct");

    decltype(Traits::main_resource_url(input)) in_main_resource_url = Traits::main_resource_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->main_resource_url)::BaseType> main_resource_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_main_resource_url,
      main_resource_url_fragment);

    fragment->main_resource_url.Set(
        main_resource_url_fragment.is_null() ? nullptr : main_resource_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->main_resource_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null main_resource_url in MixedContentIssueDetails struct");

    decltype(Traits::request(input)) in_request = Traits::request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request)::BaseType> request_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedRequestDataView>(
      in_request,
      request_fragment);

    fragment->request.Set(
        request_fragment.is_null() ? nullptr : request_fragment.data());

    decltype(Traits::frame(input)) in_frame = Traits::frame(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame)::BaseType> frame_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedFrameDataView>(
      in_frame,
      frame_fragment);

    fragment->frame.Set(
        frame_fragment.is_null() ? nullptr : frame_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::MixedContentIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::MixedContentIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ContentSecurityPolicyIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ContentSecurityPolicyIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ContentSecurityPolicyIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::blocked_url(input)) in_blocked_url = Traits::blocked_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blocked_url)::BaseType> blocked_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_blocked_url,
      blocked_url_fragment);

    fragment->blocked_url.Set(
        blocked_url_fragment.is_null() ? nullptr : blocked_url_fragment.data());

    decltype(Traits::violated_directive(input)) in_violated_directive = Traits::violated_directive(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->violated_directive)::BaseType> violated_directive_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_violated_directive,
      violated_directive_fragment);

    fragment->violated_directive.Set(
        violated_directive_fragment.is_null() ? nullptr : violated_directive_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->violated_directive.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null violated_directive in ContentSecurityPolicyIssueDetails struct");

    fragment->is_report_only = Traits::is_report_only(input);

    
    mojo::internal::Serialize<::blink::mojom::ContentSecurityPolicyViolationType>(
      Traits::content_security_policy_violation_type(input),
      &fragment->content_security_policy_violation_type);

    decltype(Traits::frame_ancestor(input)) in_frame_ancestor = Traits::frame_ancestor(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_ancestor)::BaseType> frame_ancestor_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedFrameDataView>(
      in_frame_ancestor,
      frame_ancestor_fragment);

    fragment->frame_ancestor.Set(
        frame_ancestor_fragment.is_null() ? nullptr : frame_ancestor_fragment.data());

    decltype(Traits::affected_location(input)) in_affected_location = Traits::affected_location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->affected_location)::BaseType> affected_location_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedLocationDataView>(
      in_affected_location,
      affected_location_fragment);

    fragment->affected_location.Set(
        affected_location_fragment.is_null() ? nullptr : affected_location_fragment.data());

    fragment->violating_node_id = Traits::violating_node_id(input);
  }

  static bool Deserialize(::blink::mojom::internal::ContentSecurityPolicyIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ContentSecurityPolicyIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CookieIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CookieIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CookieIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::cookie(input)) in_cookie = Traits::cookie(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie)::BaseType> cookie_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedCookieDataView>(
      in_cookie,
      cookie_fragment);

    fragment->cookie.Set(
        cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->cookie.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cookie in CookieIssueDetails struct");

    decltype(Traits::exclusion_reason(input)) in_exclusion_reason = Traits::exclusion_reason(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->exclusion_reason)::BaseType>
        exclusion_reason_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& exclusion_reason_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::CookieExclusionReason_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CookieExclusionReason>>(
      in_exclusion_reason,
      exclusion_reason_fragment,
      &exclusion_reason_validate_params);

    fragment->exclusion_reason.Set(
        exclusion_reason_fragment.is_null() ? nullptr : exclusion_reason_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->exclusion_reason.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null exclusion_reason in CookieIssueDetails struct");

    decltype(Traits::warning_reason(input)) in_warning_reason = Traits::warning_reason(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->warning_reason)::BaseType>
        warning_reason_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& warning_reason_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::CookieWarningReason_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CookieWarningReason>>(
      in_warning_reason,
      warning_reason_fragment,
      &warning_reason_validate_params);

    fragment->warning_reason.Set(
        warning_reason_fragment.is_null() ? nullptr : warning_reason_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->warning_reason.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null warning_reason in CookieIssueDetails struct");

    
    mojo::internal::Serialize<::blink::mojom::CookieOperation>(
      Traits::operation(input),
      &fragment->operation);

    decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site_for_cookies)::BaseType> site_for_cookies_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_site_for_cookies,
      site_for_cookies_fragment);

    fragment->site_for_cookies.Set(
        site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

    decltype(Traits::cookie_url(input)) in_cookie_url = Traits::cookie_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_url)::BaseType> cookie_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_cookie_url,
      cookie_url_fragment);

    fragment->cookie_url.Set(
        cookie_url_fragment.is_null() ? nullptr : cookie_url_fragment.data());

    decltype(Traits::request(input)) in_request = Traits::request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request)::BaseType> request_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedRequestDataView>(
      in_request,
      request_fragment);

    fragment->request.Set(
        request_fragment.is_null() ? nullptr : request_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::CookieIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CookieIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedArrayBufferIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SharedArrayBufferIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SharedArrayBufferIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::affected_location(input)) in_affected_location = Traits::affected_location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->affected_location)::BaseType> affected_location_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedLocationDataView>(
      in_affected_location,
      affected_location_fragment);

    fragment->affected_location.Set(
        affected_location_fragment.is_null() ? nullptr : affected_location_fragment.data());

    fragment->is_warning = Traits::is_warning(input);

    
    mojo::internal::Serialize<::blink::mojom::SharedArrayBufferIssueType>(
      Traits::type(input),
      &fragment->type);
  }

  static bool Deserialize(::blink::mojom::internal::SharedArrayBufferIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SharedArrayBufferIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::LowTextContrastIssueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::LowTextContrastIssueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::LowTextContrastIssue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->violating_node_id = Traits::violating_node_id(input);

    decltype(Traits::violating_node_selector(input)) in_violating_node_selector = Traits::violating_node_selector(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->violating_node_selector)::BaseType> violating_node_selector_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_violating_node_selector,
      violating_node_selector_fragment);

    fragment->violating_node_selector.Set(
        violating_node_selector_fragment.is_null() ? nullptr : violating_node_selector_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->violating_node_selector.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null violating_node_selector in LowTextContrastIssue struct");

    fragment->contrast_ratio = Traits::contrast_ratio(input);

    fragment->threshold_aa = Traits::threshold_aa(input);

    fragment->threshold_aaa = Traits::threshold_aaa(input);

    decltype(Traits::font_size(input)) in_font_size = Traits::font_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->font_size)::BaseType> font_size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_font_size,
      font_size_fragment);

    fragment->font_size.Set(
        font_size_fragment.is_null() ? nullptr : font_size_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->font_size.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null font_size in LowTextContrastIssue struct");

    decltype(Traits::font_weight(input)) in_font_weight = Traits::font_weight(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->font_weight)::BaseType> font_weight_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_font_weight,
      font_weight_fragment);

    fragment->font_weight.Set(
        font_weight_fragment.is_null() ? nullptr : font_weight_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->font_weight.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null font_weight in LowTextContrastIssue struct");
  }

  static bool Deserialize(::blink::mojom::internal::LowTextContrastIssue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::LowTextContrastIssueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FederatedAuthRequestIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FederatedAuthRequestIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FederatedAuthRequestIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::FederatedAuthRequestResult>(
      Traits::status(input),
      &fragment->status);
  }

  static bool Deserialize(::blink::mojom::internal::FederatedAuthRequestIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FederatedAuthRequestIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FederatedAuthUserInfoRequestIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FederatedAuthUserInfoRequestIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FederatedAuthUserInfoRequestIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::FederatedAuthUserInfoRequestResult>(
      Traits::status(input),
      &fragment->status);
  }

  static bool Deserialize(::blink::mojom::internal::FederatedAuthUserInfoRequestIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FederatedAuthUserInfoRequestIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BounceTrackingIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BounceTrackingIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::BounceTrackingIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tracking_sites(input)) in_tracking_sites = Traits::tracking_sites(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tracking_sites)::BaseType>
        tracking_sites_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tracking_sites_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_tracking_sites,
      tracking_sites_fragment,
      &tracking_sites_validate_params);

    fragment->tracking_sites.Set(
        tracking_sites_fragment.is_null() ? nullptr : tracking_sites_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tracking_sites.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tracking_sites in BounceTrackingIssueDetails struct");
  }

  static bool Deserialize(::blink::mojom::internal::BounceTrackingIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BounceTrackingIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PartitioningBlobURLIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PartitioningBlobURLIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PartitioningBlobURLIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PartitioningBlobURLIssueDetails struct");

    
    mojo::internal::Serialize<::blink::mojom::PartitioningBlobURLInfo>(
      Traits::partitioning_blob_url_info(input),
      &fragment->partitioning_blob_url_info);
  }

  static bool Deserialize(::blink::mojom::internal::PartitioningBlobURLIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PartitioningBlobURLIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CookieDeprecationMetadataIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CookieDeprecationMetadataIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CookieDeprecationMetadataIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::allowed_sites(input)) in_allowed_sites = Traits::allowed_sites(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allowed_sites)::BaseType>
        allowed_sites_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allowed_sites_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_allowed_sites,
      allowed_sites_fragment,
      &allowed_sites_validate_params);

    fragment->allowed_sites.Set(
        allowed_sites_fragment.is_null() ? nullptr : allowed_sites_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->allowed_sites.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allowed_sites in CookieDeprecationMetadataIssueDetails struct");

    fragment->opt_out_percentage = Traits::opt_out_percentage(input);

    fragment->is_opt_out_top_level = Traits::is_opt_out_top_level(input);

    
    mojo::internal::Serialize<::blink::mojom::CookieOperation>(
      Traits::operation(input),
      &fragment->operation);
  }

  static bool Deserialize(::blink::mojom::internal::CookieDeprecationMetadataIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CookieDeprecationMetadataIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GenericIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GenericIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::GenericIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::GenericIssueErrorType>(
      Traits::error_type(input),
      &fragment->error_type);

    decltype(Traits::frame_id(input)) in_frame_id = Traits::frame_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_id)::BaseType> frame_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_frame_id,
      frame_id_fragment);

    fragment->frame_id.Set(
        frame_id_fragment.is_null() ? nullptr : frame_id_fragment.data());

    fragment->violating_node_id = Traits::violating_node_id(input);

    decltype(Traits::violating_node_attribute(input)) in_violating_node_attribute = Traits::violating_node_attribute(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->violating_node_attribute)::BaseType> violating_node_attribute_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_violating_node_attribute,
      violating_node_attribute_fragment);

    fragment->violating_node_attribute.Set(
        violating_node_attribute_fragment.is_null() ? nullptr : violating_node_attribute_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::GenericIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GenericIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DeprecationIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DeprecationIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DeprecationIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::DeprecationIssueType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::affected_location(input)) in_affected_location = Traits::affected_location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->affected_location)::BaseType> affected_location_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedLocationDataView>(
      in_affected_location,
      affected_location_fragment);

    fragment->affected_location.Set(
        affected_location_fragment.is_null() ? nullptr : affected_location_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->affected_location.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null affected_location in DeprecationIssueDetails struct");
  }

  static bool Deserialize(::blink::mojom::internal::DeprecationIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DeprecationIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::UserReidentificationIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::UserReidentificationIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::UserReidentificationIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::UserReidentificationIssueType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::request(input)) in_request = Traits::request(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request)::BaseType> request_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedRequestDataView>(
      in_request,
      request_fragment);

    fragment->request.Set(
        request_fragment.is_null() ? nullptr : request_fragment.data());

    decltype(Traits::sourceCodeLocation(input)) in_sourceCodeLocation = Traits::sourceCodeLocation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sourceCodeLocation)::BaseType> sourceCodeLocation_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AffectedLocationDataView>(
      in_sourceCodeLocation,
      sourceCodeLocation_fragment);

    fragment->sourceCodeLocation.Set(
        sourceCodeLocation_fragment.is_null() ? nullptr : sourceCodeLocation_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::UserReidentificationIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::UserReidentificationIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InspectorIssueDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::InspectorIssueDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::InspectorIssueDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::cookie_issue_details(input)) in_cookie_issue_details = Traits::cookie_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_issue_details)::BaseType> cookie_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::CookieIssueDetailsDataView>(
      in_cookie_issue_details,
      cookie_issue_details_fragment);

    fragment->cookie_issue_details.Set(
        cookie_issue_details_fragment.is_null() ? nullptr : cookie_issue_details_fragment.data());

    decltype(Traits::mixed_content_issue_details(input)) in_mixed_content_issue_details = Traits::mixed_content_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mixed_content_issue_details)::BaseType> mixed_content_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::MixedContentIssueDetailsDataView>(
      in_mixed_content_issue_details,
      mixed_content_issue_details_fragment);

    fragment->mixed_content_issue_details.Set(
        mixed_content_issue_details_fragment.is_null() ? nullptr : mixed_content_issue_details_fragment.data());

    decltype(Traits::blocked_by_response_issue_details(input)) in_blocked_by_response_issue_details = Traits::blocked_by_response_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blocked_by_response_issue_details)::BaseType> blocked_by_response_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::BlockedByResponseIssueDetailsDataView>(
      in_blocked_by_response_issue_details,
      blocked_by_response_issue_details_fragment);

    fragment->blocked_by_response_issue_details.Set(
        blocked_by_response_issue_details_fragment.is_null() ? nullptr : blocked_by_response_issue_details_fragment.data());

    decltype(Traits::csp_issue_details(input)) in_csp_issue_details = Traits::csp_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->csp_issue_details)::BaseType> csp_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::ContentSecurityPolicyIssueDetailsDataView>(
      in_csp_issue_details,
      csp_issue_details_fragment);

    fragment->csp_issue_details.Set(
        csp_issue_details_fragment.is_null() ? nullptr : csp_issue_details_fragment.data());

    decltype(Traits::sab_issue_details(input)) in_sab_issue_details = Traits::sab_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sab_issue_details)::BaseType> sab_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::SharedArrayBufferIssueDetailsDataView>(
      in_sab_issue_details,
      sab_issue_details_fragment);

    fragment->sab_issue_details.Set(
        sab_issue_details_fragment.is_null() ? nullptr : sab_issue_details_fragment.data());

    decltype(Traits::heavy_ad_issue_details(input)) in_heavy_ad_issue_details = Traits::heavy_ad_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->heavy_ad_issue_details)::BaseType> heavy_ad_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::HeavyAdIssueDetailsDataView>(
      in_heavy_ad_issue_details,
      heavy_ad_issue_details_fragment);

    fragment->heavy_ad_issue_details.Set(
        heavy_ad_issue_details_fragment.is_null() ? nullptr : heavy_ad_issue_details_fragment.data());

    decltype(Traits::attribution_reporting_issue_details(input)) in_attribution_reporting_issue_details = Traits::attribution_reporting_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attribution_reporting_issue_details)::BaseType> attribution_reporting_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AttributionReportingIssueDetailsDataView>(
      in_attribution_reporting_issue_details,
      attribution_reporting_issue_details_fragment);

    fragment->attribution_reporting_issue_details.Set(
        attribution_reporting_issue_details_fragment.is_null() ? nullptr : attribution_reporting_issue_details_fragment.data());

    decltype(Traits::low_text_contrast_details(input)) in_low_text_contrast_details = Traits::low_text_contrast_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->low_text_contrast_details)::BaseType> low_text_contrast_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::LowTextContrastIssueDataView>(
      in_low_text_contrast_details,
      low_text_contrast_details_fragment);

    fragment->low_text_contrast_details.Set(
        low_text_contrast_details_fragment.is_null() ? nullptr : low_text_contrast_details_fragment.data());

    decltype(Traits::federated_auth_request_details(input)) in_federated_auth_request_details = Traits::federated_auth_request_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->federated_auth_request_details)::BaseType> federated_auth_request_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::FederatedAuthRequestIssueDetailsDataView>(
      in_federated_auth_request_details,
      federated_auth_request_details_fragment);

    fragment->federated_auth_request_details.Set(
        federated_auth_request_details_fragment.is_null() ? nullptr : federated_auth_request_details_fragment.data());

    decltype(Traits::bounce_tracking_issue_details(input)) in_bounce_tracking_issue_details = Traits::bounce_tracking_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounce_tracking_issue_details)::BaseType> bounce_tracking_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::BounceTrackingIssueDetailsDataView>(
      in_bounce_tracking_issue_details,
      bounce_tracking_issue_details_fragment);

    fragment->bounce_tracking_issue_details.Set(
        bounce_tracking_issue_details_fragment.is_null() ? nullptr : bounce_tracking_issue_details_fragment.data());

    decltype(Traits::partitioning_blob_url_issue_details(input)) in_partitioning_blob_url_issue_details = Traits::partitioning_blob_url_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->partitioning_blob_url_issue_details)::BaseType> partitioning_blob_url_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::PartitioningBlobURLIssueDetailsDataView>(
      in_partitioning_blob_url_issue_details,
      partitioning_blob_url_issue_details_fragment);

    fragment->partitioning_blob_url_issue_details.Set(
        partitioning_blob_url_issue_details_fragment.is_null() ? nullptr : partitioning_blob_url_issue_details_fragment.data());

    decltype(Traits::cookie_deprecation_metadata_issue_details(input)) in_cookie_deprecation_metadata_issue_details = Traits::cookie_deprecation_metadata_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_deprecation_metadata_issue_details)::BaseType> cookie_deprecation_metadata_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::CookieDeprecationMetadataIssueDetailsDataView>(
      in_cookie_deprecation_metadata_issue_details,
      cookie_deprecation_metadata_issue_details_fragment);

    fragment->cookie_deprecation_metadata_issue_details.Set(
        cookie_deprecation_metadata_issue_details_fragment.is_null() ? nullptr : cookie_deprecation_metadata_issue_details_fragment.data());

    decltype(Traits::generic_issue_details(input)) in_generic_issue_details = Traits::generic_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->generic_issue_details)::BaseType> generic_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::GenericIssueDetailsDataView>(
      in_generic_issue_details,
      generic_issue_details_fragment);

    fragment->generic_issue_details.Set(
        generic_issue_details_fragment.is_null() ? nullptr : generic_issue_details_fragment.data());

    decltype(Traits::deprecation_issue_details(input)) in_deprecation_issue_details = Traits::deprecation_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->deprecation_issue_details)::BaseType> deprecation_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::DeprecationIssueDetailsDataView>(
      in_deprecation_issue_details,
      deprecation_issue_details_fragment);

    fragment->deprecation_issue_details.Set(
        deprecation_issue_details_fragment.is_null() ? nullptr : deprecation_issue_details_fragment.data());

    decltype(Traits::federated_auth_user_info_request_details(input)) in_federated_auth_user_info_request_details = Traits::federated_auth_user_info_request_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->federated_auth_user_info_request_details)::BaseType> federated_auth_user_info_request_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::FederatedAuthUserInfoRequestIssueDetailsDataView>(
      in_federated_auth_user_info_request_details,
      federated_auth_user_info_request_details_fragment);

    fragment->federated_auth_user_info_request_details.Set(
        federated_auth_user_info_request_details_fragment.is_null() ? nullptr : federated_auth_user_info_request_details_fragment.data());

    decltype(Traits::user_reidentification_issue_details(input)) in_user_reidentification_issue_details = Traits::user_reidentification_issue_details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_reidentification_issue_details)::BaseType> user_reidentification_issue_details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::UserReidentificationIssueDetailsDataView>(
      in_user_reidentification_issue_details,
      user_reidentification_issue_details_fragment);

    fragment->user_reidentification_issue_details.Set(
        user_reidentification_issue_details_fragment.is_null() ? nullptr : user_reidentification_issue_details_fragment.data());

    decltype(Traits::issue_id(input)) in_issue_id = Traits::issue_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issue_id)::BaseType> issue_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_issue_id,
      issue_id_fragment);

    fragment->issue_id.Set(
        issue_id_fragment.is_null() ? nullptr : issue_id_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::InspectorIssueDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::InspectorIssueDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InspectorIssueInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::InspectorIssueInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::InspectorIssueInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::blink::mojom::InspectorIssueCode>(
      Traits::code(input),
      &fragment->code);

    decltype(Traits::details(input)) in_details = Traits::details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->details)::BaseType> details_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::InspectorIssueDetailsDataView>(
      in_details,
      details_fragment);

    fragment->details.Set(
        details_fragment.is_null() ? nullptr : details_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in InspectorIssueInfo struct");
  }

  static bool Deserialize(::blink::mojom::internal::InspectorIssueInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::InspectorIssueInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void AffectedCookieDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AffectedCookieDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AffectedCookieDataView::GetDomainDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->domain.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AffectedRequestDataView::GetRequestIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->request_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AffectedRequestDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AffectedFrameDataView::GetFrameIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->frame_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AffectedLocationDataView::GetScriptIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->script_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AffectedLocationDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void BlockedByResponseIssueDetailsDataView::GetRequestDataView(
    AffectedRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = AffectedRequestDataView(pointer, message_);
}
inline void BlockedByResponseIssueDetailsDataView::GetParentFrameDataView(
    AffectedFrameDataView* output) {
  auto pointer = data_->parentFrame.Get();
  *output = AffectedFrameDataView(pointer, message_);
}
inline void BlockedByResponseIssueDetailsDataView::GetBlockedFrameDataView(
    AffectedFrameDataView* output) {
  auto pointer = data_->blockedFrame.Get();
  *output = AffectedFrameDataView(pointer, message_);
}


inline void HeavyAdIssueDetailsDataView::GetFrameDataView(
    AffectedFrameDataView* output) {
  auto pointer = data_->frame.Get();
  *output = AffectedFrameDataView(pointer, message_);
}


inline void AttributionReportingIssueDetailsDataView::GetRequestDataView(
    AffectedRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = AffectedRequestDataView(pointer, message_);
}
inline void AttributionReportingIssueDetailsDataView::GetInvalidParameterDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->invalid_parameter.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MixedContentIssueDetailsDataView::GetInsecureUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->insecure_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MixedContentIssueDetailsDataView::GetMainResourceUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->main_resource_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MixedContentIssueDetailsDataView::GetRequestDataView(
    AffectedRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = AffectedRequestDataView(pointer, message_);
}
inline void MixedContentIssueDetailsDataView::GetFrameDataView(
    AffectedFrameDataView* output) {
  auto pointer = data_->frame.Get();
  *output = AffectedFrameDataView(pointer, message_);
}


inline void ContentSecurityPolicyIssueDetailsDataView::GetBlockedUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->blocked_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ContentSecurityPolicyIssueDetailsDataView::GetViolatedDirectiveDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->violated_directive.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ContentSecurityPolicyIssueDetailsDataView::GetFrameAncestorDataView(
    AffectedFrameDataView* output) {
  auto pointer = data_->frame_ancestor.Get();
  *output = AffectedFrameDataView(pointer, message_);
}
inline void ContentSecurityPolicyIssueDetailsDataView::GetAffectedLocationDataView(
    AffectedLocationDataView* output) {
  auto pointer = data_->affected_location.Get();
  *output = AffectedLocationDataView(pointer, message_);
}


inline void CookieIssueDetailsDataView::GetCookieDataView(
    AffectedCookieDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = AffectedCookieDataView(pointer, message_);
}
inline void CookieIssueDetailsDataView::GetExclusionReasonDataView(
    mojo::ArrayDataView<CookieExclusionReason>* output) {
  auto pointer = data_->exclusion_reason.Get();
  *output = mojo::ArrayDataView<CookieExclusionReason>(pointer, message_);
}
inline void CookieIssueDetailsDataView::GetWarningReasonDataView(
    mojo::ArrayDataView<CookieWarningReason>* output) {
  auto pointer = data_->warning_reason.Get();
  *output = mojo::ArrayDataView<CookieWarningReason>(pointer, message_);
}
inline void CookieIssueDetailsDataView::GetSiteForCookiesDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CookieIssueDetailsDataView::GetCookieUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->cookie_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CookieIssueDetailsDataView::GetRequestDataView(
    AffectedRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = AffectedRequestDataView(pointer, message_);
}


inline void SharedArrayBufferIssueDetailsDataView::GetAffectedLocationDataView(
    AffectedLocationDataView* output) {
  auto pointer = data_->affected_location.Get();
  *output = AffectedLocationDataView(pointer, message_);
}


inline void LowTextContrastIssueDataView::GetViolatingNodeSelectorDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->violating_node_selector.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LowTextContrastIssueDataView::GetFontSizeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->font_size.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void LowTextContrastIssueDataView::GetFontWeightDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->font_weight.Get();
  *output = mojo::StringDataView(pointer, message_);
}






inline void BounceTrackingIssueDetailsDataView::GetTrackingSitesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->tracking_sites.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void PartitioningBlobURLIssueDetailsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void CookieDeprecationMetadataIssueDetailsDataView::GetAllowedSitesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->allowed_sites.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void GenericIssueDetailsDataView::GetFrameIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->frame_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GenericIssueDetailsDataView::GetViolatingNodeAttributeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->violating_node_attribute.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DeprecationIssueDetailsDataView::GetAffectedLocationDataView(
    AffectedLocationDataView* output) {
  auto pointer = data_->affected_location.Get();
  *output = AffectedLocationDataView(pointer, message_);
}


inline void UserReidentificationIssueDetailsDataView::GetRequestDataView(
    AffectedRequestDataView* output) {
  auto pointer = data_->request.Get();
  *output = AffectedRequestDataView(pointer, message_);
}
inline void UserReidentificationIssueDetailsDataView::GetSourceCodeLocationDataView(
    AffectedLocationDataView* output) {
  auto pointer = data_->sourceCodeLocation.Get();
  *output = AffectedLocationDataView(pointer, message_);
}


inline void InspectorIssueDetailsDataView::GetCookieIssueDetailsDataView(
    CookieIssueDetailsDataView* output) {
  auto pointer = data_->cookie_issue_details.Get();
  *output = CookieIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetMixedContentIssueDetailsDataView(
    MixedContentIssueDetailsDataView* output) {
  auto pointer = data_->mixed_content_issue_details.Get();
  *output = MixedContentIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetBlockedByResponseIssueDetailsDataView(
    BlockedByResponseIssueDetailsDataView* output) {
  auto pointer = data_->blocked_by_response_issue_details.Get();
  *output = BlockedByResponseIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetCspIssueDetailsDataView(
    ContentSecurityPolicyIssueDetailsDataView* output) {
  auto pointer = data_->csp_issue_details.Get();
  *output = ContentSecurityPolicyIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetSabIssueDetailsDataView(
    SharedArrayBufferIssueDetailsDataView* output) {
  auto pointer = data_->sab_issue_details.Get();
  *output = SharedArrayBufferIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetHeavyAdIssueDetailsDataView(
    HeavyAdIssueDetailsDataView* output) {
  auto pointer = data_->heavy_ad_issue_details.Get();
  *output = HeavyAdIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetAttributionReportingIssueDetailsDataView(
    AttributionReportingIssueDetailsDataView* output) {
  auto pointer = data_->attribution_reporting_issue_details.Get();
  *output = AttributionReportingIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetLowTextContrastDetailsDataView(
    LowTextContrastIssueDataView* output) {
  auto pointer = data_->low_text_contrast_details.Get();
  *output = LowTextContrastIssueDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetFederatedAuthRequestDetailsDataView(
    FederatedAuthRequestIssueDetailsDataView* output) {
  auto pointer = data_->federated_auth_request_details.Get();
  *output = FederatedAuthRequestIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetBounceTrackingIssueDetailsDataView(
    BounceTrackingIssueDetailsDataView* output) {
  auto pointer = data_->bounce_tracking_issue_details.Get();
  *output = BounceTrackingIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetPartitioningBlobUrlIssueDetailsDataView(
    PartitioningBlobURLIssueDetailsDataView* output) {
  auto pointer = data_->partitioning_blob_url_issue_details.Get();
  *output = PartitioningBlobURLIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetCookieDeprecationMetadataIssueDetailsDataView(
    CookieDeprecationMetadataIssueDetailsDataView* output) {
  auto pointer = data_->cookie_deprecation_metadata_issue_details.Get();
  *output = CookieDeprecationMetadataIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetGenericIssueDetailsDataView(
    GenericIssueDetailsDataView* output) {
  auto pointer = data_->generic_issue_details.Get();
  *output = GenericIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetDeprecationIssueDetailsDataView(
    DeprecationIssueDetailsDataView* output) {
  auto pointer = data_->deprecation_issue_details.Get();
  *output = DeprecationIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetFederatedAuthUserInfoRequestDetailsDataView(
    FederatedAuthUserInfoRequestIssueDetailsDataView* output) {
  auto pointer = data_->federated_auth_user_info_request_details.Get();
  *output = FederatedAuthUserInfoRequestIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetUserReidentificationIssueDetailsDataView(
    UserReidentificationIssueDetailsDataView* output) {
  auto pointer = data_->user_reidentification_issue_details.Get();
  *output = UserReidentificationIssueDetailsDataView(pointer, message_);
}
inline void InspectorIssueDetailsDataView::GetIssueIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->issue_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void InspectorIssueInfoDataView::GetDetailsDataView(
    InspectorIssueDetailsDataView* output) {
  auto pointer = data_->details.Get();
  *output = InspectorIssueDetailsDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::InspectorIssueCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::InspectorIssueCode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::HeavyAdResolutionStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::HeavyAdResolutionStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::HeavyAdReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::HeavyAdReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::AttributionReportingIssueType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::AttributionReportingIssueType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::MixedContentResolutionStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::MixedContentResolutionStatus value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ContentSecurityPolicyViolationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ContentSecurityPolicyViolationType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::CookieOperation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::CookieOperation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::CookieExclusionReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::CookieExclusionReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::CookieWarningReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::CookieWarningReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::SharedArrayBufferIssueType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::SharedArrayBufferIssueType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FederatedAuthRequestResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FederatedAuthRequestResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::FederatedAuthUserInfoRequestResult> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::FederatedAuthUserInfoRequestResult value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::PartitioningBlobURLInfo> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::PartitioningBlobURLInfo value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::GenericIssueErrorType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::GenericIssueErrorType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::DeprecationIssueType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::DeprecationIssueType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::UserReidentificationIssueType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::UserReidentificationIssueType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DEVTOOLS_INSPECTOR_ISSUE_MOJOM_SHARED_H_