// third_party/blink/public/mojom/device_posture/device_posture_provider.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
blink.mojom.DevicePostureTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
blink.mojom.DevicePostureType = {
  
  kContinuous: 0,
  kFolded: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DevicePostureProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DevicePostureProvider.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.DevicePostureProviderInterface }
 */
blink.mojom.DevicePostureProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DevicePostureProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DevicePostureProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DevicePostureProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.DevicePostureClientRemote } client
   * @return {!Promise<{
        posture: !blink.mojom.DevicePostureType,
   *  }>}
   */

  addListenerAndGetCurrentPosture(
      client) {
    return this.proxy.sendMessage(
        0,
        blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsSpec.$,
        blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsSpec.$,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.DevicePostureType } posture
   */

  overrideDevicePostureForEmulation(
      posture) {
    this.proxy.sendMessage(
        1,
        blink.mojom.DevicePostureProvider_OverrideDevicePostureForEmulation_ParamsSpec.$,
        null,
        [
          posture
        ],
        false);
  }

  
  /**
   */

  disableDevicePostureOverrideForEmulation() {
    this.proxy.sendMessage(
        2,
        blink.mojom.DevicePostureProvider_DisableDevicePostureOverrideForEmulation_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DevicePostureProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DevicePostureProviderReceiver = class {
  /**
   * @param {!blink.mojom.DevicePostureProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DevicePostureProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DevicePostureProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevicePostureProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsSpec.$,
        blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsSpec.$,
        impl.addListenerAndGetCurrentPosture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevicePostureProvider_OverrideDevicePostureForEmulation_ParamsSpec.$,
        null,
        impl.overrideDevicePostureForEmulation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DevicePostureProvider_DisableDevicePostureOverrideForEmulation_ParamsSpec.$,
        null,
        impl.disableDevicePostureOverrideForEmulation.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DevicePostureProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevicePostureProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DevicePostureProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DevicePostureProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DevicePostureProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DevicePostureProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DevicePostureProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevicePostureProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addListenerAndGetCurrentPosture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsSpec.$,
        blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsSpec.$,
        this.addListenerAndGetCurrentPosture.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.overrideDevicePostureForEmulation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.DevicePostureProvider_OverrideDevicePostureForEmulation_ParamsSpec.$,
        null,
        this.overrideDevicePostureForEmulation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableDevicePostureOverrideForEmulation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.DevicePostureProvider_DisableDevicePostureOverrideForEmulation_ParamsSpec.$,
        null,
        this.disableDevicePostureOverrideForEmulation.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.DevicePostureClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.DevicePostureClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.DevicePostureClientInterface }
 */
blink.mojom.DevicePostureClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.DevicePostureClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.DevicePostureClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.DevicePostureClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.DevicePostureType } posture
   */

  onPostureChanged(
      posture) {
    this.proxy.sendMessage(
        0,
        blink.mojom.DevicePostureClient_OnPostureChanged_ParamsSpec.$,
        null,
        [
          posture
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DevicePostureClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.DevicePostureClientReceiver = class {
  /**
   * @param {!blink.mojom.DevicePostureClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.DevicePostureClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.DevicePostureClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevicePostureClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevicePostureClient_OnPostureChanged_ParamsSpec.$,
        null,
        impl.onPostureChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.DevicePostureClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DevicePostureClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.DevicePostureClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.DevicePostureClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DevicePostureClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.DevicePostureClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.DevicePostureClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.DevicePostureClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPostureChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.DevicePostureClient_OnPostureChanged_ParamsSpec.$,
        null,
        this.onPostureChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevicePostureProvider_OverrideDevicePostureForEmulation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevicePostureProvider_DisableDevicePostureOverrideForEmulation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.DevicePostureClient_OnPostureChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_ParamsSpec.$,
    'DevicePostureProvider_AddListenerAndGetCurrentPosture_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.DevicePostureClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_Params = class {
  constructor() {
    /** @export { !blink.mojom.DevicePostureClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParamsSpec.$,
    'DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams',
    [
      mojo.internal.StructField(
        'posture', 0,
        0,
        blink.mojom.DevicePostureTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.DevicePostureProvider_AddListenerAndGetCurrentPosture_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.DevicePostureType } */
    this.posture;
  }
};



mojo.internal.Struct(
    blink.mojom.DevicePostureProvider_OverrideDevicePostureForEmulation_ParamsSpec.$,
    'DevicePostureProvider_OverrideDevicePostureForEmulation_Params',
    [
      mojo.internal.StructField(
        'posture', 0,
        0,
        blink.mojom.DevicePostureTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.DevicePostureProvider_OverrideDevicePostureForEmulation_Params = class {
  constructor() {
    /** @export { !blink.mojom.DevicePostureType } */
    this.posture;
  }
};



mojo.internal.Struct(
    blink.mojom.DevicePostureProvider_DisableDevicePostureOverrideForEmulation_ParamsSpec.$,
    'DevicePostureProvider_DisableDevicePostureOverrideForEmulation_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.DevicePostureProvider_DisableDevicePostureOverrideForEmulation_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.DevicePostureClient_OnPostureChanged_ParamsSpec.$,
    'DevicePostureClient_OnPostureChanged_Params',
    [
      mojo.internal.StructField(
        'posture', 0,
        0,
        blink.mojom.DevicePostureTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.DevicePostureClient_OnPostureChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.DevicePostureType } */
    this.posture;
  }
};

