// third_party/blink/public/mojom/data_transfer/data_transfer.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/data_transfer/data_transfer.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var file_path$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/file_path.mojom', '../../../../../mojo/public/mojom/base/file_path.mojom.js');
  }
  var file_system_access_data_transfer_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_data_transfer_token.mojom', '../file_system_access/file_system_access_data_transfer_token.mojom.js');
  }



  function DataTransferFile(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DataTransferFile.prototype.initDefaults_ = function() {
    this.path = null;
    this.displayName = null;
    this.fileSystemAccessToken = new file_system_access_data_transfer_token$.FileSystemAccessDataTransferTokenPtr();
  };
  DataTransferFile.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DataTransferFile.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataTransferFile.path
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataTransferFile.displayName
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, file_path$.FilePath, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DataTransferFile.fileSystemAccessToken
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 16, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DataTransferFile.encodedSize = codec.kStructHeaderSize + 24;

  DataTransferFile.decode = function(decoder) {
    var packed;
    var val = new DataTransferFile();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.path =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.displayName =
        decoder.decodeStructPointer(file_path$.FilePath);
    val.fileSystemAccessToken =
        decoder.decodeStruct(new codec.NullableInterface(file_system_access_data_transfer_token$.FileSystemAccessDataTransferTokenPtr));
    return val;
  };

  DataTransferFile.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DataTransferFile.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(file_path$.FilePath, val.path);
    encoder.encodeStructPointer(file_path$.FilePath, val.displayName);
    encoder.encodeStruct(new codec.NullableInterface(file_system_access_data_transfer_token$.FileSystemAccessDataTransferTokenPtr), val.fileSystemAccessToken);
  };
  exports.DataTransferFile = DataTransferFile;
})();