// third_party/blink/public/mojom/context_menu/context_menu.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/context_menu/context_menu.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-params-data.h"
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-import-headers.h"
#include "third_party/blink/public/mojom/context_menu/context_menu.mojom-test-utils.h"


namespace blink::mojom {
Accelerator::Accelerator()
    : key_code(),
      modifiers() {}

Accelerator::Accelerator(
    uint16_t key_code_in,
    int32_t modifiers_in)
    : key_code(std::move(key_code_in)),
      modifiers(std::move(modifiers_in)) {}

Accelerator::~Accelerator() = default;
size_t Accelerator::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->key_code);
  seed = mojo::internal::Hash(seed, this->modifiers);
  return seed;
}

void Accelerator::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_code"), this->key_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "modifiers"), this->modifiers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Accelerator::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FormRendererId::FormRendererId()
    : id() {}

FormRendererId::FormRendererId(
    uint64_t id_in)
    : id(std::move(id_in)) {}

FormRendererId::~FormRendererId() = default;
size_t FormRendererId::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  return seed;
}

void FormRendererId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FormRendererId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FieldRendererId::FieldRendererId()
    : id() {}

FieldRendererId::FieldRendererId(
    uint64_t id_in)
    : id(std::move(id_in)) {}

FieldRendererId::~FieldRendererId() = default;
size_t FieldRendererId::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  return seed;
}

void FieldRendererId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FieldRendererId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CustomContextMenuItem::CustomContextMenuItem()
    : label(),
      accelerator(),
      icon(),
      tool_tip(),
      type(),
      action(),
      feature_name(),
      is_experimental_feature(),
      rtl(),
      has_directional_override(),
      enabled(),
      checked(),
      force_show_accelerator_for_item(),
      submenu() {}

CustomContextMenuItem::CustomContextMenuItem(
    const ::std::u16string& label_in,
    AcceleratorPtr accelerator_in,
    const ::std::u16string& icon_in,
    const ::std::u16string& tool_tip_in,
    CustomContextMenuItemType type_in,
    int32_t action_in,
    const ::std::u16string& feature_name_in,
    bool is_experimental_feature_in,
    bool rtl_in,
    bool has_directional_override_in,
    bool enabled_in,
    bool checked_in,
    bool force_show_accelerator_for_item_in,
    std::vector<CustomContextMenuItemPtr> submenu_in)
    : label(std::move(label_in)),
      accelerator(std::move(accelerator_in)),
      icon(std::move(icon_in)),
      tool_tip(std::move(tool_tip_in)),
      type(std::move(type_in)),
      action(std::move(action_in)),
      feature_name(std::move(feature_name_in)),
      is_experimental_feature(std::move(is_experimental_feature_in)),
      rtl(std::move(rtl_in)),
      has_directional_override(std::move(has_directional_override_in)),
      enabled(std::move(enabled_in)),
      checked(std::move(checked_in)),
      force_show_accelerator_for_item(std::move(force_show_accelerator_for_item_in)),
      submenu(std::move(submenu_in)) {}

CustomContextMenuItem::~CustomContextMenuItem() = default;

void CustomContextMenuItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accelerator"), this->accelerator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AcceleratorPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tool_tip"), this->tool_tip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CustomContextMenuItemType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_name"), this->feature_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_experimental_feature"), this->is_experimental_feature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rtl"), this->rtl,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_directional_override"), this->has_directional_override,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enabled"), this->enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "checked"), this->checked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "force_show_accelerator_for_item"), this->force_show_accelerator_for_item,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "submenu"), this->submenu,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CustomContextMenuItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CustomContextMenuItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UntrustworthyContextMenuParams::UntrustworthyContextMenuParams()
    : media_type(),
      x(),
      y(),
      link_url(),
      link_text(),
      impression(),
      unfiltered_link_url(),
      src_url(),
      has_image_contents(),
      is_image_media_plugin_document(),
      media_flags(),
      selection_text(),
      title_text(),
      alt_text(),
      suggested_filename(),
      misspelled_word(),
      dictionary_suggestions(),
      spellcheck_enabled(),
      is_editable(),
      writing_direction_default(),
      writing_direction_left_to_right(),
      writing_direction_right_to_left(),
      edit_flags(),
      frame_charset(),
      referrer_policy(),
      link_followed(),
      custom_items(),
      source_type(),
      selection_rect(),
      selection_start_offset(),
      annotation_type(),
      opened_from_interest_for(),
      interest_for_node_id(),
      form_control_type(),
      is_content_editable_for_autofill(),
      field_renderer_id(),
      form_renderer_id() {}

UntrustworthyContextMenuParams::UntrustworthyContextMenuParams(
    ContextMenuDataMediaType media_type_in,
    int32_t x_in,
    int32_t y_in,
    const ::GURL& link_url_in,
    const ::std::u16string& link_text_in,
    const std::optional<::blink::Impression>& impression_in,
    const ::GURL& unfiltered_link_url_in,
    const ::GURL& src_url_in,
    bool has_image_contents_in,
    bool is_image_media_plugin_document_in,
    int32_t media_flags_in,
    const ::std::u16string& selection_text_in,
    const ::std::u16string& title_text_in,
    const ::std::u16string& alt_text_in,
    const ::std::u16string& suggested_filename_in,
    const ::std::u16string& misspelled_word_in,
    std::vector<::std::u16string> dictionary_suggestions_in,
    bool spellcheck_enabled_in,
    bool is_editable_in,
    int32_t writing_direction_default_in,
    int32_t writing_direction_left_to_right_in,
    int32_t writing_direction_right_to_left_in,
    int32_t edit_flags_in,
    const std::string& frame_charset_in,
    ::network::mojom::ReferrerPolicy referrer_policy_in,
    const ::GURL& link_followed_in,
    std::vector<CustomContextMenuItemPtr> custom_items_in,
    ::ui::mojom::MenuSourceType source_type_in,
    const ::gfx::Rect& selection_rect_in,
    int32_t selection_start_offset_in,
    std::optional<::blink::mojom::AnnotationType> annotation_type_in,
    bool opened_from_interest_for_in,
    int32_t interest_for_node_id_in,
    std::optional<::blink::mojom::FormControlType> form_control_type_in,
    bool is_content_editable_for_autofill_in,
    FieldRendererIdPtr field_renderer_id_in,
    FormRendererIdPtr form_renderer_id_in)
    : media_type(std::move(media_type_in)),
      x(std::move(x_in)),
      y(std::move(y_in)),
      link_url(std::move(link_url_in)),
      link_text(std::move(link_text_in)),
      impression(std::move(impression_in)),
      unfiltered_link_url(std::move(unfiltered_link_url_in)),
      src_url(std::move(src_url_in)),
      has_image_contents(std::move(has_image_contents_in)),
      is_image_media_plugin_document(std::move(is_image_media_plugin_document_in)),
      media_flags(std::move(media_flags_in)),
      selection_text(std::move(selection_text_in)),
      title_text(std::move(title_text_in)),
      alt_text(std::move(alt_text_in)),
      suggested_filename(std::move(suggested_filename_in)),
      misspelled_word(std::move(misspelled_word_in)),
      dictionary_suggestions(std::move(dictionary_suggestions_in)),
      spellcheck_enabled(std::move(spellcheck_enabled_in)),
      is_editable(std::move(is_editable_in)),
      writing_direction_default(std::move(writing_direction_default_in)),
      writing_direction_left_to_right(std::move(writing_direction_left_to_right_in)),
      writing_direction_right_to_left(std::move(writing_direction_right_to_left_in)),
      edit_flags(std::move(edit_flags_in)),
      frame_charset(std::move(frame_charset_in)),
      referrer_policy(std::move(referrer_policy_in)),
      link_followed(std::move(link_followed_in)),
      custom_items(std::move(custom_items_in)),
      source_type(std::move(source_type_in)),
      selection_rect(std::move(selection_rect_in)),
      selection_start_offset(std::move(selection_start_offset_in)),
      annotation_type(std::move(annotation_type_in)),
      opened_from_interest_for(std::move(opened_from_interest_for_in)),
      interest_for_node_id(std::move(interest_for_node_id_in)),
      form_control_type(std::move(form_control_type_in)),
      is_content_editable_for_autofill(std::move(is_content_editable_for_autofill_in)),
      field_renderer_id(std::move(field_renderer_id_in)),
      form_renderer_id(std::move(form_renderer_id_in)) {}

UntrustworthyContextMenuParams::~UntrustworthyContextMenuParams() = default;

void UntrustworthyContextMenuParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_type"), this->media_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ContextMenuDataMediaType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "x"), this->x,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "y"), this->y,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "link_url"), this->link_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "link_text"), this->link_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "impression"), this->impression,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Impression>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unfiltered_link_url"), this->unfiltered_link_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "src_url"), this->src_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_image_contents"), this->has_image_contents,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_image_media_plugin_document"), this->is_image_media_plugin_document,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_flags"), this->media_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_text"), this->selection_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title_text"), this->title_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alt_text"), this->alt_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggested_filename"), this->suggested_filename,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "misspelled_word"), this->misspelled_word,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dictionary_suggestions"), this->dictionary_suggestions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spellcheck_enabled"), this->spellcheck_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_editable"), this->is_editable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "writing_direction_default"), this->writing_direction_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "writing_direction_left_to_right"), this->writing_direction_left_to_right,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "writing_direction_right_to_left"), this->writing_direction_right_to_left,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "edit_flags"), this->edit_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_charset"), this->frame_charset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "referrer_policy"), this->referrer_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::ReferrerPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "link_followed"), this->link_followed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_items"), this->custom_items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CustomContextMenuItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_type"), this->source_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::mojom::MenuSourceType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_rect"), this->selection_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_start_offset"), this->selection_start_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "annotation_type"), this->annotation_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::mojom::AnnotationType>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "opened_from_interest_for"), this->opened_from_interest_for,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "interest_for_node_id"), this->interest_for_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_control_type"), this->form_control_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::blink::mojom::FormControlType>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_content_editable_for_autofill"), this->is_content_editable_for_autofill,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "field_renderer_id"), this->field_renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FieldRendererIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "form_renderer_id"), this->form_renderer_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FormRendererIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UntrustworthyContextMenuParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ContextMenuClient::IPCStableHashFunction ContextMenuClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ContextMenuClient>(message.name())) {
    case messages::ContextMenuClient::kCustomContextMenuAction: {
      return &ContextMenuClient::CustomContextMenuAction_Sym::IPCStableHash;
    }
    case messages::ContextMenuClient::kContextMenuClosed: {
      return &ContextMenuClient::ContextMenuClosed_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ContextMenuClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ContextMenuClient>(message.name())) {
      case messages::ContextMenuClient::kCustomContextMenuAction:
            return "Receive blink::mojom::ContextMenuClient::CustomContextMenuAction";
      case messages::ContextMenuClient::kContextMenuClosed:
            return "Receive blink::mojom::ContextMenuClient::ContextMenuClosed";
    }
  } else {
    switch (static_cast<messages::ContextMenuClient>(message.name())) {
      case messages::ContextMenuClient::kCustomContextMenuAction:
            return "Receive reply blink::mojom::ContextMenuClient::CustomContextMenuAction";
      case messages::ContextMenuClient::kContextMenuClosed:
            return "Receive reply blink::mojom::ContextMenuClient::ContextMenuClosed";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ContextMenuClient::CustomContextMenuAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7d39e78f;  // IPCStableHash for blink::mojom::ContextMenuClient::CustomContextMenuAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ContextMenuClient::ContextMenuClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x130ec653;  // IPCStableHash for blink::mojom::ContextMenuClient::ContextMenuClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ContextMenuClientProxy::ContextMenuClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ContextMenuClientProxy::CustomContextMenuAction(
    uint32_t in_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ContextMenuClient::CustomContextMenuAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action"), in_action,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContextMenuClient::kCustomContextMenuAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContextMenuClient_CustomContextMenuAction_Params_Data> params(
          message);
  params.Allocate();

  params->action = in_action;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContextMenuClient::Name_);
  message.set_method_name("CustomContextMenuAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ContextMenuClientProxy::ContextMenuClosed(
    const ::GURL& in_link_followed, const std::optional<::blink::Impression>& in_impression) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::ContextMenuClient::ContextMenuClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("link_followed"), in_link_followed,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("impression"), in_impression,
                        "<value of type const std::optional<::blink::Impression>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ContextMenuClient::kContextMenuClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ContextMenuClient_ContextMenuClosed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->link_followed)::BaseType> link_followed_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_link_followed,
    link_followed_fragment);

  params->link_followed.Set(
      link_followed_fragment.is_null() ? nullptr : link_followed_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->link_followed.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null link_followed in ContextMenuClient.ContextMenuClosed request");
  mojo::internal::MessageFragment<
      typename decltype(params->impression)::BaseType> impression_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::ImpressionDataView>(
    in_impression,
    impression_fragment);

  params->impression.Set(
      impression_fragment.is_null() ? nullptr : impression_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ContextMenuClient::Name_);
  message.set_method_name("ContextMenuClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ContextMenuClientStubDispatch::Accept(
    ContextMenuClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ContextMenuClient>(message->header()->name)) {
    case messages::ContextMenuClient::kCustomContextMenuAction: {
      DCHECK(message->is_serialized());
      internal::ContextMenuClient_CustomContextMenuAction_Params_Data* params =
          reinterpret_cast<internal::ContextMenuClient_CustomContextMenuAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContextMenuClient.0
      bool success = true;
      uint32_t p_action{};
      ContextMenuClient_CustomContextMenuAction_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_action = input_data_view.action();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContextMenuClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CustomContextMenuAction(        
        std::move(p_action));
      return true;
    }
    case messages::ContextMenuClient::kContextMenuClosed: {
      DCHECK(message->is_serialized());
      internal::ContextMenuClient_ContextMenuClosed_Params_Data* params =
          reinterpret_cast<internal::ContextMenuClient_ContextMenuClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ContextMenuClient.1
      bool success = true;
      ::GURL p_link_followed{};
      std::optional<::blink::Impression> p_impression{};
      ContextMenuClient_ContextMenuClosed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLinkFollowed(&p_link_followed))
        success = false;
      if (success && !input_data_view.ReadImpression(&p_impression))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ContextMenuClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContextMenuClosed(        
        std::move(p_link_followed), 
        std::move(p_impression));
      return true;
    }
  }
  return false;
}

// static
bool ContextMenuClientStubDispatch::AcceptWithResponder(
    ContextMenuClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ContextMenuClient>(message->header()->name)) {
    case messages::ContextMenuClient::kCustomContextMenuAction: {
      break;
    }
    case messages::ContextMenuClient::kContextMenuClosed: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kContextMenuClientValidationInfo[] = {
    { &internal::ContextMenuClient_CustomContextMenuAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ContextMenuClient_ContextMenuClosed_Params_Data::Validate,
     nullptr /* no response */},
};

bool ContextMenuClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::ContextMenuClient::Name_,
    kContextMenuClientValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::Accelerator::DataView, ::blink::mojom::AcceleratorPtr>::Read(
    ::blink::mojom::Accelerator::DataView input,
    ::blink::mojom::AcceleratorPtr* output) {
  bool success = true;
  ::blink::mojom::AcceleratorPtr result(::blink::mojom::Accelerator::New());
  
      if (success)
        result->key_code = input.key_code();
      if (success)
        result->modifiers = input.modifiers();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FormRendererId::DataView, ::blink::mojom::FormRendererIdPtr>::Read(
    ::blink::mojom::FormRendererId::DataView input,
    ::blink::mojom::FormRendererIdPtr* output) {
  bool success = true;
  ::blink::mojom::FormRendererIdPtr result(::blink::mojom::FormRendererId::New());
  
      if (success)
        result->id = input.id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::FieldRendererId::DataView, ::blink::mojom::FieldRendererIdPtr>::Read(
    ::blink::mojom::FieldRendererId::DataView input,
    ::blink::mojom::FieldRendererIdPtr* output) {
  bool success = true;
  ::blink::mojom::FieldRendererIdPtr result(::blink::mojom::FieldRendererId::New());
  
      if (success)
        result->id = input.id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::CustomContextMenuItem::DataView, ::blink::mojom::CustomContextMenuItemPtr>::Read(
    ::blink::mojom::CustomContextMenuItem::DataView input,
    ::blink::mojom::CustomContextMenuItemPtr* output) {
  bool success = true;
  ::blink::mojom::CustomContextMenuItemPtr result(::blink::mojom::CustomContextMenuItem::New());
  
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadAccelerator(&result->accelerator))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
      if (success && !input.ReadToolTip(&result->tool_tip))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->action = input.action();
      if (success && !input.ReadFeatureName(&result->feature_name))
        success = false;
      if (success)
        result->is_experimental_feature = input.is_experimental_feature();
      if (success)
        result->rtl = input.rtl();
      if (success)
        result->has_directional_override = input.has_directional_override();
      if (success)
        result->enabled = input.enabled();
      if (success)
        result->checked = input.checked();
      if (success)
        result->force_show_accelerator_for_item = input.force_show_accelerator_for_item();
      if (success && !input.ReadSubmenu(&result->submenu))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::UntrustworthyContextMenuParams::DataView, ::blink::mojom::UntrustworthyContextMenuParamsPtr>::Read(
    ::blink::mojom::UntrustworthyContextMenuParams::DataView input,
    ::blink::mojom::UntrustworthyContextMenuParamsPtr* output) {
  bool success = true;
  ::blink::mojom::UntrustworthyContextMenuParamsPtr result(::blink::mojom::UntrustworthyContextMenuParams::New());
  
      if (success && !input.ReadMediaType(&result->media_type))
        success = false;
      if (success)
        result->x = input.x();
      if (success)
        result->y = input.y();
      if (success && !input.ReadLinkUrl(&result->link_url))
        success = false;
      if (success && !input.ReadLinkText(&result->link_text))
        success = false;
      if (success && !input.ReadImpression(&result->impression))
        success = false;
      if (success && !input.ReadUnfilteredLinkUrl(&result->unfiltered_link_url))
        success = false;
      if (success && !input.ReadSrcUrl(&result->src_url))
        success = false;
      if (success)
        result->has_image_contents = input.has_image_contents();
      if (success)
        result->is_image_media_plugin_document = input.is_image_media_plugin_document();
      if (success)
        result->media_flags = input.media_flags();
      if (success && !input.ReadSelectionText(&result->selection_text))
        success = false;
      if (success && !input.ReadTitleText(&result->title_text))
        success = false;
      if (success && !input.ReadAltText(&result->alt_text))
        success = false;
      if (success && !input.ReadSuggestedFilename(&result->suggested_filename))
        success = false;
      if (success && !input.ReadMisspelledWord(&result->misspelled_word))
        success = false;
      if (success && !input.ReadDictionarySuggestions(&result->dictionary_suggestions))
        success = false;
      if (success)
        result->spellcheck_enabled = input.spellcheck_enabled();
      if (success)
        result->is_editable = input.is_editable();
      if (success)
        result->writing_direction_default = input.writing_direction_default();
      if (success)
        result->writing_direction_left_to_right = input.writing_direction_left_to_right();
      if (success)
        result->writing_direction_right_to_left = input.writing_direction_right_to_left();
      if (success)
        result->edit_flags = input.edit_flags();
      if (success && !input.ReadFrameCharset(&result->frame_charset))
        success = false;
      if (success && !input.ReadReferrerPolicy(&result->referrer_policy))
        success = false;
      if (success && !input.ReadLinkFollowed(&result->link_followed))
        success = false;
      if (success && !input.ReadCustomItems(&result->custom_items))
        success = false;
      if (success && !input.ReadSourceType(&result->source_type))
        success = false;
      if (success && !input.ReadSelectionRect(&result->selection_rect))
        success = false;
      if (success)
        result->selection_start_offset = input.selection_start_offset();
      if (success && !input.ReadAnnotationType(&result->annotation_type)) {
        success = false;
      }
      if (success)
        result->opened_from_interest_for = input.opened_from_interest_for();
      if (success)
        result->interest_for_node_id = input.interest_for_node_id();
      if (success && !input.ReadFormControlType(&result->form_control_type)) {
        success = false;
      }
      if (success)
        result->is_content_editable_for_autofill = input.is_content_editable_for_autofill();
      if (success && !input.ReadFieldRendererId(&result->field_renderer_id))
        success = false;
      if (success && !input.ReadFormRendererId(&result->form_renderer_id))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void ContextMenuClientInterceptorForTesting::CustomContextMenuAction(uint32_t action) {
  GetForwardingInterface()->CustomContextMenuAction(
    std::move(action)
    );
}
void ContextMenuClientInterceptorForTesting::ContextMenuClosed(const ::GURL& link_followed, const std::optional<::blink::Impression>& impression) {
  GetForwardingInterface()->ContextMenuClosed(
    std::move(link_followed)
    , 
    std::move(impression)
    );
}
ContextMenuClientAsyncWaiter::ContextMenuClientAsyncWaiter(
    ContextMenuClient* proxy) : proxy_(proxy) {}

ContextMenuClientAsyncWaiter::~ContextMenuClientAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif