// third_party/blink/public/mojom/content_index/content_index.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/content_index/content_index.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "third_party/blink/public/mojom/manifest/manifest.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace blink::mojom {
class ContentIconDefinitionDataView;

class ContentDescriptionDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ContentIconDefinitionDataView> {
  using Data = ::blink::mojom::internal::ContentIconDefinition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ContentDescriptionDataView> {
  using Data = ::blink::mojom::internal::ContentDescription_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ContentIndexError : int32_t {
  
  NONE = 0,
  
  INVALID_PARAMETER = 1,
  
  STORAGE_ERROR = 2,
  
  NO_SERVICE_WORKER = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ContentIndexError value);
inline bool IsKnownEnumValue(ContentIndexError value) {
  return internal::ContentIndexError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ContentCategory : int32_t {
  
  NONE = 0,
  
  HOME_PAGE = 1,
  
  ARTICLE = 2,
  
  VIDEO = 3,
  
  AUDIO = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ContentCategory value);
inline bool IsKnownEnumValue(ContentCategory value) {
  return internal::ContentCategory_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ContentIndexServiceInterfaceBase {};

using ContentIndexServicePtrDataView =
    mojo::InterfacePtrDataView<ContentIndexServiceInterfaceBase>;
using ContentIndexServiceRequestDataView =
    mojo::InterfaceRequestDataView<ContentIndexServiceInterfaceBase>;
using ContentIndexServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ContentIndexServiceInterfaceBase>;
using ContentIndexServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ContentIndexServiceInterfaceBase>;


class ContentIconDefinitionDataView {
 public:
  ContentIconDefinitionDataView() = default;

  ContentIconDefinitionDataView(
      internal::ContentIconDefinition_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSrcDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrc(UserType* output) {
    
    auto* pointer = data_->src.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSizesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `sizes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSizes` instead "
    "of `ReadSizes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sizes.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadType` instead "
    "of `ReadType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContentIconDefinition_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ContentDescriptionDataView {
 public:
  ContentDescriptionDataView() = default;

  ContentDescriptionDataView(
      internal::ContentDescription_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCategory(UserType* output) const {
    auto data_value = data_->category;
    return mojo::internal::Deserialize<::blink::mojom::ContentCategory>(
        data_value, output);
  }
  ContentCategory category() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ContentCategory>(data_->category));
  }
  inline void GetIconsDataView(
      mojo::ArrayDataView<ContentIconDefinitionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcons(UserType* output) {
    
    auto* pointer = data_->icons.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ContentIconDefinitionDataView>>(
        pointer, output, message_);
  }
  inline void GetLaunchUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLaunchUrl(UserType* output) {
    
    auto* pointer = data_->launch_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::ContentDescription_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CONTENT_INDEX_CONTENT_INDEX_MOJOM_DATA_VIEW_H_