// third_party/blink/public/mojom/content_extraction/frame_metadata_observer_registry.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/content_extraction/frame_metadata_observer_registry.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var ai_page_content_metadata$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/content_extraction/ai_page_content_metadata.mojom', 'ai_page_content_metadata.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params.prototype.initDefaults_ = function() {
    this.hasPaidContent = false;
  };
  PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params.decode = function(decoder) {
    var packed;
    var val = new PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasPaidContent = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasPaidContent & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MetaTagsObserver_OnMetaTagsChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MetaTagsObserver_OnMetaTagsChanged_Params.prototype.initDefaults_ = function() {
    this.metaTags = null;
  };
  MetaTagsObserver_OnMetaTagsChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MetaTagsObserver_OnMetaTagsChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MetaTagsObserver_OnMetaTagsChanged_Params.metaTags
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ai_page_content_metadata$.MetaTag), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MetaTagsObserver_OnMetaTagsChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MetaTagsObserver_OnMetaTagsChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MetaTagsObserver_OnMetaTagsChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.metaTags =
        decoder.decodeArrayPointer(new codec.PointerTo(ai_page_content_metadata$.MetaTag));
    return val;
  };

  MetaTagsObserver_OnMetaTagsChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MetaTagsObserver_OnMetaTagsChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ai_page_content_metadata$.MetaTag), val.metaTags);
  };
  function FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new PaidContentMetadataObserverPtr();
  };
  FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params.decode = function(decoder) {
    var packed;
    var val = new FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(PaidContentMetadataObserverPtr));
    return val;
  };

  FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(PaidContentMetadataObserverPtr), val.observer);
  };
  function FrameMetadataObserverRegistry_AddMetaTagsObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FrameMetadataObserverRegistry_AddMetaTagsObserver_Params.prototype.initDefaults_ = function() {
    this.names = null;
    this.observer = new MetaTagsObserverPtr();
  };
  FrameMetadataObserverRegistry_AddMetaTagsObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FrameMetadataObserverRegistry_AddMetaTagsObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameMetadataObserverRegistry_AddMetaTagsObserver_Params.names
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FrameMetadataObserverRegistry_AddMetaTagsObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FrameMetadataObserverRegistry_AddMetaTagsObserver_Params.encodedSize = codec.kStructHeaderSize + 16;

  FrameMetadataObserverRegistry_AddMetaTagsObserver_Params.decode = function(decoder) {
    var packed;
    var val = new FrameMetadataObserverRegistry_AddMetaTagsObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.names =
        decoder.decodeArrayPointer(codec.String);
    val.observer =
        decoder.decodeStruct(new codec.Interface(MetaTagsObserverPtr));
    return val;
  };

  FrameMetadataObserverRegistry_AddMetaTagsObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FrameMetadataObserverRegistry_AddMetaTagsObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.String, val.names);
    encoder.encodeStruct(new codec.Interface(MetaTagsObserverPtr), val.observer);
  };
  var kPaidContentMetadataObserver_OnPaidContentMetadataChanged_Name = 0;

  function PaidContentMetadataObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PaidContentMetadataObserver,
                                                   handleOrPtrInfo);
  }

  function PaidContentMetadataObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PaidContentMetadataObserver, associatedInterfacePtrInfo);
  }

  PaidContentMetadataObserverAssociatedPtr.prototype =
      Object.create(PaidContentMetadataObserverPtr.prototype);
  PaidContentMetadataObserverAssociatedPtr.prototype.constructor =
      PaidContentMetadataObserverAssociatedPtr;

  function PaidContentMetadataObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  PaidContentMetadataObserverPtr.prototype.onPaidContentMetadataChanged = function() {
    return PaidContentMetadataObserverProxy.prototype.onPaidContentMetadataChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  PaidContentMetadataObserverProxy.prototype.onPaidContentMetadataChanged = function(hasPaidContent) {
    var params_ = new PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params();
    params_.hasPaidContent = hasPaidContent;
    var builder = new codec.MessageV0Builder(
        kPaidContentMetadataObserver_OnPaidContentMetadataChanged_Name,
        codec.align(PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params.encodedSize));
    builder.encodeStruct(PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PaidContentMetadataObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  PaidContentMetadataObserverStub.prototype.onPaidContentMetadataChanged = function(hasPaidContent) {
    return this.delegate_ && this.delegate_.onPaidContentMetadataChanged && this.delegate_.onPaidContentMetadataChanged(hasPaidContent);
  }

  PaidContentMetadataObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPaidContentMetadataObserver_OnPaidContentMetadataChanged_Name:
      var params = reader.decodeStruct(PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params);
      this.onPaidContentMetadataChanged(params.hasPaidContent);
      return true;
    default:
      return false;
    }
  };

  PaidContentMetadataObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePaidContentMetadataObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPaidContentMetadataObserver_OnPaidContentMetadataChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PaidContentMetadataObserver_OnPaidContentMetadataChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePaidContentMetadataObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PaidContentMetadataObserver = {
    name: 'blink.mojom.PaidContentMetadataObserver',
    kVersion: 0,
    ptrClass: PaidContentMetadataObserverPtr,
    proxyClass: PaidContentMetadataObserverProxy,
    stubClass: PaidContentMetadataObserverStub,
    validateRequest: validatePaidContentMetadataObserverRequest,
    validateResponse: null,
  };
  PaidContentMetadataObserverStub.prototype.validator = validatePaidContentMetadataObserverRequest;
  PaidContentMetadataObserverProxy.prototype.validator = null;
  var kMetaTagsObserver_OnMetaTagsChanged_Name = 0;

  function MetaTagsObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MetaTagsObserver,
                                                   handleOrPtrInfo);
  }

  function MetaTagsObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MetaTagsObserver, associatedInterfacePtrInfo);
  }

  MetaTagsObserverAssociatedPtr.prototype =
      Object.create(MetaTagsObserverPtr.prototype);
  MetaTagsObserverAssociatedPtr.prototype.constructor =
      MetaTagsObserverAssociatedPtr;

  function MetaTagsObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  MetaTagsObserverPtr.prototype.onMetaTagsChanged = function() {
    return MetaTagsObserverProxy.prototype.onMetaTagsChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MetaTagsObserverProxy.prototype.onMetaTagsChanged = function(metaTags) {
    var params_ = new MetaTagsObserver_OnMetaTagsChanged_Params();
    params_.metaTags = metaTags;
    var builder = new codec.MessageV0Builder(
        kMetaTagsObserver_OnMetaTagsChanged_Name,
        codec.align(MetaTagsObserver_OnMetaTagsChanged_Params.encodedSize));
    builder.encodeStruct(MetaTagsObserver_OnMetaTagsChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MetaTagsObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  MetaTagsObserverStub.prototype.onMetaTagsChanged = function(metaTags) {
    return this.delegate_ && this.delegate_.onMetaTagsChanged && this.delegate_.onMetaTagsChanged(metaTags);
  }

  MetaTagsObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMetaTagsObserver_OnMetaTagsChanged_Name:
      var params = reader.decodeStruct(MetaTagsObserver_OnMetaTagsChanged_Params);
      this.onMetaTagsChanged(params.metaTags);
      return true;
    default:
      return false;
    }
  };

  MetaTagsObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMetaTagsObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMetaTagsObserver_OnMetaTagsChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MetaTagsObserver_OnMetaTagsChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMetaTagsObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MetaTagsObserver = {
    name: 'blink.mojom.MetaTagsObserver',
    kVersion: 0,
    ptrClass: MetaTagsObserverPtr,
    proxyClass: MetaTagsObserverProxy,
    stubClass: MetaTagsObserverStub,
    validateRequest: validateMetaTagsObserverRequest,
    validateResponse: null,
  };
  MetaTagsObserverStub.prototype.validator = validateMetaTagsObserverRequest;
  MetaTagsObserverProxy.prototype.validator = null;
  var kFrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Name = 0;
  var kFrameMetadataObserverRegistry_AddMetaTagsObserver_Name = 1;

  function FrameMetadataObserverRegistryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FrameMetadataObserverRegistry,
                                                   handleOrPtrInfo);
  }

  function FrameMetadataObserverRegistryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FrameMetadataObserverRegistry, associatedInterfacePtrInfo);
  }

  FrameMetadataObserverRegistryAssociatedPtr.prototype =
      Object.create(FrameMetadataObserverRegistryPtr.prototype);
  FrameMetadataObserverRegistryAssociatedPtr.prototype.constructor =
      FrameMetadataObserverRegistryAssociatedPtr;

  function FrameMetadataObserverRegistryProxy(receiver) {
    this.receiver_ = receiver;
  }
  FrameMetadataObserverRegistryPtr.prototype.addPaidContentMetadataObserver = function() {
    return FrameMetadataObserverRegistryProxy.prototype.addPaidContentMetadataObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameMetadataObserverRegistryProxy.prototype.addPaidContentMetadataObserver = function(observer) {
    var params_ = new FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kFrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Name,
        codec.align(FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params.encodedSize));
    builder.encodeStruct(FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FrameMetadataObserverRegistryPtr.prototype.addMetaTagsObserver = function() {
    return FrameMetadataObserverRegistryProxy.prototype.addMetaTagsObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  FrameMetadataObserverRegistryProxy.prototype.addMetaTagsObserver = function(names, observer) {
    var params_ = new FrameMetadataObserverRegistry_AddMetaTagsObserver_Params();
    params_.names = names;
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kFrameMetadataObserverRegistry_AddMetaTagsObserver_Name,
        codec.align(FrameMetadataObserverRegistry_AddMetaTagsObserver_Params.encodedSize));
    builder.encodeStruct(FrameMetadataObserverRegistry_AddMetaTagsObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FrameMetadataObserverRegistryStub(delegate) {
    this.delegate_ = delegate;
  }
  FrameMetadataObserverRegistryStub.prototype.addPaidContentMetadataObserver = function(observer) {
    return this.delegate_ && this.delegate_.addPaidContentMetadataObserver && this.delegate_.addPaidContentMetadataObserver(observer);
  }
  FrameMetadataObserverRegistryStub.prototype.addMetaTagsObserver = function(names, observer) {
    return this.delegate_ && this.delegate_.addMetaTagsObserver && this.delegate_.addMetaTagsObserver(names, observer);
  }

  FrameMetadataObserverRegistryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Name:
      var params = reader.decodeStruct(FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params);
      this.addPaidContentMetadataObserver(params.observer);
      return true;
    case kFrameMetadataObserverRegistry_AddMetaTagsObserver_Name:
      var params = reader.decodeStruct(FrameMetadataObserverRegistry_AddMetaTagsObserver_Params);
      this.addMetaTagsObserver(params.names, params.observer);
      return true;
    default:
      return false;
    }
  };

  FrameMetadataObserverRegistryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFrameMetadataObserverRegistryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameMetadataObserverRegistry_AddPaidContentMetadataObserver_Params;
      break;
      case kFrameMetadataObserverRegistry_AddMetaTagsObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FrameMetadataObserverRegistry_AddMetaTagsObserver_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFrameMetadataObserverRegistryResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FrameMetadataObserverRegistry = {
    name: 'blink.mojom.FrameMetadataObserverRegistry',
    kVersion: 0,
    ptrClass: FrameMetadataObserverRegistryPtr,
    proxyClass: FrameMetadataObserverRegistryProxy,
    stubClass: FrameMetadataObserverRegistryStub,
    validateRequest: validateFrameMetadataObserverRegistryRequest,
    validateResponse: null,
  };
  FrameMetadataObserverRegistryStub.prototype.validator = validateFrameMetadataObserverRegistryRequest;
  FrameMetadataObserverRegistryProxy.prototype.validator = null;
  exports.PaidContentMetadataObserver = PaidContentMetadataObserver;
  exports.PaidContentMetadataObserverPtr = PaidContentMetadataObserverPtr;
  exports.PaidContentMetadataObserverAssociatedPtr = PaidContentMetadataObserverAssociatedPtr;
  exports.MetaTagsObserver = MetaTagsObserver;
  exports.MetaTagsObserverPtr = MetaTagsObserverPtr;
  exports.MetaTagsObserverAssociatedPtr = MetaTagsObserverAssociatedPtr;
  exports.FrameMetadataObserverRegistry = FrameMetadataObserverRegistry;
  exports.FrameMetadataObserverRegistryPtr = FrameMetadataObserverRegistryPtr;
  exports.FrameMetadataObserverRegistryAssociatedPtr = FrameMetadataObserverRegistryAssociatedPtr;
})();