// third_party/blink/public/mojom/compute_pressure/web_pressure_update.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/compute_pressure/web_pressure_update.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var pressure_update$ =
      mojo.internal.exposeNamespace('device.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/device/public/mojom/pressure_update.mojom', '../../../../../services/device/public/mojom/pressure_update.mojom.js');
  }



  function WebPressureUpdate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebPressureUpdate.prototype.initDefaults_ = function() {
    this.source = 0;
    this.state = 0;
    this.ownContributionEstimate = -1.0;
    this.timestamp = null;
  };
  WebPressureUpdate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebPressureUpdate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPressureUpdate.source
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, pressure_update$.PressureSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebPressureUpdate.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, pressure_update$.PressureState);
    if (err !== validator.validationError.NONE)
        return err;



    // validate WebPressureUpdate.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebPressureUpdate.encodedSize = codec.kStructHeaderSize + 24;

  WebPressureUpdate.decode = function(decoder) {
    var packed;
    var val = new WebPressureUpdate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.source =
        decoder.decodeStruct(new codec.Enum(pressure_update$.PressureSource));
    val.state =
        decoder.decodeStruct(new codec.Enum(pressure_update$.PressureState));
    val.ownContributionEstimate =
        decoder.decodeStruct(codec.Double);
    val.timestamp =
        decoder.decodeStructPointer(time$.TimeTicks);
    return val;
  };

  WebPressureUpdate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebPressureUpdate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.source);
    encoder.encodeStruct(codec.Int32, val.state);
    encoder.encodeStruct(codec.Double, val.ownContributionEstimate);
    encoder.encodeStructPointer(time$.TimeTicks, val.timestamp);
  };
  exports.WebPressureUpdate = WebPressureUpdate;
})();