// third_party/blink/public/mojom/clipboard/clipboard.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_TEST_UTILS_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_TEST_UTILS_H_

#include "third_party/blink/public/mojom/clipboard/clipboard.mojom.h"
#include "third_party/blink/public/common/common_export.h"


namespace blink::mojom {


class BLINK_COMMON_EXPORT ClipboardListenerInterceptorForTesting : public ClipboardListener {
  virtual ClipboardListener* GetForwardingInterface() = 0;
  void OnClipboardDataChanged() override;
};
class BLINK_COMMON_EXPORT ClipboardListenerAsyncWaiter {
 public:
  explicit ClipboardListenerAsyncWaiter(ClipboardListener* proxy);

  ClipboardListenerAsyncWaiter(const ClipboardListenerAsyncWaiter&) = delete;
  ClipboardListenerAsyncWaiter& operator=(const ClipboardListenerAsyncWaiter&) = delete;

  ~ClipboardListenerAsyncWaiter();

 private:
  ClipboardListener* const proxy_;
};


class BLINK_COMMON_EXPORT ClipboardHostInterceptorForTesting : public ClipboardHost {
  virtual ClipboardHost* GetForwardingInterface() = 0;
  void GetSequenceNumber(::ui::ClipboardBuffer buffer, GetSequenceNumberCallback callback) override;
  void IsFormatAvailable(ClipboardFormat format, ::ui::ClipboardBuffer buffer, IsFormatAvailableCallback callback) override;
  void ReadAvailableTypes(::ui::ClipboardBuffer buffer, ReadAvailableTypesCallback callback) override;
  void ReadText(::ui::ClipboardBuffer buffer, ReadTextCallback callback) override;
  void ReadHtml(::ui::ClipboardBuffer buffer, ReadHtmlCallback callback) override;
  void ReadSvg(::ui::ClipboardBuffer buffer, ReadSvgCallback callback) override;
  void ReadRtf(::ui::ClipboardBuffer buffer, ReadRtfCallback callback) override;
  void ReadPng(::ui::ClipboardBuffer buffer, ReadPngCallback callback) override;
  void ReadFiles(::ui::ClipboardBuffer buffer, ReadFilesCallback callback) override;
  void ReadDataTransferCustomData(::ui::ClipboardBuffer buffer, const ::std::u16string& type, ReadDataTransferCustomDataCallback callback) override;
  void ReadAvailableCustomAndStandardFormats(ReadAvailableCustomAndStandardFormatsCallback callback) override;
  void ReadUnsanitizedCustomFormat(const ::std::u16string& format, ReadUnsanitizedCustomFormatCallback callback) override;
  void WriteText(const ::std::u16string& text) override;
  void WriteHtml(const ::std::u16string& markup, const ::GURL& url) override;
  void WriteSvg(const ::std::u16string& markup) override;
  void WriteSmartPasteMarker() override;
  void WriteDataTransferCustomData(const base::flat_map<::std::u16string, ::std::u16string>& data) override;
  void WriteBookmark(const std::string& url, const ::std::u16string& title) override;
  void WriteImage(const ::SkBitmap& image) override;
  void WriteUnsanitizedCustomFormat(const ::std::u16string& format, ::mojo_base::BigBuffer data) override;
  void CommitWrite() override;
  void BeginCopyWithCompletion(int32_t token) override;
  void EndCopyWithCompletion(int32_t token, EndCopyWithCompletionCallback callback) override;
  void BeginPasteWithCompletion(int32_t token) override;
  void EndPasteWithCompletion(int32_t token, EndPasteWithCompletionCallback callback) override;
  void WriteStringToFindPboard(const ::std::u16string& text) override;
  void GetPlatformPermissionState(GetPlatformPermissionStateCallback callback) override;
  void RegisterClipboardListener(::mojo::PendingRemote<ClipboardListener> listener) override;
};
class BLINK_COMMON_EXPORT ClipboardHostAsyncWaiter {
 public:
  explicit ClipboardHostAsyncWaiter(ClipboardHost* proxy);

  ClipboardHostAsyncWaiter(const ClipboardHostAsyncWaiter&) = delete;
  ClipboardHostAsyncWaiter& operator=(const ClipboardHostAsyncWaiter&) = delete;

  ~ClipboardHostAsyncWaiter();
  void GetSequenceNumber(
      ::ui::ClipboardBuffer buffer, ::absl::uint128* out_result);
  ::absl::uint128 GetSequenceNumber(::ui::ClipboardBuffer buffer);
  void IsFormatAvailable(
      ClipboardFormat format, ::ui::ClipboardBuffer buffer, bool* out_result);
  bool IsFormatAvailable(ClipboardFormat format, ::ui::ClipboardBuffer buffer);
  void ReadAvailableTypes(
      ::ui::ClipboardBuffer buffer, std::vector<::std::u16string>* out_types);
  std::vector<::std::u16string> ReadAvailableTypes(::ui::ClipboardBuffer buffer);
  void ReadText(
      ::ui::ClipboardBuffer buffer, ::std::u16string* out_result);
  ::std::u16string ReadText(::ui::ClipboardBuffer buffer);
  void ReadHtml(
      ::ui::ClipboardBuffer buffer, ::std::u16string* out_markup, ::GURL* out_url, uint32_t* out_fragment_start, uint32_t* out_fragment_end);
  
  void ReadSvg(
      ::ui::ClipboardBuffer buffer, ::std::u16string* out_result);
  ::std::u16string ReadSvg(::ui::ClipboardBuffer buffer);
  void ReadRtf(
      ::ui::ClipboardBuffer buffer, ::std::string* out_result);
  ::std::string ReadRtf(::ui::ClipboardBuffer buffer);
  void ReadPng(
      ::ui::ClipboardBuffer buffer, ::mojo_base::BigBuffer* out_png);
  ::mojo_base::BigBuffer ReadPng(::ui::ClipboardBuffer buffer);
  void ReadFiles(
      ::ui::ClipboardBuffer buffer, ClipboardFilesPtr* out_result);
  ClipboardFilesPtr ReadFiles(::ui::ClipboardBuffer buffer);
  void ReadDataTransferCustomData(
      ::ui::ClipboardBuffer buffer, const ::std::u16string& type, ::std::u16string* out_result);
  ::std::u16string ReadDataTransferCustomData(::ui::ClipboardBuffer buffer, const ::std::u16string& type);
  void ReadAvailableCustomAndStandardFormats(
      std::vector<::std::u16string>* out_format_types);
  std::vector<::std::u16string> ReadAvailableCustomAndStandardFormats();
  void ReadUnsanitizedCustomFormat(
      const ::std::u16string& format, ::mojo_base::BigBuffer* out_data);
  ::mojo_base::BigBuffer ReadUnsanitizedCustomFormat(const ::std::u16string& format);
  void EndCopyWithCompletion(
      int32_t token, int32_t* out_token);
  int32_t EndCopyWithCompletion(int32_t token);
  void EndPasteWithCompletion(
      int32_t token, int32_t* out_token);
  int32_t EndPasteWithCompletion(int32_t token);
  void GetPlatformPermissionState(
      PlatformClipboardPermissionState* out_state);
  PlatformClipboardPermissionState GetPlatformPermissionState();

 private:
  ClipboardHost* const proxy_;
};




}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_CLIPBOARD_CLIPBOARD_MOJOM_TEST_UTILS_H_